/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.jdi;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

public class LinkedHashMap
extends AbstractMap
implements Map,
Serializable {
    private transient Entry[] table;
    private transient Entry header;
    private transient int count;
    private int threshold;
    private float loadFactor;
    private transient int modCount = 0;
    private transient Set keySet = null;
    private transient Set entries = null;
    private transient Collection values = null;
    private static final int KEYS = 0;
    private static final int VALUES = 1;
    private static final int ENTRIES = 2;

    public LinkedHashMap() {
        this(101, 0.75f);
    }

    public LinkedHashMap(int n) {
        this(n, 0.75f);
    }

    public LinkedHashMap(int n, float f) {
        if (n < 0) {
            throw new IllegalArgumentException("Illegal Initial Capacity: " + n);
        }
        if (f > 1.0f || f <= 0.0f) {
            throw new IllegalArgumentException("Illegal Load factor: " + f);
        }
        if (n == 0) {
            n = 1;
        }
        this.loadFactor = f;
        this.table = new Entry[n];
        this.threshold = (int)((float)n * f);
        this.header.before = this.header.after = (this.header = new Entry(-1, null, null, null));
    }

    public LinkedHashMap(Map map) {
        this(Math.max(3 * map.size(), 11), 0.75f);
        this.putAll(map);
    }

    public void clear() {
        Entry[] entryArray = this.table;
        ++this.modCount;
        int n = entryArray.length;
        while (--n >= 0) {
            entryArray[n] = null;
        }
        this.count = 0;
        this.header.before = this.header.after = this.header;
    }

    public Object clone() {
        return new LinkedHashMap(this);
    }

    public boolean containsKey(Object object) {
        Entry[] entryArray = this.table;
        if (object != null) {
            int n = object.hashCode();
            int n2 = (n & Integer.MAX_VALUE) % entryArray.length;
            Entry entry = entryArray[n2];
            while (entry != null) {
                if (entry.hash == n && entry.key.equals(object)) {
                    return true;
                }
                entry = entry.next;
            }
        } else {
            Entry entry = entryArray[0];
            while (entry != null) {
                if (entry.key == null) {
                    return true;
                }
                entry = entry.next;
            }
        }
        return false;
    }

    public boolean containsValue(Object object) {
        if (object == null) {
            Entry entry = this.header.after;
            while (entry != this.header) {
                if (entry.value == null) {
                    return true;
                }
                entry = entry.after;
            }
        } else {
            Entry entry = this.header.after;
            while (entry != this.header) {
                if (object.equals(entry.value)) {
                    return true;
                }
                entry = entry.after;
            }
        }
        return false;
    }

    public Set entrySet() {
        if (this.entries == null) {
            this.entries = new AbstractSet(){

                public void clear() {
                    LinkedHashMap.this.clear();
                }

                public boolean contains(Object object) {
                    if (!(object instanceof Map.Entry)) {
                        return false;
                    }
                    Map.Entry entry = (Map.Entry)object;
                    Object k = entry.getKey();
                    Entry[] entryArray = LinkedHashMap.this.table;
                    int n = k == null ? 0 : k.hashCode();
                    int n2 = (n & Integer.MAX_VALUE) % entryArray.length;
                    Entry entry2 = entryArray[n2];
                    while (entry2 != null) {
                        if (entry2.hash == n && entry2.equals(entry)) {
                            return true;
                        }
                        entry2 = entry2.next;
                    }
                    return false;
                }

                public Iterator iterator() {
                    return new HashIterator(2);
                }

                public boolean remove(Object object) {
                    if (!(object instanceof Map.Entry)) {
                        return false;
                    }
                    Map.Entry entry = (Map.Entry)object;
                    Object k = entry.getKey();
                    Entry[] entryArray = LinkedHashMap.this.table;
                    int n = k == null ? 0 : k.hashCode();
                    int n2 = (n & Integer.MAX_VALUE) % entryArray.length;
                    Entry entry2 = entryArray[n2];
                    Entry entry3 = null;
                    while (entry2 != null) {
                        if (entry2.hash == n && entry2.equals(entry)) {
                            LinkedHashMap linkedHashMap = LinkedHashMap.this;
                            linkedHashMap.modCount = linkedHashMap.modCount + 1;
                            if (entry3 != null) {
                                entry3.next = entry2.next;
                            } else {
                                entryArray[n2] = entry2.next;
                            }
                            LinkedHashMap linkedHashMap2 = LinkedHashMap.this;
                            linkedHashMap2.count = linkedHashMap2.count - 1;
                            entry2.value = null;
                            LinkedHashMap.this.listRemove(entry2);
                            return true;
                        }
                        entry3 = entry2;
                        entry2 = entry2.next;
                    }
                    return false;
                }

                public int size() {
                    return LinkedHashMap.this.count;
                }
            };
        }
        return this.entries;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof LinkedHashMap)) {
            return false;
        }
        LinkedHashMap linkedHashMap = (LinkedHashMap)object;
        if (linkedHashMap.size() != this.size()) {
            return false;
        }
        Iterator iterator = this.entrySet().iterator();
        Iterator iterator2 = linkedHashMap.entrySet().iterator();
        while (iterator.hasNext()) {
            block12: {
                boolean bl;
                Object object2;
                Object object3;
                block10: {
                    boolean bl2;
                    block11: {
                        Object object4;
                        Object object5;
                        block9: {
                            Entry entry = (Entry)iterator.next();
                            Entry entry2 = (Entry)iterator2.next();
                            object5 = entry.getKey();
                            object3 = entry.getValue();
                            object4 = entry2.getKey();
                            object2 = entry2.getValue();
                            if (object5 != null) break block9;
                            if (object4 == null) break block10;
                            bl2 = false;
                            break block11;
                        }
                        bl2 = object5.equals(object4);
                    }
                    if (!bl2) break block12;
                }
                if (object3 == null) {
                    if (object2 == null) continue;
                    bl = false;
                } else {
                    bl = object3.equals(object2);
                }
                if (bl) continue;
            }
            return false;
        }
        return true;
    }

    public Object get(Object object) {
        Entry entry = this.getEntry(object);
        return entry == null ? null : entry.value;
    }

    private Entry getEntry(Object object) {
        Entry[] entryArray = this.table;
        if (object != null) {
            int n = object.hashCode();
            int n2 = (n & Integer.MAX_VALUE) % entryArray.length;
            Entry entry = entryArray[n2];
            while (entry != null) {
                if (entry.hash == n && entry.key.equals(object)) {
                    return entry;
                }
                entry = entry.next;
            }
        } else {
            Entry entry = entryArray[0];
            while (entry != null) {
                if (entry.key == null) {
                    return entry;
                }
                entry = entry.next;
            }
        }
        return null;
    }

    public int indexOf(Object object) {
        int n = 0;
        if (object == null) {
            Entry entry = this.header.after;
            while (entry != this.header) {
                if (entry.key == null) {
                    return n;
                }
                entry = entry.after;
                ++n;
            }
        } else {
            Entry entry = this.header.after;
            while (entry != this.header) {
                if (object.equals(entry.key)) {
                    return n;
                }
                entry = entry.after;
                ++n;
            }
        }
        return -1;
    }

    public boolean isEmpty() {
        return this.count == 0;
    }

    public Set keySet() {
        if (this.keySet == null) {
            this.keySet = new AbstractSet(){

                public void clear() {
                    LinkedHashMap.this.clear();
                }

                public boolean contains(Object object) {
                    return LinkedHashMap.this.containsKey(object);
                }

                public Iterator iterator() {
                    return new HashIterator(0);
                }

                public boolean remove(Object object) {
                    return LinkedHashMap.this.remove(object) != null;
                }

                public int size() {
                    return LinkedHashMap.this.count;
                }
            };
        }
        return this.keySet;
    }

    private void listAddBefore(Entry entry, Entry entry2) {
        entry.after = entry2;
        entry.before = entry2.before;
        entry.before.after = entry;
        entry.after.before = entry;
    }

    private void listRemove(Entry entry) {
        if (entry == null) {
            return;
        }
        entry.before.after = entry.after;
        entry.after.before = entry.before;
    }

    public Object put(int n, Object object, Object object2) {
        if (n < 0 || n > this.count) {
            throw new IndexOutOfBoundsException();
        }
        Entry entry = this.header.after;
        if (n == this.count) {
            return this.putAhead(object, object2, this.header);
        }
        int n2 = 0;
        while (n2 < n) {
            entry = entry.after;
            ++n2;
        }
        return this.putAhead(object, object2, entry);
    }

    public Object put(Object object, Object object2) {
        return this.putAhead(object, object2, this.header);
    }

    private Object putAhead(Object object, Object object2, Entry entry) {
        Entry entry2;
        Entry[] entryArray = this.table;
        int n = 0;
        int n2 = 0;
        if (object != null) {
            n = object.hashCode();
            n2 = (n & Integer.MAX_VALUE) % entryArray.length;
            entry2 = entryArray[n2];
            while (entry2 != null) {
                if (entry2.hash == n && entry2.key.equals(object)) {
                    Object object3 = entry2.value;
                    entry2.value = object2;
                    return object3;
                }
                entry2 = entry2.next;
            }
        } else {
            entry2 = entryArray[0];
            while (entry2 != null) {
                if (entry2.key == null) {
                    Object object4 = entry2.value;
                    entry2.value = object2;
                    return object4;
                }
                entry2 = entry2.next;
            }
        }
        ++this.modCount;
        if (this.count >= this.threshold) {
            this.rehash();
            entryArray = this.table;
            n2 = (n & Integer.MAX_VALUE) % entryArray.length;
        }
        entryArray[n2] = entry2 = new Entry(n, object, object2, entryArray[n2]);
        this.listAddBefore(entry2, entry);
        ++this.count;
        return null;
    }

    public void putAll(Map map) {
        Iterator iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            this.put(entry.getKey(), entry.getValue());
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        int n = objectInputStream.readInt();
        this.table = new Entry[n];
        this.header.before = this.header = new Entry(-1, null, null, null);
        this.header.after = this.header;
        int n2 = objectInputStream.readInt();
        int n3 = 0;
        while (n3 < n2) {
            Object object = objectInputStream.readObject();
            Object object2 = objectInputStream.readObject();
            this.put(object, object2);
            ++n3;
        }
    }

    private void rehash() {
        int n = this.table.length;
        Entry[] entryArray = this.table;
        int n2 = n * 2 + 1;
        Entry[] entryArray2 = new Entry[n2];
        ++this.modCount;
        this.threshold = (int)((float)n2 * this.loadFactor);
        this.table = entryArray2;
        Entry entry = this.header.after;
        while (entry != this.header) {
            int n3 = (entry.hash & Integer.MAX_VALUE) % n2;
            entry.next = entryArray2[n3];
            entryArray2[n3] = entry;
            entry = entry.after;
        }
    }

    public Object remove(Object object) {
        Entry[] entryArray = this.table;
        if (object != null) {
            int n = object.hashCode();
            int n2 = (n & Integer.MAX_VALUE) % entryArray.length;
            Entry entry = entryArray[n2];
            Entry entry2 = null;
            while (entry != null) {
                if (entry.hash == n && entry.key.equals(object)) {
                    ++this.modCount;
                    if (entry2 != null) {
                        entry2.next = entry.next;
                    } else {
                        entryArray[n2] = entry.next;
                    }
                    --this.count;
                    Object object2 = entry.value;
                    entry.value = null;
                    this.listRemove(entry);
                    return object2;
                }
                entry2 = entry;
                entry = entry.next;
            }
        } else {
            Entry entry = entryArray[0];
            Entry entry3 = null;
            while (entry != null) {
                if (entry.key == null) {
                    ++this.modCount;
                    if (entry3 != null) {
                        entry3.next = entry.next;
                    } else {
                        entryArray[0] = entry.next;
                    }
                    --this.count;
                    Object object3 = entry.value;
                    entry.value = null;
                    this.listRemove(entry);
                    return object3;
                }
                entry3 = entry;
                entry = entry.next;
            }
        }
        return null;
    }

    public int size() {
        return this.count;
    }

    public Collection values() {
        if (this.values == null) {
            this.values = new AbstractCollection(){

                public void clear() {
                    LinkedHashMap.this.clear();
                }

                public boolean contains(Object object) {
                    return LinkedHashMap.this.containsValue(object);
                }

                public Iterator iterator() {
                    return new HashIterator(1);
                }

                public int size() {
                    return LinkedHashMap.this.count;
                }
            };
        }
        return this.values;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeInt(this.table.length);
        objectOutputStream.writeInt(this.count);
        Entry entry = this.header.after;
        while (entry != this.header) {
            objectOutputStream.writeObject(entry.key);
            objectOutputStream.writeObject(entry.value);
            entry = entry.after;
        }
    }

    private static class Entry
    implements Map.Entry {
        int hash;
        Object key;
        Object value;
        Entry next;
        Entry before;
        Entry after;

        Entry(int n, Object object, Object object2, Entry entry) {
            this.hash = n;
            this.key = object;
            this.value = object2;
            this.next = entry;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object object) {
            if (!(object instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)object;
            if (this.key == null) {
                if (entry.getKey() != null) {
                    return false;
                }
            } else {
                boolean bl = this.key.equals(entry.getKey());
                if (!bl) return false;
            }
            if (this.value == null) {
                if (entry.getValue() == null) return true;
                return false;
            }
            boolean bl = this.value.equals(entry.getValue());
            if (bl) return true;
            return false;
        }

        public Object getKey() {
            return this.key;
        }

        public Object getValue() {
            return this.value;
        }

        public int hashCode() {
            return this.hash ^ (this.value == null ? 0 : this.value.hashCode());
        }

        public Object setValue(Object object) {
            Object object2 = this.value;
            this.value = object;
            return object2;
        }

        public String toString() {
            return String.valueOf(String.valueOf(this.key)) + "=" + this.value;
        }
    }

    private class HashIterator
    implements Iterator {
        private Entry[] table;
        private Entry entry;
        private Entry lastReturned;
        private int type;
        private int expectedModCount;

        HashIterator(int n) {
            this.table = LinkedHashMap.this.table;
            this.entry = null;
            this.lastReturned = null;
            this.expectedModCount = LinkedHashMap.this.modCount;
            this.type = n;
            this.entry = ((LinkedHashMap)LinkedHashMap.this).header.after;
        }

        public boolean hasNext() {
            return this.entry != LinkedHashMap.this.header;
        }

        public Object next() {
            if (LinkedHashMap.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            if (this.entry == LinkedHashMap.this.header) {
                throw new NoSuchElementException();
            }
            Entry entry = this.lastReturned = this.entry;
            this.entry = entry.after;
            return this.type == 0 ? entry.key : (this.type == 1 ? entry.value : entry);
        }

        public void remove() {
            if (this.lastReturned == null) {
                throw new IllegalStateException();
            }
            if (LinkedHashMap.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            Entry[] entryArray = LinkedHashMap.this.table;
            int n = (this.lastReturned.hash & Integer.MAX_VALUE) % entryArray.length;
            Entry entry = entryArray[n];
            Entry entry2 = null;
            while (entry != null) {
                if (entry == this.lastReturned) {
                    LinkedHashMap linkedHashMap = LinkedHashMap.this;
                    linkedHashMap.modCount = linkedHashMap.modCount + 1;
                    ++this.expectedModCount;
                    if (entry2 == null) {
                        entryArray[n] = entry.next;
                    } else {
                        entry2.next = entry.next;
                    }
                    LinkedHashMap linkedHashMap2 = LinkedHashMap.this;
                    linkedHashMap2.count = linkedHashMap2.count - 1;
                    LinkedHashMap.this.listRemove(entry);
                    this.lastReturned = null;
                    return;
                }
                entry2 = entry;
                entry = entry.next;
            }
            throw new ConcurrentModificationException();
        }
    }
}

