/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.jdi;

import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.ClassNotLoadedException;
import com.sun.jdi.InternalException;
import com.sun.jdi.LocalVariable;
import com.sun.jdi.Location;
import com.sun.jdi.Method;
import com.sun.jdi.StackFrame;
import com.sun.jdi.Type;
import com.sun.jdi.VirtualMachine;
import com.sun.tools.jdi.JNITypeParser;
import com.sun.tools.jdi.MethodImpl;
import com.sun.tools.jdi.MirrorImpl;
import com.sun.tools.jdi.ReferenceTypeImpl;
import com.sun.tools.jdi.ValueContainer;

public class LocalVariableImpl
extends MirrorImpl
implements LocalVariable,
ValueContainer {
    private Method method;
    private int slot;
    private Location scopeStart;
    private Location scopeEnd;
    private String name;
    private String signature;

    LocalVariableImpl(VirtualMachine virtualMachine, Method method, int n, Location location, Location location2, String string, String string2) {
        super(virtualMachine);
        this.method = method;
        this.slot = n;
        this.scopeStart = location;
        this.scopeEnd = location2;
        this.name = string;
        this.signature = string2;
    }

    public int compareTo(Object object) {
        LocalVariableImpl localVariableImpl = (LocalVariableImpl)object;
        int n = this.method.compareTo(localVariableImpl.method);
        if (n == 0) {
            n = this.slot() - localVariableImpl.slot();
        }
        return n;
    }

    public boolean equals(Object object) {
        if (object != null && object instanceof LocalVariableImpl) {
            LocalVariableImpl localVariableImpl = (LocalVariableImpl)object;
            return this.method.equals(localVariableImpl.method) && this.slot() == localVariableImpl.slot() && super.equals(object);
        }
        return false;
    }

    public Type findType(String string) throws ClassNotLoadedException {
        ReferenceTypeImpl referenceTypeImpl = (ReferenceTypeImpl)this.method.declaringType();
        return referenceTypeImpl.findType(string);
    }

    public int hashCode() {
        return this.method.hashCode() + this.slot();
    }

    boolean hides(LocalVariable localVariable) {
        LocalVariableImpl localVariableImpl = (LocalVariableImpl)localVariable;
        if (!this.method.equals(localVariableImpl.method) || !this.name.equals(localVariableImpl.name)) {
            return false;
        }
        return this.scopeStart.compareTo(localVariableImpl.scopeStart) > 0;
    }

    public boolean isArgument() {
        try {
            MethodImpl methodImpl = (MethodImpl)this.scopeStart.method();
            return this.slot < methodImpl.argSlotCount();
        }
        catch (AbsentInformationException absentInformationException) {
            throw new InternalException();
        }
    }

    public boolean isVisible(StackFrame stackFrame) {
        this.validateMirror(stackFrame);
        return stackFrame.location().method().equals(this.method) && this.scopeStart.compareTo(stackFrame.location()) <= 0 && this.scopeEnd.compareTo(stackFrame.location()) >= 0;
    }

    public String name() {
        return this.name;
    }

    public String signature() {
        return this.signature;
    }

    int slot() {
        return this.slot;
    }

    public String toString() {
        return String.valueOf(this.name()) + " in " + this.method.toString() + "@" + this.scopeStart.toString();
    }

    public Type type() throws ClassNotLoadedException {
        return this.findType(this.signature());
    }

    public String typeName() {
        JNITypeParser jNITypeParser = new JNITypeParser(this.signature);
        return jNITypeParser.typeName();
    }
}

