/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.jdi;

import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.ClassNotLoadedException;
import com.sun.jdi.InvalidTypeException;
import com.sun.jdi.LocalVariable;
import com.sun.jdi.Location;
import com.sun.jdi.Method;
import com.sun.jdi.NativeMethodException;
import com.sun.jdi.Type;
import com.sun.jdi.Value;
import com.sun.jdi.VirtualMachine;
import com.sun.tools.jdi.JDWP;
import com.sun.tools.jdi.JDWPException;
import com.sun.tools.jdi.JNITypeParser;
import com.sun.tools.jdi.LocalVariableImpl;
import com.sun.tools.jdi.LocationImpl;
import com.sun.tools.jdi.ReferenceTypeImpl;
import com.sun.tools.jdi.TypeComponentImpl;
import com.sun.tools.jdi.ValueContainer;
import com.sun.tools.jdi.ValueImpl;
import com.sun.tools.jdi.VirtualMachineImpl;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class MethodImpl
extends TypeComponentImpl
implements Method {
    private SoftReference softLineInfoRef;
    private Location location = null;
    private SoftReference variablesRef = null;
    private boolean absentVariableInformation = false;
    private long firstIndex = -1L;
    private long lastIndex = -1L;
    private int argSlotCount = -1;
    private SoftReference bytecodesRef = null;
    private JNITypeParser signatureParser;
    private int lowestLine = -1;
    private int highestLine = -1;

    protected MethodImpl(VirtualMachine virtualMachine, ReferenceTypeImpl referenceTypeImpl, long l, String string, String string2, int n) {
        super(virtualMachine, referenceTypeImpl, l, string, string2, n);
        this.signatureParser = new JNITypeParser(string2);
    }

    public List allLineLocations() throws AbsentInformationException {
        if (this.isNative() || this.isAbstract()) {
            return new ArrayList(0);
        }
        List list = this.getLocations().lineLocations;
        if (list.size() == 0) {
            throw new AbsentInformationException();
        }
        return list;
    }

    int argSlotCount() throws AbsentInformationException {
        if (this.argSlotCount == -1) {
            this.getVariables();
        }
        return this.argSlotCount;
    }

    public List argumentSignatures() {
        return this.signatureParser.argumentSignatures();
    }

    Type argumentType(int n) throws ClassNotLoadedException {
        ReferenceTypeImpl referenceTypeImpl = (ReferenceTypeImpl)this.declaringType();
        String string = (String)this.argumentSignatures().get(n);
        return referenceTypeImpl.findType(string);
    }

    public List argumentTypeNames() {
        return this.signatureParser.argumentTypeNames();
    }

    public List argumentTypes() throws ClassNotLoadedException {
        int n = this.argumentSignatures().size();
        ArrayList<Type> arrayList = new ArrayList<Type>(n);
        int n2 = 0;
        while (n2 < n) {
            Type type = this.argumentType(n2);
            arrayList.add(type);
            ++n2;
        }
        return arrayList;
    }

    public List arguments() throws AbsentInformationException {
        List list = this.getVariables();
        ArrayList<LocalVariable> arrayList = new ArrayList<LocalVariable>(list.size());
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            LocalVariable localVariable = (LocalVariable)iterator.next();
            if (!localVariable.isArgument()) continue;
            arrayList.add(localVariable);
        }
        return arrayList;
    }

    public synchronized byte[] bytecodes() {
        byte[] byArray;
        byte[] byArray2 = byArray = this.bytecodesRef == null ? null : (byte[])this.bytecodesRef.get();
        if (byArray == null) {
            try {
                byArray = JDWP.Method.Bytecodes.process((VirtualMachineImpl)this.vm, (ReferenceTypeImpl)this.declaringType, (long)this.ref).bytes;
            }
            catch (JDWPException jDWPException) {
                throw jDWPException.toJDIException();
            }
            this.bytecodesRef = new SoftReference<byte[]>(byArray);
        }
        return (byte[])byArray.clone();
    }

    int codeIndexToLineNumber(long l) {
        if (this.firstIndex == -1L) {
            this.getLocations();
        }
        if (l < this.firstIndex || l > this.lastIndex) {
            return -1;
        }
        List list = this.getLocations().lineLocations;
        if (list.size() == 0) {
            return -1;
        }
        Iterator iterator = list.iterator();
        int n = -1;
        while (iterator.hasNext()) {
            Location location = (Location)iterator.next();
            if (location.codeIndex() > l) break;
            n = location.lineNumber();
        }
        if (n == -1) {
            n = ((Location)list.get(0)).lineNumber();
        }
        return n;
    }

    public int compareTo(Object object) {
        Method method = (Method)object;
        ReferenceTypeImpl referenceTypeImpl = (ReferenceTypeImpl)this.declaringType();
        int n = referenceTypeImpl.compareTo(method.declaringType());
        if (n == 0) {
            n = referenceTypeImpl.indexOf(this) - referenceTypeImpl.indexOf(method);
        }
        return n;
    }

    public boolean equals(Object object) {
        if (object != null && object instanceof MethodImpl) {
            MethodImpl methodImpl = (MethodImpl)object;
            return this.declaringType().equals(methodImpl.declaringType()) && this.ref() == methodImpl.ref() && super.equals(object);
        }
        return false;
    }

    public Type findType(String string) throws ClassNotLoadedException {
        ReferenceTypeImpl referenceTypeImpl = (ReferenceTypeImpl)this.declaringType();
        return referenceTypeImpl.findType(string);
    }

    private synchronized SoftLineInfo getLocations() {
        SoftLineInfo softLineInfo;
        SoftLineInfo softLineInfo2 = softLineInfo = this.softLineInfoRef == null ? null : (SoftLineInfo)this.softLineInfoRef.get();
        if (softLineInfo != null) {
            return softLineInfo;
        }
        JDWP.Method.LineTable lineTable = null;
        try {
            lineTable = JDWP.Method.LineTable.process(this.vm, this.declaringType, this.ref);
        }
        catch (JDWPException jDWPException) {
            if (jDWPException.errorCode() == 511) {
                Map map = Collections.unmodifiableMap(new HashMap());
                List list = Collections.unmodifiableList(new ArrayList(0));
                return new SoftLineInfo(map, list);
            }
            throw jDWPException.toJDIException();
        }
        int n = lineTable.lines.length;
        List<LocationImpl> list = new ArrayList(n);
        Map<Integer, ArrayList<LocationImpl>> map = new HashMap();
        int n2 = 0;
        while (n2 < n) {
            long l = lineTable.lines[n2].lineCodeIndex;
            int n3 = lineTable.lines[n2].lineNumber;
            if (n2 + 1 == n || l != lineTable.lines[n2 + 1].lineCodeIndex) {
                if (n3 > this.highestLine) {
                    this.highestLine = n3;
                }
                if (n3 < this.lowestLine || this.lowestLine == -1) {
                    this.lowestLine = n3;
                }
                LocationImpl locationImpl = new LocationImpl(this.virtualMachine(), this, l, n3);
                list.add(locationImpl);
                Integer n4 = new Integer(n3);
                ArrayList<LocationImpl> arrayList = (ArrayList<LocationImpl>)map.get(n4);
                if (arrayList == null) {
                    arrayList = new ArrayList<LocationImpl>(1);
                    map.put(n4, arrayList);
                }
                arrayList.add(locationImpl);
            }
            ++n2;
        }
        if (this.location == null) {
            this.firstIndex = lineTable.start;
            this.lastIndex = lineTable.end;
            this.location = n > 0 ? (Location)list.get(0) : new LocationImpl(this.virtualMachine(), this, this.firstIndex);
        }
        map = Collections.unmodifiableMap(map);
        list = Collections.unmodifiableList(list);
        softLineInfo = new SoftLineInfo(map, list);
        this.softLineInfoRef = new SoftReference<SoftLineInfo>(softLineInfo);
        return softLineInfo;
    }

    private synchronized List getVariables() throws AbsentInformationException {
        List<LocalVariableImpl> list;
        if (this.absentVariableInformation) {
            throw new AbsentInformationException();
        }
        if (this.isNative()) {
            throw new NativeMethodException();
        }
        List list2 = list = this.variablesRef == null ? null : (ArrayList)this.variablesRef.get();
        if (list != null) {
            return list;
        }
        JDWP.Method.VariableTable variableTable = null;
        try {
            variableTable = JDWP.Method.VariableTable.process(this.vm, this.declaringType, this.ref);
        }
        catch (JDWPException jDWPException) {
            if (jDWPException.errorCode() == 101) {
                this.absentVariableInformation = true;
                throw new AbsentInformationException();
            }
            throw jDWPException.toJDIException();
        }
        this.argSlotCount = variableTable.argCnt;
        int n = variableTable.slots.length;
        list = new ArrayList(n);
        int n2 = 0;
        while (n2 < n) {
            JDWP.Method.VariableTable.SlotInfo slotInfo = variableTable.slots[n2];
            if (!slotInfo.name.startsWith("this$") && !slotInfo.name.equals("this")) {
                LocationImpl locationImpl = new LocationImpl(this.virtualMachine(), this, slotInfo.codeIndex);
                LocationImpl locationImpl2 = new LocationImpl(this.virtualMachine(), this, slotInfo.codeIndex + (long)slotInfo.length - 1L);
                LocalVariableImpl localVariableImpl = new LocalVariableImpl(this.virtualMachine(), this, slotInfo.slot, locationImpl, locationImpl2, slotInfo.name, slotInfo.signature);
                list.add(localVariableImpl);
            }
            ++n2;
        }
        list = Collections.unmodifiableList(list);
        this.variablesRef = new SoftReference(list);
        return list;
    }

    public int hashCode() {
        return (int)this.ref();
    }

    public boolean isAbstract() {
        return this.isModifierSet(1024);
    }

    public boolean isConstructor() {
        return this.name().equals("<init>");
    }

    public boolean isNative() {
        return this.isModifierSet(256);
    }

    public boolean isStaticInitializer() {
        return this.name().equals("<clinit>");
    }

    public boolean isSynchronized() {
        return this.isModifierSet(32);
    }

    public Location location() {
        if (this.location == null) {
            this.getLocations();
        }
        return this.location;
    }

    public Location locationOfCodeIndex(long l) {
        if (this.firstIndex == -1L) {
            this.getLocations();
        }
        if (l < this.firstIndex || l > this.lastIndex) {
            return null;
        }
        return new LocationImpl(this.virtualMachine(), this, l);
    }

    public List locationsOfLine(int n) throws AbsentInformationException {
        SoftLineInfo softLineInfo = this.getLocations();
        if (softLineInfo.lineLocations.size() == 0) {
            throw new AbsentInformationException();
        }
        List list = (List)softLineInfo.lineMapper.get(new Integer(n));
        return list == null ? new ArrayList(0) : Collections.unmodifiableList(list);
    }

    void prepareArgumentsForInvoke(List list) throws ClassNotLoadedException, InvalidTypeException {
        int n = list.size();
        int n2 = 0;
        while (n2 < n) {
            Value value = (Value)list.get(n2);
            value = ValueImpl.prepareForAssignment(value, new ArgumentContainer(n2));
            list.set(n2, value);
            ++n2;
        }
    }

    String returnSignature() {
        return this.signatureParser.signature();
    }

    public Type returnType() throws ClassNotLoadedException {
        return this.findType(this.returnSignature());
    }

    public String returnTypeName() {
        return this.signatureParser.typeName();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.declaringType().name());
        stringBuffer.append(".");
        stringBuffer.append(this.name());
        stringBuffer.append("(");
        boolean bl = true;
        Iterator iterator = this.argumentTypeNames().iterator();
        while (iterator.hasNext()) {
            if (!bl) {
                stringBuffer.append(", ");
            }
            stringBuffer.append((String)iterator.next());
            bl = false;
        }
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    public List variables() throws AbsentInformationException {
        return this.getVariables();
    }

    public List variablesByName(String string) throws AbsentInformationException {
        List list = this.getVariables();
        ArrayList<LocalVariable> arrayList = new ArrayList<LocalVariable>(2);
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            LocalVariable localVariable = (LocalVariable)iterator.next();
            if (!localVariable.name().equals(string)) continue;
            arrayList.add(localVariable);
        }
        return arrayList;
    }

    private static class SoftLineInfo {
        Map lineMapper = null;
        List lineLocations = null;

        SoftLineInfo(Map map, List list) {
            this.lineMapper = map;
            this.lineLocations = list;
        }
    }

    class ArgumentContainer
    implements ValueContainer {
        int index;

        ArgumentContainer(int n) {
            this.index = n;
        }

        public Type findType(String string) throws ClassNotLoadedException {
            return MethodImpl.this.findType(string);
        }

        public String signature() {
            return (String)MethodImpl.this.argumentSignatures().get(this.index);
        }

        public Type type() throws ClassNotLoadedException {
            return MethodImpl.this.argumentType(this.index);
        }

        public String typeName() {
            return (String)MethodImpl.this.argumentTypeNames().get(this.index);
        }
    }
}

