/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.jdi;

import com.sun.tools.jdi.ConnectionService;
import com.sun.tools.jdi.Packet;
import java.io.IOException;

class SharedMemoryConnection
implements ConnectionService {
    private long id;
    private Object receiveLock = new Object();
    private Object sendLock = new Object();
    private boolean closed = false;

    SharedMemoryConnection(long l) throws IOException {
        this.id = l;
    }

    public void close() {
        this.closed = true;
        this.close0(this.id);
    }

    private native void close0(long var1);

    public byte receiveByte() throws IOException {
        if (this.closed) {
            throw new IOException("Connection closed");
        }
        Object object = this.receiveLock;
        synchronized (object) {
            byte by = this.receiveByte0(this.id);
            Object var3_3 = null;
            return by;
        }
    }

    private native byte receiveByte0(long var1) throws IOException;

    public Packet receivePacket() throws IOException {
        if (this.closed) {
            throw new IOException("Connection closed");
        }
        Object object = this.receiveLock;
        synchronized (object) {
            Packet packet = new Packet();
            this.receivePacket0(this.id, packet);
            Packet packet2 = packet;
            Object var3_4 = null;
            return packet2;
        }
    }

    private native void receivePacket0(long var1, Packet var3) throws IOException;

    public void sendByte(byte by) throws IOException {
        if (this.closed) {
            throw new IOException("Connection closed");
        }
        Object object = this.sendLock;
        synchronized (object) {
            this.sendByte0(this.id, by);
        }
    }

    private native void sendByte0(long var1, byte var3) throws IOException;

    public void sendPacket(Packet packet) throws IOException {
        if (this.closed) {
            throw new IOException("Connection closed");
        }
        Object object = this.sendLock;
        synchronized (object) {
            this.sendPacket0(this.id, packet);
        }
    }

    private native void sendPacket0(long var1, Packet var3) throws IOException;
}

