/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.jdi;

import com.sun.jdi.VirtualMachine;
import com.sun.jdi.connect.IllegalConnectorArgumentsException;
import com.sun.jdi.connect.ListeningConnector;
import com.sun.jdi.connect.Transport;
import com.sun.tools.jdi.ConnectionService;
import com.sun.tools.jdi.ConnectorImpl;
import com.sun.tools.jdi.SharedMemoryTransport;
import com.sun.tools.jdi.TransportService;
import com.sun.tools.jdi.VirtualMachineManagerService;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

class SharedMemoryListeningConnector
extends ConnectorImpl
implements ListeningConnector {
    static final String ARG_NAME = "name";
    Map listenMap;
    TransportService transport;

    SharedMemoryListeningConnector(VirtualMachineManagerService virtualMachineManagerService) {
        super(virtualMachineManagerService);
        this.addStringArgument(ARG_NAME, this.getString("memory_listening.name.label"), this.getString("memory_listening.name"), "", false);
        this.transport = new SharedMemoryTransport();
        this.listenMap = new HashMap(10);
    }

    public VirtualMachine accept(Map map) throws IOException, IllegalConnectorArgumentsException {
        ConnectionService connectionService;
        String string = (String)this.listenMap.get(map);
        if (string == null) {
            string = this.argument(ARG_NAME, map).value();
            this.transport.startListening(string);
            connectionService = this.transport.accept(string);
            this.transport.stopListening(string);
        } else {
            connectionService = this.transport.accept(string);
        }
        return this.manager().createVirtualMachine(connectionService);
    }

    public String description() {
        return this.getString("memory_listening.description");
    }

    public String name() {
        return "com.sun.jdi.SharedMemoryListen";
    }

    public String startListening(Map map) throws IOException, IllegalConnectorArgumentsException {
        if (this.listenMap.get(map) != null) {
            throw new IllegalConnectorArgumentsException("Already listening", new ArrayList(map.keySet()));
        }
        String string = this.argument(ARG_NAME, map).value();
        string = string.length() == 0 ? this.transport.startListening() : this.transport.startListening(string);
        this.listenMap.put(map, string);
        return string;
    }

    public void stopListening(Map map) throws IOException, IllegalConnectorArgumentsException {
        String string = (String)this.listenMap.remove(map);
        if (string == null) {
            throw new IllegalConnectorArgumentsException("Not listening", new ArrayList(map.keySet()));
        }
        this.transport.stopListening(string);
    }

    public boolean supportsMultipleConnections() {
        return true;
    }

    public Transport transport() {
        return this.transport;
    }
}

