/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.jdi;

import com.sun.tools.jdi.ConnectionService;
import com.sun.tools.jdi.SharedMemoryConnection;
import com.sun.tools.jdi.TransportService;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

class SharedMemoryTransport
implements TransportService {
    private static final String NAME = "dt_shmem";
    private Map listenMap = new HashMap();

    SharedMemoryTransport() {
        System.loadLibrary(NAME);
        this.initialize();
    }

    public ConnectionService accept(String string) throws IOException {
        Long l = (Long)this.listenMap.get(string);
        if (l == null) {
            throw new IllegalArgumentException("Invalid address");
        }
        long l2 = l;
        long l3 = this.accept0(l2);
        return new SharedMemoryConnection(l3);
    }

    private native long accept0(long var1) throws IOException;

    public ConnectionService attach(String string) throws IOException {
        if (string == null) {
            throw new NullPointerException("address is null");
        }
        long l = this.attach0(string);
        return new SharedMemoryConnection(l);
    }

    private native long attach0(String var1) throws IOException;

    private native void initialize();

    public String name() {
        return NAME;
    }

    private native String name(long var1) throws IOException;

    public String startListening() throws IOException {
        return this.startListening(null);
    }

    public String startListening(String string) throws IOException {
        long l = this.startListening0(string);
        string = this.name(l);
        this.listenMap.put(string, new Long(l));
        return string;
    }

    private native long startListening0(String var1) throws IOException;

    public void stopListening(String string) throws IOException {
        Long l = (Long)this.listenMap.remove(string);
        if (l == null) {
            throw new IllegalArgumentException("Invalid address");
        }
        this.stopListening0(l);
    }

    private native void stopListening0(long var1) throws IOException;

    public boolean supportsMultipleConnections() {
        return true;
    }
}

