/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.jdi;

import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.ClassNotLoadedException;
import com.sun.jdi.InternalException;
import com.sun.jdi.InvalidStackFrameException;
import com.sun.jdi.InvalidTypeException;
import com.sun.jdi.LocalVariable;
import com.sun.jdi.Location;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.StackFrame;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.Value;
import com.sun.jdi.VirtualMachine;
import com.sun.tools.jdi.JDWP;
import com.sun.tools.jdi.JDWPException;
import com.sun.tools.jdi.LocalVariableImpl;
import com.sun.tools.jdi.MethodImpl;
import com.sun.tools.jdi.MirrorImpl;
import com.sun.tools.jdi.ThreadAction;
import com.sun.tools.jdi.ThreadListener;
import com.sun.tools.jdi.ThreadReferenceImpl;
import com.sun.tools.jdi.ValueImpl;
import com.sun.tools.jdi.VirtualMachineImpl;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class StackFrameImpl
extends MirrorImpl
implements StackFrame,
ThreadListener {
    boolean isValid = true;
    ThreadReference thread;
    long id;
    Location location;
    Map visibleVariables = null;
    ObjectReference thisObject = null;

    StackFrameImpl(VirtualMachine virtualMachine, ThreadReference threadReference, long l, Location location) {
        super(virtualMachine);
        this.thread = threadReference;
        this.id = l;
        this.location = location;
        ((ThreadReferenceImpl)threadReference).addListener(this);
    }

    private void cacheThisObject() {
        if (this.thisObject == null) {
            StackFrameImpl stackFrameImpl = this;
            synchronized (stackFrameImpl) {
                if (this.thisObject == null) {
                    try {
                        ThreadReferenceImpl threadReferenceImpl = (ThreadReferenceImpl)this.thread;
                        this.thisObject = JDWP.StackFrame.ThisObject.process((VirtualMachineImpl)this.vm, (ThreadReferenceImpl)threadReferenceImpl, (long)this.id).objectThis;
                    }
                    catch (JDWPException jDWPException) {
                        switch (jDWPException.errorCode()) {
                            case 10: 
                            case 13: 
                            case 30: {
                                throw new InvalidStackFrameException();
                            }
                        }
                        throw jDWPException.toJDIException();
                    }
                }
            }
        }
    }

    private void createVisibleVariables() throws AbsentInformationException {
        if (this.visibleVariables == null) {
            StackFrameImpl stackFrameImpl = this;
            synchronized (stackFrameImpl) {
                if (this.visibleVariables != null) {
                    Object var2_2 = null;
                    return;
                }
                List list = this.location.method().variables();
                HashMap<String, LocalVariableImpl> hashMap = new HashMap<String, LocalVariableImpl>(list.size());
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    LocalVariable localVariable;
                    LocalVariableImpl localVariableImpl = (LocalVariableImpl)iterator.next();
                    String string = localVariableImpl.name();
                    if (!localVariableImpl.isVisible(this) || (localVariable = (LocalVariable)hashMap.get(string)) != null && !localVariableImpl.hides(localVariable)) continue;
                    hashMap.put(string, localVariableImpl);
                }
                this.visibleVariables = hashMap;
            }
        }
    }

    public boolean equals(Object object) {
        if (object != null && object instanceof StackFrameImpl) {
            StackFrameImpl stackFrameImpl = (StackFrameImpl)object;
            return this.id == stackFrameImpl.id && this.thread().equals(stackFrameImpl.thread()) && this.location().equals(stackFrameImpl.location()) && super.equals(object);
        }
        return false;
    }

    public Value getValue(LocalVariable localVariable) {
        ArrayList<LocalVariable> arrayList = new ArrayList<LocalVariable>(1);
        arrayList.add(localVariable);
        Map map = this.getValues(arrayList);
        return (Value)map.get(localVariable);
    }

    public synchronized Map getValues(List list) {
        Object object;
        ValueImpl[] valueImplArray;
        this.validateStackFrame();
        this.validateMirrors(list);
        int n = list.size();
        JDWP.StackFrame.GetValues.SlotInfo[] slotInfoArray = new JDWP.StackFrame.GetValues.SlotInfo[n];
        int n2 = 0;
        while (n2 < n) {
            valueImplArray = (ValueImpl[])list.get(n2);
            if (!valueImplArray.isVisible(this)) {
                throw new IllegalArgumentException(String.valueOf(valueImplArray.name()) + " is not valid at this frame location");
            }
            slotInfoArray[n2] = new JDWP.StackFrame.GetValues.SlotInfo(valueImplArray.slot(), (byte)valueImplArray.signature().charAt(0));
            ++n2;
        }
        try {
            object = (ThreadReferenceImpl)this.thread;
            valueImplArray = JDWP.StackFrame.GetValues.process((VirtualMachineImpl)this.vm, (ThreadReferenceImpl)object, (long)this.id, (JDWP.StackFrame.GetValues.SlotInfo[])slotInfoArray).values;
        }
        catch (JDWPException jDWPException) {
            switch (jDWPException.errorCode()) {
                case 10: 
                case 13: 
                case 30: {
                    throw new InvalidStackFrameException();
                }
            }
            throw jDWPException.toJDIException();
        }
        if (n != valueImplArray.length) {
            throw new InternalException("Wrong number of values returned from target VM");
        }
        object = new HashMap(n);
        int n3 = 0;
        while (n3 < n) {
            LocalVariableImpl localVariableImpl = (LocalVariableImpl)list.get(n3);
            object.put(localVariableImpl, valueImplArray[n3]);
            ++n3;
        }
        return object;
    }

    public int hashCode() {
        return (this.thread().hashCode() << 4) + (int)this.id;
    }

    public synchronized Location location() {
        this.validateStackFrame();
        return this.location;
    }

    public synchronized void setValue(LocalVariable localVariable, Value value) throws InvalidTypeException, ClassNotLoadedException {
        block8: {
            this.validateStackFrame();
            this.validateMirror(localVariable);
            this.validateMirrorOrNull(value);
            LocalVariableImpl localVariableImpl = (LocalVariableImpl)localVariable;
            ValueImpl valueImpl = (ValueImpl)value;
            if (!localVariableImpl.isVisible(this)) {
                throw new IllegalArgumentException(String.valueOf(localVariableImpl.name()) + " is not valid at this frame location");
            }
            try {
                valueImpl = ValueImpl.prepareForAssignment(valueImpl, localVariableImpl);
                JDWP.StackFrame.SetValues.SlotInfo[] slotInfoArray = new JDWP.StackFrame.SetValues.SlotInfo[]{new JDWP.StackFrame.SetValues.SlotInfo(localVariableImpl.slot(), valueImpl)};
                try {
                    ThreadReferenceImpl threadReferenceImpl = (ThreadReferenceImpl)this.thread;
                    JDWP.StackFrame.SetValues.process(this.vm, threadReferenceImpl, this.id, slotInfoArray);
                }
                catch (JDWPException jDWPException) {
                    switch (jDWPException.errorCode()) {
                        case 10: 
                        case 13: 
                        case 30: {
                            throw new InvalidStackFrameException();
                        }
                    }
                    throw jDWPException.toJDIException();
                }
            }
            catch (ClassNotLoadedException classNotLoadedException) {
                if (valueImpl == null) break block8;
                throw classNotLoadedException;
            }
        }
    }

    public synchronized ObjectReference thisObject() {
        this.validateStackFrame();
        MethodImpl methodImpl = (MethodImpl)this.location.method();
        if (methodImpl.isStatic() || methodImpl.isNative()) {
            return null;
        }
        this.cacheThisObject();
        return this.thisObject;
    }

    public synchronized ThreadReference thread() {
        this.validateStackFrame();
        return this.thread;
    }

    public synchronized boolean threadResumable(ThreadAction threadAction) {
        if (this.isValid) {
            this.isValid = false;
            this.visibleVariables = null;
            this.thisObject = null;
            this.location = null;
            this.thread = null;
            return false;
        }
        throw new InternalException("Invalid stack frame thread listener");
    }

    public String toString() {
        return String.valueOf(this.location.toString()) + " in thread " + this.thread.toString();
    }

    void validateStackFrame() {
        if (!this.isValid) {
            throw new InvalidStackFrameException("Thread has been resumed");
        }
    }

    public synchronized LocalVariable visibleVariableByName(String string) throws AbsentInformationException {
        this.validateStackFrame();
        this.createVisibleVariables();
        return (LocalVariable)this.visibleVariables.get(string);
    }

    public synchronized List visibleVariables() throws AbsentInformationException {
        this.validateStackFrame();
        this.createVisibleVariables();
        ArrayList arrayList = new ArrayList(this.visibleVariables.values());
        Collections.sort(arrayList);
        return arrayList;
    }
}

