/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.jdi;

import com.sun.jdi.ThreadGroupReference;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.VirtualMachine;
import com.sun.tools.jdi.JDWP;
import com.sun.tools.jdi.JDWPException;
import com.sun.tools.jdi.ObjectReferenceImpl;
import com.sun.tools.jdi.VMAction;
import com.sun.tools.jdi.VMListener;
import com.sun.tools.jdi.VirtualMachineImpl;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;

public class ThreadGroupReferenceImpl
extends ObjectReferenceImpl
implements ThreadGroupReference,
VMListener {
    String name;
    ThreadGroupReference parent;
    boolean triedParent;
    JDWP.ThreadGroupReference.Children cachedKids;

    ThreadGroupReferenceImpl(VirtualMachine virtualMachine, long l) {
        super(virtualMachine, l);
        this.vm.addListener(this);
    }

    private synchronized JDWP.ThreadGroupReference.Children kids() {
        try {
            JDWP.ThreadGroupReference.Children children = this.cachedKids;
            if (children == null) {
                children = JDWP.ThreadGroupReference.Children.process(this.vm, this);
                VirtualMachineImpl.State state = this.vm.state();
                synchronized (state) {
                    if (this.vm.state().isFrozen()) {
                        this.cachedKids = children;
                        if ((this.vm.traceFlags & 0x10) != 0) {
                            this.vm.printTrace("ThreadGroupReference " + this.uniqueID() + " temporarily caching children ");
                        }
                    }
                }
            }
            return children;
        }
        catch (JDWPException jDWPException) {
            throw jDWPException.toJDIException();
        }
    }

    public String name() {
        if (this.name == null) {
            ThreadGroupReferenceImpl threadGroupReferenceImpl = this;
            synchronized (threadGroupReferenceImpl) {
                if (this.name == null) {
                    try {
                        this.name = JDWP.ThreadGroupReference.Name.process((VirtualMachineImpl)this.vm, (ThreadGroupReferenceImpl)this).groupName;
                    }
                    catch (JDWPException jDWPException) {
                        throw jDWPException.toJDIException();
                    }
                }
            }
        }
        return this.name;
    }

    public synchronized ThreadGroupReference parent() {
        if (!this.triedParent) {
            try {
                this.parent = JDWP.ThreadGroupReference.Parent.process((VirtualMachineImpl)this.vm, (ThreadGroupReferenceImpl)this).parentGroup;
                this.triedParent = true;
            }
            catch (JDWPException jDWPException) {
                throw jDWPException.toJDIException();
            }
        }
        return this.parent;
    }

    public void resume() {
        List list = this.threads();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            ((ThreadReference)iterator.next()).resume();
        }
        List list2 = this.threadGroups();
        iterator = list2.iterator();
        while (iterator.hasNext()) {
            ((ThreadGroupReference)iterator.next()).resume();
        }
    }

    public void suspend() {
        List list = this.threads();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            ((ThreadReference)iterator.next()).suspend();
        }
        List list2 = this.threadGroups();
        iterator = list2.iterator();
        while (iterator.hasNext()) {
            ((ThreadGroupReference)iterator.next()).suspend();
        }
    }

    public List threadGroups() {
        return Arrays.asList(this.kids().childGroups);
    }

    public List threads() {
        return Arrays.asList(this.kids().childThreads);
    }

    public String toString() {
        return "instance of " + this.referenceType().name() + "(name='" + this.name() + "', " + "id=" + this.uniqueID() + ")";
    }

    byte typeValueKey() {
        return 103;
    }

    public boolean vmNotSuspended(VMAction vMAction) {
        if ((this.vm.traceFlags & 0x10) != 0) {
            this.vm.printTrace("Clearing temporary cache for ThreadGroupReference " + this.uniqueID());
        }
        this.cachedKids = null;
        return super.vmNotSuspended(vMAction);
    }

    public boolean vmSuspended(VMAction vMAction) {
        super.vmSuspended(vMAction);
        return true;
    }
}

