/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.jdi;

import com.sun.jdi.IncompatibleThreadStateException;
import com.sun.jdi.InternalException;
import com.sun.jdi.InvalidTypeException;
import com.sun.jdi.Location;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.StackFrame;
import com.sun.jdi.ThreadGroupReference;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.VirtualMachine;
import com.sun.jdi.request.BreakpointRequest;
import com.sun.tools.jdi.ClassTypeImpl;
import com.sun.tools.jdi.CommandSender;
import com.sun.tools.jdi.JDWP;
import com.sun.tools.jdi.JDWPException;
import com.sun.tools.jdi.ObjectReferenceImpl;
import com.sun.tools.jdi.PacketStream;
import com.sun.tools.jdi.StackFrameImpl;
import com.sun.tools.jdi.ThreadAction;
import com.sun.tools.jdi.ThreadListener;
import com.sun.tools.jdi.VMAction;
import com.sun.tools.jdi.VMListener;
import com.sun.tools.jdi.VirtualMachineImpl;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class ThreadReferenceImpl
extends ObjectReferenceImpl
implements ThreadReference,
VMListener {
    static final int SUSPEND_STATUS_SUSPENDED = 1;
    static final int SUSPEND_STATUS_BREAK = 2;
    private ThreadGroupReference threadGroup;
    private int suspendedZombieCount = 0;
    private final Object threadStateMonitor = new Object();
    String cachedName = null;
    JDWP.ThreadReference.Status cachedStatus = null;
    List cachedFrames = null;
    int cachedFramesStart = -1;
    int cachedFramesLength = 0;
    int cachedFrameCount = -1;
    List cachedOwnedMonitors = null;
    ObjectReference cachedContendedMonitor = null;
    boolean triedCurrentContended = false;
    private List listeners = Collections.synchronizedList(new ArrayList());

    ThreadReferenceImpl(VirtualMachine virtualMachine, long l) {
        super(virtualMachine, l);
        this.vm.addListener(this);
    }

    void addListener(ThreadListener threadListener) {
        this.listeners.add(new WeakReference<ThreadListener>(threadListener));
    }

    public synchronized ObjectReference currentContendedMonitor() throws IncompatibleThreadStateException {
        try {
            ObjectReference objectReference = this.cachedContendedMonitor;
            if (!this.triedCurrentContended && objectReference == null) {
                objectReference = JDWP.ThreadReference.CurrentContendedMonitor.process((VirtualMachineImpl)this.vm, (ThreadReferenceImpl)this).monitor;
                VirtualMachineImpl.State state = this.vm.state();
                synchronized (state) {
                    if (this.vm.state().isFrozen()) {
                        this.triedCurrentContended = true;
                        this.cachedContendedMonitor = objectReference;
                        if (objectReference != null && (this.vm.traceFlags & 0x10) != 0) {
                            this.vm.printTrace("ThreadReference " + this.uniqueID() + " temporarily caching contended monitor" + " (id = " + objectReference.uniqueID() + ")");
                        }
                    }
                }
            }
            return objectReference;
        }
        catch (JDWPException jDWPException) {
            if (jDWPException.errorCode() == 13 || jDWPException.errorCode() == 10) {
                throw new IncompatibleThreadStateException();
            }
            throw jDWPException.toJDIException();
        }
    }

    public StackFrame frame(int n) throws IncompatibleThreadStateException {
        List list = this.frames(n, 1);
        return (StackFrame)list.get(0);
    }

    public synchronized int frameCount() throws IncompatibleThreadStateException {
        try {
            int n = this.cachedFrameCount;
            if (n == -1) {
                n = JDWP.ThreadReference.FrameCount.process((VirtualMachineImpl)this.vm, (ThreadReferenceImpl)this).frameCount;
                VirtualMachineImpl.State state = this.vm.state();
                synchronized (state) {
                    if (this.vm.state().isFrozen()) {
                        this.cachedFrameCount = n;
                    }
                }
            }
            return n;
        }
        catch (JDWPException jDWPException) {
            if (jDWPException.errorCode() == 13 || jDWPException.errorCode() == 10) {
                throw new IncompatibleThreadStateException();
            }
            throw jDWPException.toJDIException();
        }
    }

    public List frames() throws IncompatibleThreadStateException {
        return this.frames(0, -1);
    }

    public synchronized List frames(int n, int n2) throws IncompatibleThreadStateException {
        try {
            List<StackFrameImpl> list = this.cachedFrames;
            if (list == null || !this.isSubrange(n, n2, list)) {
                JDWP.ThreadReference.Frames.Frame[] frameArray = JDWP.ThreadReference.Frames.process((VirtualMachineImpl)this.vm, (ThreadReferenceImpl)this, (int)n, (int)n2).frames;
                int n3 = frameArray.length;
                list = new ArrayList();
                Object object = this.threadStateMonitor;
                synchronized (object) {
                    int n4 = 0;
                    while (n4 < n3) {
                        if (frameArray[n4].location == null) {
                            throw new InternalException("Invalid frame location");
                        }
                        StackFrameImpl stackFrameImpl = new StackFrameImpl(this.vm, this, frameArray[n4].frameID, frameArray[n4].location);
                        list.add(stackFrameImpl);
                        ++n4;
                    }
                }
                object = this.vm.state();
                synchronized (object) {
                    if (this.vm.state().isFrozen()) {
                        this.cachedFrames = list;
                        this.cachedFramesStart = n;
                        this.cachedFramesLength = n2;
                    }
                }
            }
            int n5 = n - this.cachedFramesStart;
            int n6 = n2 == -1 ? list.size() - n5 : n5 + n2;
            list = list.subList(n5, n6);
            return Collections.unmodifiableList(list);
        }
        catch (JDWPException jDWPException) {
            if (jDWPException.errorCode() == 13 || jDWPException.errorCode() == 10) {
                throw new IncompatibleThreadStateException();
            }
            throw jDWPException.toJDIException();
        }
    }

    public void interrupt() {
        try {
            JDWP.ThreadReference.Interrupt.process(this.vm, this);
        }
        catch (JDWPException jDWPException) {
            throw jDWPException.toJDIException();
        }
    }

    public boolean isAtBreakpoint() {
        try {
            StackFrame stackFrame = this.frame(0);
            Location location = stackFrame.location();
            List list = this.vm.eventRequestManager().breakpointRequests();
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                BreakpointRequest breakpointRequest = (BreakpointRequest)iterator.next();
                if (!location.equals(breakpointRequest.location())) continue;
                return true;
            }
            return false;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            return false;
        }
        catch (IncompatibleThreadStateException incompatibleThreadStateException) {
            return false;
        }
    }

    boolean isSubrange(int n, int n2, List list) {
        if (n < this.cachedFramesStart) {
            return false;
        }
        if (n2 == -1) {
            return this.cachedFramesLength == -1;
        }
        if (this.cachedFramesLength == -1) {
            if (n + n2 > this.cachedFramesStart + list.size()) {
                throw new IndexOutOfBoundsException();
            }
            return true;
        }
        return n + n2 <= this.cachedFramesStart + this.cachedFramesLength;
    }

    public boolean isSuspended() {
        return this.suspendedZombieCount > 0 || (this.jdwpStatus().suspendStatus & 1) != 0;
    }

    private synchronized JDWP.ThreadReference.Status jdwpStatus() {
        try {
            JDWP.ThreadReference.Status status = this.cachedStatus;
            if (status == null) {
                status = JDWP.ThreadReference.Status.process(this.vm, this);
                VirtualMachineImpl.State state = this.vm.state();
                synchronized (state) {
                    if (this.vm.state().isFrozen()) {
                        this.cachedStatus = status;
                    }
                }
            }
            return status;
        }
        catch (JDWPException jDWPException) {
            throw jDWPException.toJDIException();
        }
    }

    public synchronized String name() {
        try {
            String string = this.cachedName;
            if (string == null) {
                string = JDWP.ThreadReference.Name.process((VirtualMachineImpl)this.vm, (ThreadReferenceImpl)this).threadName;
                VirtualMachineImpl.State state = this.vm.state();
                synchronized (state) {
                    if (this.vm.state().isFrozen()) {
                        this.cachedName = string;
                    }
                }
            }
            return string;
        }
        catch (JDWPException jDWPException) {
            throw jDWPException.toJDIException();
        }
    }

    public synchronized List ownedMonitors() throws IncompatibleThreadStateException {
        try {
            List<ObjectReferenceImpl> list = this.cachedOwnedMonitors;
            if (list == null) {
                list = Arrays.asList(JDWP.ThreadReference.OwnedMonitors.process((VirtualMachineImpl)this.vm, (ThreadReferenceImpl)this).owned);
                VirtualMachineImpl.State state = this.vm.state();
                synchronized (state) {
                    if (this.vm.state().isFrozen()) {
                        this.cachedOwnedMonitors = list;
                        if ((this.vm.traceFlags & 0x10) != 0) {
                            this.vm.printTrace("ThreadReference " + this.uniqueID() + " temporarily caching owned monitors" + " (count = " + list.size() + ")");
                        }
                    }
                }
            }
            return list;
        }
        catch (JDWPException jDWPException) {
            if (jDWPException.errorCode() == 13 || jDWPException.errorCode() == 10) {
                throw new IncompatibleThreadStateException();
            }
            throw jDWPException.toJDIException();
        }
    }

    void processThreadAction(ThreadAction threadAction) {
        List list = this.listeners;
        synchronized (list) {
            Iterator iterator = this.listeners.iterator();
            block6: while (iterator.hasNext()) {
                WeakReference weakReference;
                ThreadListener threadListener;
                block7: while ((threadListener = (ThreadListener)(weakReference = (WeakReference)iterator.next()).get()) != null) {
                    switch (threadAction.id()) {
                        case 2: {
                            if (threadListener.threadResumable(threadAction)) continue block6;
                            iterator.remove();
                            continue block6;
                        }
                        default: {
                            if (iterator.hasNext()) continue block7;
                        }
                    }
                }
                iterator.remove();
            }
        }
    }

    void removeListener(ThreadListener threadListener) {
        List list = this.listeners;
        synchronized (list) {
            Iterator iterator = this.listeners.iterator();
            while (iterator.hasNext()) {
                WeakReference weakReference = (WeakReference)iterator.next();
                if (!threadListener.equals(weakReference.get())) continue;
                iterator.remove();
                break;
            }
        }
    }

    public void resume() {
        PacketStream packetStream;
        if (this.suspendedZombieCount > 0) {
            --this.suspendedZombieCount;
            return;
        }
        Object object = this.threadStateMonitor;
        synchronized (object) {
            this.processThreadAction(new ThreadAction(this, 2));
            packetStream = JDWP.ThreadReference.Resume.enqueueCommand(this.vm, this);
        }
        try {
            JDWP.ThreadReference.Resume.waitForReply(this.vm, packetStream);
        }
        catch (JDWPException jDWPException) {
            throw jDWPException.toJDIException();
        }
    }

    PacketStream sendResumingCommand(CommandSender commandSender) {
        Object object = this.threadStateMonitor;
        synchronized (object) {
            this.processThreadAction(new ThreadAction(this, 2));
            PacketStream packetStream = commandSender.send();
            Object var4_4 = null;
            return packetStream;
        }
    }

    public int status() {
        return this.jdwpStatus().threadStatus;
    }

    public void stop(ObjectReference objectReference) throws InvalidTypeException {
        List list = this.vm.classesByName("java.lang.Throwable");
        ClassTypeImpl classTypeImpl = (ClassTypeImpl)list.get(0);
        if (objectReference == null || !classTypeImpl.isAssignableFrom(objectReference)) {
            throw new InvalidTypeException("Not an instance of Throwable");
        }
        try {
            JDWP.ThreadReference.Stop.process(this.vm, this, (ObjectReferenceImpl)objectReference);
        }
        catch (JDWPException jDWPException) {
            throw jDWPException.toJDIException();
        }
    }

    public void suspend() {
        try {
            JDWP.ThreadReference.Suspend.process(this.vm, this);
        }
        catch (JDWPException jDWPException) {
            throw jDWPException.toJDIException();
        }
    }

    public int suspendCount() {
        if (this.suspendedZombieCount > 0) {
            return this.suspendedZombieCount;
        }
        try {
            return JDWP.ThreadReference.SuspendCount.process((VirtualMachineImpl)this.vm, (ThreadReferenceImpl)this).suspendCount;
        }
        catch (JDWPException jDWPException) {
            throw jDWPException.toJDIException();
        }
    }

    public ThreadGroupReference threadGroup() {
        if (this.threadGroup == null) {
            ThreadReferenceImpl threadReferenceImpl = this;
            synchronized (threadReferenceImpl) {
                if (this.threadGroup == null) {
                    try {
                        this.threadGroup = JDWP.ThreadReference.ThreadGroup.process((VirtualMachineImpl)this.vm, (ThreadReferenceImpl)this).group;
                    }
                    catch (JDWPException jDWPException) {
                        throw jDWPException.toJDIException();
                    }
                }
            }
        }
        return this.threadGroup;
    }

    public String toString() {
        return "instance of " + this.referenceType().name() + "(name='" + this.name() + "', " + "id=" + this.uniqueID() + ")";
    }

    byte typeValueKey() {
        return 116;
    }

    public boolean vmNotSuspended(VMAction vMAction) {
        Object object = this.threadStateMonitor;
        synchronized (object) {
            this.processThreadAction(new ThreadAction(this, 2));
        }
        if ((this.vm.traceFlags & 0x10) != 0) {
            this.vm.printTrace("Clearing temporary cache for ThreadReference " + this.uniqueID());
        }
        this.cachedName = null;
        this.cachedStatus = null;
        this.cachedFrames = null;
        this.cachedFramesStart = -1;
        this.cachedFramesLength = 0;
        this.cachedFrameCount = -1;
        this.cachedOwnedMonitors = null;
        this.cachedContendedMonitor = null;
        this.triedCurrentContended = false;
        return super.vmNotSuspended(vMAction);
    }

    public boolean vmSuspended(VMAction vMAction) {
        super.vmSuspended(vMAction);
        return true;
    }
}

