/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.jdwpgen;

import com.sun.tools.jdwpgen.Main;
import com.sun.tools.jdwpgen.NameValueNode;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StreamTokenizer;

class JVMDIParse {
    final StreamTokenizer izer;
    static final int DEFINE_TOKEN = 101010;
    static final int NAME_TOKEN = 101011;
    int tok;
    int prevTok = 10;
    String origName;
    int value;

    JVMDIParse(Reader reader) throws IOException {
        this.izer = new StreamTokenizer(new BufferedReader(reader));
        this.izer.resetSyntax();
        this.izer.slashStarComments(true);
        this.izer.slashSlashComments(true);
        this.izer.wordChars(97, 122);
        this.izer.wordChars(65, 90);
        this.izer.wordChars(48, 57);
        this.izer.wordChars(95, 95);
        this.izer.whitespaceChars(0, 32);
        this.izer.whitespaceChars(40, 41);
        this.items();
    }

    void error(String string) {
        System.err.println("JVMDI:" + this.izer.lineno() + ": Internal Error - " + string);
        System.exit(1);
    }

    int item() throws IOException {
        switch (this.tok) {
            case -1: {
                this.error("Unexpected end-of-file");
                return this.tok;
            }
            case -3: {
                String string = this.izer.sval;
                if (Character.isDigit(string.charAt(0))) {
                    int n;
                    if (this.prevTok != 101011) {
                        return this.tok;
                    }
                    try {
                        n = string.startsWith("0x") ? Integer.parseInt(string.substring(2), 16) : Integer.parseInt(string);
                    }
                    catch (NumberFormatException numberFormatException) {
                        return this.tok;
                    }
                    NameValueNode nameValueNode = new NameValueNode(this.origName, n);
                    Main.nameMap.put(this.origName, nameValueNode);
                    return this.tok;
                }
                switch (this.prevTok) {
                    case 35: {
                        if (string.equals("define")) {
                            return 101010;
                        }
                        return this.tok;
                    }
                    case 101010: {
                        if (string.startsWith("JVMDI_")) {
                            this.origName = string;
                            return 101011;
                        }
                        return this.tok;
                    }
                    case 101011: {
                        if (string.equals("jint") || string.equals("jvmdiError")) {
                            return this.prevTok;
                        }
                        return this.tok;
                    }
                }
                return this.tok;
            }
        }
        return this.tok;
    }

    void items() throws IOException {
        while ((this.tok = this.izer.nextToken()) != -1) {
            this.prevTok = this.item();
        }
        if (Main.nameMap.size() == 0) {
            this.error("Empty name map");
        }
    }
}

