/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

public class SimpleExample
extends JPanel {
    static JFrame frame;
    static String metal;
    static String metalClassName;
    static String motif;
    static String motifClassName;
    static String windows;
    static String windowsClassName;
    JRadioButton metalButton;
    JRadioButton motifButton;
    JRadioButton windowsButton;

    static {
        metal = "Metal";
        metalClassName = "javax.swing.plaf.metal.MetalLookAndFeel";
        motif = "Motif";
        motifClassName = "com.sun.java.swing.plaf.motif.MotifLookAndFeel";
        windows = "Windows";
        windowsClassName = "com.sun.java.swing.plaf.windows.WindowsLookAndFeel";
    }

    public SimpleExample() {
        JButton jButton = new JButton("Hello, world");
        jButton.setMnemonic('h');
        this.metalButton = new JRadioButton(metal);
        this.metalButton.setMnemonic('o');
        this.metalButton.setActionCommand(metalClassName);
        this.motifButton = new JRadioButton(motif);
        this.motifButton.setMnemonic('m');
        this.motifButton.setActionCommand(motifClassName);
        this.windowsButton = new JRadioButton(windows);
        this.windowsButton.setMnemonic('w');
        this.windowsButton.setActionCommand(windowsClassName);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.metalButton);
        buttonGroup.add(this.motifButton);
        buttonGroup.add(this.windowsButton);
        RadioListener radioListener = new RadioListener();
        this.metalButton.addActionListener(radioListener);
        this.motifButton.addActionListener(radioListener);
        this.windowsButton.addActionListener(radioListener);
        this.add(jButton);
        this.add(this.metalButton);
        this.add(this.motifButton);
        this.add(this.windowsButton);
    }

    public static void main(String[] stringArray) {
        SimpleExample simpleExample = new SimpleExample();
        frame = new JFrame("SimpleExample");
        frame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                System.exit(0);
            }
        });
        frame.getContentPane().add("Center", simpleExample);
        frame.pack();
        ((Component)frame).setVisible(true);
        simpleExample.updateState();
    }

    public void updateState() {
        String string = UIManager.getLookAndFeel().getClass().getName();
        if (string.indexOf(metal) >= 0) {
            this.metalButton.setSelected(true);
        } else if (string.indexOf(windows) >= 0) {
            this.windowsButton.setSelected(true);
        } else if (string.indexOf(motif) >= 0) {
            this.motifButton.setSelected(true);
        } else {
            System.err.println("SimpleExample is using an unknown L&F: " + string);
        }
    }

    class RadioListener
    implements ActionListener {
        RadioListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            try {
                UIManager.setLookAndFeel(string);
                SwingUtilities.updateComponentTreeUI(frame);
                frame.pack();
            }
            catch (Exception exception) {
                JRadioButton jRadioButton = (JRadioButton)actionEvent.getSource();
                jRadioButton.setEnabled(false);
                SimpleExample.this.updateState();
                System.err.println("Could not load LookAndFeel: " + string);
            }
        }
    }
}

