/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.im.iiimp;

import java.awt.event.KeyEvent;
import java.io.IOException;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Properties;
import java.util.StringTokenizer;
import sun.awt.im.iiimp.Data;
import sun.awt.im.iiimp.IIIMPDispatchEvent;
import sun.awt.im.iiimp.IIIMPICValues;
import sun.awt.im.iiimp.IIIMPIMValues;
import sun.awt.im.iiimp.IIIMPInputLanguage;
import sun.awt.im.iiimp.IIIMPInputStream;
import sun.awt.im.iiimp.IIIMPKeyEvent;
import sun.awt.im.iiimp.IIIMPOutputStream;
import sun.awt.im.iiimp.IIIMPURLConnection;
import sun.awt.im.iiimp.IIIMProtocol;
import sun.awt.im.iiimp.IIIMProtocolException;
import sun.awt.im.iiimp.InputMethod;
import sun.awt.im.iiimp.KeyEventData;
import sun.awt.im.iiimp.Packet;
import sun.awt.im.iiimp.PacketData;
import sun.awt.im.iiimp.StringData;

class IIIMPClient
implements IIIMProtocol {
    private static IIIMPClient client = null;
    private boolean connected = false;
    private String userName = null;
    private URL url = null;
    private IIIMPURLConnection uc;
    private IIIMPInputStream in;
    private IIIMPOutputStream out;
    private static final String IIIMP_PGK_PREFIX = "sun.awt.im";
    private static final String JAVA_PROTOCOL_HANDLER_PKGS = "java.protocol.handler.pkgs";

    static {
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                Properties properties;
                Properties properties2 = properties = System.getProperties();
                synchronized (properties2) {
                    String string = properties.getProperty(IIIMPClient.JAVA_PROTOCOL_HANDLER_PKGS);
                    if (string == null) {
                        string = IIIMPClient.IIIMP_PGK_PREFIX;
                    } else {
                        StringTokenizer stringTokenizer = new StringTokenizer(string, "|");
                        while (stringTokenizer.hasMoreTokens()) {
                            if (!stringTokenizer.nextToken().equals(IIIMPClient.IIIMP_PGK_PREFIX)) continue;
                            Object var2_5 = null;
                            Object var4_6 = null;
                            return var2_5;
                        }
                        string = String.valueOf(string) + "|sun.awt.im";
                    }
                    ((Hashtable)properties).put(IIIMPClient.JAVA_PROTOCOL_HANDLER_PKGS, string);
                }
                return null;
            }
        });
    }

    private IIIMPClient() {
    }

    void closeIM(int n) throws IOException {
        if (!this.connected) {
            return;
        }
        PacketData packetData = new PacketData(3);
        packetData.write2(n);
        packetData.write2(0);
        Packet packet = this.request(packetData.toPacket(), 4);
        if (packet.len == 0) {
            throw new IIIMProtocolException("IM_DISCONNECT_REPLY");
        }
        packetData = new PacketData(packet);
        int n2 = packetData.read2();
        if (n != n2) {
            throw new IIIMProtocolException("IM_DISCONNECT_REPLY");
        }
    }

    synchronized IIIMPIMValues connectIM() throws IOException {
        URL uRL;
        if (this.url != null) {
            return this.connectIMImpl(this.url);
        }
        final String string = (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return InputMethod.getProperty("iiimp.server", null);
            }
        });
        if (string == null) {
            throw new IOException("No IIIMP server specified");
        }
        try {
            uRL = (URL)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws MalformedURLException {
                    return new URL(string);
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw (IOException)privilegedActionException.getException();
        }
        IIIMPIMValues iIIMPIMValues = this.connectIMImpl(uRL);
        if (iIIMPIMValues != null) {
            this.url = uRL;
            return iIIMPIMValues;
        }
        return null;
    }

    IIIMPIMValues connectIMImpl(URL uRL) {
        try {
            this.uc = (IIIMPURLConnection)uRL.openConnection();
            if (!this.uc.isConnected()) {
                try {
                    AccessController.doPrivileged(new PrivilegedExceptionAction(){

                        public Object run() throws IOException {
                            IIIMPClient.this.uc.connect();
                            return null;
                        }
                    });
                }
                catch (PrivilegedActionException privilegedActionException) {
                    throw (IOException)privilegedActionException.getException();
                }
                if (!this.uc.isConnected()) {
                    throw new IOException();
                }
            }
            this.in = new IIIMPInputStream(this, this.uc.getInputStream());
            this.out = new IIIMPOutputStream(this.uc.getOutputStream());
            return this.openIM();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    int createIC(int n, Locale locale) throws IOException {
        if (!this.connected) {
            return -1;
        }
        PacketData packetData = new PacketData(20);
        packetData.write2(n);
        IIIMPICValues iIIMPICValues = new IIIMPICValues(locale);
        byte[] byArray = iIIMPICValues.getListOfICAttr();
        packetData.write2(byArray.length);
        packetData.writeBytes(byArray);
        Packet packet = this.request(packetData.toPacket(), 21);
        if (packet.len == 0) {
            throw new IIIMProtocolException("IM_CREATEIC_REPLY");
        }
        packetData = new PacketData(packet);
        packetData.read2();
        int n2 = packetData.read2();
        return n2;
    }

    void debugPrint(Packet packet, String string) {
    }

    void destroyIC(int n, int n2) throws IOException {
        if (!this.connected) {
            return;
        }
        PacketData packetData = new PacketData(22);
        packetData.write2(n);
        packetData.write2(n2);
        Packet packet = this.request(packetData.toPacket(), 23);
        if (packet.len == 0) {
            throw new IIIMProtocolException("IM_DESTROYIC_REPLY");
        }
        packetData = new PacketData(packet);
        packetData.read2();
        packetData.read2();
    }

    void disconnect() throws IOException {
        if (!this.connected) {
            return;
        }
        if (this.uc.isConnected()) {
            this.uc.disconnect();
        }
        this.connected = false;
    }

    private String getHostName() {
        try {
            InetAddress inetAddress = InetAddress.getLocalHost();
            return inetAddress.getHostName();
        }
        catch (Exception exception) {
            return null;
        }
    }

    IIIMPICValues getICValues(int n, int n2, IIIMPICValues iIIMPICValues) throws IOException {
        if (!this.connected) {
            return null;
        }
        PacketData packetData = new PacketData(26);
        packetData.write2(n);
        packetData.write2(n2);
        packetData.writeBytes(iIIMPICValues.getListOfICAttrId());
        Packet packet = this.request(packetData.toPacket(), 27);
        if (packet.len == 0) {
            throw new IIIMProtocolException("IM_GETICVALUES_REPLY");
        }
        packetData = new PacketData(packet);
        packetData.read2();
        packetData.read2();
        int n3 = packetData.read2();
        byte[] byArray = new byte[n3];
        packetData.read(byArray, 0, n3);
        packetData.read2();
        return new IIIMPICValues(byArray);
    }

    static IIIMPClient getInstance() {
        if (client == null) {
            client = new IIIMPClient();
        }
        return client;
    }

    private Packet getReply(int n) throws IOException {
        return this.getReply(n, 0);
    }

    private Packet getReply(int n, int n2) throws IOException {
        Packet packet;
        block1: {
            int n3;
            int n4;
            PacketData packetData;
            int n5;
            do {
                n3 = this.in.readOpCode();
                int n6 = this.in.readPacketLength();
                packet = this.in.readPacket(n3, n6);
                this.debugPrint(packet, "server->client");
                if (n3 == n || n3 == n2) break block1;
            } while (IIIMPDispatchEvent.processProtocol(n5 = (packetData = new PacketData(packet)).read2(), n4 = packetData.read2(), n3, packetData));
            this.lostConnect();
            throw new IIIMProtocolException("Unexpected protocol received: " + n3 + " against: " + n);
        }
        return packet;
    }

    boolean isConnected() {
        return this.connected;
    }

    synchronized void lostConnect() {
        if (!this.connected) {
            return;
        }
        InputMethod[] inputMethodArray = InputMethod.getInputMethod();
        if (inputMethodArray == null) {
            return;
        }
        int n = 0;
        while (n < inputMethodArray.length) {
            inputMethodArray[n].lostConnect();
            ++n;
        }
        this.connected = false;
    }

    void notifyTrigger(int n, int n2, boolean bl) throws IOException {
        if (!this.connected) {
            return;
        }
        PacketData packetData = new PacketData(6);
        packetData.write2(n);
        packetData.write2(n2);
        packetData.write2(bl ? 0 : 1);
        Packet packet = this.request(packetData.toPacket(), 7);
        if (packet.len == 0) {
            throw new IIIMProtocolException("IM_TRIGGER_NOTIFY_REPLY");
        }
        packetData = new PacketData(packet);
        packetData.read2();
        packetData.read2();
    }

    synchronized IIIMPIMValues openIM() throws IOException {
        int n;
        Object object;
        IIIMPIMValues iIIMPIMValues = new IIIMPIMValues();
        if (this.userName == null) {
            this.userName = (String)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return System.getProperty("user.name", null);
                }
            });
            object = this.getHostName();
            if (object != null) {
                this.userName = String.valueOf(this.userName) + "@" + (String)object;
            }
        }
        if (this.userName == null) {
            throw new IOException();
        }
        object = new PacketData(1);
        ((Data)object).write(66);
        ((Data)object).write(1);
        ((Data)object).writeString(this.userName);
        ((Data)object).write2(0);
        this.send(((PacketData)object).toPacket());
        this.out.flush();
        Packet packet = this.getReply(5, 2);
        if (packet.protocol == 5) {
            int n2;
            int n3;
            if (packet.len == 0) {
                throw new IIIMProtocolException("IM_REGISTER_TRIGGER_KEYS");
            }
            object = new PacketData(packet);
            ((Data)object).read2();
            ((Data)object).skipBytes(2);
            int n4 = ((Data)object).read4() / 16;
            if (n4 > 0) {
                iIIMPIMValues.onKey = new IIIMPKeyEvent[n4];
                n3 = 0;
                while (n3 < n4) {
                    n = ((Data)object).read4();
                    char c2 = (char)((Data)object).read4();
                    int n5 = ((Data)object).read4();
                    n2 = ((Data)object).read4();
                    iIIMPIMValues.onKey[n3] = new IIIMPKeyEvent(n, c2, n5);
                    ++n3;
                }
            }
            if ((n3 = ((Data)object).read4() / 16) > 0) {
                iIIMPIMValues.offKey = new IIIMPKeyEvent[n3];
                n = 0;
                while (n < n3) {
                    int n6 = ((Data)object).read4();
                    char c = (char)((Data)object).read4();
                    n2 = ((Data)object).read4();
                    int n7 = ((Data)object).read4();
                    iIIMPIMValues.offKey[n] = new IIIMPKeyEvent(n6, c, n2);
                    ++n;
                }
            }
            iIIMPIMValues.dynamic_event_flow = true;
            packet = this.getReply(2);
            if (packet.len == 0) {
                throw new IIIMProtocolException("IM_CONNECT_REPLY");
            }
        } else {
            iIIMPIMValues.dynamic_event_flow = false;
        }
        object = new PacketData(packet);
        iIIMPIMValues.id = ((Data)object).read2();
        String[] stringArray = null;
        try {
            StringData stringData = new StringData((Data)object);
            stringArray = stringData.toStringArray();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (stringArray != null) {
            int n6 = stringArray.length;
            iIIMPIMValues.localeList = new Locale[n6];
            n = 0;
            while (n < n6) {
                iIIMPIMValues.localeList[n] = IIIMPInputLanguage.toLocale(stringArray[n]);
                ++n;
            }
        }
        this.connected = true;
        return iIIMPIMValues;
    }

    boolean processKeyEvent(int n, int n2, KeyEvent keyEvent) throws IOException {
        if (!this.connected) {
            return false;
        }
        PacketData packetData = new PacketData(12);
        packetData.write2(n);
        packetData.write2(n2);
        packetData.write4(2);
        KeyEventData keyEventData = new KeyEventData(keyEvent);
        packetData.writeBytes(keyEventData.toByteStream());
        Packet packet = this.request(packetData.toPacket(), 13);
        if (packet.len == 0) {
            throw new IIIMProtocolException("IM_FORWARD_EVENT_REPLY");
        }
        packetData = new PacketData(packet);
        packetData.read2();
        packetData.read2();
        return true;
    }

    private synchronized Packet request(Packet packet, int n) throws IOException {
        this.out.writeBasicPacket(packet.protocol, packet.len);
        this.debugPrint(packet, "client->server");
        this.out.write(packet.buf, 0, packet.len);
        this.out.flush();
        return this.getReply(n, 0);
    }

    void resetIC(int n, int n2) throws IOException {
        if (!this.connected) {
            return;
        }
        PacketData packetData = new PacketData(32);
        packetData.write2(n);
        packetData.write2(n2);
        Packet packet = this.request(packetData.toPacket(), 33);
        if (packet.len == 0) {
            throw new IIIMProtocolException("IM_RESETIC_REPLY");
        }
        packetData = new PacketData(packet);
        packetData.read2();
        packetData.read2();
    }

    synchronized void send(Packet packet) throws IOException {
        this.out.writeBasicPacket(packet.protocol, packet.len);
        this.debugPrint(packet, "client->server");
        this.out.write(packet.buf, 0, packet.len);
    }

    void sendAuxData(int n, int n2, int n3, String string, int[] nArray, String[] stringArray) throws IOException {
        if (!this.connected) {
            return;
        }
        PacketData packetData = new PacketData(96);
        packetData.write2(n);
        packetData.write2(n2);
        packetData.write4(n3);
        packetData.writeString(string);
        Data data = new Data();
        int n4 = 0;
        while (n4 < nArray.length) {
            data.write4(nArray[n4]);
            ++n4;
        }
        packetData.write4(data.count);
        packetData.writeBytes(data.buf, data.count);
        data = new Data();
        int n5 = 0;
        while (n5 < stringArray.length) {
            data.writeString(stringArray[n5]);
            ++n5;
        }
        packetData.write4(data.count);
        packetData.writeBytes(data.buf, data.count);
        Packet packet = this.request(packetData.toPacket(), 97);
        if (packet.len == 0) {
            throw new IIIMProtocolException("IM_AUX_SETVALUES_REPLY");
        }
        packetData = new PacketData(packet);
        packetData.read2();
        packetData.read2();
        int n6 = packetData.read4();
        String string2 = packetData.readString();
    }

    void setFocus(int n, int n2, boolean bl) throws IOException {
        if (!this.connected) {
            return;
        }
        PacketData packetData = new PacketData(bl ? 28 : 30);
        packetData.write2(n);
        packetData.write2(n2);
        Packet packet = this.request(packetData.toPacket(), bl ? 29 : 31);
        if (packet.len == 0) {
            throw new IIIMProtocolException(bl ? "IM_SETICFOCUS_REPLY" : "IM_UNSETICFOCUS_REPLY");
        }
        packetData = new PacketData(packet);
        packetData.read2();
        packetData.read2();
    }

    boolean setICValues(int n, int n2, IIIMPICValues iIIMPICValues) throws IOException {
        if (!this.connected) {
            return false;
        }
        byte[] byArray = iIIMPICValues.getListOfICAttr();
        if (byArray == null) {
            return true;
        }
        PacketData packetData = new PacketData(24);
        packetData.write2(n);
        packetData.write2(n2);
        packetData.write2(byArray.length);
        packetData.writeBytes(byArray);
        packetData.write2(0);
        Packet packet = this.request(packetData.toPacket(), 25);
        if (packet.len == 0) {
            throw new IIIMProtocolException("IM_SETICVALUES_REPLY");
        }
        packetData = new PacketData(packet);
        packetData.read2();
        packetData.read2();
        return true;
    }
}

