/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.im.iiimp;

import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import sun.awt.im.iiimp.IIIMPClient;
import sun.awt.im.iiimp.IIIMProtocol;
import sun.awt.im.iiimp.IIIMProtocolException;
import sun.awt.im.iiimp.Packet;

class IIIMPInputStream
extends DataInputStream
implements IIIMProtocol {
    static int packet_size = 0;
    IIIMPClient client;

    IIIMPInputStream(IIIMPClient iIIMPClient, InputStream inputStream) {
        this(iIIMPClient, inputStream, 0);
    }

    IIIMPInputStream(IIIMPClient iIIMPClient, InputStream inputStream, int n) {
        super(inputStream);
        this.client = iIIMPClient;
        packet_size = n;
    }

    static int packetSize() {
        return packet_size;
    }

    public int read() throws IOException {
        try {
            int n = this.in.read();
            if (n == -1) {
                this.client.lostConnect();
            }
            return n;
        }
        catch (Exception exception) {
            this.client.lostConnect();
            throw new IOException("Connection lost");
        }
    }

    int readOpCode() throws IOException {
        int n = this.read();
        int n2 = n >>> 7 & 0xFF;
        if (n2 == 0) {
            packet_size = 0;
        } else if (n2 == 1) {
            packet_size = 1;
        }
        return n & 0x7F;
    }

    Packet readPacket(int n, int n2) throws IOException {
        byte[] byArray = null;
        if (n2 != 0) {
            byArray = new byte[n2];
            int n3 = 0;
            while (n2 - n3 > 0) {
                if ((n3 += this.read(byArray, n3, n2 - n3)) != -1) continue;
                throw new IIIMProtocolException(String.valueOf(n) + ": unexpected end of the stream");
            }
        }
        return new Packet(n, byArray, n2);
    }

    int readPacketLength() throws IOException {
        int n = 0;
        int n2 = this.read();
        if (n2 == -1) {
            return 0;
        }
        int n3 = this.read();
        int n4 = this.read();
        if (packet_size == 0) {
            if ((n | n2 | n3 | n4) < 0) {
                throw new EOFException();
            }
            return (n << 24) + (n2 << 16) + (n3 << 8) + n4 << 2;
        }
        if (packet_size == 1) {
            throw new IOException("8 byte length of packet");
        }
        return 0;
    }
}

