/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.im.iiimp;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Panel;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import sun.awt.im.iiimp.IIIMPWindow;
import sun.awt.im.iiimp.InputMethodLookupDraw;
import sun.awt.im.iiimp.InputMethodLookupText;
import sun.awt.im.iiimp.InputMethodText;
import sun.awt.im.iiimp.LookupEvent;

class LookupWindow
extends IIIMPWindow {
    private static final int widthM = 20;
    private static final int heightM = 45;
    private static final String fontFace = "Monospaced";
    private int fontHeight;
    private int fontAscent;
    private int fontWidth;
    private FontMetrics fm;
    private LookupPane pane;
    private int columHeight;
    private int rows = 0;
    private int cols = 0;
    private int ic_x = 0;
    private int ic_y = 0;
    private boolean isSame = false;

    LookupWindow() {
    }

    Point calculatePopupPosition() {
        Point point = new Point(this.ic_x, this.ic_y);
        Rectangle rectangle = this.win.getBounds();
        int n = rectangle.height;
        int n2 = rectangle.width;
        point.translate(0, 20);
        int n3 = point.y + n - IIIMPWindow.screenHeight;
        if (n3 > 0) {
            point.translate(0, (20 + n + 45) * -1);
        }
        if (point.x < 0) {
            point.translate(point.x * -1, 0);
        }
        if ((n3 = point.x + n2 - IIIMPWindow.screenWidth) > 0) {
            point.translate(n3 * -1, 0);
        }
        return point;
    }

    boolean compareText(InputMethodLookupText[] inputMethodLookupTextArray, int n, InputMethodLookupText[] inputMethodLookupTextArray2, int n2, int n3) {
        return false;
    }

    void init() {
        this.win = new Dialog(new Frame(""));
        ((Dialog)this.win).setResizable(true);
        Font font = new Font(fontFace, 0, 12);
        this.win.setFont(font);
        this.fm = Toolkit.getDefaultToolkit().getFontMetrics(font);
        this.fontHeight = this.fm.getHeight();
        this.fontWidth = this.fm.getMaxAdvance();
        this.fontAscent = this.fm.getAscent();
        this.columHeight = this.fontHeight + 2;
        this.pane = new LookupPane();
        this.win.add(this.pane);
        this.win.pack();
    }

    boolean isShowing() {
        return this.win == null ? false : this.win.isShowing();
    }

    void setLocation(int n, int n2) {
        this.ic_x = n;
        this.ic_y = n2;
    }

    void setRowCol(int n, int n2) {
        this.rows = n;
        this.cols = n2;
    }

    synchronized void show(LookupEvent lookupEvent) {
        InputMethodLookupDraw inputMethodLookupDraw;
        InputMethodText inputMethodText;
        if (this.source == null) {
            return;
        }
        if (this.win == null) {
            this.init();
        }
        if ((inputMethodText = (inputMethodLookupDraw = lookupEvent.getDraw()).getTitle()) != null) {
            ((Dialog)this.win).setTitle(inputMethodText.toString());
        } else {
            ((Dialog)this.win).setTitle("");
        }
        this.pane.setData(inputMethodLookupDraw);
        this.pane.repaint();
        this.win.show();
    }

    private class LookupPane
    extends Panel {
        private final int initSize = 26;
        private final int xMargin = 10;
        private final int yMargin = 5;
        private final int cMargin = 3;
        private int width = 0;
        private int height = 0;
        private int first = 0;
        private int last = 0;
        private int length = 0;
        private int current = 0;
        private int previous = 0;
        private InputMethodLookupText[] text = null;
        private String[] textDrawn = null;
        private int maxWidth = 0;

        LookupPane() {
            this.enableInputMethods(false);
            this.addFocusListener(new FocusLostListener());
            this.addKeyListener(new KeyTypeListener());
            this.addMouseListener(new MouseFocusListener());
            this.textDrawn = new String[26];
        }

        public void paint(Graphics graphics) {
            if (this.text == null || this.length == 0) {
                return;
            }
            int n = 10;
            int n2 = 5;
            if (!LookupWindow.this.isSame) {
                ((Component)LookupWindow.this.win).setSize(((LookupWindow)LookupWindow.this).pane.width + 20, ((LookupWindow)LookupWindow.this).pane.height + 45);
                Point point = LookupWindow.this.calculatePopupPosition();
                if (!point.equals(LookupWindow.this.win.getLocation())) {
                    ((Component)LookupWindow.this.win).setLocation(point.x, point.y);
                }
                LookupWindow.this.win.show();
            }
            int n3 = 0;
            while (n3 < this.length) {
                if (n3 % LookupWindow.this.cols == 0) {
                    n2 += LookupWindow.this.columHeight;
                    n = 10;
                } else {
                    n += this.maxWidth;
                }
                if (LookupWindow.this.isSame && n3 == this.previous) {
                    graphics.setColor(this.getBackground());
                    graphics.drawRoundRect(n - 3, n2 - LookupWindow.this.columHeight + 3, this.maxWidth - 3, LookupWindow.this.columHeight - 1, 3, 3);
                    graphics.setColor(this.getForeground());
                }
                if (n3 == this.current) {
                    graphics.drawRoundRect(n - 3, n2 - LookupWindow.this.columHeight + 3, this.maxWidth - 3, LookupWindow.this.columHeight - 1, 3, 3);
                }
                if (!LookupWindow.this.isSame) {
                    graphics.drawString(this.textDrawn[n3], n, n2);
                }
                ++n3;
            }
            LookupWindow.this.isSame = false;
        }

        void setData(InputMethodLookupDraw inputMethodLookupDraw) {
            int n = inputMethodLookupDraw.getFirstIndex();
            int n2 = inputMethodLookupDraw.getLastIndex();
            InputMethodLookupText[] inputMethodLookupTextArray = inputMethodLookupDraw.getText();
            if (this.length == n2 - n + 1 && LookupWindow.this.compareText(this.text, this.first, inputMethodLookupTextArray, n, this.length)) {
                LookupWindow.this.isSame = true;
            } else {
                this.text = inputMethodLookupTextArray;
                this.first = n;
                this.last = n2;
                this.length = this.last - this.first + 1;
                if (this.textDrawn.length < this.length) {
                    this.textDrawn = new String[this.length];
                }
                this.height = 0;
                this.width = 0;
                int n3 = 0;
                this.maxWidth = 0;
                int n4 = 0;
                while (n4 < this.length) {
                    String string = String.valueOf(this.text[this.first + n4].label.toString()) + " : " + this.text[this.first + n4].value.toString() + "  ";
                    int n5 = LookupWindow.this.fm.stringWidth(string);
                    if (this.maxWidth < n5) {
                        this.maxWidth = n5;
                    }
                    this.textDrawn[n4] = string;
                    if (n4 % LookupWindow.this.cols == 0) {
                        ++n3;
                    }
                    ++n4;
                }
                this.width = this.maxWidth * (this.length > LookupWindow.this.cols ? LookupWindow.this.cols : this.length);
                this.height = LookupWindow.this.columHeight * n3;
            }
            this.previous = this.current;
            this.current = inputMethodLookupDraw.current_index;
        }

        public void update(Graphics graphics) {
            if (!LookupWindow.this.isSame) {
                super.update(graphics);
                return;
            }
            this.paint(graphics);
        }
    }

    class FocusLostListener
    extends FocusAdapter {
        FocusLostListener() {
        }

        public void focusLost(FocusEvent focusEvent) {
            if (LookupWindow.this.win.isShowing()) {
                focusEvent.getComponent().requestFocus();
            }
        }
    }

    class KeyTypeListener
    extends KeyAdapter {
        KeyTypeListener() {
        }

        public void keyPressed(KeyEvent keyEvent) {
            if (LookupWindow.this.source != null) {
                LookupWindow.this.source.dispatchEvent(keyEvent);
            }
        }
    }

    class MouseFocusListener
    extends MouseAdapter {
        MouseFocusListener() {
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            if (LookupWindow.this.source != null) {
                KeyEvent keyEvent = new KeyEvent(LookupWindow.this.source, 401, mouseEvent.getWhen(), 0, 10, '\n');
                LookupWindow.this.source.dispatchEvent(keyEvent);
            }
        }
    }
}

