/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.JTextComponent;
import javax.swing.text.StyleConstants;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class ElementTreePanel
extends JPanel
implements CaretListener,
DocumentListener,
PropertyChangeListener,
TreeSelectionListener {
    protected JTree tree;
    protected JTextComponent editor;
    protected ElementTreeModel treeModel;
    protected boolean updatingSelection;

    public ElementTreePanel(JTextComponent jTextComponent) {
        this.editor = jTextComponent;
        Document document = jTextComponent.getDocument();
        this.treeModel = new ElementTreeModel(document);
        this.tree = new JTree(this.treeModel){

            public String convertValueToText(Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
                String string;
                if (!(object instanceof Element)) {
                    return object.toString();
                }
                Element element = (Element)object;
                AttributeSet attributeSet = element.getAttributes().copyAttributes();
                if (attributeSet != null) {
                    StringBuffer stringBuffer = new StringBuffer("[");
                    Enumeration<?> enumeration = attributeSet.getAttributeNames();
                    while (enumeration.hasMoreElements()) {
                        Object obj = enumeration.nextElement();
                        if (obj == StyleConstants.ResolveAttribute) continue;
                        stringBuffer.append(" ");
                        stringBuffer.append(obj);
                        stringBuffer.append("=");
                        stringBuffer.append(attributeSet.getAttribute(obj));
                    }
                    stringBuffer.append(" ]");
                    string = stringBuffer.toString();
                } else {
                    string = "[ ]";
                }
                if (element.isLeaf()) {
                    return String.valueOf(element.getName()) + " [" + element.getStartOffset() + ", " + element.getEndOffset() + "] Attributes: " + string;
                }
                return String.valueOf(element.getName()) + " [" + element.getStartOffset() + ", " + element.getEndOffset() + "] Attributes: " + string;
            }
        };
        this.tree.addTreeSelectionListener(this);
        this.tree.setRootVisible(false);
        this.tree.setCellRenderer(new DefaultTreeCellRenderer(){

            public Dimension getPreferredSize() {
                Dimension dimension = super.getPreferredSize();
                if (dimension != null) {
                    dimension.width += 15;
                }
                return dimension;
            }
        });
        document.addDocumentListener(this);
        jTextComponent.addPropertyChangeListener(this);
        jTextComponent.addCaretListener(this);
        this.setLayout(new BorderLayout());
        this.add((Component)new JScrollPane(this.tree), "Center");
        JLabel jLabel = new JLabel("Elements that make up the current document", 0);
        jLabel.setFont(new Font("Dialog", 1, 14));
        this.add((Component)jLabel, "North");
        this.setPreferredSize(new Dimension(400, 400));
    }

    public void caretUpdate(CaretEvent caretEvent) {
        if (!this.updatingSelection) {
            Object object;
            int n;
            JTextComponent jTextComponent = this.getEditor();
            int n2 = Math.min(caretEvent.getDot(), caretEvent.getMark());
            int n3 = Math.max(caretEvent.getDot(), caretEvent.getMark());
            Vector<Object> vector = new Vector<Object>();
            DefaultTreeModel defaultTreeModel = this.getTreeModel();
            Object object2 = defaultTreeModel.getRoot();
            int n4 = defaultTreeModel.getChildCount(object2);
            int n5 = 0;
            while (n5 < n4) {
                n = n2;
                while (n <= n3) {
                    object = this.getPathForIndex(n, object2, (Element)defaultTreeModel.getChild(object2, n5));
                    Element element = (Element)((TreePath)object).getLastPathComponent();
                    vector.addElement(object);
                    if (n >= element.getEndOffset()) {
                        ++n;
                        continue;
                    }
                    n = element.getEndOffset();
                }
                ++n5;
            }
            n = vector.size();
            if (n > 0) {
                object = new TreePath[n];
                vector.copyInto((Object[])object);
                this.updatingSelection = true;
                try {
                    this.getTree().setSelectionPaths((TreePath[])object);
                    this.getTree().scrollPathToVisible((TreePath)object[0]);
                }
                finally {
                    Object var13_14 = null;
                    this.updatingSelection = false;
                }
            }
        }
    }

    public void changedUpdate(DocumentEvent documentEvent) {
        this.updateTree(documentEvent);
    }

    protected JTextComponent getEditor() {
        return this.editor;
    }

    protected TreePath getPathForIndex(int n, Object object, Element element) {
        TreePath treePath = new TreePath(object);
        Element element2 = element.getElement(element.getElementIndex(n));
        treePath = treePath.pathByAddingChild(element);
        treePath = treePath.pathByAddingChild(element2);
        while (!element2.isLeaf()) {
            element2 = element2.getElement(element2.getElementIndex(n));
            treePath = treePath.pathByAddingChild(element2);
        }
        return treePath;
    }

    protected JTree getTree() {
        return this.tree;
    }

    public DefaultTreeModel getTreeModel() {
        return this.treeModel;
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        this.updateTree(documentEvent);
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getSource() == this.getEditor() && propertyChangeEvent.getPropertyName().equals("document")) {
            JTextComponent jTextComponent = this.getEditor();
            Document document = (Document)propertyChangeEvent.getOldValue();
            Document document2 = (Document)propertyChangeEvent.getNewValue();
            document.removeDocumentListener(this);
            document2.addDocumentListener(this);
            this.treeModel = new ElementTreeModel(document2);
            this.tree.setModel(this.treeModel);
        }
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        this.updateTree(documentEvent);
    }

    public void setEditor(JTextComponent jTextComponent) {
        Document document;
        if (this.editor == jTextComponent) {
            return;
        }
        if (this.editor != null) {
            document = this.editor.getDocument();
            document.removeDocumentListener(this);
            this.editor.removePropertyChangeListener(this);
            this.editor.removeCaretListener(this);
        }
        this.editor = jTextComponent;
        if (jTextComponent == null) {
            this.treeModel = null;
            this.tree.setModel(null);
        } else {
            document = jTextComponent.getDocument();
            document.addDocumentListener(this);
            jTextComponent.addPropertyChangeListener(this);
            jTextComponent.addCaretListener(this);
            this.treeModel = new ElementTreeModel(document);
            this.tree.setModel(this.treeModel);
        }
    }

    protected void updateTree(DocumentEvent documentEvent) {
        this.updatingSelection = true;
        try {
            DefaultTreeModel defaultTreeModel = this.getTreeModel();
            Object object = defaultTreeModel.getRoot();
            int n = defaultTreeModel.getChildCount(object) - 1;
            while (n >= 0) {
                this.updateTree(documentEvent, (Element)defaultTreeModel.getChild(object, n));
                --n;
            }
        }
        finally {
            Object var3_5 = null;
            this.updatingSelection = false;
        }
    }

    protected void updateTree(DocumentEvent documentEvent, Element element) {
        int n;
        DocumentEvent.ElementChange elementChange = documentEvent.getChange(element);
        if (elementChange != null) {
            int n2;
            int[] nArray;
            Object[] objectArray = elementChange.getChildrenRemoved();
            Element[] elementArray = elementChange.getChildrenAdded();
            n = elementChange.getIndex();
            if (objectArray != null && objectArray.length > 0) {
                nArray = new int[objectArray.length];
                n2 = 0;
                while (n2 < objectArray.length) {
                    nArray[n2] = n + n2;
                    ++n2;
                }
                this.getTreeModel().nodesWereRemoved((TreeNode)((Object)element), nArray, objectArray);
            }
            if (elementArray != null && elementArray.length > 0) {
                nArray = new int[elementArray.length];
                n2 = 0;
                while (n2 < elementArray.length) {
                    nArray[n2] = n + n2;
                    ++n2;
                }
                this.getTreeModel().nodesWereInserted((TreeNode)((Object)element), nArray);
            }
        }
        if (!element.isLeaf()) {
            int n3 = element.getElementIndex(documentEvent.getOffset());
            int n4 = element.getElementCount();
            n = Math.min(n4 - 1, element.getElementIndex(documentEvent.getOffset() + documentEvent.getLength()));
            if (n3 > 0 && n3 < n4 && element.getElement(n3).getStartOffset() == documentEvent.getOffset()) {
                --n3;
            }
            if (n3 != -1 && n != -1) {
                int n5 = n3;
                while (n5 <= n) {
                    this.updateTree(documentEvent, element.getElement(n5));
                    ++n5;
                }
            }
        } else {
            this.getTreeModel().nodeChanged((TreeNode)((Object)element));
        }
    }

    public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
        TreePath treePath;
        Object object;
        JTree jTree = this.getTree();
        if (!this.updatingSelection && jTree.getSelectionCount() == 1 && !((object = (treePath = jTree.getSelectionPath()).getLastPathComponent()) instanceof DefaultMutableTreeNode)) {
            Element element = (Element)object;
            this.updatingSelection = true;
            try {
                this.getEditor().select(element.getStartOffset(), element.getEndOffset());
            }
            finally {
                Object var7_6 = null;
                this.updatingSelection = false;
            }
        }
    }

    public static class ElementTreeModel
    extends DefaultTreeModel {
        protected Element[] rootElements;

        public ElementTreeModel(Document document) {
            super(new DefaultMutableTreeNode("root"), false);
            this.rootElements = document.getRootElements();
        }

        public Object getChild(Object object, int n) {
            if (object == this.root) {
                return this.rootElements[n];
            }
            return super.getChild(object, n);
        }

        public int getChildCount(Object object) {
            if (object == this.root) {
                return this.rootElements.length;
            }
            return super.getChildCount(object);
        }

        public int getIndexOfChild(Object object, Object object2) {
            if (object == this.root) {
                int n = this.rootElements.length - 1;
                while (n >= 0) {
                    if (this.rootElements[n] == object2) {
                        return n;
                    }
                    --n;
                }
                return -1;
            }
            return super.getIndexOfChild(object, object2);
        }

        protected TreeNode[] getPathToRoot(TreeNode treeNode, int n) {
            TreeNode[] treeNodeArray;
            if (treeNode == null) {
                if (n == 0) {
                    return null;
                }
                treeNodeArray = new TreeNode[n];
            } else {
                ++n;
                if (treeNode == this.root) {
                    treeNodeArray = new TreeNode[n];
                } else {
                    TreeNode treeNode2 = treeNode.getParent();
                    if (treeNode2 == null) {
                        treeNode2 = this.root;
                    }
                    treeNodeArray = this.getPathToRoot(treeNode2, n);
                }
                treeNodeArray[treeNodeArray.length - n] = treeNode;
            }
            return treeNodeArray;
        }

        public boolean isLeaf(Object object) {
            if (object == this.root) {
                return false;
            }
            return super.isLeaf(object);
        }

        public void nodeChanged(TreeNode treeNode) {
            if (this.listenerList != null && treeNode != null) {
                int n;
                TreeNode treeNode2 = treeNode.getParent();
                if (treeNode2 == null && treeNode != this.root) {
                    treeNode2 = this.root;
                }
                if (treeNode2 != null && (n = this.getIndexOfChild(treeNode2, treeNode)) != -1) {
                    int[] nArray = new int[]{n};
                    this.nodesChanged(treeNode2, nArray);
                }
            }
        }
    }
}

