#include "Language_Defines.h"


#ifdef POLISH

#include "Text.h"

/*

******************************************************************************************************
**                                  IMPORTANT TRANSLATION NOTES                                     **
******************************************************************************************************

GENERAL INSTRUCTIONS
- Always be aware that foreign strings should be of equal or shorter length than the English equivalent.
	I know that this is difficult to do on many occasions due to the nature of foreign languages when
	compared to English.  By doing so, this will greatly reduce the amount of work on both sides.  In
	most cases (but not all), JA2 interfaces were designed with just enough space to fit the English word.
	The general rule is if the string is very short (less than 10 characters), then it's short because of
	interface limitations.  On the other hand, full sentences commonly have little limitations for length.
	Strings in between are a little dicey.
- Never translate a string to appear on multiple lines.  All strings L"This is a really long string...",
	must fit on a single line no matter how long the string is.  All strings start with L" and end with ",
- Never remove any extra spaces in strings.  In addition, all strings containing multiple sentences only
	have one space after a period, which is different than standard typing convention.  Never modify sections
	of strings contain combinations of % characters.  These are special format characters and are always
	used in conjunction with other characters.  For example, %S means string, and is commonly used for names,
	locations, items, etc.  %d is used for numbers.  %c%d is a character and a number (such as A9).
	%% is how a single % character is built.  There are countless types, but strings containing these
	special characters are usually commented to explain what they mean.  If it isn't commented, then
	if you can't figure out the context, then feel free to ask SirTech.
- Comments are always started with // Anything following these two characters on the same line are
	considered to be comments.  Do not translate comments.  Comments are always applied to the following
	string(s) on the next line(s), unless the comment is on the same line as a string.
- All new comments made by SirTech will use "//@@@ comment" (without the quotes) notation.  By searching
	for @@@ everytime you recieve a new version, it will simplify your task and identify special instructions.
  Commonly, these types of comments will be used to ask you to abbreviate a string.  Please leave the
	comments intact, and SirTech will remove them once the translation for that particular area is resolved.
- If you have a problem or question with translating certain strings, please use "//!!! comment"
	(without the quotes).  The syntax is important, and should be identical to the comments used with @@@
	symbols.  SirTech will search for !!! to look for your problems and questions.  This is a more
	efficient method than detailing questions in email, so try to do this whenever possible.



FAST HELP TEXT -- Explains how the syntax of fast help text works.
**************

1) BOLDED LETTERS
	The popup help text system supports special characters to specify the hot key(s) for a button.
	Anytime you see a '|' symbol within the help text string, that means the following key is assigned
	to activate the action which is usually a button.

	EX:  L"|Map Screen"

	This means the 'M' is the hotkey.  In the game, when somebody hits the 'M' key, it activates that
	button.  When translating the text to another language, it is best to attempt to choose a word that
	uses 'M'.  If you can't always find a match, then the best thing to do is append the 'M' at the end
	of the string in this format:

	EX:  L"Ecran De Carte (|M)"  (this is the French translation)

	Other examples are used multiple times, like the Esc key  or "|E|s|c" or Space -> (|S|p|a|c|j|a)

2) NEWLINE
  Any place you see a \n within the string, you are looking at another string that is part of the fast help
	text system.  \n notation doesn't need to be precisely placed within that string, but whereever you wish
	to start a new line.

	EX:  L"Clears all the mercs' positions,\nand allows you to re-enter them manually."

	Would appear as:

				Clears all the mercs' positions,
				and allows you to re-enter them manually.

	NOTE:  It is important that you don't pad the characters adjacent to the \n with spaces.  If we did this
	       in the above example, we would see

	WRONG WAY -- spaces before and after the \n
	EX:  L"Clears all the mercs' positions, \n and allows you to re-enter them manually."

	Would appear as: (the second line is moved in a character)

				Clears all the mercs' positions,
 				 and allows you to re-enter them manually.


@@@ NOTATION
************

	Throughout the text files, you'll find an assortment of comments.  Comments are used to describe the
	text to make translation easier, but comments don't need to be translated.  A good thing is to search for
	"@@@" after receiving new version of the text file, and address the special notes in this manner.

!!! NOTATION
************

	As described above, the "!!!" notation should be used by you to ask questions and address problems as
	SirTech uses the "@@@" notation.

*/

wchar_t ItemNames[MAXITEMS][80] =
{
	L"",
};


wchar_t ShortItemNames[MAXITEMS][80] =
{
	L"",
};

// Different weapon calibres
// CAWS is Close Assault Weapon System and should probably be left as it is
// NATO is the North Atlantic Treaty Organization
// WP is Warsaw Pact
// cal is an abbreviation for calibre
const wchar_t AmmoCaliber[][20] =
{
	L"0",
	L".38 cal",
	L"9mm",
	L".45 cal",
	L".357 cal",
	L"12 gauge",
	L"CAWS",
	L"5.45mm",
	L"5.56mm",
	L"7.62mm NATO",
	L"7.62mm WP",
	L"4.7mm",
	L"5.7mm",
	L"Monstrum",
	L"Rakiety",
	L"", // dart
	L"", // flame
};

// This BobbyRayAmmoCaliber is virtually the same as AmmoCaliber however the bobby version doesnt have as much room for the words.
//
// Different weapon calibres
// CAWS is Close Assault Weapon System and should probably be left as it is
// NATO is the North Atlantic Treaty Organization
// WP is Warsaw Pact
// cal is an abbreviation for calibre
const wchar_t BobbyRayAmmoCaliber[][20] =
{
	L"0",
	L".38 cal",
	L"9mm",
	L".45 cal",
	L".357 cal",
	L"12 gauge",
	L"CAWS",
	L"5.45mm",
	L"5.56mm",
	L"7.62mm N.",
	L"7.62mm WP",
	L"4.7mm",
	L"5.7mm",
	L"Monstrum",
	L"Rakiety",
	L"", // dart
};


const wchar_t WeaponType[][30] =
{
	L"Inny",
	L"Pistolet",
	L"Pistolet maszynowy",
	L"Karabin maszynowy",
	L"Karabin",
	L"Karabin snajperski",
	L"Karabin bojowy",
	L"Lekki karabin maszynowy",
	L"Strzelba"
};

const wchar_t TeamTurnString[][STRING_LENGTH] =
{
	L"Tura gracza", // player's turn
	L"Tura przeciwnika",
	L"Tura stworze",
	L"Tura samoobrony",
	L"Tura cywili"
	// planning turn
};

const wchar_t Message[][STRING_LENGTH] =
{
	L"",

	// In the following 8 strings, the %S is the merc's name, and the %d (if any) is a number.

	L"%S dosta(a) w gow i traci 1 punkt inteligencji!",
	L"%S dosta(a) w rami i traci 1 punkt zrcznoci!",
	L"%S dosta(a) w klatk piersiow i traci 1 punkt siy!",
	L"%S dosta(a) w nogi i traci 1 punkt zwinnoci!",
	L"%S dosta(a) w gow i traci %d pkt. inteligencji!",
	L"%S dosta(a) w rami i traci %d pkt. zrcznoci!",
	L"%S dosta(a) w klatk piersiow i traci %d pkt. siy!",
	L"%S dosta(a) w nogi i traci %d pkt. zwinnoci!",
	L"Przerwanie!",

	// The first %S is a merc's name, the second is a string from pNoiseVolStr,
	// the third is a string from pNoiseTypeStr, and the last is a string from pDirectionStr

	L"", //OBSOLETE
	L"Dotary twoje posiki!",

	// In the following four lines, all %S's are merc names

	L"%S przeadowuje.",
	L"%S posiada za mao Punktw Akcji!",
	L"%S udziela pierwszej pomocy. (Nacinij dowolny klawisz aby przerwa.)",
	L"%S i %S udzielaj pierwszej pomocy. (Nacinij dowolny klawisz aby przerwa.)",
	// the following 17 strings are used to create lists of gun advantages and disadvantages
	// (separated by commas)
	L"niezawodna",
	L"zawodna",
	L"atwa w naprawie",
	L"trudna do naprawy",
	L"solidna",
	L"niesolidna",
	L"szybkostrzelna",
	L"wolno strzelajca",
	L"daleki zasig",
	L"krtki zasig",
	L"maa waga",
	L"dua waga",
	L"niewielkie rozmiary",
	L"szybki cigy ogie",
	L"brak cigego ognia",
	L"duy magazynek",
	L"may magazynek",

	// In the following two lines, all %S's are merc names

	L"%S: kamufla si star.",
	L"%S: kamufla si zmy.",

	// The first %S is a merc name and the second %S is an item name

	L"Brak amunicji w dodatkowej broni!",
	L"%S ukrad(a): %S.",

	// The %S is a merc name

	L"%S ma bro bez funkcji cigego ognia.",

	L"Ju masz co takiego doczone.",
	L"Poczy przedmioty?",

	// Both %S's are item names

	L"%S i %S nie pasuj do siebie.",

	L"Brak",
	L"Wyjmij amunicj",
	L"Dodatki",

	//You cannot use "item(s)" and your "other item" at the same time.
	//Ex:  You cannot use sun goggles and you gas mask at the same time.
	L" %S i %S nie mog by uywane jednoczenie.",

	L"Element, ktry masz na kursorze myszy moe by doczony do pewnych przedmiotw, poprzez umieszczenie go w jednym z czterech slotw.",
	L"Element, ktry masz na kursorze myszy moe by doczony do pewnych przedmiotw, poprzez umieszczenie go w jednym z czterech slotw. (Jednak w tym przypadku, przedmioty do siebie nie pasuj.)",
	L"Ten sektor nie zosta oczyszczony z wrogw!",
	L"Wci musisz da %S %S",
	L"%S dosta(a) w gow!",
	L"Przerwa walk?",
	L"Ta zmiana bdzie trwaa. Kontynuowa?",
	L"%S ma wicej energii!",
	L"%S polizgn(na) si na kulkach!",
	L"%S nie chwyci(a) - %S!",
	L"%S naprawi(a) %S",
	L"Przerwanie dla: ",
	L"Podda si?",
	L"Ta osoba nie chce twojej pomocy.",
	L"NIE SDZ!",
  	L"Aby podrowa helikopterem Skyridera, musisz najpierw zmieni przydzia najemnikw na POJAZD/HELIKOPTER.",
	L"%S mia(a) czas by przeadowa tylko jedn bro",
	L"Tura dzikich kotw",
};


// the names of the towns in the game

const wchar_t* pTownNames[] =
{
	L"",
	L"Omerta",
	L"Drassen",
	L"Alma",
	L"Grumm",
	L"Tixa",
	L"Cambria",
	L"San Mona",
	L"Estoni",
	L"Orta",
	L"Balime",
	L"Meduna",
	L"Chitzena",
};

// the types of time compression. For example: is the timer paused? at normal speed, 5 minutes per second, etc.
// min is an abbreviation for minutes

const wchar_t* sTimeStrings[] =
{
	L"Pauza",
	L"Normalna",
	L"5 min.",
	L"30 min.",
	L"60 min.",
	L"6 godz.", //NEW
};


// Assignment Strings: what assignment does the merc  have right now? For example, are they on a squad, training,
// administering medical aid (doctor) or training a town. All are abbreviated. 8 letters is the longest it can be.

const wchar_t* pAssignmentStrings[] =
{
	L"Oddz. 1",
	L"Oddz. 2",
	L"Oddz. 3",
	L"Oddz. 4",
	L"Oddz. 5",
	L"Oddz. 6",
	L"Oddz. 7",
	L"Oddz. 8",
	L"Oddz. 9",
	L"Oddz. 10",
	L"Oddz. 11",
	L"Oddz. 12",
	L"Oddz. 13",
	L"Oddz. 14",
	L"Oddz. 15",
	L"Oddz. 16",
	L"Oddz. 17",
	L"Oddz. 18",
	L"Oddz. 19",
	L"Oddz. 20",
	L"Suba", // on active duty
	L"Lekarz", // administering medical aid
	L"Pacjent", // getting medical aid
	L"Pojazd", // sitting around resting
	L"Podr", // in transit - abbreviated form
	L"Naprawa", // repairing
	L"Praktyka", // training themselves  // ***************NEW******************** as of June 24. 1998
	L"Samoobr.", // training a town to revolt // *************NEW******************** as of June 24, 1998
	L"Instruk.", // training a teammate
	L"Ucze", // being trained by someone else // *******************NEW************** as of June 24, 1998
	L"Nie yje", // dead
	L"Obezw.", // abbreviation for incapacitated
	L"Jeniec", // Prisoner of war - captured
	L"Szpital", // patient in a hospital
	L"Pusty",	// Vehicle is empty
};


const wchar_t* pMilitiaString[] =
{
	L"Samoobrona", // the title of the militia box
	L"Bez przydziau", //the number of unassigned militia troops
	L"Nie moesz przemieszcza oddziaw samoobrony gdy nieprzyjaciel jest w sektorze!",
};


const wchar_t* pMilitiaButtonString[] =
{
	L"Auto", // auto place the militia troops for the player
	L"OK", // done placing militia troops
};

const wchar_t* pConditionStrings[] =
{
	L"Doskonay", //the state of a soldier .. excellent health
	L"Dobry", // good health
	L"Do dobry", // fair health
	L"Ranny", // wounded health
	L"Zmczony",//L"Wyczerpany", // tired
	L"Krwawi", // bleeding to death
	L"Nieprzyt.", // knocked out
	L"Umierajcy", // near death
	L"Nie yje", // dead
};

const wchar_t* pEpcMenuStrings[] =
{
	L"Suba", // set merc on active duty
	L"Pacjent", // set as a patient to receive medical aid
	L"Pojazd", // tell merc to enter vehicle
	L"Wypu", // let the escorted character go off on their own
	L"Anuluj", // close this menu
};


// look at pAssignmentString above for comments

const wchar_t* pPersonnelAssignmentStrings[] =
{
	L"Oddz. 1",
	L"Oddz. 2",
	L"Oddz. 3",
	L"Oddz. 4",
	L"Oddz. 5",
	L"Oddz. 6",
	L"Oddz. 7",
	L"Oddz. 8",
	L"Oddz. 9",
	L"Oddz. 10",
	L"Oddz. 11",
	L"Oddz. 12",
	L"Oddz. 13",
	L"Oddz. 14",
	L"Oddz. 15",
	L"Oddz. 16",
	L"Oddz. 17",
	L"Oddz. 18",
	L"Oddz. 19",
	L"Oddz. 20",
	L"Suba",
	L"Lekarz",
	L"Pacjent",
	L"Pojazd",
	L"Podr",
	L"Naprawa",
	L"Praktyka",
	L"Trenuje samoobron",
	L"Instruktor",
	L"Ucze",
	L"Nie yje",
	L"Obezwadniony",
	L"Jeniec",
	L"Szpital",
	L"Pusty",	// Vehicle is empty
};


// refer to above for comments

const wchar_t* pLongAssignmentStrings[] =
{
	L"Oddzia 1",
	L"Oddzia 2",
	L"Oddzia 3",
	L"Oddzia 4",
	L"Oddzia 5",
	L"Oddzia 6",
	L"Oddzia 7",
	L"Oddzia 8",
	L"Oddzia 9",
	L"Oddzia 10",
	L"Oddzia 11",
	L"Oddzia 12",
	L"Oddzia 13",
	L"Oddzia 14",
	L"Oddzia 15",
	L"Oddzia 16",
	L"Oddzia 17",
	L"Oddzia 18",
	L"Oddzia 19",
	L"Oddzia 20",
	L"Suba",
	L"Lekarz",
	L"Pacjent",
	L"Pojazd",
	L"W podry",
	L"Naprawa",
	L"Praktyka",
	L"Trenuj samoobron",
	L"Trenuj oddzia",
	L"Ucze",
	L"Nie yje",
	L"Obezwadniony",
	L"Jeniec",
	L"W szpitalu",
	L"Pusty",	// Vehicle is empty
};


// the contract options

const wchar_t* pContractStrings[] =
{
	L"Opcje kontraktu:",
	L"", // a blank line, required
	L"Zaproponuj 1 dzie", // offer merc a one day contract extension
	L"Zaproponuj 1 tydzie", // 1 week
	L"Zaproponuj 2 tygodnie", // 2 week
	L"Zwolnij", // end merc's contract
	L"Anuluj", // stop showing this menu
};

const wchar_t* pPOWStrings[] =
{
	L"Jeniec",  //an acronym for Prisoner of War
	L"??",
};

const wchar_t* pLongAttributeStrings[] =
{
	L"SIA", //The merc's strength attribute. Others below represent the other attributes.
	L"ZRCZNO",
	L"ZWINNO",
	L"INTELIGENCJA",
	L"UMIEJTNOCI STRZELECKIE",
	L"WIEDZA MEDYCZNA",
	L"ZNAJOMO MECHANIKI",
	L"UMIEJTNO DOWODZENIA",
	L"ZNAJOMO MATERIAW WYBUCHOWYCH",
	L"POZIOM DOWIADCZENIA",
};

const wchar_t* pInvPanelTitleStrings[] =
{
	L"Osona", // the armor rating of the merc
	L"Ekwip.", // the weight the merc is carrying
	L"Kamuf.", // the merc's camouflage rating
};

const wchar_t* pShortAttributeStrings[] =
{
	L"Zwn", // the abbreviated version of : agility
	L"Zrc", // dexterity
	L"Si", // strength
	L"Dow", // leadership
	L"Int", // wisdom
	L"Do", // experience level
	L"Str", // marksmanship skill
	L"Wyb", // explosive skill
	L"Mec", // mechanical skill
	L"Med", // medical skill
};


const wchar_t* pUpperLeftMapScreenStrings[] =
{
	L"Przydzia", // the mercs current assignment // *********************NEW****************** as of June 24, 1998
	L"Kontrakt", // the contract info about the merc
	L"Zdrowie", // the health level of the current merc
	L"Morale", // the morale of the current merc
	L"Stan",	// the condition of the current vehicle
	L"Paliwo",	// the fuel level of the current vehicle
};

const wchar_t* pTrainingStrings[] =
{
	L"Praktyka", // tell merc to train self // ****************************NEW******************* as of June 24, 1998
	L"Samoobrona", // tell merc to train town // *****************************NEW ****************** as of June 24, 1998
	L"Instruktor", // tell merc to act as trainer
	L"Ucze", // tell merc to be train by other // **********************NEW******************* as of June 24, 1998
};

const wchar_t* pGuardMenuStrings[] =
{
	L"Limit ognia:", // the allowable rate of fire for a merc who is guarding
	L" Agresywny ogie", // the merc can be aggressive in their choice of fire rates
	L" Oszczdzaj amunicj", // conserve ammo
	L" Strzelaj w ostatecznoci", // fire only when the merc needs to
	L"Inne opcje:", // other options available to merc
	L" Moe si wycofa", // merc can retreat
	L" Moe szuka schronienia",  // merc is allowed to seek cover
	L" Moe pomaga partnerom", // merc can assist teammates
	L"OK", // done with this menu
	L"Anuluj", // cancel this menu
};

// This string has the same comments as above, however the * denotes the option has been selected by the player

const wchar_t* pOtherGuardMenuStrings[] =
{
	L"Limit ognia:",
	L" *Agresywny ogie*",
	L" *Oszczdzaj amunicj*",
	L" *Strzelaj w ostatecznoci*",
	L"Inne opcje:",
	L" *Moe si wycofa*",
	L" *Moe szuka schronienia*",
	L" *Moe pomaga partnerom*",
	L"OK",
	L"Anuluj",
};

const wchar_t* pAssignMenuStrings[] =
{
	L"Suba", // merc is on active duty
	L"Lekarz", // the merc is acting as a doctor
	L"Pacjent", // the merc is receiving medical attention
	L"Pojazd", // the merc is in a vehicle
	L"Naprawa", // the merc is repairing items
	L"Szkolenie", // the merc is training
	L"Anuluj", // cancel this menu
};

const wchar_t* pRemoveMercStrings[] =
{
	L"Usu najemnika", // remove dead merc from current team
	L"Anuluj",
};

const wchar_t* pAttributeMenuStrings[] =
{
	L"Sia",
	L"Zrczno",
	L"Zwinno",
	L"Zdrowie",
	L"Um. strzeleckie",
	L"Wiedza med.",
	L"Zn. mechaniki",
	L"Um. dowodzenia",
	L"Zn. mat. wyb.",
	L"Anuluj",
};

const wchar_t* pTrainingMenuStrings[] =
{
 L"Praktyka", // train yourself //****************************NEW************************** as of June 24, 1998
 L"Samoobrona", // train the town // ****************************NEW ************************* as of June 24, 1998
 L"Instruktor", // train your teammates // *******************NEW************************** as of June 24, 1998
 L"Ucze",  // be trained by an instructor //***************NEW************************** as of June 24, 1998
 L"Anuluj", // cancel this menu
};


const wchar_t* pSquadMenuStrings[] =
{
	L"Oddzia  1",
	L"Oddzia  2",
	L"Oddzia  3",
	L"Oddzia  4",
	L"Oddzia  5",
	L"Oddzia  6",
	L"Oddzia  7",
	L"Oddzia  8",
	L"Oddzia  9",
	L"Oddzia 10",
	L"Oddzia 11",
	L"Oddzia 12",
	L"Oddzia 13",
	L"Oddzia 14",
	L"Oddzia 15",
	L"Oddzia 16",
	L"Oddzia 17",
	L"Oddzia 18",
	L"Oddzia 19",
	L"Oddzia 20",
	L"Anuluj",
};

const wchar_t* pPersonnelTitle[] =
{
	L"Personel", // the title for the personnel screen/program application
};

const wchar_t* pPersonnelScreenStrings[] =
{
	L"Zdrowie: ", // health of merc
	L"Zwinno: ",
	L"Zrczno: ",
 	L"Sia: ",
 	L"Um. dowodzenia: ",
 	L"Inteligencja: ",
 	L"Poziom dow.: ", // experience level
 	L"Um. strzeleckie: ",
 	L"Zn. mechaniki: ",
 	L"Zn. mat. wybuchowych: ",
 	L"Wiedza medyczna: ",
 	L"Zastaw na ycie: ", // amount of medical deposit put down on the merc
 	L"Biecy kontrakt: ", // cost of current contract
 	L"Liczba zabjstw: ", // number of kills by merc
 	L"Liczba asyst: ", // number of assists on kills by merc
 	L"Dzienny koszt:", // daily cost of merc
 	L"Oglny koszt:", // total cost of merc
 	L"Warto kontraktu:", // cost of current contract
 	L"Usugi ogem", // total service rendered by merc
 	L"Zalega kwota", // amount left on MERC merc to be paid
 	L"Celno:", // percentage of shots that hit target
 	L"Ilo walk:", // number of battles fought
 	L"Ranny(a):", // number of times merc has been wounded
 	L"Umiejtnoci:",
 	L"Brak umijtnoci",
};


//These string correspond to enums used in by the SkillTrait enums in SoldierProfileType.h
const wchar_t* gzMercSkillText[] =
{
	L"Brak umiejtnoci",
	L"Otwieranie zamkw",
	L"Walka wrcz",
	L"Elektronika",
	L"Nocne operacje",
	L"Rzucanie",
	L"Szkolenie",
	L"Cika bro",
	L"Bro automatyczna",
	L"Skradanie si",
	L"Oburczno",
	L"Kradziee",
	L"Sztuki walki",
	L"Bro biaa",
	L"Snajper",
	L"Kamufla",
	L"(Eksp.)",
};


// This is pop up help text for the options that are available to the merc

const wchar_t* pTacticalPopupButtonStrings[] =
{
	L"W|sta/Id",
	L"S|chyl si/Id",
	L"Wsta/Biegnij (|R)",
	L"|Padnij/Czogaj si",
	L"Patrz (|L)",
	L"Akcja",
	L"Rozmawiaj",
	L"Zbadaj (|C|t|r|l)",

	// Pop up door menu
	L"Otwrz",
	L"Poszukaj puapek",
	L"Uyj wytrychw",
	L"Wywa",
	L"Usu puapki",
	L"Zamknij na klucz",
	L"Otwrz kluczem",
	L"Uyj adunku wybuchowego",
	L"Uyj omu",
	L"Anuluj (|E|s|c)",
	L"Zamknij"
};

// Door Traps. When we examine a door, it could have a particular trap on it. These are the traps.

const wchar_t* pDoorTrapStrings[] =
{
	L"nie posiada adnych puapek",
	L"ma zaoony adunek wybuchowy",
	L"jest pod napiciem",
	L"posiada syren alarmow",
	L"posiada dyskretny alarm"
};

// Contract Extension. These are used for the contract extension with AIM mercenaries.

const wchar_t* pContractExtendStrings[] =
{
	L"dzie",
	L"tydzie",
	L"dwa tygodnie",
};

// On the map screen, there are four columns. This text is popup help text that identifies the individual columns.

const wchar_t* pMapScreenMouseRegionHelpText[] =
{
	L"Wybr postaci",
	L"Przydzia najemnika",
	L"Nanie tras podry",
	L"Kontrakt najemnika",
	L"Usu najemnika",
	L"pij", // *****************************NEW********************* as of June 29, 1998
};

// volumes of noises

const wchar_t* pNoiseVolStr[] =
{
	L"CICHY",
	L"WYRANY",
	L"GONY",
	L"BARDZO GONY"
};

// types of noises

const wchar_t* pNoiseTypeStr[] = // OBSOLETE
{
	L"NIEOKRELONY DWIK",
	L"ODGOS RUCHU",
	L"ODGOS SKRZYPNICIA",
	L"PLUSK",
	L"ODGOS UDERZENIA",
	L"STRZA",
	L"WYBUCH",
	L"KRZYK",
	L"ODGOS UDERZENIA",
	L"ODGOS UDERZENIA",
	L"OMOT",
	L"TRZASK"
};

// Directions that are used to report noises

const wchar_t* pDirectionStr[] =
{
	L"PN-WSCH",
	L"WSCH",
	L"PD-WSCH",
	L"PD",
	L"PD-ZACH",
	L"ZACH",
	L"PN-ZACH",
	L"PN"
};

// These are the different terrain types.

const wchar_t* pLandTypeStrings[] =
{
	L"Miasto",
	L"Droga",
	L"Otwarty teren",
	L"Pustynia",
	L"Las",
	L"Las",
	L"Bagno",
	L"Woda",
	L"Wzgrza",
	L"Teren nieprzejezdny",
	L"Rzeka",	//river from north to south
	L"Rzeka",	//river from east to west
	L"Terytorium innego kraju",
	//NONE of the following are used for directional travel, just for the sector description.
	L"Tropiki",
	L"Pola uprawne",
	L"Otwarty teren, droga",
	L"Las, droga",
	L"Las, droga",
	L"Tropiki, droga",
	L"Las, droga",
	L"Wybrzee",
	L"Gry, droga",
	L"Wybrzee, droga",
	L"Pustynia, droga",
	L"Bagno, droga",
	L"Las, Rakiety Z-P",
	L"Pustynia, Rakiety Z-P",
	L"Tropiki, Rakiety Z-P",
	L"Meduna, Rakiety Z-P",

	//These are descriptions for special sectors
	L"Szpital w Cambrii",
	L"Lotnisko w Drassen",
	L"Lotnisko w Medunie",
	L"Rakiety Z-P",
	L"Kryjwka rebeliantw", //The rebel base underground in sector A10
	L"Tixa - Lochy",	//The basement of the Tixa Prison (J9)
	L"Gniazdo stworze",	//Any mine sector with creatures in it
	L"Orta - Piwnica",	//The basement of Orta (K4)
	L"Tunel",				//The tunnel access from the maze garden in Meduna
						//leading to the secret shelter underneath the palace
	L"Schron",				//The shelter underneath the queen's palace
	L"",							//Unused
};

const wchar_t* gpStrategicString[] =
{
	L"",	//Unused
	L"%S wykryto w sektorze %c%d, a inny oddzia jest w drodze.",	//STR_DETECTED_SINGULAR
	L"%S wykryto w sektorze %c%d, a inne oddziay s w drodze.",	//STR_DETECTED_PLURAL
	L"Chcesz skoordynowa jednoczesne przybycie?",			//STR_COORDINATE

	//Dialog strings for enemies.

	L"Wrg daje ci szans si podda.",			//STR_ENEMY_SURRENDER_OFFER
	L"Wrg schwyta reszt twoich nieprzytomnych najemnikw.",	//STR_ENEMY_CAPTURED

	//The text that goes on the autoresolve buttons

	L"Odwrt", 		//The retreat button				//STR_AR_RETREAT_BUTTON
	L"OK",		//The done button				//STR_AR_DONE_BUTTON

	//The headers are for the autoresolve type (MUST BE UPPERCASE)

	L"OBRONA",								//STR_AR_DEFEND_HEADER
	L"ATAK",								//STR_AR_ATTACK_HEADER
	L"STARCIE",								//STR_AR_ENCOUNTER_HEADER
	L"Sektor",		//The Sector A9 part of the header		//STR_AR_SECTOR_HEADER

	//The battle ending conditions

	L"ZWYCISTWO!",								//STR_AR_OVER_VICTORY
	L"PORAKA!",								//STR_AR_OVER_DEFEAT
	L"KAPITULACJA!",							//STR_AR_OVER_SURRENDERED
	L"NIEWOLA!",								//STR_AR_OVER_CAPTURED
	L"ODWRT!",								//STR_AR_OVER_RETREATED

	//These are the labels for the different types of enemies we fight in autoresolve.

	L"Samoobrona",							//STR_AR_MILITIA_NAME,
	L"Elity",								//STR_AR_ELITE_NAME,
	L"onierze",								//STR_AR_TROOP_NAME,
	L"Administrator",							//STR_AR_ADMINISTRATOR_NAME,
	L"Stworzenie",								//STR_AR_CREATURE_NAME,

	//Label for the length of time the battle took

	L"Czas trwania",							//STR_AR_TIME_ELAPSED,

	//Labels for status of merc if retreating.  (UPPERCASE)

	L"WYCOFA(A) SI",								//STR_AR_MERC_RETREATED,
	L"WYCOFUJE SI",								//STR_AR_MERC_RETREATING,
	L"WYCOFAJ SI",								//STR_AR_MERC_RETREAT,

	//PRE BATTLE INTERFACE STRINGS
	//Goes on the three buttons in the prebattle interface.  The Auto resolve button represents
	//a system that automatically resolves the combat for the player without having to do anything.
	//These strings must be short (two lines -- 6-8 chars per line)

	L"Rozst. autom.",							//STR_PB_AUTORESOLVE_BTN,
	L"Id do sektora",							//STR_PB_GOTOSECTOR_BTN,
	L"Wycof. ludzi",							//STR_PB_RETREATMERCS_BTN,

	//The different headers(titles) for the prebattle interface.
	L"STARCIE Z WROGIEM",							//STR_PB_ENEMYENCOUNTER_HEADER,
	L"INWAZJA WROGA",							//STR_PB_ENEMYINVASION_HEADER, // 30
	L"ZASADZKA WROGA",
	L"WEJCIE DO WROGIEGO SEKTORA",
	L"ATAK STWORW",
	L"ATAK DZIKICH KOTW",							//STR_PB_BLOODCATAMBUSH_HEADER
	L"WEJCIE DO LEGOWISKA DZIKICH KOTW",			//STR_PB_ENTERINGBLOODCATLAIR_HEADER

	//Various single words for direct translation.  The Civilians represent the civilian
	//militia occupying the sector being attacked.  Limited to 9-10 chars

	L"Pooenie",
	L"Wrogowie",
	L"Najemnicy",
	L"Samoobrona",
	L"Stwory",
	L"Dzikie koty",
	L"Sektor",
	L"Brak",		//If there are no uninvolved mercs in this fight.
	L"N/D",			//Acronym of Not Applicable N/A
	L"d",			//One letter abbreviation of day
	L"g",			//One letter abbreviation of hour

	//TACTICAL PLACEMENT USER INTERFACE STRINGS
	//The four buttons

	L"Wyczy",
	L"Rozprosz",
	L"Zgrupuj",
	L"OK",

	//The help text for the four buttons.  Use \n to denote new line (just like enter).

	L"Kasuje wszystkie pozy|cje najemnikw, \ni pozwala ponownie je wprowadzi.",
	L"Po kadym naciniciu rozmie|szcza\nlosowo twoich najemnikw.",
	L"|Grupuje najemnikw w wybranym miejscu.",
	L"Kliknij ten klawisz gdy ju rozmiecisz \nswoich najemnikw. (|E|n|t|e|r)",
	L"Musisz rozmieci wszystkich najemnikw \nzanim rozpoczniesz walk.",

	//Various strings (translate word for word)

	L"Sektor",
	L"Wybierz pocztkowe pozycje",

	//Strings used for various popup message boxes.  Can be as long as desired.

	L"To miejsce nie jest zbyt dobre. Jest niedostpne. Sprbuj gdzie indziej.",
	L"Rozmie swoich najemnikw na podwietlonej czci mapy.",

	//This message is for mercs arriving in sectors.  Ex:  Red has arrived in sector A9.
	//Don't uppercase first character, or add spaces on either end.

	L"przyby(a) do sektora",

	//These entries are for button popup help text for the prebattle interface.  All popup help
	//text supports the use of \n to denote new line.  Do not use spaces before or after the \n.
	L"|Automatycznie prowadzi walk za ciebie,\nnie adujc planszy.",
	L"Atakujc sektor wroga nie mona automatycznie rozstrzygn walki.",
	L"Wejcie do s|ektora by nawiza walk z wrogiem.",
	L"Wycofuje oddzia do ssiedniego sekto|ra.",				//singular version
	L"Wycofuje wszystkie oddziay do ssiedniego sekto|ra.", //multiple groups with same previous sector

	//various popup messages for battle conditions.

	//%c%d is the sector -- ex:  A9
	L"Nieprzyjaciel zatakowa oddziay samoobrony w sektorze %c%d.",
	//%c%d is the sector -- ex:  A9
	L"Stworzenia zaatakoway oddziay samoobrony w sektorze %c%d.",
	//1st %d refers to the number of civilians eaten by monsters,  %c%d is the sector -- ex:  A9
	//Note:  the minimum number of civilians eaten will be two.
	L"Stworzenia zatakoway i zabiy %d cywili w sektorze %S.",
	//%c%d is the sector -- ex:  A9
	L"Nieprzyjaciel zatakowa twoich najemnikw w sektorze %S.  aden z twoich najemnikw nie moe walczy!",
	//%c%d is the sector -- ex:  A9
	L"Stworzenia zatakoway twoich najemnikw w sektorze %S.  aden z twoich najemnikw nie moe walczy!",

};

const wchar_t* gpGameClockString[] =
{
	//This is the day represented in the game clock.  Must be very short, 4 characters max.
	L"Dzie",
};

//When the merc finds a key, they can get a description of it which
//tells them where and when they found it.
const wchar_t* sKeyDescriptionStrings[2] =
{
	L"Zn. w sektorze:",
	L"Zn. w dniu:",
};

//The headers used to describe various weapon statistics.

const wchar_t gWeaponStatsDesc[][ 14 ] =
{
	L"Waga (%S):", // change kg to another weight unit if your standard is not kilograms, and TELL SIR-TECH!
	L"Stan:",
	L"Ilo:", 		// Number of bullets left in a magazine
	L"Zas.:",		// Range
	L"Sia:",		// Damage
    L"PA:",                 // abbreviation for Action Points
	L"",
	L"=",
	L"=",
};

//The headers used for the merc's money.

const wchar_t gMoneyStatsDesc[][ 13 ] =
{
	L"Kwota",
	L"Pozostao:", //this is the overall balance
	L"Kwota",
	L"Wydzieli:", // the amount he wants to separate from the overall balance to get two piles of money

	L"Biece",
	L"Saldo",
	L"Kwota do",
	L"podjcia",
};

//The health of various creatures, enemies, characters in the game. The numbers following each are for comment
//only, but represent the precentage of points remaining.

const wchar_t zHealthStr[][13] =
{
	L"UMIERAJCY",		//	>= 0
	L"KRYTYCZNY", 		//	>= 15
	L"KIEPSKI",		//	>= 30
	L"RANNY",    	//	>= 45
	L"ZDROWY",    	//	>= 60
	L"SILNY",     	// 	>= 75
	L"DOSKONAY",		// 	>= 90
};

const wchar_t* gzMoneyAmounts[6] =
{
	L"$1000",
	L"$100",
	L"$10",
	L"OK",
	L"Wydziel",
	L"Podejmij",
};

// short words meaning "Advantages" for "Pros" and "Disadvantages" for "Cons."
const wchar_t gzProsLabel[10] =
{
	L"Zalety:",
};

const wchar_t gzConsLabel[10] =
{
	L"Wady:",
};

//Conversation options a player has when encountering an NPC
const wchar_t zTalkMenuStrings[6][ SMALL_STRING_LENGTH ] =
{
	L"Powtrz", 	//meaning "Repeat yourself"
	L"Przyjanie",		//approach in a friendly
	L"Bezporednio",		//approach directly - let's get down to business
	L"Gronie",		//approach threateningly - talk now, or I'll blow your face off
	L"Daj",
	L"Rekrutuj",
};

//Some NPCs buy, sell or repair items. These different options are available for those NPCs as well.
const wchar_t zDealerStrings[4][ SMALL_STRING_LENGTH ]=
{
	L"Kup/Sprzedaj",
	L"Kup",
	L"Sprzedaj",
	L"Napraw",
};

const wchar_t zDialogActions[1][ SMALL_STRING_LENGTH ] =
{
	L"OK",
};


//These are vehicles in the game.

const wchar_t* pVehicleStrings[] =
{
 L"Eldorado",
 L"Hummer", // a hummer jeep/truck -- military vehicle
 L"Furgonetka z lodami",
 L"Jeep",
 L"Czog",
 L"Helikopter",
};

const wchar_t* pShortVehicleStrings[] =
{
	L"Eldor.",
	L"Hummer",			// the HMVV
	L"Furg.",
	L"Jeep",
	L"Czog",
	L"Heli.", 				// the helicopter
};

const wchar_t* zVehicleName[] =
{
	L"Eldorado",
	L"Hummer",		//a military jeep. This is a brand name.
	L"Furg.",			// Ice cream truck
	L"Jeep",
	L"Czog",
	L"Heli.", 		//an abbreviation for Helicopter
};


//These are messages Used in the Tactical Screen

const wchar_t TacticalStr[][ MED_STRING_LENGTH ] =
{
	L"Nalot",
	L"Udzieli automatycznie pierwszej pomocy?",

	// CAMFIELD NUKE THIS and add quote #66.

	L"%S zauway(a) e dostawa jest niekompletna.",

	// The %S is a string from pDoorTrapStrings

	L"Zamek %S.",
	L"Brak zamka.",
	L"Sukces!",
	L"Niepowodzenie.",
	L"Sukces!",
	L"Niepowodzenie.",
	L"Zamek nie ma puapek.",
	L"Sukces!",
	// The %S is a merc name
	L"%S nie posiada odpowiedniego klucza.",
	L"Zamek zosta rozbrojony.",
	L"Zamek nie ma puapek.",
	L"Zamknite.",
	L"DRZWI",
	L"ZABEZP.",
	L"ZAMKNITE",
	L"OTWARTE",
	L"ROZWALONE",
	L"Tu jest przecznik. Wczy go?",
	L"Rozbroi puapk?",
	L"Poprz...",
	L"Nast...",
	L"Wicej...",

	// In the next 2 strings, %S is an item name

	L"%S - pooono na ziemi.",
	L"%S - przekazano do - %S.",

	// In the next 2 strings, %S is a name

	L"%S otrzyma(a) ca zapat.",
	L"%S - naleno wobec niej/niego wynosi jeszcze %d.",
	L"Wybierz czstotliwo sygnau detonujcego:",  	//in this case, frequency refers to a radio signal
	L"Ile tur do eksplozji:",	//how much time, in turns, until the bomb blows
	L"Ustaw czstotliwo zdalnego detonatora:", 	//in this case, frequency refers to a radio signal
	L"Rozbroi puapk?",
	L"Usun niebiesk flag?",
	L"Umieci tutaj niebiesk flag?",
	L"Koczca tura",

	// In the next string, %S is a name. Stance refers to way they are standing.

	L"Na pewno chcesz zaatakowa - %S?",
	L"Pojazdy nie mog zmienia pozycji.",
	L"Robot nie moe zmienia pozycji.",

	// In the next 3 strings, %S is a name

	L"%S nie moe zmieni pozycji w tym miejscu.",
	L"%S nie moe tu otrzyma pierwszej pomocy.",
	L"%S nie potrzebuje pierwszej pomocy.",
	L"Nie mona ruszy w to miejsce.",
	L"Oddzia jest ju kompletny. Nie ma miejsca dla nowych rekrutw.",	//there's no room for a recruit on the player's team

	// In the next string, %S is a name

	L"%S pracuje ju dla ciebie.",

	// Here %S is a name and %d is a number

	L"%S - naleno wobec niej/niego wynosi %d$.",

	// In the next string, %S is a name

	L"%S - Eskortowa t osob?",

	// In the next string, the first %S is a name and the second %S is an amount of money (including $ sign)

	L"%S - Zatrudni t osob za %S dziennie?",

	// This line is used repeatedly to ask player if they wish to participate in a boxing match.

	L"Chcesz walczy?",

	// In the next string, the first %S is an item name and the
	// second %S is an amount of money (including $ sign)

	L"%S - Kupi to za %S?",

	// In the next string, %S is a name

	L"%S jest pod eskort oddziau %d.",

	// These messages are displayed during play to alert the player to a particular situation

	L"ZACITA",					//weapon is jammed.
	L"Robot potrzebuje amunicji kaliber %S.",		//Robot is out of ammo
	L"Rzuci tam? To niemoliwe.",		//Merc can't throw to the destination he selected

	// These are different buttons that the player can turn on and off.

	L"Skradanie si (|Z)",
	L"Ekran |Mapy",
	L"Koniec tury (|D)",
	L"Rozmowa",
	L"Wycisz",
	L"Pozycja do gry (|P|g|U|p)",
	L"Poziom kursora (|T|a|b)",
	L"Wspinaj si / Zeskocz",
	L"Pozycja w d (|P|g|D|n)",
	L"Bada (|C|t|r|l)",
	L"Poprzedni najemnik",
	L"Nastpny najemnik (|S|p|a|c|j|a)",
	L"|Opcje",
	L"Cigy ogie (|B)",
	L"Spjrz/Obr si (|L)",
	L"Zdrowie: %d/%d\nEnergia: %d/%d\nMorale: %S",
	L"Co?",					//this means "what?"
	L"Kont",					//an abbrieviation for "Continued"
	L"%S ma wczone potwierdzenia gosowe.",
	L"%S ma wyczone potwierdzenia gosowe.",
	L"Stan: %d/%d\nPaliwo: %d/%d",
	L"Wysid z pojazdu" ,
	L"Zmie oddzia ( |S|h|i|f|t |S|p|a|c|j|a )",
	L"Prowad",
	L"N/D",						//this is an acronym for "Not Applicable."
	L"Uyj ( Walka wrcz )",
	L"Uyj ( Broni palnej )",
	L"Uyj ( Broni biaej )",
	L"Uyj ( Mat. wybuchowych )",
	L"Uyj ( Apteczki )",
	L"(ap)",
	L"(Przeaduj)",
	L"(Daj)",
	L"%S - puapka zostaa uruchomiona.",
	L"%S przyby(a) na miejsce.",
	L"%S straci(a) wszystkie Punkty Akcji.",
	L"%S jest nieosigalny(na).",
	L"%S ma ju zaoone opatrunki.",
	L"%S nie ma banday.",
	L"Wrg w sektorze!",
	L"Nie ma wroga w zasigu wzroku.",
	L"Zbyt mao Punktw Akcji.",
	L"Nikt nie uywa zdalnego sterowania.",
	L"Cigy ogie oprni magazynek!",
	L"ONIERZ",
	L"STWR",
	L"SAMOOBRONA",
	L"CYWIL",
	L"Wyjcie z sektora",
	L"OK",
	L"Anuluj",
	L"Wybrany najemnik",
	L"Wszyscy najemnicy w oddziale",
	L"Id do sektora",
	L"Otwrz map",
	L"Nie mona opuci sektora z tej strony.",
	L"%S jest zbyt daleko.",
	L"Usu korony drzew",
	L"Poka korony drzew",
	L"WRONA",				//Crow, as in the large black bird
	L"SZYJA",
	L"GOWA",
	L"TUW",
	L"NOGI",
	L"Powiedzie krlowej to, co chce wiedzie?",
	L"Wzr odcisku palca pobrany",
	L"Niewaciwy wzr odcisku palca. Bro bezuyteczna.",
	L"Cel osignity",
	L"Droga zablokowana",
	L"Wpata/Podjcie pienidzy",		//Help text over the $ button on the Single Merc Panel
	L"Nikt nie potrzebuje pierwszej pomocy.",
	L"Zac.",						// Short form of JAMMED, for small inv slots
	L"Nie mona si tam dosta.",					// used ( now ) for when we click on a cliff
	L"Przejcie zablokowane. Czy chcesz zamieni si miejscami z t osob?",
	L"Osoba nie chce si przesun.",
	// In the following message, '%S' would be replaced with a quantity of money (e.g. $200)
	L"Zgadzasz si zapaci %S?",
	L"Zgadzasz si na darmowe leczenie?",
	L"Zgadasz si na maestwo z Darylem?",
	L"Kko na klucze",
	L"Nie moesz tego zrobi z eskortowan osob.",
	L"Oszczdzi Krotta?",
	L"Poza zasigiem broni",
	L"Grnik",
	L"Pojazdem mona podrowa tylko pomidzy sektorami",
	L"Teraz nie mona automatycznie udzieli pierwszej pomocy",
	L"Przejcie zablokowane dla - %S",
	L"Twoi najemnicy, schwytani przez onierzy Deidranny, s tutaj uwizieni!",
	L"Zamek zosta trafiony",
	L"Zamek zosta zniszczony",
	L"Kto inny majstruje przy tych drzwiach.",
	L"Stan: %d/%d\nPaliwo: %d/%d",
  L"%S nie widzi - %S.",  // Cannot see person trying to talk to
};

//Varying helptext explains (for the "Go to Sector/Map" checkbox) what will happen given different circumstances in the "exiting sector" interface.
const wchar_t* pExitingSectorHelpText[] =
{
	//Helptext for the "Go to Sector" checkbox button, that explains what will happen when the box is checked.
	L"Jeli zaznaczysz t opcj, to ssiedni sektor zostanie natychmiast zaadowany.",
	L"Jeli zaznaczysz t opcj, to na czas podry pojawi si automatycznie ekran mapy.",

	//If you attempt to leave a sector when you have multiple squads in a hostile sector.
	L"Ten sektor jest okupowany przez wroga i nie moesz tu zostawi najemnikw.\nMusisz upora si z t sytuacj zanim zaadujesz inny sektor.",

	//Because you only have one squad in the sector, and the "move all" option is checked, the "go to sector" option is locked to on.
	//The helptext explains why it is locked.
	L"Gdy wyprowadzisz swoich pozostaych najemnikw z tego sektora,\nssiedni sektor zostanie automatycznie zaadowany.",
	L"Gdy wyprowadzisz swoich pozostaych najemnikw z tego sektora,\nto na czas podry pojawi si automatycznie ekran mapy.",

	//If an EPC is the selected merc, it won't allow the merc to leave alone as the merc is being escorted.  The "single" button is disabled.
	L"%S jest pod eskort twoich najemnikw i nie moe bez nich opuci tego sektora.",

	//If only one conscious merc is left and is selected, and there are EPCs in the squad, the merc will be prohibited from leaving alone.
	//There are several strings depending on the gender of the merc and how many EPCs are in the squad.
	//DO NOT USE THE NEWLINE HERE AS IT IS USED FOR BOTH HELPTEXT AND SCREEN MESSAGES!
	L"%S nie moe sam opuci tego sektora, gdy %S jest pod jego eskort.", //male singular
	L"%S nie moe sama opuci tego sektora, gdy %S jest pod jej eskort.", //female singular
	L"%S nie moe sam opuci tego sektora, gdy eskortuje inne osoby.", //male plural
	L"%S nie moe sama opuci tego sektora, gdy eskortuje inne osoby.", //female plural

	//If one or more of your mercs in the selected squad aren't in range of the traversal area, then the  "move all" option is disabled,
	//and this helptext explains why.
	L"Wszyscy twoi najemnicy musz by w pobliu,\naby oddzia mg si przemieszcza.",

	L"", //UNUSED

	//Standard helptext for single movement.  Explains what will happen (splitting the squad)
	L"Jeli zaznaczysz t opcj, %S bdzie podrowa w pojedynk\ni automatycznie znajdzie si w osobnym oddziale.",

	//Standard helptext for all movement.  Explains what will happen (moving the squad)
	L"Jeli zaznaczysz t opcj, aktualnie\nwybrany oddzia opuci ten sektor.",

	//This strings is used BEFORE the "exiting sector" interface is created.  If you have an EPC selected and you attempt to tactically
	//traverse the EPC while the escorting mercs aren't near enough (or dead, dying, or unconscious), this message will appear and the
	//"exiting sector" interface will not appear.  This is just like the situation where
	//This string is special, as it is not used as helptext.  Do not use the special newline character (\n) for this string.
	L"%S jest pod eskort twoich najemnikw i nie moe bez nich opuci tego sektora. Aby opuci sektor twoi najemnicy musz by w pobliu.",
};



const wchar_t* pRepairStrings[] =
{
	L"Wyposaenie", 		// tell merc to repair items in inventory
	L"Baza rakiet Z-P", // tell merc to repair SAM site - SAM is an acronym for Surface to Air Missile
	L"Anuluj", 		// cancel this menu
	L"Robot", 		// repair the robot
};


// NOTE: combine prestatbuildstring with statgain to get a line like the example below.
// "John has gained 3 points of marksmanship skill."

const wchar_t* sPreStatBuildString[] =
{
	L"traci", 		// the merc has lost a statistic
	L"zyskuje", 		// the merc has gained a statistic
	L"pkt.",	// singular
	L"pkt.",	// plural
	L"pkt.",	// singular
	L"pkt.",	// plural
};

const wchar_t* sStatGainStrings[] =
{
	L"zdrowia.",
	L"zwinnoci.",
	L"zrcznoci.",
	L"inteligencji.",
	L"umiejtnoci medycznych.",
	L"umiejtnoci w dziedzinie materiaw wybuchowych.",
	L"umiejtnoci w dziedzinie mechaniki.",
	L"umiejtnoci strzeleckich.",
	L"dowiadczenia.",
	L"siy.",
	L"umiejtnoci dowodzenia.",
};


const wchar_t* pHelicopterEtaStrings[] =
{
	L"Cakowita trasa:  ",// total distance for helicopter to travel
	L" Bezp.:   ", 			// distance to travel to destination
	L" Niebezp.:", 			// distance to return from destination to airport
	L"Cakowity koszt: ", 		// total cost of trip by helicopter
	L"PCP:  ", 			// ETA is an acronym for "estimated time of arrival"
	L"Helikopter ma mao paliwa i musi wyldowa na terenie wroga.",	// warning that the sector the helicopter is going to use for refueling is under enemy control ->
  L"Pasaerowie: ",
  L"Wybr Skyridera lub pasaerw?",
  L"Skyrider",
  L"Pasaerowie",
};

const wchar_t* sMapLevelString[] =
{
	L"Poziom:", 			// what level below the ground is the player viewing in mapscreen
};

const wchar_t* gsLoyalString[] =
{
	L"Lojalnoci", 			// the loyalty rating of a town ie : Loyal 53%
};


// error message for when player is trying to give a merc a travel order while he's underground.

const wchar_t* gsUndergroundString[] =
{
	L"nie mona wydawa rozkazw podry pod ziemi.",
};

const wchar_t* gsTimeStrings[] =
{
	L"g",				// hours abbreviation
	L"m",				// minutes abbreviation
	L"s",				// seconds abbreviation
	L"d",				// days abbreviation
};

// text for the various facilities in the sector

const wchar_t* sFacilitiesStrings[] =
{
	L"Brak",
	L"Szpital",
	L"Przemys",
	L"Wizienie",
	L"Baza wojskowa",
	L"Lotnisko",
	L"Strzelnica",		// a field for soldiers to practise their shooting skills
};

// text for inventory pop up button

const wchar_t* pMapPopUpInventoryText[] =
{
	L"Inwentarz",
	L"Zamknij",
};

// town strings

const wchar_t* pwTownInfoStrings[] =
{
	L"Rozmiar",					// 0 // size of the town in sectors
	L"", 						// blank line, required
	L"Pod kontrol", 					// how much of town is controlled
	L"Brak", 					// none of this town
	L"Przynalena kopalnia", 				// mine associated with this town
	L"Lojalno",					// 5 // the loyalty level of this town
	L"Wyszkolonych", 					// the forces in the town trained by the player
	L"",
	L"Gwne obiekty", 				// main facilities in this town
	L"Poziom", 					// the training level of civilians in this town
	L"Szkolenie cywili",				// 10 // state of civilian training in town
	L"Samoobrona", 					// the state of the trained civilians in the town
};

// Mine strings

const wchar_t* pwMineStrings[] =
{
	L"Kopalnia",						// 0
	L"Srebro",
	L"Zoto",
	L"Dzienna produkcja",
	L"Moliwa produkcja",
	L"Opuszczona",				// 5
	L"Zamknita",
	L"Na wyczerpaniu",
	L"Produkuje",
	L"Stan",
	L"Tempo produkcji",
	L"Typ zoa",				// 10
	L"Kontrola miasta",
	L"Lojalno miasta",
//	L"Grnicy",
};

// blank sector strings

const wchar_t* pwMiscSectorStrings[] =
{
	L"Siy wroga",
	L"Sektor",
	L"Przedmiotw",
	L"Nieznane",
	L"Pod kontrol",
	L"Tak",
	L"Nie",
};

// error strings for inventory

const wchar_t* pMapInventoryErrorString[] =
{
	L"%S jest zbyt daleko.",	//Merc is in sector with item but not close enough
	L"Nie mona wybra tego najemnika.",  //MARK CARTER
	L"%S nie moe std zabra tego przedmiotu, gdy nie jest w tym sektorze.",
	L"Podczas walki nie mona korzysta z tego panelu.",
	L"Podczas walki nie mona korzysta z tego panelu.",
	L"%S nie moe tu zostawi tego przedmiotu, gdy nie jest w tym sektorze.",
};

const wchar_t* pMapInventoryStrings[] =
{
	L"Pooenie", 			// sector these items are in
	L"Razem przedmiotw", 		// total number of items in sector
};


// help text for the user

const wchar_t* pMapScreenFastHelpTextList[] =
{
	L"Kliknij w kolumnie 'Przydz.', aby przydzieli najemnika do innego oddziau lub wybranego zadania.",
	L"Aby wyznaczy najemnikowi cel w innym sektorze, kliknij pole w kolumnie 'Cel'.",
	L"Gdy najemnicy otrzymaj ju rozkaz przemieszczenia si, kompresja czasu pozwala im szybciej dotrze na miejsce.",
	L"Kliknij lewym klawiszem aby wybra sektor. Kliknij ponownie aby wyda najemnikom rozkazy przemieszczenia, lub kliknij prawym klawiszem by uzyska informacje o sektorze.",
	L"Nacinij w dowolnym momencie klawisz 'H' by wywietli okienko pomocy.",
	L"Prbny tekst",
	L"Prbny tekst",
	L"Prbny tekst",
	L"Prbny tekst",
	L"Niewiele moesz tu zrobi, dopki najemnicy nie przylec do Arulco. Gdy ju zbierzesz swj oddzia, kliknij przycisk Kompresji Czasu, w prawym dolnym rogu. W ten sposb twoi najemnicy szybciej dotr na miejsce.",
};

// movement menu text

const wchar_t* pMovementMenuStrings[] =
{
	L"Przemie najemnikw", 	// title for movement box
	L"Nanie tras podry", 		// done with movement menu, start plotting movement
	L"Anuluj", 		// cancel this menu
	L"Inni",		// title for group of mercs not on squads nor in vehicles
};


const wchar_t* pUpdateMercStrings[] =
{
	L"Oj:", 			// an error has occured
	L"Wygas kontrakt najemnikw:", 	// this pop up came up due to a merc contract ending
	L"Najemnicy wypenili zadanie:", // this pop up....due to more than one merc finishing assignments
	L"Najemnicy wrcili do pracy:", // this pop up ....due to more than one merc waking up and returing to work
	L"Odpoczywajcy najemnicy:", // this pop up ....due to more than one merc being tired and going to sleep
	L"Wkrtce wygasn kontrakty:", 	// this pop up came up due to a merc contract ending
};

// map screen map border buttons help text

const wchar_t* pMapScreenBorderButtonHelpText[] =
{
	L"Poka miasta (|W)",
	L"Poka kopalnie (|M)",
	L"Poka oddziay i wrogw (|T)",
	L"Poka przestrze powietrzn (|A)",
	L"Poka przedmioty (|I)",
	L"Poka samoobron i wrogw (|Z)",
};


const wchar_t* pMapScreenBottomFastHelp[] =
{
	L"|Laptop",
	L"Ekran taktyczny (|E|s|c)",
	L"|Opcje",
	L"Kompresja czasu (|+)", 	// time compress more
	L"Kompresja czasu (|-)", 	// time compress less
	L"Poprzedni komunikat (|S|t|r|z|a||k|a |w |g||r|)\nPoprzednia strona (|P|g|U|p)", 	// previous message in scrollable list
	L"Nastpny komunikat (|S|t|r|z|a||k|a |w |d||)\nNastpna strona (|P|g|D|n)", 	// next message in the scrollable list
	L"Wcz/Wycz kompresj czasu (|S|p|a|c|j|a)",	// start/stop time compression
};

const wchar_t* pMapScreenBottomText[] =
{
	L"Saldo dostpne", 	// current balance in player bank account
};

const wchar_t* pMercDeadString[] =
{
	L"%S nie yje.",
};


const wchar_t* pDayStrings[] =
{
	L"Dzie",
};

// the list of email sender names

const wchar_t* pSenderNameList[] =
{
	L"Enrico",
	L"Psych Pro Inc",
	L"Pomoc",
	L"Psych Pro Inc",
	L"Speck",
	L"R.I.S.",
	L"Barry",
	L"Blood",
	L"Lynx",
	L"Grizzly",
	L"Vicki",
	L"Trevor",
	L"Grunty",
	L"Ivan",
	L"Steroid",
	L"Igor",
	L"Shadow",
	L"Red",
	L"Reaper",
	L"Fidel",
	L"Fox",
	L"Sidney",
	L"Gus",
	L"Buns",
	L"Ice",
	L"Spider",
	L"Cliff",
	L"Bull",
	L"Hitman",
	L"Buzz",
	L"Raider",
	L"Raven",
	L"Static",
	L"Len",
	L"Danny",
	L"Magic",
	L"Stephan",
	L"Scully",
	L"Malice",
	L"Dr.Q",
	L"Nails",
	L"Thor",
	L"Scope",
	L"Wolf",
	L"MD",
	L"Meltdown",
	//----------
	L"M.I.S. Ubezpieczenia",
	L"Bobby Ray",
	L"Kingpin",
	L"John Kulba",
	L"A.I.M.",
};


// next/prev strings

const wchar_t* pTraverseStrings[] =
{
  L"Poprzedni",
  L"Nastpny",
};

// new mail notify string

const wchar_t* pNewMailStrings[] =
{
 L"Masz now poczt...",
};


// confirm player's intent to delete messages

const wchar_t* pDeleteMailStrings[] =
{
 L"Usun wiadomo?",
 L"Usun wiadomo?",
};


// the sort header strings

const wchar_t* pEmailHeaders[] =
{
 	L"Od:",
 	L"Temat:",
 	L"Dzie:",
};

// email titlebar text

const wchar_t* pEmailTitleText[] =
{
 	L"Skrzynka odbiorcza",
};


// the financial screen strings
const wchar_t* pFinanceTitle[] =
{
	L"Ksigowy Plus",		//the name we made up for the financial program in the game
};

const wchar_t* pFinanceSummary[] =
{
	L"Wypata:", 				// credit (subtract from) to player's account
	L"Wpata:", 				// debit (add to) to player's account
	L"Wczorajsze wpywy:",
	L"Wczorajsze dodatkowe wpywy:",
	L"Wczorajsze wydatki:",
	L"Saldo na koniec dnia:",
	L"Dzisiejsze wpywy:",
	L"Dzisiejsze dodatkowe wpywy:",
	L"Dzisiejsze wydatki:",
	L"Saldo dostpne:",
	L"Przewidywane wpywy:",
	L"Przewidywane saldo:", 		// projected balance for player for tommorow
};


// headers to each list in financial screen

const wchar_t* pFinanceHeaders[] =
{
	L"Dzie", 					// the day column
	L"Ma", 				// the credits column
	L"Winien",				// the debits column
	L"Transakcja", 			// transaction type - see TransactionText below
	L"Saldo", 				// balance at this point in time
	L"Strona", 				// page number
	L"Dzie (dni)", 		// the day(s) of transactions this page displays
};


const wchar_t* pTransactionText[] =
{
	L"Narose odsetki",			// interest the player has accumulated so far
	L"Anonimowa wpata",
	L"Koszt transakcji",
	L"Wynajto -", 				// Merc was hired
	L"Zakupy u Bobby'ego Ray'a", 		// Bobby Ray is the name of an arms dealer
	L"Uregulowanie rachunkw w M.E.R.C.",
	L"Zastaw na ycie dla - %S", 		// medical deposit for merc
	L"Analiza profilu w IMP", 		// IMP is the acronym for International Mercenary Profiling
	L"Ubezpieczneie dla - %S",
	L"Redukcja ubezp. dla - %S",
	L"Przed. ubezp. dla - %S", 				// johnny contract extended
	L"Anulowano ubezp. dla - %S",
	L"Odszkodowanie za - %S", 		// insurance claim for merc
	L"1 dzie", 				// merc's contract extended for a day
	L"1 tydzie", 				// merc's contract extended for a week
	L"2 tygodnie", 				// ... for 2 weeks
	L"Przychd z kopalni",
	L"", //String nuked
	L"Zakup kwiatw",
	L"Peny zwrot zastawu za - %S",
	L"Czciowy zwrot zastawu za - %S",
	L"Brak zwrotu zastawu za - %S",
	L"Zapata dla - %S",		// %S is the name of the npc being paid
	L"Transfer funduszy do - %S", 			// transfer funds to a merc
	L"Transfer funduszy od - %S", 		// transfer funds from a merc
	L"Samoobrona w - %S", // initial cost to equip a town's militia
	L"Zakupy u - %S.",	//is used for the Shop keeper interface.  The dealers name will be appended to the end of the string.
	L"%S wpaci(a) pienidze.",
};

const wchar_t* pTransactionAlternateText[] =
{
	L"Ubezpieczenie dla -", 				// insurance for a merc
	L"Przed. kontrakt z - %S o 1 dzie.", 				// entend mercs contract by a day
	L"Przed. kontrakt z - %S o 1 tydzie.",
	L"Przed. kontrakt z - %S o 2 tygodnie.",
};

// helicopter pilot payment

const wchar_t* pSkyriderText[] =
{
	L"Skyriderowi zapacono %d$", 			// skyrider was paid an amount of money
	L"Skyriderowi trzeba jeszcze zapaci %d$", 		// skyrider is still owed an amount of money
	L"Skyrider zatankowa",	// skyrider has finished refueling
	L"",//unused
	L"",//unused
	L"Skyrider jest gotw do kolejnego lotu.", // Skyrider was grounded but has been freed
	L"Skyrider nie ma pasaerw. Jeli chcesz przetransportowa najemnikw, zmie ich przydzia na POJAZD/HELIKOPTER.",
};


// strings for different levels of merc morale

const wchar_t* pMoralStrings[] =
{
 L"wietne",
 L"Dobre",
 L"Stabilne",
 L"Sabe",
 L"Panika",
 L"Ze",
};

// Mercs equipment has now arrived and is now available in Omerta or Drassen.

const wchar_t* pLeftEquipmentString[] =
{
	L"%S - jego/jej sprzt jest ju w Omercie( A9 ).",
	L"%S - jego/jej sprzt jest ju w Drassen( B13 ).",
};

// Status that appears on the Map Screen

const wchar_t* pMapScreenStatusStrings[] =
{
	L"Zdrowie",
	L"Energia",
	L"Morale",
	L"Stan",	// the condition of the current vehicle (its "health")
	L"Paliwo",	// the fuel level of the current vehicle (its "energy")
};


const wchar_t* pMapScreenPrevNextCharButtonHelpText[] =
{
	L"Poprzedni najemnik (|S|t|r|z|a||k|a |w |l|e|w|o)", 			// previous merc in the list
	L"Nastpny najemnik (|S|t|r|z|a||k|a |w |p|r|a|w|o)", 				// next merc in the list
};


const wchar_t* pEtaString[] =
{
	L"PCP:", 				// eta is an acronym for Estimated Time of Arrival
};

const wchar_t* pTrashItemText[] =
{
	L"Wicej tego nie zobaczysz. Czy na pewno chcesz to zrobi?", 	// do you want to continue and lose the item forever
	L"To wyglda na co NAPRAWD wanego. Czy NA PEWNO chcesz to zniszczy?", // does the user REALLY want to trash this item
};


const wchar_t* pMapErrorString[] =
{
	L"Oddzia nie moe si przemieszcza, jeli ktry z najemnikw pi.",

//1-5
	L"Najpierw wyprowad oddzia na powierzchni.",
	L"Rozkazy przemieszczenia? To jest sektor wroga!",
	L"Aby podrowa najemnicy musz by przydzieleni do oddziau lub pojazdu.",
	L"Nie masz jeszcze ludzi.", 		// you have no members, can't do anything
	L"Najemnik nie moe wypeni tego rozkazu.",			 		// merc can't comply with your order
//6-10
	L"musi mie eskort, aby si przemieszcza. Umie go w oddziale z eskort.", // merc can't move unescorted .. for a male
	L"musi mie eskort, aby si przemieszcza. Umie j w oddziale z eskort.", // for a female
	L"Najemnik nie przyby jeszcze do Arulco!",
	L"Wyglda na to, e trzeba wpierw uregulowa sprawy kontraktu.",
	L"",
//11-15
	L"Rozkazy przemieszczenia? Trwa walka!",
	L"Zaatakoway ci dzikie koty, w sektorze %S!",
	L"W sektorze I16 znajduje si co, co wyglda na legowisko dzikich kotw!",
	L"",
	L"Baza rakiet Ziemia-Powietrze zostaa przejta.",
//16-20
	L"%S - kopalnia zostaa przejta. Twj dzienny przychd zosta zredukowany do %S.",
	L"Nieprzyjaciel bezkonfliktowo przej sektor %S.",
	L"Przynajmniej jeden z twoich najemnikw nie zosta do tego przydzielony.",
	L"%S nie moe si przyczy, poniewa %S jest peny",
	L"%S nie moe si przyczy, poniewa %S jest zbyt daleko.",
//21-25
	L"%S - kopalnia zostaa przejta przez siy Deidranny!",
	L"Siy Deidranny wanie zaatakoway baz rakiet Ziemia-Powietrze w - %S.",
	L"Siy Deidranny wanie zaatakoway - %S.",
	L"Wanie zauwaono siy Deidranny w - %S.",
	L"Siy Deidranny wanie przejy - %S.",
//26-30
	L"Przynajmniej jeden z twoich najemnikw nie mg si pooy spa.",
	L"Przynajmniej jeden z twoich najemnikw nie mg wsta.",
	L"Oddziay samoobrony nie pojawi si dopki nie zostan wyszkolone.",
	L"%S nie moe si w tej chwili przemieszcza.",
	L"onierze samoobrony, ktrzy znajduj si poza granicami miasta, nie mog by przeniesieni do innego sektora.",
//31-35
	L"Nie moesz trenowa samoobrony w - %S.",
	L"Pusty pojazd nie moe si porusza!",
	L"%S ma zbyt wiele ran by podrowa!",
	L"Musisz wpierw opuci muzeum!",
	L"%S nie yje!",
//36-40
	L"%S nie moe si zamieni z - %S, poniewa si porusza",
	L"%S nie moe w ten sposb wejc do pojazdu",
	L"%S nie moe si doczy do - %S",
	L"Nie moesz kompresowa czasu dopki nie zatrudnisz sobie kilku nowych najemnikw!",
	L"Ten pojazd moe si porusza tylko po drodze!",
//41-45
	L"Nie mona zmienia przydziau najemnikw, ktrzy s w drodze",
	L"Pojazd nie ma paliwa!",
	L"%S jest zbyt zmczony(na) by podrowa.",
	L"aden z pasaerw nie jest w stanie kierowa tym pojazdem.",
	L"Jeden lub wicej czonkw tego oddziau nie moe si w tej chwili przemieszcza.",
//46-50
	L"Jeden lub wicej INNYCH czonkw tego oddziau nie moe si w tej chwili przemieszcza.",
	L"Pojazd jest uszkodzony!",
	L"Pamitaj, e w jednym sektorze tylko dwch najemnikw moe trenowa onierzy samoobrony.",
	L"Robot nie moe si porusza bez operatora. Umie ich razem w jednym oddziale.",
};


// help text used during strategic route plotting
const wchar_t* pMapPlotStrings[] =
{
	L"Kliknij ponownie sektor docelowy, aby zatwierdzi tras podry, lub kliknij inny sektor, aby j wyduy.",
	L"Trasa podry zatwierdzona.",
	L"Cel podry nie zosta zmieniony.",
	L"Trasa podry zostaa anulowana.",
	L"Trasa podry zostaa skrcona.",
};


// help text used when moving the merc arrival sector
const wchar_t* pBullseyeStrings[] =
{
	L"Kliknij sektor, do ktrego maj przylatywa najemnicy.",
	L"Dobrze. Przylatujcy najemnicy bd zrzucani w %S",
	L"Najemnicy nie mog tu przylatywa. Przestrze powietrzna nie jest zabezpieczona!",
	L"Anulowano. Sektor zrzutu nie zosta zmieniony.",
	L"Przestrze powietrzna nad %S nie jest ju bezpieczna! Sektor zrzutu zosta przesunity do %S.",
};


// help text for mouse regions

const wchar_t* pMiscMapScreenMouseRegionHelpText[] =
{
	L"Otwrz wyposaenie (|E|n|t|e|r)",
	L"Zniszcz przedmiot",
	L"Zamknij wyposaenie (|E|n|t|e|r)",
};



// male version of where equipment is left
const wchar_t* pMercHeLeaveString[] =
{
	L"Czy %S ma zostawi swj sprzt w sektorze, w ktrym si obecnie znajduje (%S), czy w Dressen (B13), skd odlatuje? ",
	L"Czy %S ma zostawi swj sprzt w sektorze, w ktrym si obecnie znajduje (%S), czy w Omercie (A9), skd odlatuje?",
	L"wkrtce odchodzi i zostawi swj sprzt w Omercie (A9).",
	L"wkrtce odchodzi i zostawi swj sprzt w Drassen (B13).",
	L"%S wkrtce odchodzi i zostawi swj sprzt w %S.",
};


// female version
const wchar_t* pMercSheLeaveString[] =
{
	L"Czy %S ma zostawi swj sprzt w sektorze, w ktrym si obecnie znajduje (%S), czy w Dressen (B13), skd odlatuje? ",
	L"Czy %S ma zostawi swj sprzt w sektorze, w ktrym si obecnie znajduje (%S), czy w Omercie (A9), skd odlatuje?",
	L"wkrtce odchodzi i zostawi swj sprzt w Omercie (A9).",
	L"wkrtce odchodzi i zostawi swj sprzt w Drassen (B13).",
	L"%S wkrtce odchodzi i zostawi swj sprzt w %S.",
};


const wchar_t* pMercContractOverStrings[] =
{
	L" zakoczy kontrakt wic wyjecha.", 		// merc's contract is over and has departed
	L" zakoczya kontrakt wic wyjechaa.", 		// merc's contract is over and has departed
	L" - jego kontrakt zosta zerwany wic odszed.", 		// merc's contract has been terminated
	L" - jej kontrakt zosta zerwany wic odesza.",		// merc's contract has been terminated
	L"Masz za duy dug wobec M.E.R.C. wic %S odchodzi.", // Your M.E.R.C. account is invalid so merc left
};

// Text used on IMP Web Pages

const wchar_t* pImpPopUpStrings[] =
{
	L"Nieprawidowy kod dostpu",
	L"Czy na pewno chcesz wznowi proces okrelenia profilu?",
	L"Wprowad nazwisko oraz pe",
	L"Wstpna kontrola stanu twoich finansw wykazaa, e nie sta ci na analiz profilu.",
	L"Opcja tym razem nieaktywna.",
	L"Aby wykona profil, musisz mie miejsce dla przynajmniej jednego czonka zaogi.",
	L"Profil zosta ju wykonany.",
};


// button labels used on the IMP site

const wchar_t* pImpButtonText[] =
{
	L"O Nas", 			// about the IMP site
	L"ZACZNIJ", 			// begin profiling
	L"Osobowo", 		// personality section
	L"Atrybuty", 		// personal stats/attributes section
	L"Portret", 			// the personal portrait selection
	L"Gos %d", 			// the voice selection
	L"Gotowe", 			// done profiling
	L"Zacznij od pocztku", 		// start over profiling
	L"Tak, wybieram t odpowied.",
	L"Tak",
	L"Nie",
	L"Skoczone", 			// finished answering questions
	L"Poprz.", 			// previous question..abbreviated form
	L"Nast.", 			// next question
	L"TAK, JESTEM.", 		// yes, I am certain
	L"NIE, CHC ZACZ OD NOWA.", // no, I want to start over the profiling process
	L"TAK",
	L"NIE",
	L"Wstecz", 			// back one page
	L"Anuluj", 			// cancel selection
	L"Tak.",
	L"Nie, Chc spojrze jeszcze raz.",
	L"Rejestr", 			// the IMP site registry..when name and gender is selected
	L"Analizuj...", 			// analyzing your profile results
	L"OK",
	L"Gos",
};

const wchar_t* pExtraIMPStrings[] =
{
	L"Aby zacz analiz profilu, wybierz osobowo.",
	L"Teraz okrel swoje atrybuty.",
	L"Teraz moesz przystpi do wyboru portretu.",
	L"Aby zakoczy proces, wybierz prbk gosu, ktra ci najbardziej odpowiada."
};

const wchar_t* pFilesTitle[] =
{
	L"Przegldarka plikw",
};

const wchar_t* pFilesSenderList[] =
{
	L"Raport Rozp.", 		// the recon report sent to the player. Recon is an abbreviation for reconissance
	L"Intercept #1", 		// first intercept file .. Intercept is the title of the organization sending the file...similar in function to INTERPOL/CIA/KGB..refer to fist record in files.txt for the translated title
	L"Intercept #2",	   // second intercept file
	L"Intercept #3",			 // third intercept file
	L"Intercept #4", // fourth intercept file
	L"Intercept #5", // fifth intercept file
	L"Intercept #6", // sixth intercept file
};

// Text having to do with the History Log

const wchar_t* pHistoryTitle[] =
{
	L"Historia",
};

const wchar_t* pHistoryHeaders[] =
{
	L"Dzie", 			// the day the history event occurred
	L"Strona", 			// the current page in the history report we are in
	L"Dzie", 			// the days the history report occurs over
	L"Pooenie", 			// location (in sector) the event occurred
	L"Zdarzenie", 			// the event label
};

// various history events
// THESE STRINGS ARE "HISTORY LOG" STRINGS AND THEIR LENGTH IS VERY LIMITED.
// PLEASE BE MINDFUL OF THE LENGTH OF THESE STRINGS. ONE WAY TO "TEST" THIS
// IS TO TURN "CHEAT MODE" ON AND USE CONTROL-R IN THE TACTICAL SCREEN, THEN
// GO INTO THE LAPTOP/HISTORY LOG AND CHECK OUT THE STRINGS. CONTROL-R INSERTS
// MANY (NOT ALL) OF THE STRINGS IN THE FOLLOWING LIST INTO THE GAME.
const wchar_t* pHistoryStrings[] =
{
	L"",																						// leave this line blank
	//1-5
	L"%S najty(ta) w A.I.M.", 										// merc was hired from the aim site
	L"%S najty(ta) w M.E.R.C.", 									// merc was hired from the aim site
	L"%S ginie.", 															// merc was killed
	L"Uregulowano rachunki w M.E.R.C.",								// paid outstanding bills at MERC
	L"Przyjto zlecenie od Enrico Chivaldori",
	//6-10
	L"Profil IMP wygenerowany",
	L"Podpisano umow ubezpieczeniow dla %S.", 				// insurance contract purchased
	L"Anulowano umow ubezpieczeniow dla %S.", 				// insurance contract canceled
	L"Wypata ubezpieczenia za %S.", 							// insurance claim payout for merc
	L"Przeduono kontrakt z: %S o 1 dzie.", 						// Extented "mercs name"'s for a day
	//11-15
	L"Przeduono kontrakt z: %S o 1 tydzie.", 					// Extented "mercs name"'s for a week
	L"Przeduono kontrakt z: %S o 2 tygodnie.", 					// Extented "mercs name"'s 2 weeks
	L"%S zwolniony(na).", 													// "merc's name" was dismissed.
	L"%S odchodzi.", 																		// "merc's name" quit.
	L"przyjto zadanie.", 															// a particular quest started
	//16-20
	L"zadanie wykonane.",
	L"Rozmawiano szefem kopalni %S",									// talked to head miner of town
	L"Wyzwolono - %S",
	L"Uyto kodu Cheat",
	L"ywno powinna by jutro w Omercie",
	//21-25
	L"%S odchodzi, aby wzi lub z Darylem Hickiem",
	L"Wygas kontrakt z - %S.",
	L"%S zrekrutowany(na).",
	L"Enrico narzeka na brak postpw",
	L"Walka wygrana",
	//26-30
	L"%S - w kopalni koczy si ruda",
	L"%S - w kopalni skoczya si ruda",
	L"%S - kopalnia zostaa zamknita",
	L"%S - kopalnia zostaa otwarta",
	L"Informacja o wizieniu zwanym Tixa.",
	//31-35
	L"Informacja o tajnej fabryce broni zwanej Orta.",
	L"Naukowiec w Orcie ofiarowa kilka karabinw rakietowych.",
	L"Krlowa Deidranna robi uytek ze zwok.",
	L"Frank opowiedzia o walkach w San Monie.",
	L"Pewien pacjent twierdzi, e widzia co w kopalni.",
	//36-40
	L"Go o imieniu Devin sprzedaje materiay wybuchowe.",
	L"Spotkanie ze sawynm eks-najemnikiem A.I.M. - Mike'iem!",
	L"Tony handluje broni.",
	L"Otrzymano karabin rakietowy od sieranta Krotta.",
	L"Dano Kyle'owi akt wasnoci sklepu Angela.",
	//41-45
	L"Madlab zaoferowa si zbudowa robota.",
	L"Gabby potrafi zrobi mikstur chronic przed robakami.",
	L"Keith wypad z interesu.",
	L"Howard dostarcza cyjanek krlowej Deidrannie.",
	L"Spotkanie z handlarzem Keithem w Cambrii.",
	//46-50
	L"Spotkanie z aptekarzem Howardem w Balime",
	L"Spotkanie z Perko, prowadzcym may warsztat.",
	L"Spotkanie z Samem z Balime - prowadzi sklep z narzdziami.",
	L"Franz handluje sprztem elektronicznym.",
	L"Arnold prowadzi warsztat w Grumm.",
	//51-55
	L"Fredo naprawia sprzt elektroniczny w Grumm.",
	L"Otrzymano darowizn od bogatego gocia w Balime.",
	L"Spotkano Jake'a, ktry prowadzi zomowisko.",
	L"Jaki wczga da nam elektroniczn kart dostpu.",
	L"Przekupiono Waltera, aby otworzy drzwi do piwnicy.",
	//56-60
	L"Dave oferuje darmowe tankowania, jeli bdzie mia paliwo.",
	L"Greased Pablo's palms.",
	L"Kingpin trzyma pienidze w kopalni w San Mona.",
	L"%S wygra(a) walk",
	L"%S przegra(a) walk",
	//61-65
	L"%S zdyskwalifikowany(na) podczas walki",
	L"Znaleziono duo pienidzy w opuszczonej kopalni.",
	L"Spotkano zabjc nasanego przez Kingpina.",
	L"Utrata kontroli nad sektorem",				//ENEMY_INVASION_CODE
	L"Sektor obroniony",
	//66-70
	L"Przegrana bitwa",							//ENEMY_ENCOUNTER_CODE
	L"Fatalna zasadzka",						//ENEMY_AMBUSH_CODE
	L"Usunieto zasadzk wroga",
	L"Nieudany atak",			//ENTERING_ENEMY_SECTOR_CODE
	L"Udany atak!",
	//71-75
	L"Stworzenia zaatakoway",			//CREATURE_ATTACK_CODE
	L"Zabity(ta) przez dzikie koty",			//BLOODCAT_AMBUSH_CODE
	L"Wyrnito dzikie koty",
	L"%S zabity(ta)",
	L"Przekazano Carmenowi gow terrorysty",
	L"Slay odszed",
	L"Zabito: %S",
};

const wchar_t* pHistoryLocations[] =
{
	L"N/D",						// N/A is an acronym for Not Applicable
};

// icon text strings that appear on the laptop

const wchar_t* pLaptopIcons[] =
{
	L"E-mail",
	L"Sie",
	L"Finanse",
	L"Personel",
	L"Historia",
	L"Pliki",
	L"Zamknij",
	L"sir-FER 4.0",			// our play on the company name (Sirtech) and web surFER
};

// bookmarks for different websites
// IMPORTANT make sure you move down the Cancel string as bookmarks are being added

const wchar_t* pBookMarkStrings[] =
{
	L"A.I.M.",
	L"Bobby Ray's",
	L"I.M.P",
	L"M.E.R.C.",
	L"Pogrzeby",
	L"Kwiaty",
	L"Ubezpieczenia",
	L"Anuluj",
};

const wchar_t* pBookmarkTitle[] =
{
	L"Ulubione",
	L"Aby w przyszoci otworzy to menu, kliknij prawym klawiszem myszy.",
};

// When loading or download a web page

const wchar_t* pDownloadString[] =
{
	L"adowanie strony...",
	L"Otwieranie strony...",
};

//This is the text used on the bank machines, here called ATMs for Automatic Teller Machine

const wchar_t* gsAtmSideButtonText[] =
{
	L"OK",
	L"We", 			// take money from merc
	L"Daj", 			// give money to merc
	L"Anuluj", 			// cancel transaction
	L"Skasuj", 			// clear amount being displayed on the screen
};

const wchar_t* gsAtmStartButtonText[] =
{
	L"Transfer $", 		// transfer money to merc -- short form
	L"Atrybuty", 			// view stats of the merc
	L"Wyposaenie", 			// view the inventory of the merc
	L"Zatrudnienie",
};

const wchar_t* sATMText[ ]=
{
	L"Przesa fundusze?", 		// transfer funds to merc?
	L"OK?", 			// are we certain?
	L"Wprowad kwot", 		// enter the amount you want to transfer to merc
	L"Wybierz typ", 		// select the type of transfer to merc
	L"Brak rodkw", 	// not enough money to transfer to merc
	L"Kwota musi by podzielna przez $10", // transfer amount must be a multiple of $10
};

// Web error messages. Please use foreign language equivilant for these messages.
// DNS is the acronym for Domain Name Server
// URL is the acronym for Uniform Resource Locator

const wchar_t* pErrorStrings[] =
{
	L"Bd",
	L"Serwer nie posiada DNS.",
	L"Sprawd adres URL i sprbuj ponownie.",
	L"OK",
	L"Niestabilne poczenie z Hostem. Transfer moe trwa duej.",
};


const wchar_t* pPersonnelString[] =
{
	L"Najemnicy:", 			// mercs we have
};


const wchar_t* pWebTitle[ ]=
{
	L"sir-FER 4.0",		// our name for thL"sir-FER 4.0",		// our name for the version of the browser, play on company name
};


// The titles for the web program title bar, for each page loaded

const wchar_t* pWebPagesTitles[] =
{
	L"A.I.M.",
	L"A.I.M. Czonkowie",
	L"A.I.M. Portrety",		// a mug shot is another name for a portrait
	L"A.I.M. Lista",
	L"A.I.M.",
	L"A.I.M. Weterani",
	L"A.I.M. Polisy",
	L"A.I.M. Historia",
	L"A.I.M. Linki",
	L"M.E.R.C.",
	L"M.E.R.C. Konta",
	L"M.E.R.C. Rejestracja",
	L"M.E.R.C. Indeks",
	L"Bobby Ray's",
	L"Bobby Ray's - Bro",
	L"Bobby Ray's - Amunicja",
	L"Bobby Ray's - Pancerz",
	L"Bobby Ray's - Rne",							//misc is an abbreviation for miscellaneous
	L"Bobby Ray's - Uywane",
	L"Bobby Ray's - Zamwienie pocztowe",
	L"I.M.P.",
	L"I.M.P.",
	L"United Floral Service",
	L"United Floral Service - Galeria",
	L"United Floral Service - Zamwienie",
	L"United Floral Service - Galeria kartek",
	L"Malleus, Incus & Stapes - Brokerzy ubezpieczeniowi",
	L"Informacja",
	L"Kontrakt",
	L"Uwagi",
	L"McGillicutty - Zakad pogrzebowy",
	L"",
	L"Nie odnaleziono URL.",
	L"Bobby Ray's - Ostatnie dostawy",
	L"",
	L"",
};

const wchar_t* pShowBookmarkString[] =
{
	L"Sir-Pomoc",
	L"Kliknij ponownie Sie by otworzy menu Ulubione.",
};

const wchar_t* pLaptopTitles[] =
{
	L"Poczta",
	L"Przegldarka plikw",
	L"Personel",
	L"Ksigowy Plus",
	L"Historia",
};

const wchar_t* pPersonnelDepartedStateStrings[] =
{
	//reasons why a merc has left.
	L"mier w akcji",
	L"Zwolnienie",
	L"Inny",
	L"Maestwo",
	L"Koniec kontraktu",
	L"Rezygnacja",
};
// personnel strings appearing in the Personnel Manager on the laptop

const wchar_t* pPersonelTeamStrings[] =
{
	L"Biecy oddzia",
	L"Wyjazdy",
	L"Koszt dzienny:",
	L"Najwyszy koszt:",
	L"Najniszy koszt:",
	L"mier w akcji:",
	L"Zwolnienie:",
	L"Inny:",
};


const wchar_t* pPersonnelCurrentTeamStatsStrings[] =
{
	L"Najniszy",
	L"redni",
	L"Najwyszy",
};


const wchar_t* pPersonnelTeamStatsStrings[] =
{
	L"ZDR",
	L"ZWN",
	L"ZRCZ",
	L"SIA",
	L"DOW",
	L"INT",
	L"DOW",
	L"STRZ",
	L"MECH",
	L"WYB",
	L"MED",
};


// horizontal and vertical indices on the map screen

const wchar_t* pMapVertIndex[] =
{
	L"X",
	L"A",
	L"B",
	L"C",
	L"D",
	L"E",
	L"F",
	L"G",
	L"H",
	L"I",
	L"J",
	L"K",
	L"L",
	L"M",
	L"N",
	L"O",
	L"P",
};

const wchar_t* pMapHortIndex[] =
{
	L"X",
	L"1",
	L"2",
	L"3",
	L"4",
	L"5",
	L"6",
	L"7",
	L"8",
	L"9",
	L"10",
	L"11",
	L"12",
	L"13",
	L"14",
	L"15",
	L"16",
};

const wchar_t* pMapDepthIndex[] =
{
	L"",
	L"-1",
	L"-2",
	L"-3",
};

// text that appears on the contract button

const wchar_t* pContractButtonString[] =
{
	L"Kontrakt",
};

// text that appears on the update panel buttons

const wchar_t* pUpdatePanelButtons[] =
{
	L"Dalej",
	L"Stop",
};

// Text which appears when everyone on your team is incapacitated and incapable of battle

const wchar_t LargeTacticalStr[][ LARGE_STRING_LENGTH ] =
{
	L"Pokonano ci w tym sektorze!",
	L"Wrg nie zna litoci i poera was wszystkich!",
	L"Nieprzytomni czonkowie twojego oddziau zostali pojmani!",
	L"Czonkowie twojego oddziau zostali uwizieni.",
};


//Insurance Contract.c
//The text on the buttons at the bottom of the screen.

const wchar_t* InsContractText[] =
{
	L"Wstecz",
	L"Dalej",
	//L"Akceptuj",
	L"OK",
	L"Skasuj",
};



//Insurance Info
// Text on the buttons on the bottom of the screen

const wchar_t* InsInfoText[] =
{
	L"Wstecz",
	L"Dalej"
};



//For use at the M.E.R.C. web site. Text relating to the player's account with MERC

const wchar_t* MercAccountText[] =
{
	// Text on the buttons on the bottom of the screen
	L"Autoryzacja",
	L"Strona gwna",
	L"Konto #:",
	L"Najemnik",
	L"Dni",
	L"Stawka",	//5
	L"Opata",
	L"Razem:",
	L"Czy na pewno chcesz zatwierdzi patno: %S?",		//the %S is a string that contains the dollar amount ( ex. "$150" )
};



//For use at the M.E.R.C. web site. Text relating a MERC mercenary


const wchar_t* MercInfo[] =
{
	L"Zdrowie",
	L"Zwinno",
	L"Sprawno",
	L"Sia",
	L"Um. dowodz.",
	L"Inteligencja",
	L"Poz. dowiadczenia",
	L"Um. strzeleckie",
	L"Zn. mechaniki",
	L"Mat. wybuchowe",
	L"Wiedza medyczna",

	L"Poprzedni",
	L"Najmij",
	L"Nastpny",
	L"Dodatkowe informacje",
	L"Strona gwna",
	L"Najty",
	L"Koszt:",
	L"Dziennie",
	L"Nie yje",

	L"Wyglda na to, e chcesz wynaj zbyt wielu najemnikw. Limit wynosi 18.",
	L"Niedostpny",
};



// For use at the M.E.R.C. web site. Text relating to opening an account with MERC

const wchar_t* MercNoAccountText[] =
{
	//Text on the buttons at the bottom of the screen
	L"Otwrz konto",
	L"Anuluj",
	L"Nie posiadasz konta. Czy chcesz sobie zaoy?"
};



// For use at the M.E.R.C. web site. MERC Homepage

const wchar_t* MercHomePageText[] =
{
	//Description of various parts on the MERC page
	L"Speck T. Kline, zaoyciel i waciciel",
	L"Aby otworzy konto nacinij tu",
	L"Aby zobaczy konto nacinij tu",
	L"Aby obejrze akta nacinij tu",
	// The version number on the video conferencing system that pops up when Speck is talking
	L"Speck Com v3.2",
};

// For use at MiGillicutty's Web Page.

const wchar_t* sFuneralString[] =
{
	L"Zakad pogrzebowy McGillicutty, pomaga rodzinom pogronym w smutku od 1983.",
	L"Kierownik, byy najemnik A.I.M. Murray \'Pops\' McGillicutty jest dowiadczonym pracownikiem zakadu pogrzebowego.",
	L"Przez cae ycie obcowa ze mierci, 'Pops' wie jak trudne s te chwile.",
	L"Zakad pogrzebowy McGillicutty oferuje szeroki zakres usug, od duchowego wsparcia po rekonstrukcj silnie znieksztaconych zwok.",
	L"Pozwl by McGillicutty ci pomg a twj ukochany bdzie spoczywa w pokoju.",

	// Text for the various links available at the bottom of the page
	L"WYLIJ KWIATY",
	L"KOLEKCJA TRUMIEN I URN",
	L"USUGI KREMA- CYJNE",
	L"USUGI PLANOWANIA POGRZEBU",
	L"KARTKI POGRZE- BOWE",

	// The text that comes up when you click on any of the links ( except for send flowers ).
	L"Niestety, z powodu mierci w rodzinie, nie dziaaj jeszcze wszystkie elementy tej strony.",
	L"Przepraszamy za powysze uniedogodnienie."
};

// Text for the florist Home page

const wchar_t* sFloristText[] =
{
	//Text on the button on the bottom of the page

	L"Galeria",

	//Address of United Florist

	L"\"Zrzucamy z samolotu w dowolnym miejscu\"",
	L"1-555-POCZUJ-MNIE",
	L"Ul. Nosowska 333, Zapuszczone miasto, CA USA 90210",
	L"http://www.poczuj-mnie.com",

	// detail of the florist page

	L"Dziaamy szybko i sprawnie!",
	L"Gwarantujemy dostaw w dowolny punkt na Ziemi, nastpnego dnia po zoeniu zamwienia!",
	L"Oferujemy najnisze ceny na wiecie!",
	L"Poka nam ofert z nisz cen, a dostaniesz w nagrod tuzin r, za darmo!",
	L"Latajca flora, fauna i kwiaty od 1981.",
	L"Nasz ozdobiony bombowiec zrzuci twj bukiet w promieniu co najwyej dziesiciu mil od danego miejsca. Kiedy tylko zechcesz!",
	L"Pozwl nam zaspokoi twoje kwieciste fantazje.",
	L"Bruce, nasz wiatowej renomy projektant bukietw, zerwie dla ciebie najwiesze i najwspanialsze kwiaty z naszej szklarni.",
	L"I pamitaj, jeli czego nie mamy, moemy to szybko zasadzi!"
};



//Florist OrderForm

const wchar_t* sOrderFormText[] =
{
	//Text on the buttons

	L"Powrt",
	L"Wylij",
	L"Skasuj",
	L"Galeria",

	L"Nazwa bukietu:",
	L"Cena:",			//5
	L"Zamwienie numer:",
	L"Czas dostawy",
	L"nast. dnia",
	L"dostawa gdy to bdzie moliwe",
	L"Miejsce dostawy",			//10
	L"Dodatkowe usugi",
	L"Zgnieciony bukiet($10)",
	L"Czarne Re($20)",
	L"Zwidnity bukiet($10)",
	L"Ciasto owocowe (jeeli bdzie)($10)",		//15
	L"Osobiste kondolencje:",
	L"Ze wzgldu na rozmiar karteczek, tekst nie moe zawiera wicej ni 75 znakw.",
	L"...moesz te przejrze nasze",

	L"STANDARDOWE KARTKI",
	L"Informacja o rachunku",//20

	//The text that goes beside the area where the user can enter their name

	L"Nazwisko:",
};




//Florist Gallery.c

const wchar_t* sFloristGalleryText[] =
{
	//text on the buttons

	L"Poprz.",	//abbreviation for previous
	L"Nast.",	//abbreviation for next

	L"Kliknij wybran pozycj aby zoy zamwienie.",
	L"Uwaga: $10 dodatkowej opaty za zwidnity lub zgnieciony bukiet.",

	//text on the button

	L"Gwna",
};

//Florist Cards

const wchar_t* sFloristCards[] =
{
	L"Kliknij swj wybr",
	L"Wstecz"
};



// Text for Bobby Ray's Mail Order Site

const wchar_t* BobbyROrderFormText[] =
{
	L"Formularz zamwienia",				//Title of the page
	L"Ilo",					// The number of items ordered
	L"Waga (%S)",			// The weight of the item
	L"Nazwa",				// The name of the item
	L"Cena",				// the item's weight
	L"Warto",				//5	// The total price of all of items of the same type
	L"W sumie",				// The sub total of all the item totals added
	L"Transport",		// S&H is an acronym for Shipping and Handling
	L"Razem",			// The grand total of all item totals + the shipping and handling
	L"Miejsce dostawy",
	L"Czas dostawy",			//10	// See below
	L"Koszt (za %S.)",			// The cost to ship the items
	L"Ekspres - 24h",			// Gets deliverd the next day
	L"2 dni robocze",			// Gets delivered in 2 days
	L"Standardowa dostawa",			// Gets delivered in 3 days
	L" Wyczy",//15			// Clears the order page
	L" Akceptuj",			// Accept the order
	L"Wstecz",				// text on the button that returns to the previous page
	L"Strona gwna",				// Text on the button that returns to the home page
	L"* oznacza uywane rzeczy",		// Disclaimer stating that the item is used
	L"Nie sta ci na to.",		//20	// A popup message that to warn of not enough money
	L"<BRAK>",				// Gets displayed when there is no valid city selected
	L"Miejsce docelowe przesyki: %S. Potwierdzasz?",		// A popup that asks if the city selected is the correct one
	L"Waga przesyki*",			// Displays the weight of the package
	L"* Min. Waga",				// Disclaimer states that there is a minimum weight for the package
	L"Dostawy",
};


// This text is used when on the various Bobby Ray Web site pages that sell items

const wchar_t* BobbyRText[] =
{
	L"Zamw",				// Title

	L"Kliknij wybrane towary. Lewym klawiszem zwikszasz ilo towaru, a prawym zmniejszasz. Gdy ju skompletujesz swoje zakupy przejd do formularza zamwienia.",			// instructions on how to order

	//Text on the buttons to go the various links

	L"Poprzednia",		//
	L"Bro", 			//3
	L"Amunicja",			//4
	L"Ochraniacze",			//5
	L"Rne",			//6	//misc is an abbreviation for miscellaneous
	L"Uywane",			//7
	L"Nastpna",
	L"FORMULARZ",
	L"Strona gwna",			//10

	//The following 2 lines are used on the Ammunition page.
	//They are used for help text to display how many items the player's merc has
	//that can use this type of ammo

	L"Twj zesp posiada",//11
	L"szt. broni do ktrej pasuje amunicja tego typu", //12

	//The following lines provide information on the items

	L"Waga:",			// Weight of all the items of the same type
	L"Kal:",			// the caliber of the gun
	L"Mag:",			// number of rounds of ammo the Magazine can hold
	L"Zas:",				// The range of the gun
	L"Sia:",				// Damage of the weapon
	L"CS:",			// Weapon's Rate Of Fire, acroymn ROF
	L"Koszt:",			// Cost of the item
	L"Na stanie:",			// The number of items still in the store's inventory
	L"Ilo na zamw.:",		// The number of items on order
	L"Uszkodz.",			// If the item is damaged
	L"Waga:",			// the Weight of the item
	L"Razem:",			// The total cost of all items on order
	L"* Stan: %%",		// if the item is damaged, displays the percent function of the item

	//Popup that tells the player that they can only order 10 items at a time

	L"Przepraszamy za to utrudnienie, ale na jednym zamwieniu moe si znajdowa tylko 10 pozycji! Jeli potrzebujesz wicej, z kolejne zamwienie.",

	// A popup that tells the user that they are trying to order more items then the store has in stock

	L"Przykro nam. Chwilowo nie mamy tego wicej na magazynie. Prosz sprbowa pniej.",

	//A popup that tells the user that the store is temporarily sold out

	L"Przykro nam, ale chwilowo nie mamy tego towaru na magazynie",

};


// Text for Bobby Ray's Home Page

const wchar_t* BobbyRaysFrontText[] =
{
	//Details on the web site

	L"Tu znajdziesz nowoci z dziedziny broni i osprztu wojskowego",
	L"Zaspokoimy wszystkie twoje potrzeby w dziedzinie materiaw wybuchowych",
	L"UYWANE RZECZY",

	//Text for the various links to the sub pages

	L"RӯNE",
	L"BRO",
	L"AMUNICJA",		//5
	L"OCHRANIACZE",

	//Details on the web site

	L"Jeli MY tego nie mamy, to znaczy, e nigdzie tego nie dostaniesz!",
	L"W trakcie budowy",
};



// Text for the AIM page.
// This is the text used when the user selects the way to sort the aim mercanaries on the AIM mug shot page

const wchar_t* AimSortText[] =
{
	L"Czonkowie A.I.M.",				// Title

	L"Sortuj wg:",					// Title for the way to sort

	// sort by...

	L"Ceny",
	L"Dowiadczenia",
	L"Um. strzeleckich",
	L"Um. med.",
	L"Zn. mat. wyb.",
	L"Zn. mechaniki",

	//Text of the links to other AIM pages

	L"Portrety najemnikw",
	L"Akta najemnika",
	L"Poka galeri byych czonkw A.I.M.",

	// text to display how the entries will be sorted

	L"Rosnco",
	L"Malejco",
};


//Aim Policies.c
//The page in which the AIM policies and regulations are displayed

const wchar_t* AimPolicyText[] =
{
	// The text on the buttons at the bottom of the page

	L"Poprzednia str.",
	L"Strona gwna",
	L"Przepisy",
	L"Nastpna str.",
	L"Rezygnuj",
	L"Akceptuj",
};



//Aim Member.c
//The page in which the players hires AIM mercenaries

// Instructions to the user to either start video conferencing with the merc, or to go the mug shot index

const wchar_t* AimMemberText[] =
{
	L"Lewy klawisz myszy",
	L"kontakt z najemnikiem",
	L"Prawy klawisz myszy",
	L"lista portretw",
};

//Aim Member.c
//The page in which the players hires AIM mercenaries

const wchar_t* CharacterInfo[] =
{
	// The various attributes of the merc

	L"Zdrowie",
	L"Zwinno",
	L"Sprawno",
	L"Sia",
	L"Um. dowodzenia",
	L"Inteligencja",
	L"Poziom dow.",
	L"Um. strzeleckie",
	L"Zn. mechaniki",
	L"Zn. mat. wyb.",
	L"Wiedza med.",				//10

	// the contract expenses' area

	L"Zapata",
	L"Czas",
	L"1 dzie",
	L"1 tydzie",
	L"2 tygodnie",

	// text for the buttons that either go to the previous merc,
	// start talking to the merc, or go to the next merc

	L"Poprzedni",
	L"Kontakt",
	L"Nastpny",

	L"Dodatkowe informacje",				// Title for the additional info for the merc's bio
	L"Aktywni czonkowie",		//20		// Title of the page
	L"Opcjonalne wyposaenie:",				// Displays the optional gear cost
	L"Wymagany jest zastaw na ycie",			// If the merc required a medical deposit, this is displayed
};


//Aim Member.c
//The page in which the player's hires AIM mercenaries

//The following text is used with the video conference popup

const wchar_t* VideoConfercingText[] =
{
	L"Warto kontraktu:",				//Title beside the cost of hiring the merc

	//Text on the buttons to select the length of time the merc can be hired

	L"Jeden dzie",
	L"Jeden tydzie",
	L"Dwa tygodnie",

	//Text on the buttons to determine if you want the merc to come with the equipment

	L"Bez sprztu",
	L"We sprzt",

	// Text on the Buttons

	L"TRANSFER",			// to actually hire the merc
	L"ANULUJ",				// go back to the previous menu
	L"WYNAJMIJ",				// go to menu in which you can hire the merc
	L"ROZCZ",				// stops talking with the merc
	L"OK",
	L"NAGRAJ SI",			// if the merc is not there, you can leave a message

	//Text on the top of the video conference popup

	L"Wideo konferencja z - ",
	L"cz. . .",

	L"z zastawem"			// Displays if you are hiring the merc with the medical deposit
};



//Aim Member.c
//The page in which the player hires AIM mercenaries

// The text that pops up when you select the TRANSFER FUNDS button

const wchar_t* AimPopUpText[] =
{
	L"TRANSFER ZAKOCZONY POMYLNIE",	// You hired the merc
	L"PRZEPROWADZENIE TRANSFERU NIE MOLIWE",		// Player doesn't have enough money, message 1
	L"BRAK RODKW",				// Player doesn't have enough money, message 2

	// if the merc is not available, one of the following is displayed over the merc's face

	L"Wynajto",
	L"Prosz zostaw wiadomo",
	L"Nie yje",

	//If you try to hire more mercs than game can support

	L"Masz ju peny zesp 18 najemnikw.",

	L"Nagrana wiadomo",
	L"Wiadomo zapisana",
};


//AIM Link.c

const wchar_t* AimLinkText[] =
{
	L"A.I.M. Linki",	//The title of the AIM links page
};



//Aim History

// This page displays the history of AIM

const wchar_t* AimHistoryText[] =
{
	L"A.I.M. Historia",					//Title

	// Text on the buttons at the bottom of the page

	L"Poprzednia str.",
	L"Strona gwna",
	L"Byli czonkowie",
	L"Nastpna str."
};


//Aim Mug Shot Index

//The page in which all the AIM members' portraits are displayed in the order selected by the AIM sort page.

const wchar_t* AimFiText[] =
{
	// displays the way in which the mercs were sorted

	L"ceny",
	L"dowiadczenia",
	L"um. strzeleckich",
	L"um. medycznych",
	L"zn. materiaw wyb.",
	L"zn. mechaniki",

	// The title of the page, the above text gets added at the end of this text

	L"Czonkowie A.I.M. posortowani rosnco wg %S",
	L"Czonkowie A.I.M. posortowani malejco wg %S",

	// Instructions to the players on what to do

	L"Lewy klawisz",
	L"Wybr najemnika",			//10
	L"Prawy klawisz",
	L"Opcje sortowania",

	// Gets displayed on top of the merc's portrait if they are...

	L"Wyjecha(a)",
	L"Nie yje",						//14
	L"Wynajto",
};



//AimArchives.
// The page that displays information about the older AIM alumni merc... mercs who are no longer with AIM

const wchar_t* AimAlumniText[] =
{

	L"STRONA 1",
	L"STRONA 2",
	L"STRONA 3",

	L"Byli czonkowie A.I.M.",	// Title of the page


	L"OK"			// Stops displaying information on selected merc
};






//AIM Home Page

const wchar_t* AimScreenText[] =
{
	// AIM disclaimers

	L"Znaki A.I.M. i logo A.I.M. s prawnie chronione w wikszoci krajw.",
	L"Wic nawet nie myl o prbie ich podrobienia.",
	L"Copyright 1998-1999 A.I.M., Ltd. All rights reserved.",

	//Text for an advertisement that gets displayed on the AIM page

	L"United Floral Service",
	L"\"Zrzucamy gdziekolwiek\"",				//10
	L"Zrb to jak naley...",
	L"...za pierwszym razem",
	L"Bro i akcesoria, jeli czego nie mamy, to tego nie potrzebujesz.",
};


//Aim Home Page

const wchar_t* AimBottomMenuText[] =
{
	//Text for the links at the bottom of all AIM pages
	L"Strona gwna",
	L"Czonkowie",
	L"Byli czonkowie",
	L"Przepisy",
	L"Historia",
	L"Linki",
};



//ShopKeeper Interface
// The shopkeeper interface is displayed when the merc wants to interact with
// the various store clerks scattered through out the game.

const wchar_t* SKI_Text[ ] =
{
	L"TOWARY NA STANIE",		//Header for the merchandise available
	L"STRONA",				//The current store inventory page being displayed
	L"KOSZT OGӣEM",				//The total cost of the the items in the Dealer inventory area
	L"WARTO OGӣEM",			//The total value of items player wishes to sell
	L"WYCENA",				//Button text for dealer to evaluate items the player wants to sell
	L"TRANSAKCJA",			//Button text which completes the deal. Makes the transaction.
	L"OK",				//Text for the button which will leave the shopkeeper interface.
	L"KOSZT NAPRAWY",			//The amount the dealer will charge to repair the merc's goods
	L"1 GODZINA",			// SINGULAR! The text underneath the inventory slot when an item is given to the dealer to be repaired
	L"%d GODZIN(Y)",		// PLURAL!   The text underneath the inventory slot when an item is given to the dealer to be repaired
	L"NAPRAWIONO",		// Text appearing over an item that has just been repaired by a NPC repairman dealer
	L"Brak miejsca by zaoferowa wicej rzeczy.",	//Message box that tells the user there is no more room to put there stuff
	L"%d MINUT(Y)",		// The text underneath the inventory slot when an item is given to the dealer to be repaired
	L"Upu przedmiot na ziemi.",
};

//ShopKeeper Interface
//for the bank machine panels. Referenced here is the acronym ATM, which means Automatic Teller Machine

const wchar_t* SkiAtmText[] =
{
	//Text on buttons on the banking machine, displayed at the bottom of the page
	L"0",
	L"1",
	L"2",
	L"3",
	L"4",
	L"5",
	L"6",
	L"7",
	L"8",
	L"9",
	L"OK",						// Transfer the money
	L"We",					// Take money from the player
	L"Daj",					// Give money to the player
	L"Anuluj",					// Cancel the transfer
	L"Skasuj",					// Clear the money display
};


//Shopkeeper Interface
const wchar_t* gzSkiAtmText[] =
{

	// Text on the bank machine panel that....
	L"Wybierz",			// tells the user to select either to give or take from the merc
	L"Wprowad kwot",			// Enter the amount to transfer
	L"Transfer gotwki do najemnika",		// Giving money to the merc
	L"Transfer gotwki od najemnika",		// Taking money from the merc
	L"Brak rodkw",			// Not enough money to transfer
	L"Saldo",				// Display the amount of money the player currently has
};


const wchar_t* SkiMessageBoxText[] =
{
	L"Czy chcesz dooy %S ze swojego konta, aby pokry rnic?",
	L"Brak rodkw. Brakuje ci %S",
	L"Czy chcesz przeznaczy %S ze swojego konta, aby pokry koszty?",
	L"Popro o rozpoczcie transakscji",
	L"Popro o napraw wybranych przedmiotw",
	L"Zakocz rozmow",
	L"Saldo dostpne",
};


//OptionScreen.c

const wchar_t* zOptionsText[] =
{
	//button Text
	L"Zapisz gr",
	L"Odczytaj gr",
	L"Wyjcie",
	L"OK",

	//Text above the slider bars
	L"Efekty",
	L"Dialogi",
	L"Muzyka",

	//Confirmation pop when the user selects..
	L"Zakoczy gr i wrci do gwnego menu?",

	L"Musisz wczy opcj dialogw lub napisw.",
};


//SaveLoadScreen
const wchar_t* zSaveLoadText[] =
{
	L"Zapisz gr",
	L"Odczytaj gr",
	L"Anuluj",
	L"Zapisz wybran",
	L"Odczytaj wybran",

	L"Gra zostaa pomylnie zapisana",
	L"BD podczas zapisu gry!",
	L"Gra zostaa pomylnie odczytana",
	L"BD podczas odczytu gry!",

	L"Wersja gry w zapisanym pliku rni si od biecej. Prawdopodobnie mona bezpiecznie kontynuowa. Kontynuowa?",
	L"Zapisane pliki gier mog by uszkodzone. Czy chcesz je usun?",

	//Translators, the next two strings are for the same thing.  The first one is for beta version releases and the second one
	//is used for the final version.  Please don't modify the "#ifdef JA2BETAVERSION" or the "#else" or the "#endif" as they are
	//used by the compiler and will cause program errors if modified/removed.  It's okay to translate the strings though.
#ifdef JA2BETAVERSION
	L"Nieprawidowa wersja zapisu gry.  W razie problemw prosimy o raport.  Kontynuowa?",
#else
	L"Prba odczytu starszej wersji zapisu gry.  Zaktualizowa ten zapis i odczyta gr?",
#endif

	//Translators, the next two strings are for the same thing.  The first one is for beta version releases and the second one
	//is used for the final version.  Please don't modify the "#ifdef JA2BETAVERSION" or the "#else" or the "#endif" as they are
	//used by the compiler and will cause program errors if modified/removed.  It's okay to translate the strings though.
#ifdef JA2BETAVERSION
	L"Nieprawidowa wersja zapisu gry.  W razie problemw prosimy o raport.  Kontynuowa?",
#else
	L"Prba odczytu starszej wersji zapisu gry.  Zaktualizowa ten zapis i odczyta gr?",
#endif

	L"Czy na pewno chcesz nadpisa gr na pozycji %d?",
	L"Chcesz odczyta gr z pozycji",


	//The first %d is a number that contains the amount of free space on the users hard drive,
	//the second is the recommended amount of free space.
	L"Brak miejsca na dysku twardym.  Na dysku wolne jest %d MB, a wymagane jest przynajmniej %d MB.",

	L"Zapisuj...",			//When saving a game, a message box with this string appears on the screen

	L"Standardowe uzbrojenie",
	L"Cae mnstwo broni",
	L"Realistyczna gra",
	L"Elementy S-F",

	L"Stopie trudnoci",
};



//MapScreen
const wchar_t* zMarksMapScreenText[] =
{
	L"Poziom mapy",
	L"Nie masz jeszcze onierzy samoobrony.  Musisz najpierw wytrenowa mieszkacw miast.",
	L"Dzienny przychd",
	L"Najmemnik ma polis ubezpieczeniow",
    L"%S nie potrzebuje snu.",
	L"%S jest w drodze i nie moe spa",
	L"%S jest zbyt zmczony(na), sprbuj troch pniej.",
	L"%S prowadzi.",
	L"Oddzia nie moe si porusza jeeli jeden z najemnikw pi.",

	// stuff for contracts
	L"Mimo, e moesz opaci kontrakt, to jednak nie masz gotwki by opaci skadk ubezpieczeniow za najemnika.",
	L"%S - skadka ubezpieczeniowa najemnika bdzie kosztowa %S za %d dzie(dni). Czy chcesz j opaci?",
	L"Inwentarz sektora",
	L"Najemnik posiada zastaw na ycie.",

	// other items
	L"Lekarze", // people acting a field medics and bandaging wounded mercs // **************************************NEW******** as of July 09, 1998
	L"Pacjenci", // people who are being bandaged by a medic // ****************************************************NEW******** as of July 10, 1998
	L"Gotowe", // Continue on with the game after autobandage is complete
	L"Przerwij", // Stop autobandaging of patients by medics now
	L"Przykro nam, ale ta opcja jest wyczona w wersji demo.", // informs player this option/button has been disabled in the demo
	L"%S nie ma zestawu narzdzi.",
	L"%S nie ma apteczki.",
	L"Brak chtnych ludzi do szkolenia, w tej chwili.",
	L"%S posiada ju maksymaln liczb oddziaw samoobrony.",
	L"Najemnik ma kontrakt na okrelony czas.",
  L"Kontrakt najemnika nie jest ubezpieczony",
};


const wchar_t* pLandMarkInSectorString[] =
{
	L"Oddzia %d zauway kogo w sektorze %S",
};

// confirm the player wants to pay X dollars to build a militia force in town
const wchar_t* pMilitiaConfirmStrings[] =
{
	L"Szkolenie oddziau samoobrony bdzie kosztowao $", // telling player how much it will cost
	L"Zatwierdzasz wydatek?", // asking player if they wish to pay the amount requested
	L"Nie sta ci na to.", // telling the player they can't afford to train this town
	L"Kontynuowa szkolenie samoobrony w - %S (%S %d)?", // continue training this town?
	L"Koszt $", // the cost in dollars to train militia
	L"( T/N )",   // abbreviated yes/no
	L"",	// unused
	L"Szkolenie samoobrony w %d sektorach bdzie kosztowao $ %d. %S", // cost to train sveral sectors at once
	L"Nie masz %d$, aby wyszkoli samoobron w tym miecie.",
	L"%S musi mie %d% lojalnoci, aby mona byo kontynuowa szkolenie samoobrony.",
	L"Nie moesz ju duej szkoli samoobrony w miecie %S.",
};

#ifdef JA2DEMOADS
const wchar_t* gpDemoString[] =
{
	//0-9
	L"NAJLEPSZA GRA STRATEGICZNA.",
	L"NAJLEPSZA GRA ROLE-PLAYING.",
	L"Nieliniowy scenariusz gry",
	L"Absolutnie nowy pomys",
	L"Wspaniae strzelaniny",
	L"Dynamiczne owietlenie",
	L"Rozmowy z postaciami",
	L"Nocne akcje",
	L"Kreowanie wasnego najemnika",
	L"Ambitne i wcigajce misje",
	L"Sterowanie pojazdami",
	//10-19
	L"Ponad 150 rnych postaci",
	L"Setki ciekawych przedmiotw",
	L"Ponad 250 rnych plenerw",
	L"Efektowne eksplozje",
	L"Nowe taktyczne manewry",
	L"Tony animacji",
	L"Ponad 9000 kwestii dialogowych",
	L"Niesamowity podkad muzyczny Kevina Manthei",
	L"Globalna strategia",
	L"Naloty",
	//20-29
	L"Szkolenie oddziaw samoobrony",
	L"Moliwo dostosowania scenariusza gry",
	L"Realistyczne tereny",
	L"Efektowna grafika high-color",
	L"Kupno, sprzeda i handel",
	L"Bezwzgldny przeciwnik AI",
	L"wietna walka taktyczna",
	L"Opcjonalny element S-F",
	L"24 godzinny zegar",
	L"Minimum 60 godzin gry",
	//30-34
	L"Rne poziomy trudnoci",
	L"Realistycznie opracowana balistyka",
	L"Wierne odwzorowanie zasad fizyki",
	L"W peni interaktywny interfejs",
	L"I wiele, wiele wicej...",
	//35 on are BOLD
	L"",
	L"",
	L"Jedna z najbardziej pomysowych gier 1998 roku",
	L"PC Gamer",
	L"Zamw ju dzisiaj na stronie WWW.TOPWARE.PL !",
};

const wchar_t* gpDemoIntroString[] =
{
	L"Za chwil sprbujesz najlepszej strategii, role-playing i najwspanialszej walki taktycznej:",
	//Point 1 (uses one string)
	L"Kontrola nad grup najemnikw o bogatej osobowoci   (adnych nudnych i zbdnych postaci).",
	//Point 2 (uses one string)
	L"Sprawd wspaniae manewry taktyczne, poczwszy od biegu do czogania si, wspinania si, skakania, walki wrcz i wielu innych.",
	//Point 3 (uses one string)
	L"Igraj z ogniem! Fajne zabawki, miercionona bro, efektowne eksplozje.",
	//Additional comment
	L"(a to dopiero pocztek...)",
	//Introduction/instructions
	L"Witamy w Demoville... (nacinij dowolny klawisz)",
};
#endif

//Strings used in the popup box when withdrawing, or depositing money from the $ sign at the bottom of the single merc panel
const wchar_t* gzMoneyWithdrawMessageText[] =
{
	L"Jednorazowo moesz wypaci do 20,000$.",
	L"Czy na pewno chcesz wpaci %S na swoje konto?",
};

const wchar_t* gzCopyrightText[] =
{
	L"Copyright (C) 1999 Sir-tech Canada Ltd.  All rights reserved.",
};

//option Text
const wchar_t* zOptionsToggleText[] =
{
	L"Dialogi",
	L"Wycisz potwierdzenia",
	L"Napisy",
	L"Wstrzymuj napisy",
	L"Animowany dym",
	L"Drastyczne sceny",
	L"Nigdy nie ruszaj mojej myszki!",
	L"Stara metoda wyboru",
	L"Pokazuj tras ruchu",
	L"Pokazuj chybione strzay",
	L"Potwierdzenia w trybie Real-Time",
	L"Informacja, e najemnik pi/budzi si",
	L"Uywaj systemu metrycznego",
	L"wiato wok najemnikw podczas ruchu",
	L"Przycigaj kursor do najemnikw",
	L"Przycigaj kursor do drzwi",
	L"Pulsujce przedmioty",
	L"Pokazuj korony drzew",
	L"Pokazuj siatk",
	L"Pokazuj kursor 3D",
};

//This is the help text associated with the above toggles.
const wchar_t* zOptionsScreenHelpText[] =
{
	//speech
	L"Wcz t opcj, jeli chcesz sucha dialogw.",

	//Mute Confirmation
	L"Wcza lub wycza gosowe potwierzenia postaci.",

		//Subtitles
	L"Wcza lub wycza napisy podczas dialogw.",

	//Key to advance speech
	L"Jeli napisy s wczone, opcja ta pozwoli ci spokojnie je przeczyta podczas dialogu.",

	//Toggle smoke animation
	L"Wycz t opcj, aby poprawi pynno dziaania gry.",

	//Blood n Gore
	L"Wycz t opcj, jeli nie lubisz widoku krwi.",

	//Never move my mouse
	L"Wycz t opcj, aby kursor myszki automatycznie ustawia si nad pojawiajcymi si okienkami dialogowymi.",

	//Old selection method
	L"Wcz t opcj, aby wybr postaci dziaa tak jak w poprzedniej wersji gry.",

	//Show movement path
	L"Wcz t opcj jeli chcesz widzie tras ruchu w trybie Real-Time.",

	//show misses
	L"Wcz t opcj, aby zobaczy w co trafiaj twoje kule gdy pudujesz.",

	//Real Time Confirmation
	L"Gdy opcja ta jest wczona, kady ruch najemnika w trybie Real-Time bdzie wymaga dodatkowego, potwierdzajcego kliknicia.",

	//Sleep/Wake notification
  	L"Gdy opcja ta jest wczona, wywietlana bdzie informacja, e najemnik pooy si spa lub wsta i wrci do pracy.",

	//Use the metric system
	L"Gdy opcja ta jest wczona, gra uywa systemu metrycznego.",

	//Merc Lighted movement
	L"Gdy opcja ta jest wczona, teren wok najemnika bdzie owietlony podczas ruchu. Wycz t opcj, jeli obnia pynno gry.",

	//Smart cursor
	L"Gdy opcja ta jest wczona, kursor automatycznie ustawia si na najemnikach gdy znajdzie si w ich pobliu.",

	//snap cursor to the door
	L"Gdy opcja ta jest wczona, kursor automatycznie ustawi si na drzwiach gdy znajdzie si w ich pobliu.",

	//glow items
	L"Gdy opcja ta jest wczona, przedmioty pulsuj. ( |I )",

	//toggle tree tops
	L"Gdy opcja ta jest wczona, wywietlane s korony drzew. ( |T )",

	//toggle wireframe
	L"Gdy opcja ta jest wczona, wywietlane s zarysy niewidocznych cian. ( |W )",

	L"Gdy opcja ta jest wczona, kursor ruchu wywietlany jest w 3D. ( |Home )",

};


const wchar_t* gzGIOScreenText[] =
{
	L"POCZTKOWE USTAWIENIA GRY",
	L"Styl gry",
	L"Realistyczny",
	L"S-F",
	L"Opcje broni",
	L"Mnstwo broni",
	L"Standardowe uzbrojenie",
	L"Stopie trudnoci",
	L"Nowicjusz",
	L"Dowiadczony",
	L"Ekspert",
	L"Ok",
	L"Anuluj",
	L"Dodatkowe opcje",
	L"Nielimitowany czas",
	L"Tury limitowane czasowo",
	L"Nie dziaa w wersji demo",
};

const wchar_t* pDeliveryLocationStrings[] =
{
	L"Austin",			//Austin, Texas, USA
	L"Bagdad",			//Baghdad, Iraq (Suddam Hussein's home)
	L"Drassen",			//The main place in JA2 that you can receive items.  The other towns are dummy names...
	L"Hong Kong",		//Hong Kong, Hong Kong
	L"Bejrut",			//Beirut, Lebanon	(Middle East)
	L"Londyn",			//London, England
	L"Los Angeles",	//Los Angeles, California, USA (SW corner of USA)
	L"Meduna",			//Meduna -- the other airport in JA2 that you can receive items.
	L"Metavira",		//The island of Metavira was the fictional location used by JA1
	L"Miami",				//Miami, Florida, USA (SE corner of USA)
	L"Moskwa",			//Moscow, USSR
	L"Nowy Jork",		//New York, New York, USA
	L"Ottawa",			//Ottawa, Ontario, Canada -- where JA2 was made!
	L"Pary",				//Paris, France
	L"Trypolis",			//Tripoli, Libya (eastern Mediterranean)
	L"Tokio",				//Tokyo, Japan
	L"Vancouver",		//Vancouver, British Columbia, Canada (west coast near US border)
};

const wchar_t* pSkillAtZeroWarning[] =
{ //This string is used in the IMP character generation.  It is possible to select 0 ability
	//in a skill meaning you can't use it.  This text is confirmation to the player.
	L"Na pewno? Warto zero oznacza brak jakichkolwiek umiejtnoci w tej dziedzinie.",
};

const wchar_t* pIMPBeginScreenStrings[] =
{
	L"( Maks. 8 znakw )",
};

const wchar_t* pIMPFinishButtonText[ 1 ]=
{
	L"Analizuj",
};

const wchar_t* pIMPFinishStrings[ ]=
{
	L"Dzikujemy, %S", //%S is the name of the merc
};

// the strings for imp voices screen
const wchar_t* pIMPVoicesStrings[] =
{
	L"Gos",
};

const wchar_t* pDepartedMercPortraitStrings[ ]=
{
	L"mier w akcji",
	L"Zwolnienie",
	L"Inny",
};

// title for program
const wchar_t* pPersTitleText[] =
{
	L"Personel",
};

// paused game strings
const wchar_t* pPausedGameText[] =
{
	L"Gra wstrzymana",
	L"Wznw gr (|P|a|u|s|e)",
	L"Wstrzymaj gr (|P|a|u|s|e)",
};


const wchar_t* pMessageStrings[] =
{
	L"Zakoczy gr?",
	L"OK",
	L"TAK",
	L"NIE",
	L"ANULUJ",
	L"NAJMIJ",
	L"LIE",
	L"Brak opisu", //Save slots that don't have a description.
	L"Gra zapisana.",
	L"Gra zapisana.",
	L"QuickSave", //The name of the quicksave file (filename, text reference)
	L"SaveGame",	//The name of the normal savegame file, such as SaveGame01, SaveGame02, etc.
	L"sav",				//The 3 character dos extension (represents sav)
	L"..\\SavedGames", //The name of the directory where games are saved.
	L"Dzie",
	L"Najemn.",
	L"Wolna pozycja", //An empty save game slot
	L"Demo",				//Demo of JA2
	L"Debug",				//State of development of a project (JA2) that is a debug build
	L"",			//Release build for JA2
	L"strz/min",					//Abbreviation for Rounds per minute -- the potential # of bullets fired in a minute.
	L"min",					//Abbreviation for minute.
	L"m",						//One character abbreviation for meter (metric distance measurement unit).
	L"kul",				//Abbreviation for rounds (# of bullets)
	L"kg",					//Abbreviation for kilogram (metric weight measurement unit)
	L"lb",					//Abbreviation for pounds (Imperial weight measurement unit)
	L"Strona gwna",				//Home as in homepage on the internet.
	L"USD",					//Abbreviation to US dollars
	L"N/D",					//Lowercase acronym for not applicable.
	L"Tymczasem",		//Meanwhile
	L"%S przyby(a) do sektora %S%S", //Name/Squad has arrived in sector A9.  Order must not change without notifying
																		//SirTech
	L"Wersja",
	L"Wolna pozycja na szybki zapis",
	L"Ta pozycja zarezerwowana jest na szybkie zapisy wykonywane podczas gry kombinacj klawiszy ALT+S.",
	L"Otw.",
	L"Zamkn.",
#ifdef JA2DEMO
	L"Tu ju wszystko zaatwione. Moe czas spotka si z Gabby'm.",
	L"Nie trzeba byo go zabija.",
#endif
	L"Brak miejsca na dysku twardym.  Na dysku wolne jest %S MB, a wymagane jest przynajmniej %S MB.",
	L"Najto - %S z A.I.M.",
	L"%S zapa(a) %S",		//'Merc name' has caught 'item' -- let SirTech know if name comes after item.
	L"%S zaaplikowa(a) sobie lekarstwo", //'Merc name' has taken the drug
	L"%S nie posiada wiedzy medycznej",//'Merc name' has no medical skill.

	//CDRom errors (such as ejecting CD while attempting to read the CD)
	L"Integralno gry zostaa naraona na szwank.",
	L"BD: Wyjto pyt CD",

	//When firing heavier weapons in close quarters, you may not have enough room to do so.
	L"Nie ma miejsca, eby std odda strza.",

	//Can't change stance due to objects in the way...
	L"Nie mona zmieni pozycji w tej chwili.",

	//Simple text indications that appear in the game, when the merc can do one of these things.
	L"Upu",
	L"Rzu",
	L"Podaj",

	L"%S przekazano do - %S.", //"Item" passed to "merc".  Please try to keep the item %S before the merc %S, otherwise,
											 //must notify SirTech.
	L"Brak wolnego miejsca, by przekaza %S do - %S.", //pass "item" to "merc".  Same instructions as above.

	//A list of attachments appear after the items.  Ex:  Kevlar vest ( Ceramic Plate 'Attached )'
	L" doczono )",

	//Cheat modes
	L"Pierwszy poziom lamerskich zagrywek osignity",
	L"Drugi poziom lamerskich zagrywek osignity",

	//Toggling various stealth modes
	L"Oddzia ma wczony tryb skradania si.",
	L"Oddzia ma wyczony tryb skradania si.",
	L"%S ma wczony tryb skradania si.",
	L"%S ma wyczony tryb skradania si.",

	//Wireframes are shown through buildings to reveal doors and windows that can't otherwise be seen in
	//an isometric engine.  You can toggle this mode freely in the game.
	L"Dodatkowe siatki wczone.",
	L"Dodatkowe siatki wyczone.",

	//These are used in the cheat modes for changing levels in the game.  Going from a basement level to
	//an upper level, etc.
	L"Nie mona wyj do gry z tego poziomu...",
	L"Nie ma ju niszych poziomw...",
	L"Wejcie na %d poziom pod ziemi...",
	L"Wyjcie z podziemii...",

	#ifdef JA2DEMO

	//For the demo, the sector exit interface, you'll be able to split your teams up, but the demo
	//has this feature disabled.  This string is fast help text that appears over "single" button.
	L"W penej wersji gry bdzie mona dzieli oddziay,\nale w wersji demo jest to niemoliwe.",

	//The overhead map is a map of the entire sector, which you can go into anytime, except in the demo.
	L"Oglna mapa sektora jest niedostpna w wersji demo.",

	#endif

	L" - ",		// used in the shop keeper inteface to mark the ownership of the item eg Red's gun
	L"Automatyczne centrowanie ekranu wyczone.",
	L"Automatyczne centrowanie ekranu wczone.",
	L"Kursor 3D wyczony.",
	L"Kursor 3D wczony.",
	L"Oddzia %d aktywny.",
	L"%S - Nie sta ci by wypaci jej/jemu dzienn pensj w wysokoci %S.",	//first %S is the mercs name, the seconds is a string containing the salary
	L"Pomi",
	L"%S nie moe odej sam(a).",
	L"Utworzono zapis gry o nazwie SaveGame99.sav. W razie potrzeby zmie jego nazw na SaveGame01..10. Wtedy bdzie mona go odczyta ze standardowego okna odczytu gry.",
	L"%S wypi(a) troch - %S",
	L"Przesyka dotara do Drassen.",
 	L"%S przybdzie do wyznaczonego punktu zrzutu (sektor %S) w dniu %d, okoo godziny %S.",		//first %S is mercs name, next is the sector location and name where they will be arriving in, lastely is the day an the time of arrival
	L"Lista historii zaktualizowana.",
#ifdef JA2BETAVERSION
	L"Automatyczny zapis zosta pomylnie wykonany.",
#endif
};


const wchar_t ItemPickupHelpPopup[][40] =
{
	L"OK",
	L"W gr",
	L"Wybierz wszystko",
	L"W d",
	L"Anuluj",
};

const wchar_t* pDoctorWarningString[] =
{
	L"%S jest za daleko, aby podda si leczeniu.",
	L"Lekarze nie mogli opatrzy wszystkich rannych.",
};

const wchar_t* pMilitiaButtonsHelpText[] =
{
	L"Podnie(Prawy klawisz myszy)/upu(Lewy klawisz myszy) Zielonych onierzy", // button help text informing player they can pick up or drop militia with this button
	L"Podnie(Prawy klawisz myszy)/upu(Lewy klawisz myszy) Dowiadczonych onierzy",
	L"Podnie(Prawy klawisz myszy)/upu(Lewy klawisz myszy) Weteranw",
	L"Umieszcza jednakow ilo onierzy samoobrony w kadym sektorze.",
};

const wchar_t* pMapScreenJustStartedHelpText[] =
{
	L"Zajrzyj do A.I.M. i zatrudnij kilku najemnikw (*Wskazwka* musisz otworzy laptopa)", // to inform the player to hired some mercs to get things going
	L"Jeli chcesz ju uda si do Arulco, kliknij przycisk kompresji czasu, w prawym dolnym rogu ekranu.", // to inform the player to hit time compression to get the game underway
};

const wchar_t* pAntiHackerString[] =
{
	L"Bd. Brakuje pliku, lub jest on uszkodzony. Gra zostanie przerwana.",
};


const wchar_t* gzLaptopHelpText[] =
{
	//Buttons:
	L"Przegldanie poczty",
	L"Przegldanie stron internetowych",
	L"Przegldanie plikw i zacznikw pocztowych",
	L"Rejestr zdarze",
	L"Informacje o czonkach oddziau",
	L"Finanse i rejestr transakcji",
	L"Koniec pracy z laptopem",

	//Bottom task bar icons (if they exist):
	L"Masz now poczt",
	L"Masz nowe pliki",

	//Bookmarks:
	L"Midzynarodowe Stowarzyszenie Najemnikw",
	L"Bobby Ray's - Internetowy sklep z broni",
	L"Instytut Bada Najemnikw",
	L"Bardziej Ekonomiczne Centrum Rekrutacyjne",
	L"McGillicutty's - Zakad pogrzebowy",
	L"United Floral Service",
	L"Brokerzy ubezpieczeniowi",
};


const wchar_t* gzHelpScreenText[] =
{
	L"Zamknij okno pomocy",
};

const wchar_t* gzNonPersistantPBIText[] =
{
	L"Trwa walka. Najemnikw mona wycofa tylko na ekranie taktycznym.",
	L"W|ejd do sektora, aby kontynuowa walk.",
	L"|Automatycznie rozstrzyga walk.",
	L"Nie mona automatycznie rozstrzygn walki, gdy atakujesz.",
	L"Nie mona automatycznie rozstrzygn walki, gdy wpadasz w puapk.",
	L"Nie mona automatycznie rozstrzygn walki, gdy walczysz ze stworzeniami w kopalni.",
	L"Nie mona automatycznie rozstrzygn walki, gdy w sektorze s wrodzy cywile.",
	L"Nie mona automatycznie rozstrzygn walki, gdy w sektorze s dzikie koty.",
	L"TRWA WALKA",
	L"W tym momencie nie moesz si wycofa.",
};

const wchar_t* gzMiscString[] =
{
	L"onierze samoobrony kontynuuj walk bez pomocy twoich najemnikw...",
	L"W tym momencie tankowanie nie jest konieczne.",
	L"W baku jest %d%% paliwa.",
	L"onierze Deidranny przejli cakowit kontrol nad - %S.",
	L"Nie masz ju gdzie zatankowa.",
};

const wchar_t* gzIntroScreen[] =
{
	L"Nie odnaleziono filmu wprowadzajcego",
};

// These strings are combined with a merc name, a volume string (from pNoiseVolStr),
// and a direction (either "above", "below", or a string from pDirectionStr) to
// report a noise.
// e.g. "Sidney hears a loud sound of MOVEMENT coming from the SOUTH."
const wchar_t* pNewNoiseStr[] =
{
	L"%S syszy %S DWIK dochodzcy z %S.",
	L"%S syszy %S ODGOS RUCHU dochodzcy z %S.",
	L"%S syszy %S ODGOS SKRZYPNICIA dochodzcy z %S.",
	L"%S syszy %S PLUSK dochodzcy z %S.",
	L"%S syszy %S ODGOS UDERZENIA dochodzcy z %S.",
	L"%S syszy %S WYBUCH dochodzcy z %S.",
	L"%S syszy %S KRZYK dochodzcy z %S.",
	L"%S syszy %S ODGOS UDERZENIA dochodzcy z %S.",
	L"%S syszy %S ODGOS UDERZENIA dochodzcy z %S.",
	L"%S syszy %S OMOT dochodzcy z %S.",
	L"%S syszy %S TRZASK dochodzcy z %S.",
};

const wchar_t* wMapScreenSortButtonHelpText[] =
{
	L"Sortuj wedug kolumny Imi (|F|1)",
	L"Sortuj wedug kolumny Przydzia (|F|2)",
	L"Sortuj wedug kolumny Sen (|F|3)",
	L"Sortuj wedug kolumny Lokalizacja (|F|4)",
	L"Sortuj wedug kolumny Cel podry (|F|5)",
	L"Sortuj wedug kolumny Wyjazd (|F|6)",
};



const wchar_t* BrokenLinkText[] =
{
	L"Bd 404",
	L"Nie odnaleziono strony.",
};


const wchar_t* gzBobbyRShipmentText[] =
{
	L"Ostatnie dostawy",
	L"Zamwienie nr ",
	L"Ilo przedmiotw",
	L"Zamwiono:",
};


const wchar_t* gzCreditNames[]=
{
	L"Chris Camfield",
	L"Shaun Lyng",
	L"Kris Mrnes",
	L"Ian Currie",
	L"Linda Currie",
	L"Eric \"WTF\" Cheng",
	L"Lynn Holowka",
	L"Norman \"NRG\" Olsen",
	L"George Brooks",
	L"Andrew Stacey",
	L"Scot Loving",
	L"Andrew \"Big Cheese\" Emmons",
	L"Dave \"The Feral\" French",
	L"Alex Meduna",
	L"Joey \"Joeker\" Whelan",
};


const wchar_t* gzCreditNameTitle[]=
{
	L"Game Internals Programmer", 			// Chris Camfield
	L"Co-designer/Writer",							// Shaun Lyng
	L"Strategic Systems & Editor Programmer",					//Kris Marnes
	L"Producer/Co-designer",						// Ian Currie
	L"Co-designer/Map Designer",				// Linda Currie
	L"Artist",													// Eric \"WTF\" Cheng
	L"Beta Coordinator, Support",				// Lynn Holowka
	L"Artist Extraordinaire",						// Norman \"NRG\" Olsen
	L"Sound Guru",											// George Brooks
	L"Screen Designer/Artist",					// Andrew Stacey
	L"Lead Artist/Animator",						// Scot Loving
	L"Lead Programmer",									// Andrew \"Big Cheese Doddle\" Emmons
	L"Programmer",											// Dave French
	L"Strategic Systems & Game Balance Programmer",					// Alex Meduna
	L"Portraits Artist",								// Joey \"Joeker\" Whelan",
};

const wchar_t* gzCreditNameFunny[]=
{
	L"", 																			// Chris Camfield
	L"(still learning punctuation)",					// Shaun Lyng
	L"(\"It's done. I'm just fixing it\")",	//Kris \"The Cow Rape Man\" Marnes
	L"(getting much too old for this)",				// Ian Currie
	L"(and working on Wizardry 8)",						// Linda Currie
	L"(forced at gunpoint to also do QA)",			// Eric \"WTF\" Cheng
	L"(Left us for the CFSA - go figure...)",	// Lynn Holowka
	L"",																			// Norman \"NRG\" Olsen
	L"",																			// George Brooks
	L"(Dead Head and jazz lover)",						// Andrew Stacey
	L"(his real name is Robert)",							// Scot Loving
	L"(the only responsible person)",					// Andrew \"Big Cheese Doddle\" Emmons
	L"(can now get back to motocrossing)",	// Dave French
	L"(stolen from Wizardry 8)",							// Alex Meduna
	L"(did items and loading screens too!)",	// Joey \"Joeker\" Whelan",
};

const wchar_t* sRepairsDoneString[] =
{
	L"%S skoczy(a) naprawia wasne wyposaenie",
	L"%S skoczy(a) naprawia bro i ochraniacze wszystkich czonkw oddziau",
	L"%S skoczy(a) naprawia wyposaenie wszystkich czonkw oddziau",
	L"%S skoczy(a) naprawia ekwipunek wszystkich czonkw oddziau",
};


const wchar_t* zGioDifConfirmText[]=
{
	L"Wybrano opcj Nowicjusz. Opcja ta jest przeznaczona dla niedowiadczonych graczy, lub dla tych, ktrzy nie maj ochoty na dugie i cikie walki. Pamitaj, e opcja ta ma wpyw na przebieg caej gry. Czy na pewno chcesz gra w trybie Nowicjusz?",
	L"Wybrano opcj Dowiadczony. Opcja ta jest przenaczona dla graczy posiadajcych ju pewne dowiadczenie w grach tego typu. Pamitaj, e opcja ta ma wpyw na przebieg caej gry. Czy na pewno chcesz gra w trybie Dowiadczony?",
	L"Wybrano opcj Ekspert. Jakby co, to ostrzegalimy ci. Nie obwiniaj nas, jeli wrcisz w plastikowym worku. Pamitaj, e opcja ta ma wpyw na przebieg caej gry. Czy na pewno chcesz gra w trybie Ekspert?",
};


const wchar_t* gzLateLocalizedString[] =
{
	L"%S - nie odnaleziono pliku...",

	//1-5
	L"Robot nie moe opuci sektora bez operatora.",

	//This message comes up if you have pending bombs waiting to explode in tactical.
	L"Nie mona teraz kompresowa czasu.  Poczekaj na fajerwerki!",

	//'Name' refuses to move.
	L"%S nie chce si przesun.",

	//%S a merc name
	L"%S ma zbyt mao energii, aby zmieni pozycj.",

	//A message that pops up when a vehicle runs out of gas.
	L"%S nie ma paliwa i stoi w sektorze %c%d.",

	//6-10

	// the following two strings are combined with the pNewNoise[] strings above to report noises
	// heard above or below the merc
	L"GRY",
	L"DOU",

	//The following strings are used in autoresolve for autobandaging related feedback.
	L"aden z twoich najemnikw nie posiada wiedzy medycznej.",
	L"Brak rodkw medycznych, aby zaoy rannym opatrunki.",
	L"Zabrako rodkw medycznych, aby zaoy wszystkim rannym opatrunki.",
	L"aden z twoich najemnikw nie potrzebuje pomocy medycznej.",
	L"Automatyczne zakadanie opatrunkw rannym najemnikom.",
	L"Wszystkim twoim najemnikom zaoono opatrunki.",

	//14
	L"Arulco",

  L"(dach)",

	L"Zdrowie: %d/%d",

	//In autoresolve if there were 5 mercs fighting 8 enemies the text would be "5 vs. 8"
	//"vs." is the abbreviation of versus.
	L"%d vs. %d",

	L"%S - brak wolnych miejsc!",  //(ex "The ice cream truck is full")

  L"%S nie potrzebuje pierwszej pomocy lecz opieki lekarza lub duszego odpoczynku.",

	//20
	//Happens when you get shot in the legs, and you fall down.
	L"%S dosta(a) w nogi i upad(a)!",
	//Name can't speak right now.
	L"%S nie moe teraz mwi.",

	//22-24 plural versions
	L"%d zielonych onierzy samoobrony awansowao na weteranw.",
	L"%d zielonych onierzy samoobrony awansowao na regularnych onierzy.",
	L"%d regularnych onierzy samoobrony awansowao na weteranw.",

	//25
	L"Przecznik",

	//26
	//Name has gone psycho -- when the game forces the player into burstmode (certain unstable characters)
	L"%S dostaje wira!",

	//27-28
	//Messages why a player can't time compress.
	L"Niebezpiecznie jest kompresowa teraz czas, gdy masz najemnikw w sektorze %S.",
	L"Niebezpiecznie jest kompresowa teraz czas, gdy masz najemnikw w kopalni zaatakowanej przez robale.",

	//29-31 singular versions
	L"1 zielony onierz samoobrony awansowa na weterana.",
	L"1 zielony onierz samoobrony awansowa na regularnego onierza.",
	L"1 regularny onierz samoobrony awansowa na weterana.",

	//32-34
	L"%S nic nie mwi.",
	L"Wyj na powierzchni?",
	L"(Oddzia %d)",

	//35
	//Ex: "Red has repaired Scope's MP5K".  Careful to maintain the proper order (Red before Scope, Scope before MP5K)
	L"%S naprawi(a) najemnikowi - %S, jego/jej - %S",

	//36
	L"DZIKI KOT",

	//37-38 "Name trips and falls"
	L"%S potyka si i upada",
	L"Nie mona std podnie tego przedmiotu.",

	//39
	L"aden z twoich najemnikw nie jest w stanie walczy.  onierze samoobrony sami bd walczy z robalami.",

	//40-43
	//%S is the name of merc.
	L"%S nie ma rodkw medycznych!",
	L"%S nie posiada odpowiedniej wiedzy, aby kogokolwiek wyleczy!",
	L"%S nie ma narzdzi!",
	L"%S nie posiada odpowiedniej wiedzy, aby cokolwiek naprawi!",

	//44-45
	L"Czas naprawy",
	L"%S nie widzi tej osoby.",

	//46-48
	L"%S - przeduka lufy jego/jej broni odpada!",
	L"W jednym sektorze, szkolenie samoobrony moe prowadzi tylko %d instruktor(w).",
  	L"Na pewno?",

	//49-50
	L"Kompresja czasu",
	L"Pojazd ma peny zbiornik paliwa.",

	//51-52 Fast help text in mapscreen.
	L"Kontynuuj kompresj czasu (|S|p|a|c|j|a)",
	L"Zatrzymaj kompresj czasu (|E|s|c)",

	//53-54 "Magic has unjammed the Glock 18" or "Magic has unjammed Raven's H&K G11"
	L"%S odblokowa(a) - %S",
	L"%S odblokowa(a) najemnikowi - %S, jego/jej - %S",

	//55
	L"Nie mona kompresowa czasu, gdy otwarty jest inwentarz sektora.",

	L"Nie odnaleziono pyty nr 2 Jagged Alliance 2.",

	L"Przedmioty zostay pomylnie poczone.",

	//58
	//Displayed with the version information when cheats are enabled.
	L"Biecy/Maks. postp: %d%%/%d%%",

	//59
	L"Eskortowa Johna i Mary?",

  L"Przecznik aktywowany.",
};




#endif //POLISH
