/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.tidy;

import org.w3c.tidy.AttVal;
import org.w3c.tidy.AttributeTable;
import org.w3c.tidy.DOMCDATASectionImpl;
import org.w3c.tidy.DOMCommentImpl;
import org.w3c.tidy.DOMDocumentImpl;
import org.w3c.tidy.DOMDocumentTypeImpl;
import org.w3c.tidy.DOMElementImpl;
import org.w3c.tidy.DOMNodeImpl;
import org.w3c.tidy.DOMProcessingInstructionImpl;
import org.w3c.tidy.DOMTextImpl;
import org.w3c.tidy.Dict;
import org.w3c.tidy.Lexer;
import org.w3c.tidy.Report;
import org.w3c.tidy.TagTable;

public class Node {
    public static final short RootNode = 0;
    public static final short DocTypeTag = 1;
    public static final short CommentTag = 2;
    public static final short ProcInsTag = 3;
    public static final short TextNode = 4;
    public static final short StartTag = 5;
    public static final short EndTag = 6;
    public static final short StartEndTag = 7;
    public static final short CDATATag = 8;
    public static final short SectionTag = 9;
    public static final short AspTag = 10;
    public static final short JsteTag = 11;
    public static final short PhpTag = 12;
    protected Node parent = null;
    protected Node prev = null;
    protected Node next = null;
    protected Node last = null;
    protected int start;
    protected int end;
    protected byte[] textarray;
    protected short type;
    protected boolean closed;
    protected boolean implicit;
    protected boolean linebreak;
    protected Dict was;
    protected Dict tag;
    protected String element;
    protected AttVal attributes;
    protected Node content;
    private static final String[] nodeTypeString = new String[]{"RootNode", "DocTypeTag", "CommentTag", "ProcInsTag", "TextNode", "StartTag", "EndTag", "StartEndTag", "SectionTag", "AspTag", "PhpTag"};
    protected org.w3c.dom.Node adapter = null;

    public Node() {
        this(4, null, 0, 0);
    }

    public Node(short type, byte[] textarray, int start, int end) {
        this.start = start;
        this.end = end;
        this.textarray = textarray;
        this.type = type;
        this.closed = false;
        this.implicit = false;
        this.linebreak = false;
        this.was = null;
        this.tag = null;
        this.element = null;
        this.attributes = null;
        this.content = null;
    }

    public Node(short type, byte[] textarray, int start, int end, String element, TagTable tt) {
        this.start = start;
        this.end = end;
        this.textarray = textarray;
        this.type = type;
        this.closed = false;
        this.implicit = false;
        this.linebreak = false;
        this.was = null;
        this.tag = null;
        this.element = element;
        this.attributes = null;
        this.content = null;
        if (type == 5 || type == 7 || type == 6) {
            tt.findTag(this);
        }
    }

    protected Object clone() {
        Node node = new Node();
        node.parent = this.parent;
        if (this.textarray != null) {
            node.textarray = new byte[this.end - this.start];
            node.start = 0;
            node.end = this.end - this.start;
            if (node.end > 0) {
                System.arraycopy(this.textarray, this.start, node.textarray, node.start, node.end);
            }
        }
        node.type = this.type;
        node.closed = this.closed;
        node.implicit = this.implicit;
        node.linebreak = this.linebreak;
        node.was = this.was;
        node.tag = this.tag;
        if (this.element != null) {
            node.element = this.element;
        }
        if (this.attributes != null) {
            node.attributes = (AttVal)this.attributes.clone();
        }
        return node;
    }

    public AttVal getAttrByName(String name) {
        AttVal attr = this.attributes;
        while (attr != null) {
            if (name != null && attr.attribute != null && attr.attribute.equals(name)) break;
            attr = attr.next;
        }
        return attr;
    }

    public void checkAttributes(Lexer lexer) {
        AttVal attval = this.attributes;
        while (attval != null) {
            attval.checkAttribute(lexer, this);
            attval = attval.next;
        }
    }

    public void checkUniqueAttributes(Lexer lexer) {
        AttVal attval = this.attributes;
        while (attval != null) {
            if (attval.asp == null && attval.php == null) {
                attval.checkUniqueAttribute(lexer, this);
            }
            attval = attval.next;
        }
    }

    public void addAttribute(String name, String value) {
        AttVal av = new AttVal(null, null, null, null, 34, name, value);
        av.dict = AttributeTable.getDefaultAttributeTable().findAttribute(av);
        if (this.attributes == null) {
            this.attributes = av;
        } else {
            AttVal here = this.attributes;
            while (here.next != null) {
                here = here.next;
            }
            here.next = av;
        }
    }

    public void removeAttribute(AttVal attr) {
        AttVal prev = null;
        AttVal av = this.attributes;
        while (av != null) {
            AttVal next = av.next;
            if (av == attr) {
                if (prev != null) {
                    prev.next = next;
                } else {
                    this.attributes = next;
                }
            } else {
                prev = av;
            }
            av = next;
        }
    }

    public Node findDocType() {
        Node node = this.content;
        while (node != null && node.type != 1) {
            node = node.next;
        }
        return node;
    }

    public void discardDocType() {
        Node node = this.findDocType();
        if (node != null) {
            if (node.prev != null) {
                node.prev.next = node.next;
            } else {
                node.parent.content = node.next;
            }
            if (node.next != null) {
                node.next.prev = node.prev;
            }
            node.next = null;
        }
    }

    public static Node discardElement(Node element) {
        Node next = null;
        if (element != null) {
            next = element.next;
            Node.removeNode(element);
        }
        return next;
    }

    public static void insertNodeAtStart(Node element, Node node) {
        node.parent = element;
        if (element.content == null) {
            element.last = node;
        } else {
            element.content.prev = node;
        }
        node.next = element.content;
        node.prev = null;
        element.content = node;
    }

    public static void insertNodeAtEnd(Node element, Node node) {
        node.parent = element;
        node.prev = element.last;
        if (element.last != null) {
            element.last.next = node;
        } else {
            element.content = node;
        }
        element.last = node;
    }

    public static void insertNodeAsParent(Node element, Node node) {
        node.content = element;
        node.last = element;
        node.parent = element.parent;
        element.parent = node;
        if (node.parent.content == element) {
            node.parent.content = node;
        }
        if (node.parent.last == element) {
            node.parent.last = node;
        }
        node.prev = element.prev;
        element.prev = null;
        if (node.prev != null) {
            node.prev.next = node;
        }
        node.next = element.next;
        element.next = null;
        if (node.next != null) {
            node.next.prev = node;
        }
    }

    public static void insertNodeBeforeElement(Node element, Node node) {
        Node parent;
        node.parent = parent = element.parent;
        node.next = element;
        node.prev = element.prev;
        element.prev = node;
        if (node.prev != null) {
            node.prev.next = node;
        }
        if (parent.content == element) {
            parent.content = node;
        }
    }

    public static void insertNodeAfterElement(Node element, Node node) {
        Node parent;
        node.parent = parent = element.parent;
        if (parent != null && parent.last == element) {
            parent.last = node;
        } else {
            node.next = element.next;
            if (node.next != null) {
                node.next.prev = node;
            }
        }
        element.next = node;
        node.prev = element;
    }

    public static void trimEmptyElement(Lexer lexer, Node element) {
        TagTable tt = lexer.configuration.tt;
        if (lexer.canPrune(element)) {
            if (element.type != 4) {
                Report.warning(lexer, element, null, (short)18);
            }
            Node.discardElement(element);
        } else if (element.tag == tt.tagP && element.content == null) {
            Node node = lexer.inferredTag("br");
            Node.coerceNode(lexer, element, tt.tagBr);
            Node.insertNodeAfterElement(element, node);
        }
    }

    public static void trimTrailingSpace(Lexer lexer, Node element, Node last) {
        byte c;
        TagTable tt = lexer.configuration.tt;
        if (last != null && last.type == 4 && last.end > last.start && ((c = lexer.lexbuf[last.end - 1]) == 160 || c == 32)) {
            if (element.tag == tt.tagTd || element.tag == tt.tagTh) {
                if (last.end > last.start + 1) {
                    --last.end;
                }
            } else {
                --last.end;
                if ((element.tag.model & 0x10) != 0 && (element.tag.model & 0x400) == 0) {
                    lexer.insertspace = true;
                }
                if (last.start == last.end) {
                    Node.trimEmptyElement(lexer, last);
                }
            }
        }
    }

    public static void trimInitialSpace(Lexer lexer, Node element, Node text) {
        if (text.type == 4 && text.textarray[text.start] == 32 && text.start < text.end) {
            if ((element.tag.model & 0x10) != 0 && (element.tag.model & 0x400) == 0 && element.parent.content != element) {
                Node prev = element.prev;
                if (prev != null && prev.type == 4) {
                    if (prev.textarray[prev.end - 1] != 32) {
                        prev.textarray[prev.end++] = 32;
                    }
                    ++element.start;
                } else {
                    Node node = lexer.newNode();
                    if (element.start >= element.end) {
                        node.start = 0;
                        node.end = 1;
                        node.textarray = new byte[1];
                    } else {
                        node.start = element.start++;
                        node.end = element.start;
                        node.textarray = element.textarray;
                    }
                    node.textarray[node.start] = 32;
                    node.prev = prev;
                    if (prev != null) {
                        prev.next = node;
                    }
                    node.next = element;
                    element.prev = node;
                    node.parent = element.parent;
                }
            }
            ++text.start;
        }
    }

    public static void trimSpaces(Lexer lexer, Node element) {
        Node text = element.content;
        TagTable tt = lexer.configuration.tt;
        if (text != null && text.type == 4 && element.tag != tt.tagPre) {
            Node.trimInitialSpace(lexer, element, text);
        }
        if ((text = element.last) != null && text.type == 4) {
            Node.trimTrailingSpace(lexer, element, text);
        }
    }

    public boolean isDescendantOf(Dict tag) {
        Node parent = this.parent;
        while (parent != null) {
            if (parent.tag == tag) {
                return true;
            }
            parent = parent.parent;
        }
        return false;
    }

    public static void insertDocType(Lexer lexer, Node element, Node doctype) {
        TagTable tt = lexer.configuration.tt;
        Report.warning(lexer, element, doctype, (short)29);
        while (element.tag != tt.tagHtml) {
            element = element.parent;
        }
        Node.insertNodeBeforeElement(element, doctype);
    }

    public Node findBody(TagTable tt) {
        Node node = this.content;
        while (node != null && node.tag != tt.tagHtml) {
            node = node.next;
        }
        if (node == null) {
            return null;
        }
        node = node.content;
        while (node != null && node.tag != tt.tagBody) {
            node = node.next;
        }
        return node;
    }

    public boolean isElement() {
        return this.type == 5 || this.type == 7;
    }

    public static void moveBeforeTable(Node row, Node node, TagTable tt) {
        Node table = row.parent;
        while (table != null) {
            if (table.tag == tt.tagTable) {
                if (table.parent.content == table) {
                    table.parent.content = node;
                }
                node.prev = table.prev;
                node.next = table;
                table.prev = node;
                node.parent = table.parent;
                if (node.prev == null) break;
                node.prev.next = node;
                break;
            }
            table = table.parent;
        }
    }

    public static void fixEmptyRow(Lexer lexer, Node row) {
        if (row.content == null) {
            Node cell = lexer.inferredTag("td");
            Node.insertNodeAtEnd(row, cell);
            Report.warning(lexer, row, cell, (short)7);
        }
    }

    public static void coerceNode(Lexer lexer, Node node, Dict tag) {
        Node tmp = lexer.inferredTag(tag.name);
        Report.warning(lexer, node, tmp, (short)15);
        node.was = node.tag;
        node.tag = tag;
        node.type = (short)5;
        node.implicit = true;
        node.element = tag.name;
    }

    public static void removeNode(Node node) {
        if (node.prev != null) {
            node.prev.next = node.next;
        }
        if (node.next != null) {
            node.next.prev = node.prev;
        }
        if (node.parent != null) {
            if (node.parent.content == node) {
                node.parent.content = node.next;
            }
            if (node.parent.last == node) {
                node.parent.last = node.prev;
            }
        }
        node.next = null;
        node.prev = null;
        node.parent = null;
    }

    public static boolean insertMisc(Node element, Node node) {
        if (node.type == 2 || node.type == 3 || node.type == 8 || node.type == 9 || node.type == 10 || node.type == 11 || node.type == 12) {
            Node.insertNodeAtEnd(element, node);
            return true;
        }
        return false;
    }

    public static boolean isNewNode(Node node) {
        if (node != null && node.tag != null) {
            return (node.tag.model & 0x100000) != 0;
        }
        return true;
    }

    public boolean hasOneChild() {
        return this.content != null && this.content.next == null;
    }

    public Node findHTML(TagTable tt) {
        Node node = this.content;
        while (node != null && node.tag != tt.tagHtml) {
            node = node.next;
        }
        return node;
    }

    public Node findHEAD(TagTable tt) {
        Node node = this.findHTML(tt);
        if (node != null) {
            node = node.content;
            while (node != null && node.tag != tt.tagHead) {
                node = node.next;
            }
        }
        return node;
    }

    public boolean checkNodeIntegrity() {
        Node child;
        boolean found = false;
        if (this.prev != null && this.prev.next != this) {
            return false;
        }
        if (this.next != null && this.next.prev != this) {
            return false;
        }
        if (this.parent != null) {
            if (this.prev == null && this.parent.content != this) {
                return false;
            }
            if (this.next == null && this.parent.last != this) {
                return false;
            }
            child = this.parent.content;
            while (child != null) {
                if (child == this) {
                    found = true;
                    break;
                }
                child = child.next;
            }
            if (!found) {
                return false;
            }
        }
        child = this.content;
        while (child != null) {
            if (!child.checkNodeIntegrity()) {
                return false;
            }
            child = child.next;
        }
        return true;
    }

    public static void addClass(Node node, String classname) {
        AttVal classattr = node.getAttrByName("class");
        if (classattr != null) {
            classattr.value = String.valueOf(classattr.value) + " " + classname;
        } else {
            node.addAttribute("class", classname);
        }
    }

    public String toString() {
        String s = "";
        Node n = this;
        while (n != null) {
            s = String.valueOf(s) + "[Node type=";
            s = String.valueOf(s) + nodeTypeString[n.type];
            s = String.valueOf(s) + ",element=";
            s = n.element != null ? String.valueOf(s) + n.element : String.valueOf(s) + "null";
            if (n.type == 4 || n.type == 2 || n.type == 3) {
                s = String.valueOf(s) + ",text=";
                if (n.textarray != null && n.start <= n.end) {
                    s = String.valueOf(s) + "\"";
                    s = String.valueOf(s) + Lexer.getString(n.textarray, n.start, n.end - n.start);
                    s = String.valueOf(s) + "\"";
                } else {
                    s = String.valueOf(s) + "null";
                }
            }
            s = String.valueOf(s) + ",content=";
            s = n.content != null ? String.valueOf(s) + n.content.toString() : String.valueOf(s) + "null";
            s = String.valueOf(s) + "]";
            if (n.next != null) {
                s = String.valueOf(s) + ",";
            }
            n = n.next;
        }
        return s;
    }

    protected org.w3c.dom.Node getAdapter() {
        if (this.adapter == null) {
            switch (this.type) {
                case 0: {
                    this.adapter = new DOMDocumentImpl(this);
                    break;
                }
                case 5: 
                case 7: {
                    this.adapter = new DOMElementImpl(this);
                    break;
                }
                case 1: {
                    this.adapter = new DOMDocumentTypeImpl(this);
                    break;
                }
                case 2: {
                    this.adapter = new DOMCommentImpl(this);
                    break;
                }
                case 4: {
                    this.adapter = new DOMTextImpl(this);
                    break;
                }
                case 8: {
                    this.adapter = new DOMCDATASectionImpl(this);
                    break;
                }
                case 3: {
                    this.adapter = new DOMProcessingInstructionImpl(this);
                    break;
                }
                default: {
                    this.adapter = new DOMNodeImpl(this);
                }
            }
        }
        return this.adapter;
    }

    protected Node cloneNode(boolean deep) {
        Node node = (Node)this.clone();
        if (deep) {
            Node child = this.content;
            while (child != null) {
                Node newChild = child.cloneNode(deep);
                Node.insertNodeAtEnd(node, newChild);
                child = child.next;
            }
        }
        return node;
    }

    protected void setType(short newType) {
        this.type = newType;
    }
}

