/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.assertions;

import java.io.Serializable;
import java.text.MessageFormat;
import org.apache.jmeter.assertions.Assertion;
import org.apache.jmeter.assertions.AssertionResult;
import org.apache.jmeter.samplers.SampleResult;
import org.apache.jmeter.testelement.AbstractTestElement;
import org.apache.jmeter.testelement.property.JMeterProperty;
import org.apache.jmeter.testelement.property.LongProperty;
import org.apache.jmeter.util.JMeterUtils;

public class DurationAssertion
extends AbstractTestElement
implements Serializable,
Assertion {
    private static final String DURATION_KEY = "DurationAssertion.duration";

    public AssertionResult getResult(SampleResult response) {
        AssertionResult result = new AssertionResult();
        result.setFailure(false);
        if (response.getTime() > this.getAllowedDuration() && this.getAllowedDuration() > 0L) {
            result.setFailure(true);
            Object[] arguments = new Object[]{new Long(response.getTime()), new Long(this.getAllowedDuration())};
            String message = MessageFormat.format(JMeterUtils.getResString((String)"duration_assertion_failure"), arguments);
            result.setFailureMessage(message);
        }
        return result;
    }

    public long getAllowedDuration() {
        return this.getPropertyAsLong(DURATION_KEY);
    }

    public void setAllowedDuration(long duration) throws IllegalArgumentException {
        if (duration < 0L) {
            throw new IllegalArgumentException(JMeterUtils.getResString((String)"argument_must_not_be_negative"));
        }
        if (duration == Long.MAX_VALUE) {
            this.setProperty((JMeterProperty)new LongProperty(DURATION_KEY, 0L));
        } else {
            this.setProperty((JMeterProperty)new LongProperty(DURATION_KEY, duration));
        }
    }
}

