/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.assertions;

import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import org.apache.jmeter.assertions.Assertion;
import org.apache.jmeter.assertions.AssertionResult;
import org.apache.jmeter.samplers.SampleResult;
import org.apache.jmeter.testelement.AbstractTestElement;
import org.jdom.input.SAXBuilder;

public class XMLAssertion
extends AbstractTestElement
implements Serializable,
Assertion {
    private static SAXBuilder builder = null;

    public AssertionResult getResult(SampleResult response) {
        AssertionResult result = new AssertionResult();
        if (response.getResponseData() == null) {
            return this.setResultForNull(result);
        }
        result.setFailure(false);
        String resultData = new String(this.getResultBody(response.getResponseData()));
        if (builder == null) {
            try {
                builder = new SAXBuilder();
            }
            catch (Exception e) {
                AbstractTestElement.log.error("Unable to instantiate DOM Builder", (Throwable)e);
                result.setFailure(true);
                result.setFailureMessage("Unable to instantiate DOM Builder");
                return result;
            }
        }
        try {
            builder.build((Reader)new StringReader(resultData));
        }
        catch (Exception e) {
            AbstractTestElement.log.debug("Cannot parse result content", (Throwable)e);
            result.setFailure(true);
            result.setFailureMessage(e.getMessage());
        }
        return result;
    }

    protected AssertionResult setResultForNull(AssertionResult result) {
        result.setError(false);
        result.setFailure(true);
        result.setFailureMessage("Response was null");
        return result;
    }

    private byte[] getResultBody(byte[] resultData) {
        int i = 0;
        while (i < resultData.length - 1) {
            if (resultData[i] == 10 && resultData[i + 1] == 10) {
                return this.getByteArraySlice(resultData, i + 2, resultData.length - 1);
            }
            ++i;
        }
        return resultData;
    }

    private byte[] getByteArraySlice(byte[] array, int begin, int end) {
        byte[] slice = new byte[end - begin + 1];
        int count = 0;
        int i = begin;
        while (i <= end) {
            slice[count] = array[i];
            ++count;
            ++i;
        }
        return slice;
    }
}

