/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.assertions.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import org.apache.jmeter.assertions.ResponseAssertion;
import org.apache.jmeter.assertions.gui.AbstractAssertionGui;
import org.apache.jmeter.gui.util.PowerTableModel;
import org.apache.jmeter.gui.util.TextAreaCellRenderer;
import org.apache.jmeter.gui.util.TextAreaTableCellEditor;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.testelement.property.PropertyIterator;
import org.apache.jmeter.util.JMeterUtils;

public class AssertionGui
extends AbstractAssertionGui {
    private static final String COL_NAME = JMeterUtils.getResString((String)"assertion_patterns_to_test");
    private JRadioButton responseStringButton;
    private JRadioButton labelButton;
    private JRadioButton containsBox;
    private JRadioButton matchesBox;
    private JCheckBox notBox;
    private JTable stringTable;
    private JButton addPattern;
    private JButton deletePattern;
    private PowerTableModel tableModel;
    static /* synthetic */ Class class$java$lang$String;

    public AssertionGui() {
        this.init();
    }

    public String getStaticLabel() {
        return JMeterUtils.getResString((String)"assertion_title");
    }

    public TestElement createTestElement() {
        ResponseAssertion el = new ResponseAssertion();
        this.modifyTestElement((TestElement)el);
        return el;
    }

    public void modifyTestElement(TestElement el) {
        this.configureTestElement(el);
        if (el instanceof ResponseAssertion) {
            ResponseAssertion ra = (ResponseAssertion)el;
            ra.clearTestStrings();
            String[] testStrings = this.tableModel.getData().getColumn(COL_NAME);
            int i = 0;
            while (i < testStrings.length) {
                ra.addTestString(testStrings[i]);
                ++i;
            }
            if (this.labelButton.isSelected()) {
                ra.setTestField("Assertion.sample_label");
            } else {
                ra.setTestField("Assertion.response_data");
            }
            if (this.containsBox.isSelected()) {
                ra.setToContainsType();
            } else {
                ra.setToMatchType();
            }
            if (this.notBox.isSelected()) {
                ra.setToNotType();
            } else {
                ra.unsetNotType();
            }
        }
    }

    public void configure(TestElement el) {
        super.configure(el);
        ResponseAssertion model = (ResponseAssertion)el;
        if (model.isContainsType()) {
            this.containsBox.setSelected(true);
            this.matchesBox.setSelected(false);
        } else {
            this.containsBox.setSelected(false);
            this.matchesBox.setSelected(true);
        }
        if (model.isNotType()) {
            this.notBox.setSelected(true);
        } else {
            this.notBox.setSelected(false);
        }
        if ("Assertion.response_data".equals(model.getTestField())) {
            this.responseStringButton.setSelected(true);
            this.labelButton.setSelected(false);
        } else {
            this.responseStringButton.setSelected(false);
            this.labelButton.setSelected(true);
        }
        this.tableModel.clearData();
        PropertyIterator tests = model.getTestStrings().iterator();
        while (tests.hasNext()) {
            this.tableModel.addRow(new Object[]{tests.next().getStringValue()});
        }
        if (model.getTestStrings().size() == 0) {
            this.deletePattern.setEnabled(false);
        } else {
            this.deletePattern.setEnabled(true);
        }
        this.tableModel.fireTableDataChanged();
    }

    private void init() {
        this.setLayout(new BorderLayout());
        Box box = Box.createVerticalBox();
        this.setBorder(this.makeBorder());
        box.add(this.makeTitlePanel());
        box.add(this.createFieldPanel());
        box.add(this.createTypePanel());
        this.add(box, "North");
        this.add(this.createStringPanel(), "Center");
    }

    private JPanel createFieldPanel() {
        JPanel panel = new JPanel();
        panel.setBorder(BorderFactory.createTitledBorder(JMeterUtils.getResString((String)"assertion_resp_field")));
        this.responseStringButton = new JRadioButton(JMeterUtils.getResString((String)"assertion_text_resp"));
        this.labelButton = new JRadioButton(JMeterUtils.getResString((String)"assertion_url_samp"));
        ButtonGroup group = new ButtonGroup();
        group.add(this.responseStringButton);
        group.add(this.labelButton);
        panel.add(this.responseStringButton);
        panel.add(this.labelButton);
        this.responseStringButton.setSelected(true);
        return panel;
    }

    private JPanel createTypePanel() {
        JPanel panel = new JPanel();
        panel.setBorder(BorderFactory.createTitledBorder(JMeterUtils.getResString((String)"assertion_pattern_match_rules")));
        ButtonGroup group = new ButtonGroup();
        this.containsBox = new JRadioButton(JMeterUtils.getResString((String)"assertion_contains"));
        group.add(this.containsBox);
        this.containsBox.setSelected(true);
        panel.add(this.containsBox);
        this.matchesBox = new JRadioButton(JMeterUtils.getResString((String)"assertion_matches"));
        group.add(this.matchesBox);
        panel.add(this.matchesBox);
        this.notBox = new JCheckBox(JMeterUtils.getResString((String)"assertion_not"));
        panel.add(this.notBox);
        return panel;
    }

    private JPanel createStringPanel() {
        this.tableModel = new PowerTableModel(new String[]{COL_NAME}, new Class[]{class$java$lang$String == null ? (class$java$lang$String = AssertionGui.class$("java.lang.String")) : class$java$lang$String});
        this.stringTable = new JTable((TableModel)this.tableModel);
        TextAreaCellRenderer renderer = new TextAreaCellRenderer();
        this.stringTable.setRowHeight(renderer.getPreferredHeight());
        this.stringTable.setDefaultRenderer(class$java$lang$String == null ? (class$java$lang$String = AssertionGui.class$("java.lang.String")) : class$java$lang$String, (TableCellRenderer)renderer);
        this.stringTable.setDefaultEditor(class$java$lang$String == null ? (class$java$lang$String = AssertionGui.class$("java.lang.String")) : class$java$lang$String, (TableCellEditor)new TextAreaTableCellEditor());
        this.stringTable.setPreferredScrollableViewportSize(new Dimension(100, 70));
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        panel.setBorder(BorderFactory.createTitledBorder(JMeterUtils.getResString((String)"assertion_patterns_to_test")));
        panel.add((Component)new JScrollPane(this.stringTable), "Center");
        panel.add((Component)this.createButtonPanel(), "South");
        return panel;
    }

    private JPanel createButtonPanel() {
        this.addPattern = new JButton(JMeterUtils.getResString((String)"add"));
        this.addPattern.addActionListener(new AddPatternListener());
        this.deletePattern = new JButton(JMeterUtils.getResString((String)"delete"));
        this.deletePattern.addActionListener(new ClearPatternsListener());
        this.deletePattern.setEnabled(false);
        JPanel buttonPanel = new JPanel();
        buttonPanel.add(this.addPattern);
        buttonPanel.add(this.deletePattern);
        return buttonPanel;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class AddPatternListener
    implements ActionListener {
        private AddPatternListener() {
        }

        public void actionPerformed(ActionEvent e) {
            AssertionGui.this.tableModel.addNewRow();
            AssertionGui.this.deletePattern.setEnabled(true);
            AssertionGui.this.tableModel.fireTableDataChanged();
        }
    }

    private class ClearPatternsListener
    implements ActionListener {
        private ClearPatternsListener() {
        }

        public void actionPerformed(ActionEvent e) {
            int index = AssertionGui.this.stringTable.getSelectedRow();
            if (index > -1) {
                AssertionGui.this.stringTable.getCellEditor(index, AssertionGui.this.stringTable.getSelectedColumn()).cancelCellEditing();
                AssertionGui.this.tableModel.removeRow(index);
                AssertionGui.this.tableModel.fireTableDataChanged();
            }
            if (AssertionGui.this.stringTable.getModel().getRowCount() == 0) {
                AssertionGui.this.deletePattern.setEnabled(false);
            }
        }
    }
}

