/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.assertions.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.Border;
import org.apache.jmeter.assertions.DurationAssertion;
import org.apache.jmeter.assertions.gui.AbstractAssertionGui;
import org.apache.jmeter.gui.util.HorizontalPanel;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.log.Hierarchy;
import org.apache.log.Logger;

public class DurationAssertionGui
extends AbstractAssertionGui
implements FocusListener {
    private static transient Logger log = Hierarchy.getDefaultHierarchy().getLoggerFor("jmeter.elements");
    private JTextField duration;

    public DurationAssertionGui() {
        this.init();
    }

    public String getStaticLabel() {
        return JMeterUtils.getResString((String)"duration_assertion_title");
    }

    public String getDurationAttributesTitle() {
        return JMeterUtils.getResString((String)"duration_assertion_duration_test");
    }

    public TestElement createTestElement() {
        DurationAssertion el = new DurationAssertion();
        this.modifyTestElement((TestElement)el);
        return el;
    }

    public void modifyTestElement(TestElement el) {
        this.configureTestElement(el);
        String durationString = this.duration.getText();
        long assertionDuration = 0L;
        try {
            assertionDuration = Long.parseLong(durationString);
        }
        catch (NumberFormatException e) {
            assertionDuration = Long.MAX_VALUE;
        }
        ((DurationAssertion)el).setAllowedDuration(assertionDuration);
    }

    public void configure(TestElement el) {
        super.configure(el);
        DurationAssertion assertion = (DurationAssertion)el;
        this.duration.setText(String.valueOf(assertion.getAllowedDuration()));
    }

    private void init() {
        this.setLayout(new BorderLayout(0, 10));
        this.setBorder(this.makeBorder());
        this.add(this.makeTitlePanel(), "North");
        JPanel mainPanel = new JPanel(new BorderLayout());
        HorizontalPanel durationPanel = new HorizontalPanel();
        durationPanel.setBorder((Border)BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), this.getDurationAttributesTitle()));
        durationPanel.add((Component)new JLabel(JMeterUtils.getResString((String)"duration_assertion_label")));
        this.duration = new JTextField(5);
        this.duration.addFocusListener(this);
        durationPanel.add((Component)this.duration);
        mainPanel.add((Component)durationPanel, "North");
        this.add(mainPanel, "Center");
    }

    public void focusLost(FocusEvent e) {
        boolean isInvalid = false;
        String durationString = this.duration.getText();
        if (durationString != null) {
            try {
                long assertionDuration = Long.parseLong(durationString);
                if (assertionDuration < 0L) {
                    isInvalid = true;
                }
            }
            catch (NumberFormatException ex) {
                isInvalid = true;
            }
            if (isInvalid) {
                log.warn("DurationAssertionGui: Not a valid number!");
                JOptionPane.showMessageDialog(null, JMeterUtils.getResString((String)"duration_assertion_input_error"), "Error", 0);
            }
        }
    }

    public void focusGained(FocusEvent e) {
    }
}

