/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.assertions.gui;

import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import org.apache.jmeter.assertions.SizeAssertion;
import org.apache.jmeter.assertions.gui.AbstractAssertionGui;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jorphan.gui.layout.VerticalLayout;
import org.apache.log.Hierarchy;
import org.apache.log.Logger;

public class SizeAssertionGui
extends AbstractAssertionGui
implements FocusListener,
ActionListener {
    private static transient Logger log = Hierarchy.getDefaultHierarchy().getLoggerFor("jmeter.elements");
    private JTextField size;
    private JRadioButton equalButton;
    private JRadioButton notequalButton;
    private JRadioButton greaterthanButton;
    private JRadioButton lessthanButton;
    private JRadioButton greaterthanequalButton;
    private JRadioButton lessthanequalButton;
    private int execState;

    public SizeAssertionGui() {
        this.init();
    }

    public String getStaticLabel() {
        return JMeterUtils.getResString((String)"size_assertion_title");
    }

    public String getSizeAttributesTitle() {
        return JMeterUtils.getResString((String)"size_assertion_size_test");
    }

    public TestElement createTestElement() {
        SizeAssertion el = new SizeAssertion();
        this.modifyTestElement((TestElement)el);
        return el;
    }

    public void modifyTestElement(TestElement el) {
        this.configureTestElement(el);
        String sizeString = this.size.getText();
        long assertionSize = 0L;
        try {
            assertionSize = Long.parseLong(sizeString);
        }
        catch (NumberFormatException e) {
            assertionSize = Long.MAX_VALUE;
        }
        ((SizeAssertion)el).setAllowedSize(assertionSize);
        ((SizeAssertion)el).setCompOper(this.getState());
    }

    public void configure(TestElement el) {
        super.configure(el);
        SizeAssertion assertion = (SizeAssertion)el;
        this.size.setText(String.valueOf(assertion.getAllowedSize()));
        this.setState(assertion.getCompOper());
    }

    public void setState(int state) {
        if (state == 1) {
            this.equalButton.setSelected(true);
            this.execState = 1;
        } else if (state == 2) {
            this.notequalButton.setSelected(true);
            this.execState = 2;
        } else if (state == 3) {
            this.greaterthanButton.setSelected(true);
            this.execState = 3;
        } else if (state == 4) {
            this.lessthanButton.setSelected(true);
            this.execState = 4;
        } else if (state == 5) {
            this.greaterthanequalButton.setSelected(true);
            this.execState = 5;
        } else if (state == 6) {
            this.lessthanequalButton.setSelected(true);
            this.execState = 6;
        }
    }

    public int getState() {
        return this.execState;
    }

    private void init() {
        this.setLayout((LayoutManager)new VerticalLayout(5, 2, 1));
        this.setBorder(this.makeBorder());
        this.add(this.makeTitlePanel());
        JPanel sizePanel = new JPanel();
        sizePanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), this.getSizeAttributesTitle()));
        sizePanel.add(new JLabel(JMeterUtils.getResString((String)"size_assertion_label")));
        this.size = new JTextField(5);
        this.size.addFocusListener(this);
        sizePanel.add(this.size);
        sizePanel.add(this.createComparatorButtonPanel());
        this.add(sizePanel);
    }

    private Box createComparatorButtonPanel() {
        ButtonGroup group = new ButtonGroup();
        this.equalButton = this.createComparatorButton("=", 1, group);
        this.notequalButton = this.createComparatorButton("!=", 2, group);
        this.greaterthanButton = this.createComparatorButton(">", 3, group);
        this.lessthanButton = this.createComparatorButton("<", 4, group);
        this.greaterthanequalButton = this.createComparatorButton(">=", 5, group);
        this.lessthanequalButton = this.createComparatorButton("<=", 6, group);
        this.equalButton.setSelected(true);
        Box checkPanel = Box.createVerticalBox();
        JLabel compareLabel = new JLabel(JMeterUtils.getResString((String)"size_assertion_comparator_label"));
        checkPanel.add(compareLabel);
        checkPanel.add(this.equalButton);
        checkPanel.add(this.notequalButton);
        checkPanel.add(this.greaterthanButton);
        checkPanel.add(this.lessthanButton);
        checkPanel.add(this.greaterthanequalButton);
        checkPanel.add(this.lessthanequalButton);
        return checkPanel;
    }

    private JRadioButton createComparatorButton(String name, int value, ButtonGroup group) {
        JRadioButton button = new JRadioButton(name);
        button.setActionCommand(String.valueOf(value));
        button.addActionListener(this);
        group.add(button);
        return button;
    }

    public void focusLost(FocusEvent e) {
        boolean isInvalid = false;
        String sizeString = this.size.getText();
        if (sizeString != null) {
            try {
                long assertionSize = Long.parseLong(sizeString);
                if (assertionSize < 0L) {
                    isInvalid = true;
                }
            }
            catch (NumberFormatException ex) {
                isInvalid = true;
            }
            if (isInvalid) {
                log.warn("SizeAssertionGui: Not a valid number!");
                JOptionPane.showMessageDialog(null, JMeterUtils.getResString((String)"size_assertion_input_error"), "Error", 0);
            }
        }
    }

    public void focusGained(FocusEvent e) {
    }

    public void actionPerformed(ActionEvent e) {
        int comparator;
        this.execState = comparator = Integer.parseInt(e.getActionCommand());
    }
}

