/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.control;

import java.io.Serializable;
import junit.framework.Assert;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.apache.jmeter.control.Controller;
import org.apache.jmeter.control.GenericController;
import org.apache.jmeter.control.LoopController;
import org.apache.jmeter.control.NextIsNullException;
import org.apache.jmeter.junit.JMeterTestCase;
import org.apache.jmeter.junit.stubs.TestSampler;
import org.apache.jmeter.samplers.Sampler;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.testelement.property.IntegerProperty;
import org.apache.jmeter.testelement.property.JMeterProperty;

public class InterleaveControl
extends GenericController
implements Serializable {
    private static final String STYLE = "InterleaveControl.style";
    public static final int IGNORE_SUB_CONTROLLERS = 0;
    public static final int USE_SUB_CONTROLLERS = 1;
    private boolean skipNext;
    private boolean doNotIncrement = false;
    private TestElement searchStart = null;
    private boolean currentReturnedAtLeastOne;
    private boolean stillSame = true;

    public void reInitialize() {
        this.setFirst(true);
        this.currentReturnedAtLeastOne = false;
        this.searchStart = null;
        this.stillSame = true;
        this.skipNext = false;
        this.incrementIterCount();
    }

    public void setStyle(int style) {
        this.setProperty((JMeterProperty)new IntegerProperty(STYLE, style));
    }

    public int getStyle() {
        return this.getPropertyAsInt(STYLE);
    }

    public Sampler next() {
        if (this.isSkipNext()) {
            this.reInitialize();
            return null;
        }
        return super.next();
    }

    protected Sampler nextIsAController(Controller controller) throws NextIsNullException {
        Sampler sampler = controller.next();
        if (sampler == null) {
            this.currentReturnedNull(controller);
            return this.next();
        }
        this.currentReturnedAtLeastOne = true;
        if (this.getStyle() == 0) {
            this.incrementCurrent();
            this.skipNext = true;
        } else {
            this.searchStart = null;
        }
        return sampler;
    }

    protected Sampler nextIsASampler(Sampler element) throws NextIsNullException {
        this.skipNext = true;
        this.incrementCurrent();
        return element;
    }

    protected Sampler nextIsNull() {
        this.resetCurrent();
        return this.next();
    }

    protected void setCurrentElement(TestElement currentElement) throws NextIsNullException {
        if (this.searchStart == null) {
            this.searchStart = currentElement;
        } else if (this.searchStart == currentElement && !this.stillSame) {
            this.reInitialize();
            throw new NextIsNullException();
        }
    }

    protected void currentReturnedNull(Controller c) {
        if (c.isDone()) {
            this.removeCurrentElement();
        } else if (this.getStyle() == 1) {
            this.incrementCurrent();
        }
    }

    protected boolean isSkipNext() {
        return this.skipNext;
    }

    protected void setSkipNext(boolean skipNext) {
        this.skipNext = skipNext;
    }

    public static void main(String[] args) {
        TestRunner.run((junit.framework.Test)InterleaveControl.suite());
    }

    public static TestSuite suite() {
        TestSuite suite = new TestSuite();
        suite.addTest((junit.framework.Test)new Test("testProcessing"));
        suite.addTest((junit.framework.Test)new Test("testProcessing2"));
        suite.addTest((junit.framework.Test)new Test("testProcessing3"));
        suite.addTest((junit.framework.Test)new Test("testProcessing4"));
        suite.addTest((junit.framework.Test)new Test("testProcessing5"));
        return suite;
    }

    protected void incrementCurrent() {
        if (this.currentReturnedAtLeastOne) {
            this.skipNext = true;
        }
        this.stillSame = false;
        super.incrementCurrent();
    }

    public static class Test
    extends JMeterTestCase {
        public Test(String name) {
            super(name);
        }

        public void testProcessing() throws Exception {
            JMeterTestCase.testLog.debug("Testing Interleave Controller 1");
            GenericController controller = new GenericController();
            InterleaveControl sub_1 = new InterleaveControl();
            sub_1.setStyle(0);
            sub_1.addTestElement((TestElement)new TestSampler("one"));
            sub_1.addTestElement((TestElement)new TestSampler("two"));
            controller.addTestElement((TestElement)sub_1);
            controller.addTestElement((TestElement)new TestSampler("three"));
            LoopController sub_2 = new LoopController();
            sub_2.setLoops(3);
            GenericController sub_3 = new GenericController();
            sub_2.addTestElement((TestElement)new TestSampler("four"));
            sub_3.addTestElement((TestElement)new TestSampler("five"));
            sub_3.addTestElement((TestElement)new TestSampler("six"));
            sub_2.addTestElement((TestElement)sub_3);
            sub_2.addTestElement((TestElement)new TestSampler("seven"));
            controller.addTestElement((TestElement)sub_2);
            String[] interleaveOrder = new String[]{"one", "two"};
            String[] order = new String[]{"dummy", "three", "four", "five", "six", "seven", "four", "five", "six", "seven", "four", "five", "six", "seven"};
            int counter = 14;
            controller.initialize();
            int i = 0;
            while (i < 4) {
                Assert.assertEquals((int)14, (int)counter);
                counter = 0;
                Sampler sampler = null;
                while ((sampler = controller.next()) != null) {
                    if (counter == 0) {
                        Assert.assertEquals((Object)interleaveOrder[i % 2], (Object)sampler.getPropertyAsString("TestElement.name"));
                    } else {
                        Assert.assertEquals((Object)order[counter], (Object)sampler.getPropertyAsString("TestElement.name"));
                    }
                    ++counter;
                }
                ++i;
            }
        }

        public void testProcessing6() throws Exception {
            JMeterTestCase.testLog.debug("Testing Interleave Controller 6");
            GenericController controller = new GenericController();
            InterleaveControl sub_1 = new InterleaveControl();
            controller.addTestElement((TestElement)new TestSampler("one"));
            sub_1.setStyle(0);
            controller.addTestElement((TestElement)sub_1);
            LoopController sub_2 = new LoopController();
            sub_1.addTestElement((TestElement)sub_2);
            sub_2.setLoops(3);
            int counter = 1;
            controller.initialize();
            int i = 0;
            while (i < 4) {
                Assert.assertEquals((int)1, (int)counter);
                counter = 0;
                Sampler sampler = null;
                while ((sampler = controller.next()) != null) {
                    Assert.assertEquals((Object)"one", (Object)sampler.getPropertyAsString("TestElement.name"));
                    ++counter;
                }
                ++i;
            }
        }

        public void testProcessing2() throws Exception {
            JMeterTestCase.testLog.debug("Testing Interleave Controller 2");
            GenericController controller = new GenericController();
            InterleaveControl sub_1 = new InterleaveControl();
            sub_1.setStyle(0);
            sub_1.addTestElement((TestElement)new TestSampler("one"));
            sub_1.addTestElement((TestElement)new TestSampler("two"));
            controller.addTestElement((TestElement)sub_1);
            controller.addTestElement((TestElement)new TestSampler("three"));
            LoopController sub_2 = new LoopController();
            sub_2.setLoops(3);
            GenericController sub_3 = new GenericController();
            sub_2.addTestElement((TestElement)new TestSampler("four"));
            sub_3.addTestElement((TestElement)new TestSampler("five"));
            sub_3.addTestElement((TestElement)new TestSampler("six"));
            sub_2.addTestElement((TestElement)sub_3);
            sub_2.addTestElement((TestElement)new TestSampler("seven"));
            sub_1.addTestElement((TestElement)sub_2);
            String[] order = new String[]{"one", "three", "two", "three", "four", "three", "one", "three", "two", "three", "five", "three", "one", "three", "two", "three", "six", "three", "one", "three"};
            int counter = 0;
            boolean loops = true;
            controller.initialize();
            while (counter < order.length) {
                Sampler sampler = null;
                while ((sampler = controller.next()) != null) {
                    Assert.assertEquals((String)("failed on " + counter), (Object)order[counter], (Object)sampler.getPropertyAsString("TestElement.name"));
                    ++counter;
                }
            }
        }

        public void testProcessing3() throws Exception {
            JMeterTestCase.testLog.debug("Testing Interleave Controller 3");
            GenericController controller = new GenericController();
            InterleaveControl sub_1 = new InterleaveControl();
            sub_1.setStyle(1);
            sub_1.addTestElement((TestElement)new TestSampler("one"));
            sub_1.addTestElement((TestElement)new TestSampler("two"));
            controller.addTestElement((TestElement)sub_1);
            controller.addTestElement((TestElement)new TestSampler("three"));
            LoopController sub_2 = new LoopController();
            sub_2.setLoops(3);
            GenericController sub_3 = new GenericController();
            sub_2.addTestElement((TestElement)new TestSampler("four"));
            sub_3.addTestElement((TestElement)new TestSampler("five"));
            sub_3.addTestElement((TestElement)new TestSampler("six"));
            sub_2.addTestElement((TestElement)sub_3);
            sub_2.addTestElement((TestElement)new TestSampler("seven"));
            sub_1.addTestElement((TestElement)sub_2);
            String[] order = new String[]{"one", "three", "two", "three", "four", "five", "six", "seven", "four", "five", "six", "seven", "four", "five", "six", "seven", "three", "one", "three", "two", "three"};
            int counter = 0;
            boolean loops = true;
            controller.initialize();
            while (counter < order.length) {
                Sampler sampler = null;
                while ((sampler = controller.next()) != null) {
                    Assert.assertEquals((String)("failed on" + counter), (Object)order[counter], (Object)sampler.getPropertyAsString("TestElement.name"));
                    ++counter;
                }
            }
        }

        public void testProcessing4() throws Exception {
            JMeterTestCase.testLog.debug("Testing Interleave Controller 4");
            GenericController controller = new GenericController();
            InterleaveControl sub_1 = new InterleaveControl();
            sub_1.setStyle(0);
            controller.addTestElement((TestElement)sub_1);
            GenericController sub_2 = new GenericController();
            sub_2.addTestElement((TestElement)new TestSampler("one"));
            sub_2.addTestElement((TestElement)new TestSampler("two"));
            sub_1.addTestElement((TestElement)sub_2);
            GenericController sub_3 = new GenericController();
            sub_3.addTestElement((TestElement)new TestSampler("three"));
            sub_3.addTestElement((TestElement)new TestSampler("four"));
            sub_1.addTestElement((TestElement)sub_3);
            String[] order = new String[]{"one", "three", "two", "four"};
            int counter = 0;
            boolean loops = true;
            controller.initialize();
            while (counter < order.length) {
                Sampler sampler = null;
                while ((sampler = controller.next()) != null) {
                    Assert.assertEquals((String)("failed on" + counter), (Object)order[counter], (Object)sampler.getPropertyAsString("TestElement.name"));
                    ++counter;
                }
            }
        }

        public void testProcessing5() throws Exception {
            JMeterTestCase.testLog.debug("Testing Interleave Controller 5");
            GenericController controller = new GenericController();
            InterleaveControl sub_1 = new InterleaveControl();
            sub_1.setStyle(1);
            controller.addTestElement((TestElement)sub_1);
            GenericController sub_2 = new GenericController();
            sub_2.addTestElement((TestElement)new TestSampler("one"));
            sub_2.addTestElement((TestElement)new TestSampler("two"));
            sub_1.addTestElement((TestElement)sub_2);
            GenericController sub_3 = new GenericController();
            sub_3.addTestElement((TestElement)new TestSampler("three"));
            sub_3.addTestElement((TestElement)new TestSampler("four"));
            sub_1.addTestElement((TestElement)sub_3);
            String[] order = new String[]{"one", "two", "three", "four"};
            int counter = 0;
            boolean loops = true;
            controller.initialize();
            while (counter < order.length) {
                Sampler sampler = null;
                while ((sampler = controller.next()) != null) {
                    Assert.assertEquals((String)("failed on" + counter), (Object)order[counter], (Object)sampler.getPropertyAsString("TestElement.name"));
                    ++counter;
                }
            }
        }
    }
}

