/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.control;

import java.util.Enumeration;
import java.util.Vector;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import org.apache.jmeter.control.GenericController;
import org.apache.jmeter.control.ReplaceableController;
import org.apache.jmeter.gui.GuiPackage;
import org.apache.jmeter.gui.tree.JMeterTreeNode;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.testelement.property.CollectionProperty;
import org.apache.jmeter.testelement.property.JMeterProperty;
import org.apache.jmeter.testelement.property.NullProperty;
import org.apache.jorphan.collections.HashTree;

public class ModuleController
extends GenericController
implements ReplaceableController {
    private static final String NODE_PATH = "ModuleController.node_path";
    private JMeterTreeNode selectedNode = null;

    public Object clone() {
        ModuleController clone = (ModuleController)((Object)super.clone());
        if (this.selectedNode == null) {
            this.restoreSelected();
        }
        clone.selectedNode = this.selectedNode;
        return clone;
    }

    public TestElement getReplacement() {
        if (this.selectedNode != null) {
            return this.selectedNode.createTestElement();
        }
        return this;
    }

    public void setSelectedNode(JMeterTreeNode tn) {
        this.selectedNode = tn;
        this.setNodePath();
    }

    public JMeterTreeNode getSelectedNode() {
        return this.selectedNode;
    }

    private void setNodePath() {
        Vector<String> nodePath = new Vector<String>();
        if (this.selectedNode != null) {
            TreeNode[] path = this.selectedNode.getPath();
            int i = 0;
            while (i < path.length) {
                nodePath.add(((JMeterTreeNode)path[i]).getName());
                ++i;
            }
            nodePath.add(this.selectedNode.getName());
        }
        this.setProperty((JMeterProperty)new CollectionProperty(NODE_PATH, nodePath));
    }

    private Vector getNodePath() {
        JMeterProperty prop = this.getProperty(NODE_PATH);
        if (!(prop instanceof NullProperty)) {
            return (Vector)((CollectionProperty)prop).getObjectValue();
        }
        return null;
    }

    private void restoreSelected() {
        GuiPackage gp;
        Vector nodePath;
        if (this.selectedNode == null && (nodePath = this.getNodePath()) != null && nodePath.size() > 0 && (gp = GuiPackage.getInstance()) != null) {
            JMeterTreeNode root = (JMeterTreeNode)gp.getTreeModel().getRoot();
            nodePath.remove(0);
            this.traverse(root, nodePath);
        }
    }

    private void traverse(JMeterTreeNode node, Vector nodePath) {
        if (node != null && nodePath.size() > 0) {
            int i = 0;
            while (i < node.getChildCount()) {
                JMeterTreeNode cur = (JMeterTreeNode)node.getChildAt(i);
                if (cur.getName().equals(nodePath.elementAt(0).toString())) {
                    this.selectedNode = cur;
                    nodePath.remove(0);
                    this.traverse(cur, nodePath);
                }
                ++i;
            }
        }
    }

    public void replace(HashTree tree) {
        if (!this.selectedNode.isEnabled()) {
            this.selectedNode = ModuleController.cloneTreeNode(this.selectedNode);
            this.selectedNode.setEnabled(true);
        }
        this.createSubTree(tree, this.selectedNode);
    }

    private void createSubTree(HashTree tree, JMeterTreeNode node) {
        Enumeration e = node.children();
        while (e.hasMoreElements()) {
            JMeterTreeNode subNode = (JMeterTreeNode)e.nextElement();
            tree.add((Object)subNode);
            this.createSubTree(tree.getTree((Object)subNode), subNode);
        }
    }

    private static JMeterTreeNode cloneTreeNode(JMeterTreeNode node) {
        JMeterTreeNode treeNode = (JMeterTreeNode)node.clone();
        treeNode.setUserObject(((TestElement)node.getUserObject()).clone());
        ModuleController.cloneChildren(treeNode, node);
        return treeNode;
    }

    private static void cloneChildren(JMeterTreeNode to, JMeterTreeNode from) {
        Enumeration enumeration = from.children();
        while (enumeration.hasMoreElements()) {
            JMeterTreeNode child = (JMeterTreeNode)enumeration.nextElement();
            JMeterTreeNode childClone = (JMeterTreeNode)child.clone();
            childClone.setUserObject(((TestElement)child.getUserObject()).clone());
            to.add((MutableTreeNode)childClone);
            ModuleController.cloneChildren((JMeterTreeNode)to.getLastChild(), child);
        }
    }
}

