/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.control;

import java.io.Serializable;
import junit.framework.Assert;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.apache.jmeter.control.GenericController;
import org.apache.jmeter.control.LoopController;
import org.apache.jmeter.control.NextIsNullException;
import org.apache.jmeter.engine.event.LoopIterationEvent;
import org.apache.jmeter.engine.event.LoopIterationListener;
import org.apache.jmeter.junit.stubs.TestSampler;
import org.apache.jmeter.samplers.Sampler;
import org.apache.jmeter.testelement.TestElement;

public class OnceOnlyController
extends GenericController
implements Serializable,
LoopIterationListener {
    public void iterationStart(LoopIterationEvent event) {
        if (event.getIteration() == 1) {
            this.reInitialize();
        }
    }

    protected Sampler nextIsNull() throws NextIsNullException {
        return null;
    }

    public static void main(String[] args) {
        TestRunner.run((junit.framework.Test)OnceOnlyController.suite());
    }

    public static TestSuite suite() {
        TestSuite suite = new TestSuite();
        suite.addTest((junit.framework.Test)new Test("testProcessing"));
        suite.addTest((junit.framework.Test)new Test("testProcessing2"));
        return suite;
    }

    public static class Test
    extends TestCase {
        public Test(String name) {
            super(name);
        }

        public void testProcessing() throws Exception {
            GenericController controller = new GenericController();
            OnceOnlyController sub_1 = new OnceOnlyController();
            sub_1.addTestElement((TestElement)new TestSampler("one"));
            sub_1.addTestElement((TestElement)new TestSampler("two"));
            controller.addTestElement((TestElement)sub_1);
            controller.addTestElement((TestElement)new TestSampler("three"));
            LoopController sub_2 = new LoopController();
            sub_2.setLoops(3);
            GenericController sub_3 = new GenericController();
            sub_2.addTestElement((TestElement)new TestSampler("four"));
            sub_3.addTestElement((TestElement)new TestSampler("five"));
            sub_3.addTestElement((TestElement)new TestSampler("six"));
            sub_2.addTestElement((TestElement)sub_3);
            sub_2.addTestElement((TestElement)new TestSampler("seven"));
            controller.addTestElement((TestElement)sub_2);
            String[] interleaveOrder = new String[]{"one", "two"};
            String[] order = new String[]{"", "", "three", "four", "five", "six", "seven", "four", "five", "six", "seven", "four", "five", "six", "seven"};
            int counter = 15;
            controller.initialize();
            int i = 0;
            while (i < 4) {
                Assert.assertEquals((int)15, (int)counter);
                counter = 0;
                if (i > 0) {
                    counter = 2;
                }
                Sampler sampler = null;
                while ((sampler = controller.next()) != null) {
                    if (i == 0 && counter < 2) {
                        Assert.assertEquals((Object)interleaveOrder[counter], (Object)sampler.getPropertyAsString("TestElement.name"));
                    } else {
                        Assert.assertEquals((Object)order[counter], (Object)sampler.getPropertyAsString("TestElement.name"));
                    }
                    ++counter;
                }
                ++i;
            }
        }

        public void testProcessing2() throws Exception {
            GenericController controller = new GenericController();
            OnceOnlyController sub_1 = new OnceOnlyController();
            sub_1.addTestElement((TestElement)new TestSampler("one"));
            sub_1.addTestElement((TestElement)new TestSampler("two"));
            controller.addTestElement((TestElement)sub_1);
            controller.addTestElement((TestElement)new TestSampler("three"));
            LoopController sub_2 = new LoopController();
            sub_2.setLoops(3);
            OnceOnlyController sub_3 = new OnceOnlyController();
            sub_2.addTestElement((TestElement)new TestSampler("four"));
            sub_3.addTestElement((TestElement)new TestSampler("five"));
            sub_3.addTestElement((TestElement)new TestSampler("six"));
            sub_2.addTestElement((TestElement)sub_3);
            sub_2.addIterationListener((LoopIterationListener)sub_3);
            sub_2.addTestElement((TestElement)new TestSampler("seven"));
            controller.addTestElement((TestElement)sub_2);
            String[] interleaveOrder = new String[]{"one", "two"};
            String[] order = new String[]{"", "", "three", "four", "five", "six", "seven", "four", "seven", "four", "seven"};
            int counter = 11;
            controller.initialize();
            int i = 0;
            while (i < 4) {
                Assert.assertEquals((int)11, (int)counter);
                counter = 0;
                if (i > 0) {
                    counter = 2;
                }
                Sampler sampler = null;
                while ((sampler = controller.next()) != null) {
                    if (i == 0 && counter < 2) {
                        Assert.assertEquals((Object)interleaveOrder[counter], (Object)sampler.getPropertyAsString("TestElement.name"));
                    } else {
                        Assert.assertEquals((Object)order[counter], (Object)sampler.getPropertyAsString("TestElement.name"));
                    }
                    ++counter;
                }
                ++i;
            }
        }
    }
}

