/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.control;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import org.apache.jmeter.control.GenericController;
import org.apache.jmeter.engine.event.LoopIterationEvent;
import org.apache.jmeter.engine.event.LoopIterationListener;
import org.apache.jmeter.samplers.Sampler;
import org.apache.jmeter.testelement.TestListener;
import org.apache.jmeter.testelement.property.BooleanProperty;
import org.apache.jmeter.testelement.property.FloatProperty;
import org.apache.jmeter.testelement.property.IntegerProperty;
import org.apache.jmeter.testelement.property.JMeterProperty;
import org.apache.jmeter.testelement.property.StringProperty;

public class ThroughputController
extends GenericController
implements Serializable,
LoopIterationListener,
TestListener {
    public static final int BYNUMBER = 0;
    public static final int BYPERCENT = 1;
    private static final String STYLE = "ThroughputController.style";
    private static final String PERTHREAD = "ThroughputController.perThread";
    private static final String MAXTHROUGHPUT = "ThroughputController.maxThroughput";
    private static final String PERCENTTHROUGHPUT = "ThroughputController.percentThroughput";
    private IntegerWrapper globalNumExecutions = new IntegerWrapper(new Integer(0));
    private IntegerWrapper globalIteration = new IntegerWrapper(new Integer(-1));
    private transient Object numExecutionsLock = new Object();
    private transient Object iterationLock = new Object();
    private int numExecutions = 0;
    private int iteration = -1;
    private boolean returnTrue;
    private boolean cloned = false;

    public ThroughputController() {
        this.setStyle(0);
        this.setPerThread(true);
        this.setMaxThroughput(1);
        this.setPercentThroughput(100.0f);
        this.returnTrue = false;
    }

    public void reInitialize() {
        this.returnTrue = false;
        super.reInitialize();
    }

    public void setStyle(int style) {
        this.setProperty((JMeterProperty)new IntegerProperty(STYLE, style));
    }

    public int getStyle() {
        return this.getPropertyAsInt(STYLE);
    }

    public void setPerThread(boolean perThread) {
        this.setProperty((JMeterProperty)new BooleanProperty(PERTHREAD, perThread));
    }

    public boolean isPerThread() {
        return this.getPropertyAsBoolean(PERTHREAD);
    }

    public void setMaxThroughput(int maxThroughput) {
        this.setProperty((JMeterProperty)new IntegerProperty(MAXTHROUGHPUT, maxThroughput));
    }

    public void setMaxThroughput(String maxThroughput) {
        this.setProperty((JMeterProperty)new StringProperty(MAXTHROUGHPUT, maxThroughput));
    }

    public String getMaxThroughput() {
        return this.getPropertyAsString(MAXTHROUGHPUT);
    }

    protected int getMaxThroughputAsInt() {
        JMeterProperty prop = this.getProperty(MAXTHROUGHPUT);
        int retVal = 1;
        if (prop instanceof IntegerProperty) {
            retVal = ((IntegerProperty)prop).getIntValue();
        } else {
            try {
                retVal = Integer.parseInt(prop.getStringValue());
            }
            catch (NumberFormatException e) {}
        }
        return retVal;
    }

    public void setPercentThroughput(float percentThroughput) {
        this.setProperty((JMeterProperty)new FloatProperty(PERCENTTHROUGHPUT, percentThroughput));
    }

    public void setPercentThroughput(String percentThroughput) {
        this.setProperty((JMeterProperty)new StringProperty(PERCENTTHROUGHPUT, percentThroughput));
    }

    public String getPercentThroughput() {
        return this.getPropertyAsString(PERCENTTHROUGHPUT);
    }

    protected float getPercentThroughputAsFloat() {
        JMeterProperty prop = this.getProperty(PERCENTTHROUGHPUT);
        float retVal = 100.0f;
        if (prop instanceof FloatProperty) {
            retVal = ((FloatProperty)prop).getFloatValue();
        } else {
            try {
                retVal = Float.parseFloat(prop.getStringValue());
            }
            catch (NumberFormatException e) {}
        }
        return retVal;
    }

    protected void setExecutions(int executions) {
        if (!this.isPerThread()) {
            this.globalNumExecutions.setInteger(new Integer(executions));
        }
        this.numExecutions = executions;
    }

    protected int getExecutions() {
        if (!this.isPerThread()) {
            return this.globalNumExecutions.getInteger();
        }
        return this.numExecutions;
    }

    private void increaseExecutions() {
        this.setExecutions(this.getExecutions() + 1);
    }

    protected void setIteration(int iteration) {
        if (!this.isPerThread()) {
            this.globalIteration.setInteger(new Integer(iteration));
        }
        this.iteration = iteration;
    }

    protected int getIteration() {
        if (!this.isPerThread()) {
            return this.globalIteration.getInteger();
        }
        return this.iteration;
    }

    private void increaseIteration() {
        this.setIteration(this.getIteration() + 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Sampler next() {
        Sampler retVal = null;
        if (this.getSubControllers().size() > 0 && this.current < this.getSubControllers().size()) {
            if (!this.isPerThread()) {
                Object object = this.numExecutionsLock;
                synchronized (object) {
                    if (this.canExecute()) {
                        retVal = super.next();
                    }
                }
            } else if (this.canExecute()) {
                retVal = super.next();
            }
        }
        return retVal;
    }

    protected boolean canExecute() {
        if (this.returnTrue) {
            return true;
        }
        boolean retval = false;
        int executions = this.getExecutions();
        int iterations = this.getIteration();
        if (this.getStyle() == 0) {
            if (executions < this.getMaxThroughputAsInt()) {
                retval = true;
            }
        } else if (this.iteration == 0 && this.getPercentThroughputAsFloat() > 0.0f) {
            retval = true;
        } else if ((float)executions / (float)this.iteration * 100.0f <= this.getPercentThroughputAsFloat()) {
            retval = true;
        }
        if (retval) {
            this.returnTrue = true;
            this.increaseExecutions();
        }
        return retval;
    }

    public boolean isDone() {
        if (this.subControllersAndSamplers.size() == 0) {
            return true;
        }
        return this.getStyle() == 0 && this.getExecutions() >= this.getMaxThroughputAsInt();
    }

    public Object clone() {
        ThroughputController clone = (ThroughputController)super.clone();
        clone.numExecutions = this.numExecutions;
        clone.iteration = this.iteration;
        clone.globalNumExecutions = this.globalNumExecutions;
        clone.globalIteration = this.globalIteration;
        clone.numExecutionsLock = this.numExecutionsLock;
        clone.iterationLock = this.iterationLock;
        clone.returnTrue = false;
        return clone;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.numExecutionsLock = new Object();
        this.iterationLock = new Object();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void iterationStart(LoopIterationEvent iterEvent) {
        if (!this.isPerThread()) {
            Object object = this.iterationLock;
            synchronized (object) {
                this.increaseIteration();
            }
        } else {
            this.increaseIteration();
        }
        this.reInitialize();
    }

    public void testStarted() {
        this.setExecutions(0);
        this.setIteration(-1);
    }

    public void testEnded() {
    }

    public void testStarted(String host) {
    }

    public void testEnded(String host) {
    }

    public void testIterationStart(LoopIterationEvent event) {
    }

    protected class IntegerWrapper
    implements Serializable {
        Integer i;

        public IntegerWrapper() {
        }

        public IntegerWrapper(Integer i) {
            this.i = i;
        }

        public void setInteger(Integer i) {
            this.i = i;
        }

        public Integer getInteger() {
            return this.i;
        }
    }
}

