/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.control.gui;

import java.awt.FlowLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import org.apache.jmeter.control.Controller;
import org.apache.jmeter.control.ModuleController;
import org.apache.jmeter.control.gui.AbstractControllerGui;
import org.apache.jmeter.control.gui.TreeNodeWrapper;
import org.apache.jmeter.gui.GuiPackage;
import org.apache.jmeter.gui.action.ActionRouter;
import org.apache.jmeter.gui.tree.JMeterTreeNode;
import org.apache.jmeter.gui.util.MenuFactory;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.testelement.TestPlan;
import org.apache.jmeter.testelement.WorkBench;
import org.apache.jmeter.threads.ThreadGroup;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jorphan.gui.layout.VerticalLayout;

public class ModuleControllerGui
extends AbstractControllerGui {
    private JMeterTreeNode selected = null;
    private JComboBox nodes;
    private DefaultComboBoxModel nodesModel;
    public static String STATIC_LABEL = JMeterUtils.getResString((String)"module_controller_title");
    public static String CONTROLLER = "Module To Run";

    public ModuleControllerGui() {
        this.init();
    }

    public String getStaticLabel() {
        return STATIC_LABEL;
    }

    public void configure(TestElement el) {
        super.configure(el);
        this.selected = ((ModuleController)el).getSelectedNode();
        this.reinitialize();
    }

    public TestElement createTestElement() {
        ModuleController mc = new ModuleController();
        this.configureTestElement((TestElement)mc);
        if (this.selected != null) {
            mc.setSelectedNode(this.selected);
        }
        return mc;
    }

    public void modifyTestElement(TestElement element) {
        this.configureTestElement(element);
        TreeNodeWrapper tnw = (TreeNodeWrapper)this.nodesModel.getSelectedItem();
        if (tnw != null) {
            this.selected = tnw.getTreeNode();
            if (this.selected != null) {
                ((ModuleController)element).setSelectedNode(this.selected);
            }
        }
    }

    public JPopupMenu createPopupMenu() {
        JPopupMenu menu = new JPopupMenu();
        JMenu addMenu = MenuFactory.makeMenus((String[])new String[]{"menu_config_element", "menu_assertions", "menu_timer", "menu_listener"}, (String)JMeterUtils.getResString((String)"Add"), (String)"Add");
        menu.add(addMenu);
        MenuFactory.addEditMenu((JPopupMenu)menu, (boolean)true);
        MenuFactory.addFileMenu((JPopupMenu)menu);
        return menu;
    }

    private void init() {
        this.setLayout((LayoutManager)new VerticalLayout(5, 2, 1));
        this.setBorder(this.makeBorder());
        this.add(this.makeTitlePanel());
        JPanel modulesPanel = new JPanel(new FlowLayout(0));
        modulesPanel.add(new JLabel(CONTROLLER));
        this.nodesModel = new DefaultComboBoxModel();
        this.nodes = new JComboBox(this.nodesModel);
        this.reinitialize();
        try {
            Class<?> addToTree = Class.forName("org.apache.jmeter.gui.action.AddToTree");
            Class<?> remove = Class.forName("org.apache.jmeter.gui.action.Remove");
            ActionListener listener = new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    ModuleControllerGui.this.reinitialize();
                }
            };
            ActionRouter ar = ActionRouter.getInstance();
            ar.addPostActionListener(addToTree, listener);
            ar.addPostActionListener(remove, listener);
        }
        catch (ClassNotFoundException e) {
            // empty catch block
        }
        modulesPanel.add(this.nodes);
        this.add(modulesPanel);
    }

    private void reinitialize() {
        this.nodesModel.removeAllElements();
        GuiPackage gp = GuiPackage.getInstance();
        if (gp != null) {
            JMeterTreeNode root = (JMeterTreeNode)GuiPackage.getInstance().getTreeModel().getRoot();
            this.buildNodesModel(root, "", 0);
        }
        if (this.selected != null) {
            int i = 0;
            while (i < this.nodesModel.getSize()) {
                TreeNodeWrapper current = (TreeNodeWrapper)this.nodesModel.getElementAt(i);
                if (current.getTreeNode().equals(this.selected)) {
                    this.nodesModel.setSelectedItem(current);
                    break;
                }
                ++i;
            }
        }
    }

    private void buildNodesModel(JMeterTreeNode node, String parent_name, int level) {
        String seperator = " > ";
        if (node != null) {
            int i = 0;
            while (i < node.getChildCount()) {
                StringBuffer name = new StringBuffer();
                JMeterTreeNode cur = (JMeterTreeNode)node.getChildAt(i);
                TestElement te = cur.createTestElement();
                if (te instanceof ThreadGroup) {
                    name.append(parent_name);
                    name.append(cur.getName());
                    name.append(seperator);
                    this.buildNodesModel(cur, name.toString(), level);
                } else if (te instanceof Controller && !(te instanceof ModuleController)) {
                    name.append(this.spaces(level));
                    name.append(parent_name);
                    name.append(cur.getName());
                    TreeNodeWrapper tnw = new TreeNodeWrapper(cur, name.toString());
                    this.nodesModel.addElement(tnw);
                    name = new StringBuffer();
                    name.append(cur.getName());
                    name.append(seperator);
                    this.buildNodesModel(cur, name.toString(), level + 1);
                } else if (te instanceof TestPlan || te instanceof WorkBench) {
                    name.append(cur.getName());
                    name.append(seperator);
                    this.buildNodesModel(cur, name.toString(), 0);
                }
                ++i;
            }
        }
    }

    private String spaces(int level) {
        int multi = 4;
        StringBuffer spaces = new StringBuffer(level * multi);
        int i = 0;
        while (i < level * multi) {
            spaces.append(" ");
            ++i;
        }
        return spaces.toString();
    }
}

