/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.extractor;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.apache.jmeter.processor.PostProcessor;
import org.apache.jmeter.samplers.SampleResult;
import org.apache.jmeter.testelement.AbstractTestElement;
import org.apache.jmeter.testelement.property.IntegerProperty;
import org.apache.jmeter.testelement.property.JMeterProperty;
import org.apache.jmeter.threads.JMeterContext;
import org.apache.jmeter.threads.JMeterContextService;
import org.apache.jmeter.threads.JMeterVariables;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.log.Hierarchy;
import org.apache.log.Logger;
import org.apache.oro.text.PatternCacheLRU;
import org.apache.oro.text.regex.MatchResult;
import org.apache.oro.text.regex.Pattern;
import org.apache.oro.text.regex.PatternCompiler;
import org.apache.oro.text.regex.PatternMatcher;
import org.apache.oro.text.regex.PatternMatcherInput;
import org.apache.oro.text.regex.Perl5Compiler;
import org.apache.oro.text.regex.Perl5Matcher;
import org.apache.oro.text.regex.Util;

public class RegexExtractor
extends AbstractTestElement
implements PostProcessor,
Serializable {
    private static transient Logger log = Hierarchy.getDefaultHierarchy().getLoggerFor("jmeter.elements");
    public static final String REGEX = "RegexExtractor.regex";
    public static final String REFNAME = "RegexExtractor.refname";
    public static final String MATCH_NUMBER = "RegexExtractor.match_number";
    public static final String DEFAULT = "RegexExtractor.default";
    public static final String TEMPLATE = "RegexExtractor.template";
    private Object[] template = null;
    private static PatternCacheLRU patternCache = new PatternCacheLRU(1000, (PatternCompiler)new Perl5Compiler());
    private static ThreadLocal localMatcher = new ThreadLocal(){

        protected Object initialValue() {
            return new Perl5Matcher();
        }
    };

    public void process() {
        this.initTemplate();
        JMeterContext context = JMeterContextService.getContext();
        if (context.getPreviousResult() == null || context.getPreviousResult().getResponseData() == null) {
            return;
        }
        log.debug("RegexExtractor processing result");
        context.getVariables().put(this.getRefName(), this.getDefaultValue());
        Perl5Matcher matcher = (Perl5Matcher)localMatcher.get();
        PatternMatcherInput input = new PatternMatcherInput(new String(context.getPreviousResult().getResponseData()));
        log.debug("Regex = " + this.getRegex());
        Pattern pattern = patternCache.getPattern(this.getRegex(), 32768);
        ArrayList<MatchResult> matches = new ArrayList<MatchResult>();
        int x = 0;
        boolean done = false;
        do {
            if (matcher.contains(input, pattern)) {
                log.debug("RegexExtractor: Match found!");
                matches.add(matcher.getMatch());
                continue;
            }
            done = true;
        } while (++x != this.getMatchNumber() && !done);
        try {
            MatchResult match = this.getCorrectMatch(matches);
            if (match != null) {
                context.getVariables().put(this.getRefName(), this.generateResult(match));
                this.saveGroups(context.getVariables(), this.getRefName(), match);
            }
        }
        catch (RuntimeException e) {
            log.warn("Error while generating result");
        }
    }

    private void saveGroups(JMeterVariables vars, String basename, MatchResult match) {
        StringBuffer buf = new StringBuffer();
        int x = 0;
        while (x < match.groups()) {
            buf.append(basename);
            buf.append("_g");
            buf.append(x);
            vars.put(buf.toString(), match.group(x));
            buf.setLength(0);
            ++x;
        }
    }

    public Object clone() {
        RegexExtractor cloned = (RegexExtractor)super.clone();
        cloned.template = this.template;
        return cloned;
    }

    protected String generateResult(MatchResult match) {
        StringBuffer result = new StringBuffer();
        int a = 0;
        while (a < this.template.length) {
            log.debug("RegexExtractor: Template piece #" + a + " = " + this.template[a]);
            if (this.template[a] instanceof String) {
                result.append(this.template[a]);
            } else {
                result.append(match.group(((Integer)this.template[a]).intValue()));
            }
            ++a;
        }
        log.debug("Regex Extractor result = " + result.toString());
        return result.toString();
    }

    private void initTemplate() {
        if (this.template != null) {
            return;
        }
        ArrayList pieces = new ArrayList();
        LinkedList<Integer> combined = new LinkedList<Integer>();
        String rawTemplate = this.getTemplate();
        Perl5Matcher matcher = (Perl5Matcher)localMatcher.get();
        Pattern templatePattern = patternCache.getPattern("\\$(\\d+)\\$", 0);
        log.debug("Pattern = " + templatePattern);
        log.debug("template = " + rawTemplate);
        Util.split(pieces, (PatternMatcher)matcher, (Pattern)templatePattern, (String)rawTemplate);
        PatternMatcherInput input = new PatternMatcherInput(rawTemplate);
        boolean count = false;
        Iterator iter = pieces.iterator();
        boolean startsWith = this.isFirstElementGroup(rawTemplate);
        log.debug("template split into " + pieces.size() + " pieces, starts with = " + startsWith);
        while (iter.hasNext()) {
            boolean matchExists = matcher.contains(input, templatePattern);
            if (startsWith) {
                if (matchExists) {
                    combined.add(new Integer(matcher.getMatch().group(1)));
                }
                combined.add((Integer)iter.next());
                continue;
            }
            combined.add((Integer)iter.next());
            if (!matchExists) continue;
            combined.add(new Integer(matcher.getMatch().group(1)));
        }
        if (matcher.contains(input, templatePattern)) {
            log.debug("Template does end with template pattern");
            combined.add(new Integer(matcher.getMatch().group(1)));
        }
        this.template = combined.toArray();
    }

    private boolean isFirstElementGroup(String rawData) {
        try {
            Pattern pattern = patternCache.getPattern("^\\$\\d+\\$", 0);
            return ((Perl5Matcher)localMatcher.get()).contains(rawData, pattern);
        }
        catch (RuntimeException e) {
            log.error("", (Throwable)e);
            return false;
        }
    }

    protected MatchResult getCorrectMatch(List matches) {
        if (this.getMatchNumber() == matches.size() && matches.size() > 0) {
            return (MatchResult)matches.get(matches.size() - 1);
        }
        if (this.getMatchNumber() == 0 && matches.size() > 0) {
            return (MatchResult)matches.get(JMeterUtils.getRandomInt((int)matches.size()));
        }
        return null;
    }

    public void setRegex(String regex) {
        this.setProperty(REGEX, regex);
    }

    public String getRegex() {
        return this.getPropertyAsString(REGEX);
    }

    public void setRefName(String refName) {
        this.setProperty(REFNAME, refName);
    }

    public String getRefName() {
        return this.getPropertyAsString(REFNAME);
    }

    public void setMatchNumber(int matchNumber) {
        this.setProperty((JMeterProperty)new IntegerProperty(MATCH_NUMBER, matchNumber));
    }

    public int getMatchNumber() {
        return this.getPropertyAsInt(MATCH_NUMBER);
    }

    public void setDefaultValue(String defaultValue) {
        this.setProperty(DEFAULT, defaultValue);
    }

    public String getDefaultValue() {
        return this.getPropertyAsString(DEFAULT);
    }

    public void setTemplate(String template) {
        this.setProperty(TEMPLATE, template);
    }

    public String getTemplate() {
        return this.getPropertyAsString(TEMPLATE);
    }

    public static class Test
    extends TestCase {
        RegexExtractor extractor;
        SampleResult result;
        JMeterVariables vars;

        public Test(String name) {
            super(name);
        }

        public void setUp() {
            this.extractor = new RegexExtractor();
            this.extractor.setRefName("regVal");
            this.result = new SampleResult();
            String data = "<company-xmlext-query-ret><row><value field=\"RetCode\">LIS_OK</value><value field=\"RetCodeExtension\"></value><value field=\"alias\"></value><value field=\"positioncount\"></value><value field=\"invalidpincount\">0</value><value field=\"pinposition1\">1</value><value field=\"pinpositionvalue1\"></value><value field=\"pinposition2\">5</value><value field=\"pinpositionvalue2\"></value><value field=\"pinposition3\">6</value><value field=\"pinpositionvalue3\"></value></row></company-xmlext-query-ret>";
            this.result.setResponseData(data.getBytes());
            this.vars = new JMeterVariables();
            JMeterContextService.getContext().setVariables(this.vars);
            JMeterContextService.getContext().setPreviousResult(this.result);
        }

        public void testVariableExtraction() throws Exception {
            this.extractor.setRegex("<value field=\"(pinposition\\d+)\">(\\d+)</value>");
            this.extractor.setTemplate("$2$");
            this.extractor.setMatchNumber(2);
            this.extractor.process();
            Assert.assertEquals((Object)"5", (Object)this.vars.get("regVal"));
        }

        public void testVariableExtraction2() throws Exception {
            this.extractor.setRegex("<value field=\"(pinposition\\d+)\">(\\d+)</value>");
            this.extractor.setTemplate("$1$");
            this.extractor.setMatchNumber(3);
            this.extractor.process();
            Assert.assertEquals((Object)"pinposition3", (Object)this.vars.get("regVal"));
        }

        public void testVariableExtraction6() throws Exception {
            this.extractor.setRegex("<value field=\"(pinposition\\d+)\">(\\d+)</value>");
            this.extractor.setTemplate("$2$");
            this.extractor.setMatchNumber(4);
            this.extractor.setDefaultValue("default");
            this.extractor.process();
            Assert.assertEquals((Object)"default", (Object)this.vars.get("regVal"));
        }

        public void testVariableExtraction3() throws Exception {
            this.extractor.setRegex("<value field=\"(pinposition\\d+)\">(\\d+)</value>");
            this.extractor.setTemplate("_$1$");
            this.extractor.setMatchNumber(2);
            this.extractor.process();
            Assert.assertEquals((Object)"_pinposition2", (Object)this.vars.get("regVal"));
        }
    }
}

