/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.extractor.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.List;
import javax.swing.JPanel;
import org.apache.jmeter.extractor.RegexExtractor;
import org.apache.jmeter.processor.gui.AbstractPostProcessorGui;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jorphan.gui.JLabeledTextField;

public class RegexExtractorGui
extends AbstractPostProcessorGui {
    private JLabeledTextField regexField;
    private JLabeledTextField templateField;
    private JLabeledTextField defaultField;
    private JLabeledTextField matchNumberField;
    private JLabeledTextField refNameField;

    public RegexExtractorGui() {
        this.init();
    }

    public String getStaticLabel() {
        return JMeterUtils.getResString((String)"regex_extractor_title");
    }

    public void configure(TestElement el) {
        super.configure(el);
        this.regexField.setText(el.getPropertyAsString("RegexExtractor.regex"));
        this.templateField.setText(el.getPropertyAsString("RegexExtractor.template"));
        this.defaultField.setText(el.getPropertyAsString("RegexExtractor.default"));
        this.matchNumberField.setText(el.getPropertyAsString("RegexExtractor.match_number"));
        this.refNameField.setText(el.getPropertyAsString("RegexExtractor.refname"));
    }

    public TestElement createTestElement() {
        RegexExtractor extractor = new RegexExtractor();
        this.modifyTestElement((TestElement)extractor);
        return extractor;
    }

    public void modifyTestElement(TestElement extractor) {
        super.configureTestElement(extractor);
        extractor.setProperty("RegexExtractor.match_number", this.matchNumberField.getText());
        if (extractor instanceof RegexExtractor) {
            RegexExtractor regex = (RegexExtractor)extractor;
            regex.setRefName(this.refNameField.getText());
            regex.setRegex(this.regexField.getText());
            regex.setTemplate(this.templateField.getText());
            regex.setDefaultValue(this.defaultField.getText());
        }
    }

    private void init() {
        this.setLayout(new BorderLayout());
        this.setBorder(this.makeBorder());
        this.add(this.makeTitlePanel(), "North");
        this.add(this.makeParameterPanel(), "Center");
    }

    private JPanel makeParameterPanel() {
        this.regexField = new JLabeledTextField(JMeterUtils.getResString((String)"regex_field"));
        this.templateField = new JLabeledTextField(JMeterUtils.getResString((String)"template_field"));
        this.defaultField = new JLabeledTextField(JMeterUtils.getResString((String)"default_value_field"));
        this.refNameField = new JLabeledTextField(JMeterUtils.getResString((String)"ref_name_field"));
        this.matchNumberField = new JLabeledTextField(JMeterUtils.getResString((String)"match_num_field"));
        JPanel panel = new JPanel(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        this.initConstraints(gbc);
        this.addField(panel, this.refNameField, gbc);
        this.resetContraints(gbc);
        this.addField(panel, this.regexField, gbc);
        this.resetContraints(gbc);
        this.addField(panel, this.templateField, gbc);
        this.resetContraints(gbc);
        this.addField(panel, this.matchNumberField, gbc);
        this.resetContraints(gbc);
        gbc.weighty = 1.0;
        this.addField(panel, this.defaultField, gbc);
        return panel;
    }

    private void addField(JPanel panel, JLabeledTextField field, GridBagConstraints gbc) {
        List item = field.getComponentList();
        panel.add((Component)item.get(0), gbc.clone());
        ++gbc.gridx;
        gbc.weightx = 1.0;
        panel.add((Component)item.get(1), gbc.clone());
    }

    private void resetContraints(GridBagConstraints gbc) {
        gbc.gridx = 0;
        ++gbc.gridy;
        gbc.weightx = 0.0;
    }

    private void initConstraints(GridBagConstraints gbc) {
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.gridheight = 1;
        gbc.gridwidth = 1;
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
    }
}

