/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.modifiers;

import java.io.Serializable;
import org.apache.jmeter.engine.event.LoopIterationEvent;
import org.apache.jmeter.engine.event.LoopIterationListener;
import org.apache.jmeter.engine.util.NoThreadClone;
import org.apache.jmeter.testelement.AbstractTestElement;
import org.apache.jmeter.testelement.property.BooleanProperty;
import org.apache.jmeter.testelement.property.IntegerProperty;
import org.apache.jmeter.testelement.property.JMeterProperty;
import org.apache.jmeter.threads.JMeterContextService;
import org.apache.jmeter.threads.JMeterVariables;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.log.Logger;

public class CounterConfig
extends AbstractTestElement
implements Serializable,
LoopIterationListener,
NoThreadClone {
    private static Logger log = LoggingManager.getLoggerFor((String)"jmeter.elements");
    public static final String START = "CounterConfig.start";
    public static final String END = "CounterConfig.end";
    public static final String INCREMENT = "CounterConfig.incr";
    public static final String PER_USER = "CounterConfig.per_user";
    public static final String VAR_NAME = "CounterConfig.name";
    private boolean perUser = false;
    private int globalCounter = -1;
    private int currentIterationCount = -1;

    public synchronized void iterationStart(LoopIterationEvent event) {
        JMeterVariables variables = JMeterContextService.getContext().getVariables();
        int start = this.getStart();
        int end = this.getEnd();
        int increment = this.getIncrement();
        if (!this.isPerUser()) {
            if (this.globalCounter == -1 || this.globalCounter > end) {
                this.globalCounter = start;
            }
            variables.put(this.getVarName(), Integer.toString(this.globalCounter));
            this.globalCounter += increment;
        } else {
            String value = variables.get(this.getVarName());
            if (value == null) {
                variables.put(this.getVarName(), Integer.toString(start));
                value = variables.get(this.getVarName());
            } else {
                try {
                    int current = Integer.parseInt(value);
                    if ((current += increment) > end) {
                        current = start;
                    }
                    variables.put(this.getVarName(), Integer.toString(current));
                }
                catch (NumberFormatException e) {
                    log.info("Bad number in Counter config", (Throwable)e);
                }
            }
        }
    }

    public void setStart(int start) {
        this.setProperty((JMeterProperty)new IntegerProperty(START, start));
    }

    public void setStart(String start) {
        this.setProperty(START, start);
    }

    public int getStart() {
        return this.getPropertyAsInt(START);
    }

    public void setEnd(int end) {
        this.setProperty((JMeterProperty)new IntegerProperty(END, end));
    }

    public void setEnd(String end) {
        this.setProperty(END, end);
    }

    public int getEnd() {
        return this.getPropertyAsInt(END);
    }

    public void setIncrement(int inc) {
        this.setProperty((JMeterProperty)new IntegerProperty(INCREMENT, inc));
    }

    public void setIncrement(String incr) {
        this.setProperty(INCREMENT, incr);
    }

    public int getIncrement() {
        return this.getPropertyAsInt(INCREMENT);
    }

    public void setIsPerUser(boolean isPer) {
        this.setProperty((JMeterProperty)new BooleanProperty(PER_USER, isPer));
    }

    public boolean isPerUser() {
        return this.getPropertyAsBoolean(PER_USER);
    }

    public void setVarName(String name) {
        this.setProperty(VAR_NAME, name);
    }

    public String getVarName() {
        return this.getPropertyAsString(VAR_NAME);
    }
}

