/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.modifiers;

import java.io.Serializable;
import java.util.Collection;
import java.util.LinkedList;
import org.apache.jmeter.engine.event.LoopIterationEvent;
import org.apache.jmeter.engine.event.LoopIterationListener;
import org.apache.jmeter.processor.PreProcessor;
import org.apache.jmeter.testelement.AbstractTestElement;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.testelement.property.BooleanProperty;
import org.apache.jmeter.testelement.property.CollectionProperty;
import org.apache.jmeter.testelement.property.JMeterProperty;
import org.apache.jmeter.testelement.property.PropertyIterator;
import org.apache.jmeter.threads.JMeterContextService;
import org.apache.jmeter.threads.JMeterVariables;

public class UserParameters
extends AbstractTestElement
implements Serializable,
PreProcessor,
LoopIterationListener {
    public static final String NAMES = "UserParameters.names";
    public static final String THREAD_VALUES = "UserParameters.thread_values";
    public static final String PER_ITERATION = "UserParameters.per_iteration";
    private int counter = 0;
    private Integer lock = new Integer(0);

    public CollectionProperty getNames() {
        return (CollectionProperty)this.getProperty(NAMES);
    }

    public CollectionProperty getThreadLists() {
        return (CollectionProperty)this.getProperty(THREAD_VALUES);
    }

    public void setNames(Collection list) {
        this.setProperty((JMeterProperty)new CollectionProperty(NAMES, list));
    }

    public void setNames(CollectionProperty list) {
        this.setProperty((JMeterProperty)list);
    }

    public void setThreadLists(Collection threadLists) {
        this.setProperty((JMeterProperty)new CollectionProperty(THREAD_VALUES, threadLists));
    }

    public void setThreadLists(CollectionProperty threadLists) {
        this.setProperty((JMeterProperty)threadLists);
    }

    private CollectionProperty getValues() {
        CollectionProperty threadValues = (CollectionProperty)this.getProperty(THREAD_VALUES);
        if (threadValues.size() > 0) {
            return (CollectionProperty)threadValues.get(JMeterContextService.getContext().getThreadNum() % threadValues.size());
        }
        return new CollectionProperty("noname", new LinkedList());
    }

    public boolean isPerIteration() {
        return this.getPropertyAsBoolean(PER_ITERATION);
    }

    public void setPerIteration(boolean perIter) {
        this.setProperty((JMeterProperty)new BooleanProperty(PER_ITERATION, perIter));
    }

    public void process() {
        if (!this.isPerIteration()) {
            this.setValues();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setValues() {
        Integer n = this.lock;
        synchronized (n) {
            AbstractTestElement.log.debug("Running up named: " + this.getName());
            PropertyIterator namesIter = this.getNames().iterator();
            PropertyIterator valueIter = this.getValues().iterator();
            JMeterVariables jmvars = JMeterContextService.getContext().getVariables();
            while (namesIter.hasNext() && valueIter.hasNext()) {
                String name = namesIter.next().getStringValue();
                String value = valueIter.next().getStringValue();
                AbstractTestElement.log.debug("saving variable: " + name + "=" + value);
                jmvars.put(name, value);
            }
        }
    }

    public void iterationStart(LoopIterationEvent event) {
        if (this.isPerIteration()) {
            this.setValues();
        }
    }

    public Object clone() {
        UserParameters up = (UserParameters)super.clone();
        up.lock = this.lock;
        return up;
    }

    protected void mergeIn(TestElement element) {
    }
}

