/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.modifiers.gui;

import java.awt.Component;
import java.awt.LayoutManager;
import javax.swing.JCheckBox;
import org.apache.jmeter.modifiers.CounterConfig;
import org.apache.jmeter.processor.gui.AbstractPreProcessorGui;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jorphan.gui.JLabeledTextField;
import org.apache.jorphan.gui.layout.VerticalLayout;

public class CounterConfigGui
extends AbstractPreProcessorGui {
    private JLabeledTextField startField;
    private JLabeledTextField incrField;
    private JLabeledTextField endField;
    private JLabeledTextField varNameField;
    private JCheckBox perUserField;

    public CounterConfigGui() {
        this.init();
    }

    public String getStaticLabel() {
        return JMeterUtils.getResString((String)"counter_config_title");
    }

    public TestElement createTestElement() {
        CounterConfig config = new CounterConfig();
        this.modifyTestElement((TestElement)config);
        return config;
    }

    public void modifyTestElement(TestElement c) {
        if (c instanceof CounterConfig) {
            CounterConfig config = (CounterConfig)c;
            config.setStart(this.startField.getText());
            if (this.endField.getText().length() > 0) {
                config.setEnd(this.endField.getText());
            }
            config.setIncrement(this.incrField.getText());
            config.setVarName(this.varNameField.getText());
            config.setIsPerUser(this.perUserField.isSelected());
        }
        super.configureTestElement(c);
    }

    public void configure(TestElement element) {
        super.configure(element);
        CounterConfig config = (CounterConfig)element;
        this.startField.setText(config.getPropertyAsString("CounterConfig.start"));
        this.endField.setText(config.getPropertyAsString("CounterConfig.end"));
        this.incrField.setText(config.getPropertyAsString("CounterConfig.incr"));
        this.varNameField.setText(config.getVarName());
        this.perUserField.setSelected(config.isPerUser());
    }

    private void init() {
        this.setBorder(this.makeBorder());
        this.setLayout((LayoutManager)new VerticalLayout(5, 2));
        this.startField = new JLabeledTextField(JMeterUtils.getResString((String)"start"), 5);
        this.incrField = new JLabeledTextField(JMeterUtils.getResString((String)"increment"), 5);
        this.endField = new JLabeledTextField(JMeterUtils.getResString((String)"max"), 5);
        this.varNameField = new JLabeledTextField(JMeterUtils.getResString((String)"var_name"));
        this.perUserField = new JCheckBox(JMeterUtils.getResString((String)"counter_per_user"));
        this.add(this.makeTitlePanel());
        this.add((Component)this.startField);
        this.add((Component)this.incrField);
        this.add((Component)this.endField);
        this.add((Component)this.varNameField);
        this.add(this.perUserField);
    }
}

