/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.modifiers.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableModel;
import org.apache.jmeter.gui.util.PowerTableModel;
import org.apache.jmeter.gui.util.VerticalPanel;
import org.apache.jmeter.modifiers.UserParameters;
import org.apache.jmeter.processor.gui.AbstractPreProcessorGui;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.testelement.property.CollectionProperty;
import org.apache.jmeter.testelement.property.PropertyIterator;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.log.Logger;

public class UserParametersGui
extends AbstractPreProcessorGui {
    private static Logger log = LoggingManager.getLoggerFor((String)"jmeter.gui");
    private String THREAD_COLUMNS = JMeterUtils.getResString((String)"user");
    private JTable paramTable;
    private PowerTableModel tableModel;
    private int numUserColumns = 1;
    private JButton addParameterButton;
    private JButton addUserButton;
    private JButton deleteRowButton;
    private JButton deleteColumnButton;
    private JCheckBox perIterationCheck;
    static /* synthetic */ Class class$java$lang$String;

    public UserParametersGui() {
        this.init();
    }

    public String getStaticLabel() {
        return JMeterUtils.getResString((String)"user_parameters_title");
    }

    public void configure(TestElement el) {
        this.initTableModel();
        this.paramTable.setModel((TableModel)this.tableModel);
        UserParameters params = (UserParameters)el;
        CollectionProperty names = params.getNames();
        CollectionProperty threadValues = params.getThreadLists();
        this.tableModel.setColumnData(0, (List)names.getObjectValue());
        PropertyIterator iter = threadValues.iterator();
        if (iter.hasNext()) {
            this.tableModel.setColumnData(1, (List)iter.next().getObjectValue());
        }
        int count = 2;
        while (iter.hasNext()) {
            String colName = this.THREAD_COLUMNS + "_" + count;
            this.tableModel.addNewColumn(colName, class$java$lang$String == null ? UserParametersGui.class$("java.lang.String") : class$java$lang$String);
            this.tableModel.setColumnData(count, (List)iter.next().getObjectValue());
            ++count;
        }
        this.perIterationCheck.setSelected(params.isPerIteration());
        super.configure(el);
    }

    public TestElement createTestElement() {
        UserParameters params = new UserParameters();
        this.modifyTestElement((TestElement)params);
        return params;
    }

    public void modifyTestElement(TestElement params) {
        ((UserParameters)params).setNames(new CollectionProperty("UserParameters.names", (Collection)this.tableModel.getColumnData(JMeterUtils.getResString((String)"name"))));
        CollectionProperty threadLists = new CollectionProperty("UserParameters.thread_values", new ArrayList());
        log.debug("making threadlists from gui = " + threadLists);
        int x = 1;
        while (x < this.tableModel.getColumnCount()) {
            threadLists.addItem((Object)this.tableModel.getColumnData(this.THREAD_COLUMNS + "_" + x));
            log.debug("Adding column to threadlist: " + this.tableModel.getColumnData(this.THREAD_COLUMNS + "_" + x));
            log.debug("Threadlists now = " + threadLists);
            ++x;
        }
        log.debug("In the end, threadlists = " + threadLists);
        ((UserParameters)params).setThreadLists(threadLists);
        ((UserParameters)params).setPerIteration(this.perIterationCheck.isSelected());
        super.configureTestElement(params);
    }

    private void init() {
        this.setBorder(this.makeBorder());
        this.setLayout(new BorderLayout());
        VerticalPanel vertPanel = new VerticalPanel();
        vertPanel.add(this.makeTitlePanel());
        this.perIterationCheck = new JCheckBox(JMeterUtils.getResString((String)"update_per_iter"), true);
        Box perIterationPanel = Box.createHorizontalBox();
        perIterationPanel.add(this.perIterationCheck);
        perIterationPanel.add(Box.createHorizontalGlue());
        vertPanel.add(perIterationPanel);
        this.add((Component)vertPanel, "North");
        this.add(this.makeParameterPanel(), "Center");
    }

    private JPanel makeParameterPanel() {
        JLabel tableLabel = new JLabel(JMeterUtils.getResString((String)"user_parameters_table"));
        this.initTableModel();
        this.paramTable = new JTable((TableModel)this.tableModel);
        this.paramTable.setSelectionMode(0);
        JPanel paramPanel = new JPanel(new BorderLayout());
        paramPanel.add((Component)tableLabel, "North");
        JScrollPane scroll = new JScrollPane(this.paramTable);
        scroll.setPreferredSize(scroll.getMinimumSize());
        paramPanel.add((Component)scroll, "Center");
        paramPanel.add((Component)this.makeButtonPanel(), "South");
        return paramPanel;
    }

    protected void initTableModel() {
        this.tableModel = new PowerTableModel(new String[]{JMeterUtils.getResString((String)"name"), this.THREAD_COLUMNS + "_" + this.numUserColumns}, new Class[]{class$java$lang$String == null ? (class$java$lang$String = UserParametersGui.class$("java.lang.String")) : class$java$lang$String, class$java$lang$String == null ? (class$java$lang$String = UserParametersGui.class$("java.lang.String")) : class$java$lang$String});
    }

    private JPanel makeButtonPanel() {
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new GridLayout(2, 2));
        this.addParameterButton = new JButton(JMeterUtils.getResString((String)"add_parameter"));
        this.addUserButton = new JButton(JMeterUtils.getResString((String)"add_user"));
        this.deleteRowButton = new JButton(JMeterUtils.getResString((String)"delete_parameter"));
        this.deleteColumnButton = new JButton(JMeterUtils.getResString((String)"delete_user"));
        buttonPanel.add(this.addParameterButton);
        buttonPanel.add(this.deleteRowButton);
        buttonPanel.add(this.addUserButton);
        buttonPanel.add(this.deleteColumnButton);
        this.addParameterButton.addActionListener(new AddParamAction());
        this.addUserButton.addActionListener(new AddUserAction());
        this.deleteRowButton.addActionListener(new DeleteRowAction());
        this.deleteColumnButton.addActionListener(new DeleteColumnAction());
        return buttonPanel;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class DeleteColumnAction
    implements ActionListener {
        private DeleteColumnAction() {
        }

        public void actionPerformed(ActionEvent e) {
            int colSelected;
            if (UserParametersGui.this.paramTable.isEditing()) {
                TableCellEditor cellEditor = UserParametersGui.this.paramTable.getCellEditor(UserParametersGui.this.paramTable.getEditingRow(), UserParametersGui.this.paramTable.getEditingColumn());
                cellEditor.cancelCellEditing();
            }
            if ((colSelected = UserParametersGui.this.paramTable.getSelectedColumn()) == 0 || colSelected == 1) {
                JOptionPane.showMessageDialog(null, JMeterUtils.getResString((String)"column_delete_disallowed"), "Error", 0);
                return;
            }
            if (colSelected >= 0) {
                UserParametersGui.this.tableModel.removeColumn(colSelected);
                UserParametersGui.this.tableModel.fireTableDataChanged();
                if (UserParametersGui.this.tableModel.getColumnCount() == 0) {
                    UserParametersGui.this.deleteColumnButton.setEnabled(false);
                } else {
                    if (colSelected >= UserParametersGui.this.tableModel.getColumnCount()) {
                        --colSelected;
                    }
                    UserParametersGui.this.paramTable.setColumnSelectionInterval(colSelected, colSelected);
                }
            }
        }
    }

    private class DeleteRowAction
    implements ActionListener {
        private DeleteRowAction() {
        }

        public void actionPerformed(ActionEvent e) {
            int rowSelected;
            if (UserParametersGui.this.paramTable.isEditing()) {
                TableCellEditor cellEditor = UserParametersGui.this.paramTable.getCellEditor(UserParametersGui.this.paramTable.getEditingRow(), UserParametersGui.this.paramTable.getEditingColumn());
                cellEditor.cancelCellEditing();
            }
            if ((rowSelected = UserParametersGui.this.paramTable.getSelectedRow()) >= 0) {
                UserParametersGui.this.tableModel.removeRow(rowSelected);
                UserParametersGui.this.tableModel.fireTableDataChanged();
                if (UserParametersGui.this.tableModel.getRowCount() == 0) {
                    UserParametersGui.this.deleteRowButton.setEnabled(false);
                } else {
                    int rowToSelect = rowSelected;
                    if (rowSelected >= UserParametersGui.this.tableModel.getRowCount()) {
                        rowToSelect = rowSelected - 1;
                    }
                    UserParametersGui.this.paramTable.setRowSelectionInterval(rowToSelect, rowToSelect);
                }
            }
        }
    }

    private class AddUserAction
    implements ActionListener {
        private AddUserAction() {
        }

        public void actionPerformed(ActionEvent e) {
            if (UserParametersGui.this.paramTable.isEditing()) {
                TableCellEditor cellEditor = UserParametersGui.this.paramTable.getCellEditor(UserParametersGui.this.paramTable.getEditingRow(), UserParametersGui.this.paramTable.getEditingColumn());
                cellEditor.stopCellEditing();
            }
            UserParametersGui.this.tableModel.addNewColumn(UserParametersGui.this.THREAD_COLUMNS + "_" + UserParametersGui.this.tableModel.getColumnCount(), class$java$lang$String == null ? (class$java$lang$String = UserParametersGui.class$("java.lang.String")) : class$java$lang$String);
            UserParametersGui.this.tableModel.fireTableDataChanged();
            UserParametersGui.this.deleteColumnButton.setEnabled(true);
            int colToSelect = UserParametersGui.this.tableModel.getColumnCount() - 1;
            UserParametersGui.this.paramTable.setColumnSelectionInterval(colToSelect, colToSelect);
        }
    }

    private class AddParamAction
    implements ActionListener {
        private AddParamAction() {
        }

        public void actionPerformed(ActionEvent e) {
            if (UserParametersGui.this.paramTable.isEditing()) {
                TableCellEditor cellEditor = UserParametersGui.this.paramTable.getCellEditor(UserParametersGui.this.paramTable.getEditingRow(), UserParametersGui.this.paramTable.getEditingColumn());
                cellEditor.stopCellEditing();
            }
            UserParametersGui.this.tableModel.addNewRow();
            UserParametersGui.this.tableModel.fireTableDataChanged();
            UserParametersGui.this.deleteRowButton.setEnabled(true);
            int rowToSelect = UserParametersGui.this.tableModel.getRowCount() - 1;
            UserParametersGui.this.paramTable.setRowSelectionInterval(rowToSelect, rowToSelect);
        }
    }
}

