/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.reporters;

import java.io.Serializable;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.mail.Address;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.jmeter.samplers.SampleResult;
import org.apache.jmeter.testelement.AbstractTestElement;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.log.Hierarchy;
import org.apache.log.Logger;

public class MailerModel
extends AbstractTestElement
implements Serializable {
    private long failureCount = 0L;
    private long successCount = 0L;
    private boolean failureMsgSent = false;
    private boolean siteDown = false;
    private boolean successMsgSent = false;
    private static final String FROM_KEY = "MailerModel.fromAddress";
    private static final String TO_KEY = "MailerModel.addressie";
    private static final String HOST_KEY = "MailerModel.smtpHost";
    private static final String SUCCESS_SUBJECT = "MailerModel.successSubject";
    private static final String FAILURE_SUBJECT = "MailerModel.failureSubject";
    private static final String FAILURE_LIMIT_KEY = "MailerModel.failureLimit";
    private static final String SUCCESS_LIMIT_KEY = "MailerModel.successLimit";
    private static transient Logger log = Hierarchy.getDefaultHierarchy().getLoggerFor("jmeter.elements");
    ChangeListener changeListener;

    public MailerModel() {
        this.setProperty(SUCCESS_LIMIT_KEY, JMeterUtils.getPropDefault((String)"mailer.successlimit", (String)"2"));
        this.setProperty(FAILURE_LIMIT_KEY, JMeterUtils.getPropDefault((String)"mailer.failurelimit", (String)"2"));
    }

    public void addChangeListener(ChangeListener list) {
        this.changeListener = list;
    }

    public Object clone() {
        MailerModel m = (MailerModel)super.clone();
        m.changeListener = this.changeListener;
        return m;
    }

    public synchronized boolean isFailing() {
        return this.failureCount > this.getFailureLimit();
    }

    public void notifyChangeListeners() {
        if (this.changeListener != null) {
            this.changeListener.stateChanged(new ChangeEvent(this));
        }
    }

    public synchronized Vector getAddressVector() {
        String theAddressie = this.getToAddress();
        Vector<String> addressVector = new Vector<String>();
        if (theAddressie != null) {
            String addressSep = ",";
            StringTokenizer next = new StringTokenizer(theAddressie, addressSep);
            while (next.hasMoreTokens()) {
                String theToken = next.nextToken().trim();
                if (theToken.indexOf("@") <= 0) continue;
                addressVector.addElement(theToken);
            }
        } else {
            return new Vector(0);
        }
        return addressVector;
    }

    public synchronized void add(SampleResult sample) {
        Vector addressVector;
        if (!sample.isSuccessful()) {
            ++this.failureCount;
            this.successCount = 0L;
        } else {
            ++this.successCount;
        }
        if (this.isFailing() && !this.siteDown && !this.failureMsgSent && (addressVector = this.getAddressVector()).size() != 0) {
            try {
                this.sendMail(this.getFromAddress(), addressVector, this.getFailureSubject(), "URL Failed: " + sample.getSampleLabel(), this.getSmtpHost());
            }
            catch (Exception e) {
                log.error("Problem sending mail", (Throwable)e);
            }
            this.siteDown = true;
            this.failureMsgSent = true;
            this.successCount = 0L;
            this.successMsgSent = false;
        }
        if (this.siteDown && sample.getTime() != -1L & !this.successMsgSent && this.successCount > this.getSuccessLimit()) {
            addressVector = this.getAddressVector();
            try {
                this.sendMail(this.getFromAddress(), addressVector, this.getSuccessSubject(), "URL Restarted: " + sample.getSampleLabel(), this.getSmtpHost());
            }
            catch (Exception e) {
                log.error("Problem sending mail", (Throwable)e);
            }
            this.siteDown = false;
            this.successMsgSent = true;
            this.failureCount = 0L;
            this.failureMsgSent = false;
        }
        if (this.successMsgSent && this.failureMsgSent) {
            this.clear();
        }
        this.notifyChangeListeners();
    }

    public synchronized void clear() {
        this.failureCount = 0L;
        this.successCount = 0L;
        this.siteDown = false;
        this.successMsgSent = false;
        this.failureMsgSent = false;
        this.notifyChangeListeners();
    }

    public String toString() {
        return "E-Mail Notification";
    }

    public synchronized void sendMail(String from, Vector vEmails, String subject, String attText, String smtpHost) throws UnknownHostException, AddressException, MessagingException {
        String host = smtpHost;
        boolean debug = Boolean.valueOf(host);
        InetAddress remote = InetAddress.getByName(host);
        InternetAddress[] address = new InternetAddress[vEmails.size()];
        int k = 0;
        while (k < vEmails.size()) {
            address[k] = new InternetAddress(vEmails.elementAt(k).toString());
            ++k;
        }
        Properties props = new Properties();
        props.put("mail.smtp.host", host);
        Session session = Session.getDefaultInstance((Properties)props, null);
        session.setDebug(debug);
        MimeMessage msg = new MimeMessage(session);
        msg.setFrom((Address)new InternetAddress(from));
        msg.setRecipients(Message.RecipientType.TO, (Address[])address);
        msg.setSubject(subject);
        msg.setText(attText);
        Transport.send((Message)msg);
    }

    public void setToAddress(String str) {
        this.setProperty(TO_KEY, str);
    }

    public void setFromAddress(String str) {
        this.setProperty(FROM_KEY, str);
    }

    public void setSmtpHost(String str) {
        this.setProperty(HOST_KEY, str);
    }

    public void setFailureSubject(String str) {
        this.setProperty(FAILURE_SUBJECT, str);
    }

    public void setSuccessSubject(String str) {
        this.setProperty(SUCCESS_SUBJECT, str);
    }

    public void setSuccessLimit(String limit) {
        this.setProperty(SUCCESS_LIMIT_KEY, limit);
    }

    private void setSuccessCount(long count) {
        this.successCount = count;
    }

    public void setFailureLimit(String limit) {
        this.setProperty(FAILURE_LIMIT_KEY, limit);
    }

    private void setFailureCount(long count) {
        this.failureCount = count;
    }

    public String getToAddress() {
        return this.getPropertyAsString(TO_KEY);
    }

    public String getFromAddress() {
        return this.getPropertyAsString(FROM_KEY);
    }

    public String getSmtpHost() {
        return this.getPropertyAsString(HOST_KEY);
    }

    public String getFailureSubject() {
        return this.getPropertyAsString(FAILURE_SUBJECT);
    }

    public String getSuccessSubject() {
        return this.getPropertyAsString(SUCCESS_SUBJECT);
    }

    public long getSuccessLimit() {
        return this.getPropertyAsLong(SUCCESS_LIMIT_KEY);
    }

    public long getSuccessCount() {
        return this.successCount;
    }

    public long getFailureLimit() {
        return this.getPropertyAsLong(FAILURE_LIMIT_KEY);
    }

    public long getFailureCount() {
        return this.failureCount;
    }
}

