/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.timers;

import java.io.Serializable;
import java.util.LinkedList;
import java.util.List;
import org.apache.jmeter.testelement.AbstractTestElement;
import org.apache.jmeter.timers.Timer;
import org.apache.jmeter.util.JMeterUtils;

public class ConstantThroughputTimer
extends AbstractTestElement
implements Timer,
Serializable {
    public static final String THROUGHPUT = "ConstantThroughputTimer.throughput";
    private static List addableList = new LinkedList();
    private long targetTime = 0L;
    private long delay;

    public void setThroughput(String throughput) {
        this.setProperty(THROUGHPUT, throughput);
    }

    public void setRange(double range) {
    }

    public double getRange() {
        return 0.0;
    }

    public void setDelay(String delay) {
    }

    public String getDelay() {
        return "";
    }

    public long getThroughput() {
        return this.getPropertyAsLong(THROUGHPUT);
    }

    public String getThroughputString() {
        return this.getPropertyAsString(THROUGHPUT);
    }

    public synchronized long delay() {
        long currentTime = System.currentTimeMillis();
        long currentTarget = this.targetTime == 0L ? currentTime : this.targetTime;
        this.targetTime = currentTarget + 60000L / this.getThroughput();
        if (currentTime > currentTarget) {
            return 0L;
        }
        return currentTarget - currentTime;
    }

    public String toString() {
        return JMeterUtils.getResString((String)"constant_throughput_timer_memo");
    }

    public Object clone() {
        ConstantThroughputTimer result = (ConstantThroughputTimer)super.clone();
        result.targetTime = 0L;
        return result;
    }
}

