/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.timers.gui;

import java.awt.LayoutManager;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.timers.ConstantTimer;
import org.apache.jmeter.timers.gui.AbstractTimerGui;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jorphan.gui.layout.VerticalLayout;

public class ConstantTimerGui
extends AbstractTimerGui {
    private final String DEFAULT_DELAY = "300";
    private final String DELAY_FIELD = "Delay Field";
    private JTextField delayField;

    public ConstantTimerGui() {
        this.init();
    }

    public static void error(Exception e, JComponent thrower) {
        JOptionPane.showMessageDialog(thrower, e, "Error", 0);
    }

    public String getStaticLabel() {
        return JMeterUtils.getResString((String)"constant_timer_title");
    }

    public TestElement createTestElement() {
        ConstantTimer timer = new ConstantTimer();
        this.modifyTestElement((TestElement)timer);
        return timer;
    }

    public void modifyTestElement(TestElement timer) {
        this.configureTestElement(timer);
        ((ConstantTimer)timer).setDelay(this.delayField.getText());
    }

    public void configure(TestElement el) {
        super.configure(el);
        this.delayField.setText(((ConstantTimer)el).getDelay());
    }

    private void init() {
        this.setLayout((LayoutManager)new VerticalLayout(5, 2, 1));
        this.setBorder(this.makeBorder());
        this.add(this.makeTitlePanel());
        Box delayPanel = Box.createHorizontalBox();
        JLabel delayLabel = new JLabel(JMeterUtils.getResString((String)"constant_timer_delay"));
        delayPanel.add(delayLabel);
        this.delayField = new JTextField(6);
        this.delayField.setText("300");
        this.delayField.setName("Delay Field");
        delayPanel.add(this.delayField);
        this.add(delayPanel);
    }

    public void clear() {
        this.delayField.setText("300");
        super.clear();
    }
}

