/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.timers.gui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.apache.jmeter.gui.util.FocusRequester;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.timers.GaussianRandomTimer;
import org.apache.jmeter.timers.RandomTimer;
import org.apache.jmeter.timers.gui.AbstractTimerGui;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jorphan.gui.layout.VerticalLayout;

public class GaussianRandomTimerGui
extends AbstractTimerGui {
    private final String DELAY_FIELD = "Delay Field";
    private final String RANGE_FIELD = "Range Field";
    public final String DEFAULT_DELAY = "300";
    public final String DEFAULT_RANGE = "100.0";
    private JTextField delayField;
    private JTextField rangeField;

    public GaussianRandomTimerGui() {
        this.init();
    }

    public static void error(Exception e, JComponent thrower) {
        JOptionPane.showMessageDialog(thrower, e, "Error", 0);
    }

    public TestElement createTestElement() {
        GaussianRandomTimer timer = new GaussianRandomTimer();
        this.modifyTestElement((TestElement)timer);
        return timer;
    }

    public void modifyTestElement(TestElement timer) {
        this.configureTestElement(timer);
        ((RandomTimer)timer).setDelay(this.delayField.getText());
        ((RandomTimer)timer).setRange(this.rangeField.getText());
    }

    public void configure(TestElement el) {
        super.configure(el);
        this.delayField.setText(el.getPropertyAsString("ConstantTimer.delay"));
        this.rangeField.setText(el.getPropertyAsString("RandomTimer.range"));
    }

    public String getStaticLabel() {
        return JMeterUtils.getResString((String)"gaussian_timer_title");
    }

    private void init() {
        this.setLayout((LayoutManager)new VerticalLayout(5, 2));
        this.setBorder(this.makeBorder());
        this.add(this.makeTitlePanel());
        JPanel threadDelayPropsPanel = new JPanel();
        threadDelayPropsPanel.setLayout((LayoutManager)new VerticalLayout(5, 2));
        threadDelayPropsPanel.setBorder(BorderFactory.createTitledBorder(JMeterUtils.getResString((String)"thread_delay_properties")));
        Box delayDevPanel = Box.createHorizontalBox();
        delayDevPanel.add(new JLabel(JMeterUtils.getResString((String)"gaussian_timer_range")));
        delayDevPanel.add(Box.createHorizontalStrut(5));
        this.rangeField = new JTextField(6);
        this.rangeField.setText("100.0");
        this.rangeField.setName("Range Field");
        delayDevPanel.add(this.rangeField);
        threadDelayPropsPanel.add(delayDevPanel);
        Box avgDelayPanel = Box.createHorizontalBox();
        avgDelayPanel.add(new JLabel(JMeterUtils.getResString((String)"gaussian_timer_delay")));
        avgDelayPanel.add(Box.createHorizontalStrut(5));
        this.delayField = new JTextField(6);
        this.delayField.setText("300");
        this.delayField.setName("Delay Field");
        avgDelayPanel.add(this.delayField);
        threadDelayPropsPanel.add(avgDelayPanel);
        threadDelayPropsPanel.setMaximumSize(new Dimension(threadDelayPropsPanel.getMaximumSize().width, threadDelayPropsPanel.getPreferredSize().height));
        this.add(threadDelayPropsPanel);
        new FocusRequester((Component)this.rangeField);
    }

    public void clear() {
        this.rangeField.setText("100.0");
        this.delayField.setText("300");
        super.clear();
    }
}

