/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.visualizers;

import java.awt.BorderLayout;
import javax.swing.Box;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.border.EmptyBorder;
import org.apache.jmeter.assertions.AssertionResult;
import org.apache.jmeter.samplers.Clearable;
import org.apache.jmeter.samplers.SampleResult;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jmeter.visualizers.gui.AbstractVisualizer;

public class AssertionVisualizer
extends AbstractVisualizer
implements Clearable {
    private JTextArea textArea;

    public AssertionVisualizer() {
        this.init();
        this.setName(this.getStaticLabel());
    }

    public String getStaticLabel() {
        return JMeterUtils.getResString((String)"assertion_visualizer_title");
    }

    public void add(SampleResult sample) {
        if (null != sample.getSamplerData()) {
            this.textArea.append(sample.getSamplerData().toString());
        } else {
            this.textArea.append(sample.getSampleLabel());
        }
        this.textArea.append(this.getAssertionResult(sample));
        this.textArea.append("\n");
    }

    public void clear() {
        this.textArea.setText("");
    }

    private String getAssertionResult(SampleResult res) {
        if (res != null) {
            StringBuffer display = new StringBuffer();
            AssertionResult[] assertionResults = res.getAssertionResults();
            if (assertionResults != null) {
                int i = 0;
                while (i < assertionResults.length) {
                    AssertionResult item = assertionResults[i];
                    if (item.isFailure() || item.isError()) {
                        display.append("\n\t\t");
                        display.append(item.getFailureMessage());
                    }
                    ++i;
                }
            }
            return display.toString();
        }
        return "";
    }

    private void init() {
        this.setLayout(new BorderLayout());
        EmptyBorder margin = new EmptyBorder(10, 10, 5, 10);
        this.setBorder(margin);
        this.add(this.makeTitlePanel(), "North");
        JLabel textAreaLabel = new JLabel(JMeterUtils.getResString((String)"assertion_textarea_label"));
        Box mainPanel = Box.createVerticalBox();
        mainPanel.add(textAreaLabel);
        this.textArea = new JTextArea();
        this.textArea.setEditable(false);
        this.textArea.setLineWrap(false);
        JScrollPane areaScrollPane = new JScrollPane(this.textArea);
        areaScrollPane.setVerticalScrollBarPolicy(22);
        areaScrollPane.setHorizontalScrollBarPolicy(30);
        mainPanel.add(areaScrollPane);
        mainPanel.add(Box.createVerticalGlue());
        this.add(mainPanel, "Center");
    }
}

