/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.visualizers;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.util.Iterator;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.Scrollable;
import javax.swing.SwingUtilities;
import org.apache.jmeter.gui.util.JMeterColor;
import org.apache.jmeter.samplers.Clearable;
import org.apache.jmeter.visualizers.GraphListener;
import org.apache.jmeter.visualizers.GraphModel;
import org.apache.jmeter.visualizers.Sample;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.log.Logger;

public class Graph
extends JComponent
implements Scrollable,
GraphListener,
Clearable {
    private static Logger log = LoggingManager.getLoggerFor((String)"jmeter.gui");
    private boolean data = true;
    private boolean average = true;
    private boolean deviation = true;
    private boolean throughput = true;
    private boolean median = true;
    private GraphModel model;
    private static int width = 2000;

    public Graph() {
        this.setPreferredSize(new Dimension(width, 100));
    }

    public Graph(GraphModel model) {
        this();
        this.setModel(model);
    }

    private void setModel(Object model) {
        this.model = (GraphModel)model;
        this.model.addGraphListener(this);
        this.repaint();
    }

    public Dimension getPreferredScrollableViewportSize() {
        return this.getPreferredSize();
    }

    public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction) {
        return 5;
    }

    public int getScrollableBlockIncrement(Rectangle visibleRect, int orientation, int direction) {
        return (int)((double)visibleRect.width * 0.9);
    }

    public boolean getScrollableTracksViewportWidth() {
        return false;
    }

    public boolean getScrollableTracksViewportHeight() {
        return true;
    }

    public void clear() {
    }

    public void enableData(boolean value) {
        this.data = value;
    }

    public void enableAverage(boolean value) {
        this.average = value;
    }

    public void enableMedian(boolean value) {
        this.median = value;
    }

    public void enableDeviation(boolean value) {
        this.deviation = value;
    }

    public void enableThroughput(boolean value) {
        this.throughput = value;
    }

    public void updateGui() {
        this.repaint();
    }

    public void updateGui(final Sample oneSample) {
        final int xPos = this.model.getSampleCount();
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                Graphics g = Graph.this.getGraphics();
                if (g != null) {
                    Graph.this.drawSample(xPos, oneSample, g);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        Dimension d = this.getSize();
        List list = this.model.getSamples();
        synchronized (list) {
            Iterator e = this.model.getSamples().iterator();
            int i = 0;
            while (e.hasNext()) {
                Sample s = (Sample)e.next();
                this.drawSample(i, s, g);
                ++i;
            }
        }
    }

    private void drawSample(int x, Sample oneSample, Graphics g) {
        int height = this.getHeight();
        log.debug("Drawing a sample at " + x);
        if (this.data) {
            int data = (int)(oneSample.data * (long)height / this.model.getGraphMax());
            if (!oneSample.error) {
                g.setColor(Color.black);
            } else {
                g.setColor(JMeterColor.YELLOW);
            }
            g.drawLine(x % width, height - data, x % width, height - data - 1);
            log.debug("Drawing coords = " + x % width + "," + (height - data));
        }
        if (this.average) {
            int average = (int)(oneSample.average * (long)height / this.model.getGraphMax());
            g.setColor(Color.blue);
            g.drawLine(x % width, height - average, x % width, height - average - 1);
        }
        if (this.median) {
            int median = (int)(oneSample.median * (long)height / this.model.getGraphMax());
            g.setColor(JMeterColor.purple);
            g.drawLine(x % width, height - median, x % width, height - median - 1);
        }
        if (this.deviation) {
            int deviation = (int)(oneSample.deviation * (long)height / this.model.getGraphMax());
            g.setColor(Color.red);
            g.drawLine(x % width, height - deviation, x % width, height - deviation - 1);
        }
        if (this.throughput) {
            int throughput = (int)(oneSample.throughput * (float)height / (float)this.model.getThroughputMax());
            g.setColor(JMeterColor.dark_green);
            g.drawLine(x % width, height - throughput, x % width, height - throughput - 1);
        }
    }
}

