/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.visualizers;

import java.io.Serializable;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.jmeter.samplers.Clearable;
import org.apache.jmeter.samplers.SampleResult;
import org.apache.jmeter.visualizers.GraphListener;
import org.apache.jmeter.visualizers.Sample;
import org.apache.jorphan.math.StatCalculator;

public class GraphModel
implements Clearable,
Serializable {
    private String name;
    private List samples;
    private List listeners;
    private long previous = 0L;
    private boolean bigChange = false;
    private Sample current = new Sample(0L, 0L, 0L, 0.0f, 0L, false);
    private long startTime = Long.MAX_VALUE;
    private long endTime = Long.MIN_VALUE;
    private int throughputMax = 20;
    private long graphMax = 20L;
    private StatCalculator statCalc = new StatCalculator();
    static /* synthetic */ Class class$org$apache$jmeter$visualizers$GraphVisualizer;

    public GraphModel() {
        this.listeners = new LinkedList();
        this.samples = Collections.synchronizedList(new LinkedList());
    }

    public void setName(String name) {
        this.name = name;
    }

    public long getCurrentData() {
        return this.current.data;
    }

    public long getCurrentAverage() {
        return this.current.average;
    }

    public long getCurrentMedian() {
        return this.current.median;
    }

    public long getCurrentDeviation() {
        return this.current.deviation;
    }

    public float getCurrentThroughput() {
        return this.current.throughput;
    }

    public int getSampleCount() {
        return this.samples.size();
    }

    public List getSamples() {
        return this.samples;
    }

    public Class getGuiClass() {
        return class$org$apache$jmeter$visualizers$GraphVisualizer == null ? (class$org$apache$jmeter$visualizers$GraphVisualizer = GraphModel.class$("org.apache.jmeter.visualizers.GraphVisualizer")) : class$org$apache$jmeter$visualizers$GraphVisualizer;
    }

    public String getName() {
        return this.name;
    }

    public long getMaxSample() {
        return this.statCalc.getMax().longValue();
    }

    public long getGraphMax() {
        return this.graphMax;
    }

    public int getThroughputMax() {
        return this.throughputMax;
    }

    public void addGraphListener(GraphListener listener) {
        this.listeners.add(listener);
    }

    public Sample addSample(SampleResult e) {
        Sample s = this.addNewSample(e.getTime(), e.getTimeStamp(), e.isSuccessful());
        this.fireDataChanged();
        return s;
    }

    public void clear() {
        this.samples.clear();
        this.previous = 0L;
        this.graphMax = 1L;
        this.bigChange = true;
        this.current = new Sample(0L, 0L, 0L, 0.0f, 0L, false);
        this.statCalc.clear();
        this.startTime = Long.MAX_VALUE;
        this.endTime = Long.MIN_VALUE;
        this.fireDataChanged();
    }

    protected void fireDataChanged() {
        Iterator iter = this.listeners.iterator();
        if (this.bigChange) {
            while (iter.hasNext()) {
                ((GraphListener)iter.next()).updateGui();
            }
            this.bigChange = false;
        } else {
            this.quickUpdate(this.current);
        }
    }

    protected void quickUpdate(Sample s) {
        Iterator iter = this.listeners.iterator();
        while (iter.hasNext()) {
            ((GraphListener)iter.next()).updateGui(s);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Sample addNewSample(long sample, long timeStamp, boolean success) {
        long median;
        long deviation;
        float average;
        int counter = 0;
        StatCalculator statCalculator = this.statCalc;
        synchronized (statCalculator) {
            this.statCalc.addValue(sample);
            counter = this.statCalc.getCount();
            average = (float)this.statCalc.getMean();
            deviation = (long)this.statCalc.getStandardDeviation();
            median = this.statCalc.getMedian().longValue();
            long start = timeStamp - sample;
            if (this.startTime > start) {
                this.startTime = start;
            }
            if (this.endTime < timeStamp) {
                this.endTime = timeStamp;
            }
        }
        float throughput = 0.0f;
        if (this.endTime - this.startTime > 0L) {
            throughput = (float)(this.samples.size() + 1) / (float)(timeStamp - this.startTime) * 60000.0f;
        }
        if (throughput > (float)this.throughputMax) {
            this.bigChange = true;
            this.throughputMax = (int)(throughput * 1.5f);
        }
        if (average > (float)this.graphMax) {
            this.bigChange = true;
            this.graphMax = (long)average * 3L;
        }
        if (deviation > this.graphMax) {
            this.bigChange = true;
            this.graphMax = deviation * 3L;
        }
        Sample s = new Sample(sample, (long)average, deviation, throughput, median, !success);
        this.previous = sample;
        this.current = s;
        this.samples.add(s);
        return s;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

