/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.visualizers;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.jmeter.gui.util.VerticalPanel;
import org.apache.jmeter.reporters.MailerModel;
import org.apache.jmeter.reporters.MailerResultCollector;
import org.apache.jmeter.samplers.Clearable;
import org.apache.jmeter.samplers.SampleResult;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jmeter.visualizers.gui.AbstractVisualizer;
import org.apache.log.Hierarchy;
import org.apache.log.Logger;

public class MailerVisualizer
extends AbstractVisualizer
implements Clearable,
ChangeListener {
    private JButton testerButton;
    private JTextField addressField;
    private JTextField fromField;
    private JTextField smtpHostField;
    private JTextField failureSubjectField;
    private JTextField successSubjectField;
    private JTextField failureField;
    private JTextField failureLimitField;
    private JTextField successLimitField;
    private JPanel mainPanel;
    private JLabel panelTitleLabel;
    private static transient Logger log = Hierarchy.getDefaultHierarchy().getLoggerFor("jmeter.gui");

    public MailerVisualizer() {
        this.initGui();
    }

    public JPanel getControlPanel() {
        return this;
    }

    public synchronized void clear() {
        if (this.getModel() != null) {
            ((MailerResultCollector)this.getModel()).getMailerModel().clear();
        }
    }

    public void add(SampleResult res) {
    }

    public String toString() {
        return "E-Mail Notification";
    }

    private void initGui() {
        this.setLayout(new BorderLayout());
        VerticalPanel mainPanel = new VerticalPanel();
        EmptyBorder margin = new EmptyBorder(10, 10, 5, 10);
        this.setBorder(margin);
        mainPanel.add(this.makeTitlePanel());
        JPanel mailerPanel = new JPanel();
        mailerPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), this.getAttributesTitle()));
        GridBagLayout g = new GridBagLayout();
        mailerPanel.setLayout(g);
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 18;
        c.insets = new Insets(0, 0, 0, 0);
        c.gridwidth = 1;
        mailerPanel.add(new JLabel("From:"));
        this.fromField = new JTextField(25);
        this.fromField.setEditable(true);
        c.gridwidth = 0;
        g.setConstraints(this.fromField, c);
        mailerPanel.add(this.fromField);
        c.anchor = 18;
        c.insets = new Insets(0, 0, 0, 0);
        c.gridwidth = 1;
        mailerPanel.add(new JLabel("Addressie(s):"));
        this.addressField = new JTextField(25);
        this.addressField.setEditable(true);
        c.gridwidth = 0;
        g.setConstraints(this.addressField, c);
        mailerPanel.add(this.addressField);
        c.gridwidth = 1;
        mailerPanel.add(new JLabel("SMTP Host:"));
        this.smtpHostField = new JTextField(25);
        this.smtpHostField.setEditable(true);
        c.gridwidth = 0;
        g.setConstraints(this.smtpHostField, c);
        mailerPanel.add(this.smtpHostField);
        c.gridwidth = 1;
        mailerPanel.add(new JLabel("Failure Subject:"));
        this.failureSubjectField = new JTextField(25);
        this.failureSubjectField.setEditable(true);
        c.gridwidth = 0;
        g.setConstraints(this.failureSubjectField, c);
        mailerPanel.add(this.failureSubjectField);
        c.gridwidth = 1;
        mailerPanel.add(new JLabel("Success Subject:"));
        this.successSubjectField = new JTextField(25);
        this.successSubjectField.setEditable(true);
        c.gridwidth = 0;
        g.setConstraints(this.successSubjectField, c);
        mailerPanel.add(this.successSubjectField);
        c.gridwidth = 1;
        mailerPanel.add(new JLabel("Failure Limit:"));
        this.failureLimitField = new JTextField("2", 25);
        this.failureLimitField.setEditable(true);
        c.gridwidth = 0;
        g.setConstraints(this.failureLimitField, c);
        mailerPanel.add(this.failureLimitField);
        c.gridwidth = 1;
        mailerPanel.add(new JLabel("Success Limit:"));
        this.successLimitField = new JTextField("2", 25);
        this.successLimitField.setEditable(true);
        c.gridwidth = 0;
        g.setConstraints(this.successLimitField, c);
        mailerPanel.add(this.successLimitField);
        this.testerButton = new JButton("Test Mail");
        this.testerButton.setEnabled(true);
        c.gridwidth = 1;
        g.setConstraints(this.testerButton, c);
        mailerPanel.add(this.testerButton);
        c.gridwidth = 1;
        mailerPanel.add(new JLabel("Failures:"));
        this.failureField = new JTextField(6);
        this.failureField.setEditable(false);
        c.gridwidth = 0;
        g.setConstraints(this.failureField, c);
        mailerPanel.add(this.failureField);
        mainPanel.add(mailerPanel);
        this.add((Component)mainPanel, "West");
    }

    public String getStaticLabel() {
        return JMeterUtils.getResString((String)"mailer_visualizer_title");
    }

    public String getAttributesTitle() {
        return JMeterUtils.getResString((String)"mailer_attributes_panel");
    }

    public void configure(TestElement el) {
        super.configure(el);
        this.updateVisualizer(((MailerResultCollector)el).getMailerModel());
    }

    public TestElement createTestElement() {
        if (this.getModel() == null) {
            this.setModel(new MailerResultCollector());
        }
        this.modifyTestElement((TestElement)this.getModel());
        return this.getModel();
    }

    public void modifyTestElement(TestElement c) {
        super.modifyTestElement(c);
        MailerModel mailerModel = ((MailerResultCollector)c).getMailerModel();
        mailerModel.setFailureLimit(this.failureLimitField.getText());
        mailerModel.setFailureSubject(this.failureSubjectField.getText());
        mailerModel.setFromAddress(this.fromField.getText());
        mailerModel.setSmtpHost(this.smtpHostField.getText());
        mailerModel.setSuccessLimit(this.successLimitField.getText());
        mailerModel.setSuccessSubject(this.successSubjectField.getText());
        mailerModel.setToAddress(this.addressField.getText());
    }

    public void updateVisualizer(MailerModel model) {
        this.addressField.setText(model.getToAddress());
        this.fromField.setText(model.getFromAddress());
        this.smtpHostField.setText(model.getSmtpHost());
        this.successSubjectField.setText(model.getSuccessSubject());
        this.failureSubjectField.setText(model.getFailureSubject());
        this.failureLimitField.setText(String.valueOf(model.getFailureLimit()));
        this.failureField.setText(String.valueOf(model.getFailureCount()));
        this.successLimitField.setText(String.valueOf(model.getSuccessLimit()));
        this.repaint();
    }

    public void displayMessage(String message, boolean isError) {
        int type = 0;
        type = isError ? 0 : 1;
        JOptionPane.showMessageDialog(null, message, "Error", type);
    }

    public void stateChanged(ChangeEvent e) {
        if (e.getSource() instanceof MailerModel) {
            MailerModel testModel = (MailerModel)e.getSource();
            this.updateVisualizer(testModel);
        } else {
            super.stateChanged(e);
        }
    }
}

