/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.visualizers;

import java.awt.BorderLayout;
import java.awt.Dimension;
import javax.swing.BoxLayout;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.border.EmptyBorder;
import javax.swing.event.TableModelEvent;
import javax.swing.table.AbstractTableModel;
import org.apache.jmeter.samplers.Clearable;
import org.apache.jmeter.samplers.SampleResult;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jmeter.visualizers.AccumListener;
import org.apache.jmeter.visualizers.RunningSample;
import org.apache.jmeter.visualizers.StatVisualizerModel;
import org.apache.jmeter.visualizers.gui.AbstractVisualizer;

public class StatVisualizer
extends AbstractVisualizer
implements AccumListener,
Clearable {
    protected JTable myJTable;
    protected JScrollPane myScrollPane;
    private static final String VISUALIZER_NAME = JMeterUtils.getResString((String)"aggregate_report");
    private long sleepTill = 0L;
    private transient StatVisualizerModel model = new StatVisualizerModel();
    private transient StatTableModel myStatTableModel;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Long;

    public StatVisualizer() {
        this.model.addAccumListener(this);
        this.init();
    }

    public String getStaticLabel() {
        return VISUALIZER_NAME;
    }

    public void add(SampleResult res) {
        this.model.addNewSample(res);
    }

    public void clear() {
        this.myStatTableModel.clear();
        this.model.clear();
    }

    public synchronized void updateGui(RunningSample s) {
        this.myStatTableModel.rowChanged(s.getIndex());
    }

    public TestElement createTestElement() {
        TestElement t = super.createTestElement();
        this.sleepTill = 0L;
        return t;
    }

    private void init() {
        this.setLayout(new BorderLayout());
        JPanel mainPanel = new JPanel();
        EmptyBorder margin = new EmptyBorder(10, 10, 5, 10);
        mainPanel.setBorder(margin);
        mainPanel.setLayout(new BoxLayout(mainPanel, 1));
        mainPanel.add(this.makeTitlePanel());
        this.myStatTableModel = new StatTableModel(this.model);
        this.myJTable = new JTable(this.myStatTableModel);
        this.myJTable.setPreferredScrollableViewportSize(new Dimension(500, 70));
        this.myScrollPane = new JScrollPane(this.myJTable);
        this.add(mainPanel, "North");
        this.add(this.myScrollPane, "Center");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    class StatTableModel
    extends AbstractTableModel {
        private final String[] columnNames = new String[]{"URL", "Count", "Average", "Min", "Max", "Error%", "Rate"};
        private final Class[] columnClasses = new Class[]{class$java$lang$String == null ? (class$java$lang$String = StatVisualizer.class$("java.lang.String")) : class$java$lang$String, class$java$lang$Long == null ? (class$java$lang$Long = StatVisualizer.class$("java.lang.Long")) : class$java$lang$Long, class$java$lang$Long == null ? (class$java$lang$Long = StatVisualizer.class$("java.lang.Long")) : class$java$lang$Long, class$java$lang$Long == null ? (class$java$lang$Long = StatVisualizer.class$("java.lang.Long")) : class$java$lang$Long, class$java$lang$Long == null ? (class$java$lang$Long = StatVisualizer.class$("java.lang.Long")) : class$java$lang$Long, class$java$lang$String == null ? (class$java$lang$String = StatVisualizer.class$("java.lang.String")) : class$java$lang$String, class$java$lang$String == null ? (class$java$lang$String = StatVisualizer.class$("java.lang.String")) : class$java$lang$String};
        private final String TOTAL_LABEL = JMeterUtils.getResString((String)"aggregate_report_total_label");
        private transient StatVisualizerModel model;
        private int currentRowCount = 0;

        public StatTableModel(StatVisualizerModel model) {
            this.model = model;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void rowChanged(int index) {
            TableModelEvent event;
            StatTableModel statTableModel = this;
            synchronized (statTableModel) {
                if (index >= this.currentRowCount - 1) {
                    event = new TableModelEvent(this, this.currentRowCount - 1, index, -1, 1);
                    this.currentRowCount = index + 2;
                } else {
                    event = new TableModelEvent(this, index);
                }
            }
            this.fireTableChanged(event);
            this.fireTableChanged(new TableModelEvent(this, this.currentRowCount));
        }

        public int getColumnCount() {
            return this.columnNames.length;
        }

        public int getRowCount() {
            this.currentRowCount = this.model.getRunningSampleCount() + 1;
            return this.currentRowCount;
        }

        public String getColumnName(int col) {
            return this.columnNames[col];
        }

        public Object getValueAt(int row, int col) {
            RunningSample s;
            if (row == this.model.getRunningSampleCount()) {
                if (col == 0) {
                    return this.TOTAL_LABEL;
                }
                s = this.model.getRunningSampleTotal();
            } else {
                s = this.model.getRunningSample(row);
            }
            switch (col) {
                case 0: {
                    return s.getLabel();
                }
                case 1: {
                    return new Long(s.getNumSamples());
                }
                case 2: {
                    return new Long(s.getAverage());
                }
                case 3: {
                    return new Long(s.getMin());
                }
                case 4: {
                    return new Long(s.getMax());
                }
                case 5: {
                    return s.getErrorPercentageString();
                }
                case 6: {
                    return s.getRateString();
                }
            }
            return "__ERROR__";
        }

        public Class getColumnClass(int c) {
            return this.columnClasses[c];
        }

        public void clear() {
            this.fireTableDataChanged();
        }
    }
}

