/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.visualizers;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.LayoutManager;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.swing.event.TableModelEvent;
import org.apache.jmeter.samplers.Clearable;
import org.apache.jmeter.samplers.SampleResult;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jmeter.visualizers.GraphListener;
import org.apache.jmeter.visualizers.Sample;
import org.apache.jmeter.visualizers.TableDataModel;
import org.apache.jmeter.visualizers.gui.AbstractVisualizer;
import org.apache.jorphan.gui.layout.VerticalLayout;

public class TableVisualizer
extends AbstractVisualizer
implements GraphListener,
Clearable {
    private TableDataModel model = new TableDataModel();
    private JTable table = null;
    private JTextField dataField = null;
    private JTextField averageField = null;
    private JTextField deviationField = null;
    private JTextField noSamplesField = null;
    private JScrollPane tableScrollPanel = null;

    public TableVisualizer() {
        this.model.addGraphListener(this);
        this.init();
    }

    public String getStaticLabel() {
        return JMeterUtils.getResString((String)"view_results_in_table");
    }

    public void updateGui() {
        this.table.tableChanged(new TableModelEvent(this.model));
        this.tableScrollPanel.revalidate();
        this.tableScrollPanel.repaint();
        this.updateTextFields();
    }

    protected synchronized void updateTextFields() {
        this.noSamplesField.setText(Long.toString(this.model.getSampleCount()));
        this.dataField.setText(Long.toString(this.model.getCurrentData()));
        this.averageField.setText(Long.toString(this.model.getCurrentAverage()));
        this.deviationField.setText(Long.toString(this.model.getCurrentDeviation()));
    }

    public void add(SampleResult res) {
        this.model.addSample(res);
    }

    public void updateGui(Sample s) {
        this.table.tableChanged(new TableModelEvent(this.model));
        this.tableScrollPanel.revalidate();
        this.tableScrollPanel.repaint();
        this.updateTextFields();
    }

    public synchronized void clear() {
        AbstractVisualizer.log.warn("Clear called", (Throwable)new Exception());
        this.model.clear();
        this.dataField.setText("0000");
        this.averageField.setText("0000");
        this.deviationField.setText("0000");
        this.repaint();
    }

    public String toString() {
        return "Show the samples in a table";
    }

    private void init() {
        this.setLayout(new BorderLayout());
        JPanel mainPanel = new JPanel();
        EmptyBorder margin = new EmptyBorder(10, 10, 5, 10);
        mainPanel.setBorder(margin);
        mainPanel.setLayout((LayoutManager)new VerticalLayout(5, 2));
        mainPanel.add(this.makeTitlePanel());
        this.table = new JTable(this.model);
        this.tableScrollPanel = new JScrollPane(this.table);
        this.tableScrollPanel.setViewportBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        JPanel dataPanel = new JPanel();
        JLabel dataLabel = new JLabel(JMeterUtils.getResString((String)"graph_results_latest_sample"));
        dataLabel.setForeground(Color.black);
        this.dataField = new JTextField(5);
        this.dataField.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.dataField.setEditable(false);
        this.dataField.setForeground(Color.black);
        this.dataField.setBackground(this.getBackground());
        dataPanel.add(dataLabel);
        dataPanel.add(this.dataField);
        JPanel averagePanel = new JPanel();
        JLabel averageLabel = new JLabel(JMeterUtils.getResString((String)"graph_results_average"));
        averageLabel.setForeground(Color.blue);
        this.averageField = new JTextField(5);
        this.averageField.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.averageField.setEditable(false);
        this.averageField.setForeground(Color.blue);
        this.averageField.setBackground(this.getBackground());
        averagePanel.add(averageLabel);
        averagePanel.add(this.averageField);
        JPanel deviationPanel = new JPanel();
        JLabel deviationLabel = new JLabel(JMeterUtils.getResString((String)"graph_results_deviation"));
        deviationLabel.setForeground(Color.red);
        this.deviationField = new JTextField(5);
        this.deviationField.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.deviationField.setEditable(false);
        this.deviationField.setForeground(Color.red);
        this.deviationField.setBackground(this.getBackground());
        deviationPanel.add(deviationLabel);
        deviationPanel.add(this.deviationField);
        JPanel noSamplesPanel = new JPanel();
        JLabel noSamplesLabel = new JLabel(JMeterUtils.getResString((String)"graph_results_no_samples"));
        this.noSamplesField = new JTextField(10);
        this.noSamplesField.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.noSamplesField.setEditable(false);
        this.noSamplesField.setForeground(Color.black);
        this.noSamplesField.setBackground(this.getBackground());
        noSamplesPanel.add(noSamplesLabel);
        noSamplesPanel.add(this.noSamplesField);
        JPanel tableInfoPanel = new JPanel();
        tableInfoPanel.setLayout(new FlowLayout());
        tableInfoPanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        tableInfoPanel.add(noSamplesPanel);
        tableInfoPanel.add(dataPanel);
        tableInfoPanel.add(averagePanel);
        tableInfoPanel.add(deviationPanel);
        JPanel tablePanel = new JPanel();
        tablePanel.setLayout(new BorderLayout());
        tablePanel.add((Component)this.tableScrollPanel, "Center");
        tablePanel.add((Component)tableInfoPanel, "South");
        this.add(mainPanel, "North");
        this.add(tablePanel, "Center");
    }
}

