/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.visualizers;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.UnsupportedEncodingException;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.JTextPane;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import org.apache.jmeter.samplers.Clearable;
import org.apache.jmeter.samplers.SampleResult;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jmeter.visualizers.gui.AbstractVisualizer;
import org.apache.log.Hierarchy;
import org.apache.log.Logger;

public class ViewResultsFullVisualizer
extends AbstractVisualizer
implements ActionListener,
TreeSelectionListener,
Clearable {
    private static transient Logger log = Hierarchy.getDefaultHierarchy().getLoggerFor("jmeter.gui");
    public static final Color SERVER_ERROR_COLOR = Color.red;
    public static final Color CLIENT_ERROR_COLOR = Color.blue;
    public static final Color REDIRECT_COLOR = Color.green;
    private static final String HTML_BUTTON_LABEL = "Render HTML";
    private static final String TEXT_BUTTON_LABEL = "Show Text";
    private static final String HTML_COMMAND = "html";
    private static final String TEXT_COMMAND = "text";
    private boolean textMode = true;
    private DefaultMutableTreeNode root;
    private DefaultTreeModel treeModel;
    private JTextPane stats;
    private JEditorPane results;
    private JScrollPane resultsScrollPane;
    private JLabel imageLabel;
    private JTextArea sampleDataField;
    private JRadioButton textButton;
    private JRadioButton htmlButton;
    private JTree jTree;

    public ViewResultsFullVisualizer() {
        log.debug("Start : ViewResultsFullVisualizer1");
        this.init();
        log.debug("End : ViewResultsFullVisualizer1");
    }

    public void add(SampleResult res) {
        this.updateGui(res);
    }

    public String getStaticLabel() {
        return JMeterUtils.getResString((String)"view_results_tree_title");
    }

    public void updateGui(SampleResult res) {
        log.debug("Start : updateGui1");
        if (log.isDebugEnabled()) {
            log.debug("updateGui1 : sample result - " + res);
        }
        DefaultMutableTreeNode currNode = new DefaultMutableTreeNode(res);
        this.treeModel.insertNodeInto(currNode, this.root, this.root.getChildCount());
        this.addSubResults(currNode, res);
        log.debug("End : updateGui1");
    }

    private void addSubResults(DefaultMutableTreeNode currNode, SampleResult res) {
        SampleResult[] subResults = res.getSubResults();
        if (subResults != null) {
            int leafIndex = 0;
            int i = 0;
            while (i < subResults.length) {
                SampleResult child = subResults[i];
                if (log.isDebugEnabled()) {
                    log.debug("updateGui1 : child sample result - " + child);
                }
                DefaultMutableTreeNode leafNode = new DefaultMutableTreeNode(child);
                this.treeModel.insertNodeInto(leafNode, currNode, leafIndex++);
                this.addSubResults(leafNode, child);
                ++i;
            }
        }
    }

    public void clear() {
        log.debug("Start : clear1");
        int totalChild = this.root.getChildCount();
        if (log.isDebugEnabled()) {
            log.debug("clear1 : total child - " + totalChild);
        }
        int i = 0;
        while (i < totalChild) {
            this.treeModel.removeNodeFromParent((DefaultMutableTreeNode)this.root.getChildAt(0));
            ++i;
        }
        this.results.setText("");
        log.debug("End : clear1");
    }

    public String toString() {
        String desc = "Shows the text results of sampling in tree form";
        if (log.isDebugEnabled()) {
            log.debug("toString1 : Returning description - " + desc);
        }
        return desc;
    }

    public void valueChanged(TreeSelectionEvent e) {
        block20: {
            log.debug("Start : valueChanged1");
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.jTree.getLastSelectedPathComponent();
            if (log.isDebugEnabled()) {
                log.debug("valueChanged : selected node - " + node);
            }
            StyledDocument statsDoc = this.stats.getStyledDocument();
            try {
                statsDoc.remove(0, statsDoc.getLength());
                if (node == null) break block20;
                SampleResult res = (SampleResult)node.getUserObject();
                if (log.isDebugEnabled()) {
                    log.debug("valueChanged1 : sample result - " + res);
                }
                if (res == null) break block20;
                log.debug("valueChanged1 : load time - " + res.getTime());
                if (res != null && res.getSamplerData() != null) {
                    this.sampleDataField.setText(res.getSamplerData().trim());
                }
                statsDoc.insertString(statsDoc.getLength(), "Load time: " + res.getTime() + "\n", null);
                String responseCode = res.getResponseCode();
                log.debug("valueChanged1 : response code - " + responseCode);
                int responseLevel = 0;
                if (responseCode != null) {
                    try {
                        responseLevel = Integer.parseInt(responseCode) / 100;
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                Style style = null;
                switch (responseLevel) {
                    case 3: {
                        style = statsDoc.getStyle("Redirect");
                        break;
                    }
                    case 4: {
                        style = statsDoc.getStyle("ClientError");
                        break;
                    }
                    case 5: {
                        style = statsDoc.getStyle("ServerError");
                    }
                }
                statsDoc.insertString(statsDoc.getLength(), "HTTP response code: " + responseCode + "\n", style);
                String responseMsgStr = res.getResponseMessage();
                log.debug("valueChanged1 : response message - " + responseMsgStr);
                statsDoc.insertString(statsDoc.getLength(), "HTTP response message: " + responseMsgStr + "\n", null);
                byte[] responseBytes = res.getResponseData();
                if (res.getDataType() != null && res.getDataType().equals(TEXT_COMMAND)) {
                    String response = null;
                    try {
                        response = new String(responseBytes, "utf-8");
                    }
                    catch (UnsupportedEncodingException err) {
                        response = new String(responseBytes);
                    }
                    if (response != null) {
                        if (this.textMode) {
                            this.showTextResponse(response);
                        } else {
                            this.showRenderedResponse(response);
                        }
                    }
                    break block20;
                }
                if (responseBytes != null) {
                    this.showImage(new ImageIcon(responseBytes));
                }
            }
            catch (BadLocationException exc) {
                log.error("Error setting statistics text", (Throwable)exc);
                this.stats.setText("");
            }
        }
        log.debug("End : valueChanged1");
    }

    private void showImage(Icon image) {
        this.imageLabel.setIcon(image);
        this.resultsScrollPane.setViewportView(this.imageLabel);
        this.textButton.setEnabled(false);
        this.htmlButton.setEnabled(false);
    }

    protected void showTextResponse(String response) {
        this.results.setContentType("text/plain");
        this.results.setText(response == null ? "" : response);
        this.results.setCaretPosition(0);
        this.resultsScrollPane.setViewportView(this.results);
        this.textButton.setEnabled(true);
        this.htmlButton.setEnabled(true);
    }

    public void actionPerformed(ActionEvent e) {
        String command = e.getActionCommand();
        if (command != null && command.equals(TEXT_COMMAND) || command.equals(HTML_COMMAND)) {
            this.textMode = !this.textMode;
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.jTree.getLastSelectedPathComponent();
            if (node == null) {
                this.results.setText("");
                return;
            }
            SampleResult res = (SampleResult)node.getUserObject();
            byte[] responseBytes = res.getResponseData();
            String response = null;
            if (res.getDataType() != null && res.getDataType().equals(TEXT_COMMAND)) {
                try {
                    response = new String(responseBytes, "utf-8");
                }
                catch (UnsupportedEncodingException err) {
                    response = new String(responseBytes);
                }
            }
            if (this.textMode) {
                this.showTextResponse(response);
            } else {
                this.showRenderedResponse(response);
            }
        }
    }

    protected void showRenderedResponse(String response) {
        if (response == null) {
            this.results.setText("");
            return;
        }
        int htmlIndex = response.indexOf("<HTML>");
        if (htmlIndex < 0) {
            htmlIndex = response.indexOf("<html>");
        }
        if (htmlIndex < 0) {
            htmlIndex = 0;
        }
        String html = response.substring(htmlIndex);
        this.results.setContentType("text/html");
        this.results.setText(html);
        this.results.setCaretPosition(0);
        this.resultsScrollPane.setViewportView(this.results);
        this.textButton.setEnabled(true);
        this.htmlButton.setEnabled(true);
    }

    protected Component createHtmlOrTextPane() {
        ButtonGroup group = new ButtonGroup();
        this.textButton = new JRadioButton(TEXT_BUTTON_LABEL);
        this.textButton.setActionCommand(TEXT_COMMAND);
        this.textButton.addActionListener(this);
        this.textButton.setSelected(this.textMode);
        group.add(this.textButton);
        this.htmlButton = new JRadioButton(HTML_BUTTON_LABEL);
        this.htmlButton.setActionCommand(HTML_COMMAND);
        this.htmlButton.addActionListener(this);
        this.htmlButton.setSelected(!this.textMode);
        group.add(this.htmlButton);
        JPanel pane = new JPanel();
        pane.add(this.textButton);
        pane.add(this.htmlButton);
        return pane;
    }

    protected void init() {
        this.setLayout(new BorderLayout(0, 5));
        this.setBorder(this.makeBorder());
        this.add(this.makeTitlePanel(), "North");
        Component topLeft = this.createTopLeftPanel();
        Component bottomLeft = this.createBottomLeftPanel();
        JSplitPane leftSide = new JSplitPane(0, topLeft, bottomLeft);
        Component topRight = this.createTopRightPanel();
        Component bottomRight = this.createBottomRightPanel();
        JSplitPane rightSide = new JSplitPane(0, topRight, bottomRight);
        JSplitPane mainSplit = new JSplitPane(1, leftSide, rightSide);
        this.add(mainSplit, "Center");
    }

    private Component createTopLeftPanel() {
        SampleResult rootSampleResult = new SampleResult();
        rootSampleResult.setSampleLabel("Root");
        rootSampleResult.setSuccessful(true);
        this.root = new DefaultMutableTreeNode(rootSampleResult);
        this.treeModel = new DefaultTreeModel(this.root);
        this.jTree = new JTree(this.treeModel);
        this.jTree.setCellRenderer(new ResultsNodeRenderer());
        this.jTree.getSelectionModel().setSelectionMode(1);
        this.jTree.addTreeSelectionListener(this);
        this.jTree.setShowsRootHandles(true);
        JScrollPane treePane = new JScrollPane(this.jTree);
        treePane.setPreferredSize(new Dimension(200, 300));
        return treePane;
    }

    private Component createBottomLeftPanel() {
        this.stats = new JTextPane();
        this.stats.setEditable(false);
        this.stats.setBackground(this.getBackground());
        StyledDocument doc = (StyledDocument)this.stats.getDocument();
        Style style = doc.addStyle("Redirect", null);
        StyleConstants.setForeground(style, REDIRECT_COLOR);
        style = doc.addStyle("ClientError", null);
        StyleConstants.setForeground(style, CLIENT_ERROR_COLOR);
        style = doc.addStyle("ServerError", null);
        StyleConstants.setForeground(style, SERVER_ERROR_COLOR);
        JScrollPane pane = this.makeScrollPane(this.stats);
        pane.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        return pane;
    }

    private Component createTopRightPanel() {
        this.sampleDataField = new JTextArea();
        this.sampleDataField.setEditable(false);
        this.sampleDataField.setLineWrap(true);
        this.sampleDataField.setWrapStyleWord(true);
        JPanel pane = new JPanel(new BorderLayout(0, 5));
        pane.setBorder(BorderFactory.createTitledBorder("Request Data"));
        pane.add(this.makeScrollPane(this.sampleDataField));
        return pane;
    }

    private Component createBottomRightPanel() {
        this.results = new JEditorPane();
        this.results.setEditable(false);
        this.resultsScrollPane = this.makeScrollPane(this.results);
        this.imageLabel = new JLabel();
        JPanel resultsPane = new JPanel(new BorderLayout());
        resultsPane.setBorder(BorderFactory.createTitledBorder("Response Data"));
        resultsPane.add((Component)this.resultsScrollPane, "Center");
        resultsPane.add(this.createHtmlOrTextPane(), "South");
        return resultsPane;
    }

    private class ResultsNodeRenderer
    extends DefaultTreeCellRenderer {
        private ResultsNodeRenderer() {
        }

        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
            if (!((SampleResult)((DefaultMutableTreeNode)value).getUserObject()).isSuccessful()) {
                this.setForeground(Color.red);
            }
            return this;
        }
    }
}

