/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.protocol.ldap.config.gui;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import org.apache.jmeter.config.ConfigTestElement;
import org.apache.jmeter.config.gui.AbstractConfigGui;
import org.apache.jmeter.config.gui.ArgumentsPanel;
import org.apache.jmeter.gui.util.VerticalPanel;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.testelement.property.BooleanProperty;
import org.apache.jmeter.testelement.property.JMeterProperty;
import org.apache.jmeter.testelement.property.StringProperty;
import org.apache.jmeter.testelement.property.TestElementProperty;
import org.apache.jmeter.util.JMeterUtils;

public class LdapConfigGui
extends AbstractConfigGui
implements ItemListener {
    private static final String ROOTDN = "rootdn";
    private static final String TEST = "test";
    private static String testValue = "NNNN";
    private JTextField rootdn = new JTextField(20);
    private JTextField searchbase = new JTextField(20);
    private JTextField searchfilter = new JTextField(20);
    private JTextField delete = new JTextField(20);
    private JTextField add = new JTextField(20);
    private JTextField modify = new JTextField(20);
    private JTextField servername = new JTextField(20);
    private JTextField port = new JTextField(20);
    private JCheckBox user_Defined = new JCheckBox(JMeterUtils.getResString((String)"user_defined_test"));
    private JRadioButton addTest = new JRadioButton(JMeterUtils.getResString((String)"add_test"));
    private JRadioButton modifyTest = new JRadioButton(JMeterUtils.getResString((String)"modify_test"));
    private JRadioButton deleteTest = new JRadioButton(JMeterUtils.getResString((String)"delete_test"));
    private JRadioButton searchTest = new JRadioButton(JMeterUtils.getResString((String)"search_test"));
    private ButtonGroup bGroup = new ButtonGroup();
    private boolean displayName = true;
    ArgumentsPanel tableAddPanel = new ArgumentsPanel(JMeterUtils.getResString((String)"add_test"));
    ArgumentsPanel tableModifyPanel = new ArgumentsPanel(JMeterUtils.getResString((String)"modify_test"));
    private JPanel cards;

    public LdapConfigGui() {
        this(true);
    }

    public String getStaticLabel() {
        return JMeterUtils.getResString((String)"ldap_sample_title");
    }

    public void configure(TestElement element) {
        super.configure(element);
        this.servername.setText(element.getPropertyAsString("servername"));
        this.port.setText(element.getPropertyAsString("port"));
        this.rootdn.setText(element.getPropertyAsString(ROOTDN));
        CardLayout cl = (CardLayout)this.cards.getLayout();
        if (element.getPropertyAsString(TEST).equals("add")) {
            this.addTest.setSelected(true);
            this.add.setText(element.getPropertyAsString("base_entry_dn"));
            this.tableAddPanel.configure((TestElement)element.getProperty("arguments").getObjectValue());
            cl.show(this.cards, "Add");
        } else if (element.getPropertyAsString(TEST).equals("modify")) {
            this.modifyTest.setSelected(true);
            this.modify.setText(element.getPropertyAsString("base_entry_dn"));
            this.tableModifyPanel.configure((TestElement)element.getProperty("arguments").getObjectValue());
            cl.show(this.cards, "Modify");
        } else if (element.getPropertyAsString(TEST).equals("delete")) {
            this.deleteTest.setSelected(true);
            this.delete.setText(element.getPropertyAsString("delete"));
            cl.show(this.cards, "Delete");
        } else if (element.getPropertyAsString(TEST).equals("search")) {
            this.searchTest.setSelected(true);
            this.searchbase.setText(element.getPropertyAsString("search"));
            this.searchfilter.setText(element.getPropertyAsString("searchfilter"));
            cl.show(this.cards, "Search");
        }
        if (element.getPropertyAsBoolean("user_defined")) {
            this.user_Defined.setSelected(true);
        } else {
            this.user_Defined.setSelected(false);
            cl.show(this.cards, "");
        }
    }

    public TestElement createTestElement() {
        ConfigTestElement element = new ConfigTestElement();
        this.modifyTestElement((TestElement)element);
        return element;
    }

    public void modifyTestElement(TestElement element) {
        element.clear();
        this.configureTestElement(element);
        element.setProperty("servername", this.servername.getText());
        element.setProperty("port", this.port.getText());
        element.setProperty(ROOTDN, this.rootdn.getText());
        element.setProperty((JMeterProperty)new BooleanProperty("user_defined", this.user_Defined.isSelected()));
        if (this.addTest.isSelected()) {
            element.setProperty((JMeterProperty)new StringProperty(TEST, "add"));
            element.setProperty((JMeterProperty)new StringProperty("base_entry_dn", this.add.getText()));
            element.setProperty((JMeterProperty)new TestElementProperty("arguments", this.tableAddPanel.createTestElement()));
        }
        if (this.modifyTest.isSelected()) {
            element.setProperty((JMeterProperty)new StringProperty(TEST, "modify"));
            element.setProperty((JMeterProperty)new StringProperty("base_entry_dn", this.modify.getText()));
            element.setProperty((JMeterProperty)new TestElementProperty("arguments", this.tableModifyPanel.createTestElement()));
        }
        if (this.deleteTest.isSelected()) {
            element.setProperty((JMeterProperty)new StringProperty(TEST, "delete"));
            element.setProperty((JMeterProperty)new StringProperty("delete", this.delete.getText()));
        }
        if (this.searchTest.isSelected()) {
            element.setProperty((JMeterProperty)new StringProperty(TEST, "search"));
            element.setProperty((JMeterProperty)new StringProperty("search", this.searchbase.getText()));
            element.setProperty((JMeterProperty)new StringProperty("searchfilter", this.searchfilter.getText()));
        }
    }

    public void itemStateChanged(ItemEvent ie) {
        CardLayout cl = (CardLayout)this.cards.getLayout();
        if (this.user_Defined.isSelected()) {
            if (this.addTest.isSelected()) {
                cl.show(this.cards, "Add");
                this.tableModifyPanel.clear();
                this.searchbase.setText("");
                this.searchfilter.setText("");
                this.delete.setText("");
            } else if (this.deleteTest.isSelected()) {
                cl.show(this.cards, "Delete");
                this.tableModifyPanel.clear();
                this.tableAddPanel.clear();
                this.searchbase.setText("");
                this.searchfilter.setText("");
            } else if (this.searchTest.isSelected()) {
                cl.show(this.cards, "Search");
                this.delete.setText("");
                this.tableModifyPanel.clear();
                this.tableAddPanel.clear();
            } else if (this.modifyTest.isSelected()) {
                cl.show(this.cards, "Modify");
                this.tableAddPanel.clear();
                this.searchbase.setText("");
                this.searchfilter.setText("");
                this.delete.setText("");
            } else {
                cl.show(this.cards, "");
                this.tableAddPanel.clear();
                this.tableModifyPanel.clear();
                this.searchbase.setText("");
                this.searchfilter.setText("");
                this.delete.setText("");
            }
        } else {
            cl.show(this.cards, "");
            this.tableAddPanel.clear();
            this.tableModifyPanel.clear();
            this.searchbase.setText("");
            this.searchfilter.setText("");
            this.delete.setText("");
        }
    }

    public LdapConfigGui(boolean displayName) {
        this.displayName = displayName;
        this.init();
    }

    private JPanel createServernamePanel() {
        JPanel serverPanel = new JPanel(new BorderLayout(5, 0));
        JLabel label = new JLabel(JMeterUtils.getResString((String)"servername"));
        label.setLabelFor(this.servername);
        serverPanel.add((Component)label, "West");
        serverPanel.add((Component)this.servername, "Center");
        return serverPanel;
    }

    private JPanel createPortPanel() {
        JPanel portPanel = new JPanel(new BorderLayout(5, 0));
        JLabel label = new JLabel(JMeterUtils.getResString((String)"port"));
        label.setLabelFor(this.port);
        portPanel.add((Component)label, "West");
        portPanel.add((Component)this.port, "Center");
        return portPanel;
    }

    private JPanel createRootdnPanel() {
        JPanel rootdnPanel = new JPanel(new BorderLayout(5, 0));
        JLabel label = new JLabel(JMeterUtils.getResString((String)"dn"));
        label.setLabelFor(this.rootdn);
        rootdnPanel.add((Component)label, "West");
        rootdnPanel.add((Component)this.rootdn, "Center");
        return rootdnPanel;
    }

    private JPanel createSearchPanel() {
        VerticalPanel searchPanel = new VerticalPanel();
        JPanel searchBPanel = new JPanel(new BorderLayout(5, 0));
        JLabel label = new JLabel(JMeterUtils.getResString((String)"search_base"));
        label.setLabelFor(this.searchbase);
        searchBPanel.add((Component)label, "West");
        searchBPanel.add((Component)this.searchbase, "Center");
        JPanel searchFPanel = new JPanel(new BorderLayout(5, 0));
        JLabel label2 = new JLabel(JMeterUtils.getResString((String)"search_filter"));
        label2.setLabelFor(this.searchfilter);
        searchFPanel.add((Component)label2, "West");
        searchFPanel.add((Component)this.searchfilter, "Center");
        searchPanel.add((Component)searchBPanel);
        searchPanel.add((Component)searchFPanel);
        return searchPanel;
    }

    private JPanel createDeletePanel() {
        VerticalPanel panel = new VerticalPanel();
        JPanel deletePanel = new JPanel(new BorderLayout(5, 0));
        JLabel label = new JLabel(JMeterUtils.getResString((String)"delete"));
        label.setLabelFor(this.delete);
        deletePanel.add((Component)label, "West");
        deletePanel.add((Component)this.delete, "Center");
        panel.add((Component)deletePanel);
        return panel;
    }

    private JPanel createAddPanel() {
        JPanel addPanel = new JPanel(new BorderLayout(5, 0));
        JPanel addInnerPanel = new JPanel(new BorderLayout(5, 0));
        JLabel label = new JLabel(JMeterUtils.getResString((String)"entry_dn"));
        label.setLabelFor(this.add);
        addInnerPanel.add((Component)label, "West");
        addInnerPanel.add((Component)this.add, "Center");
        addPanel.add((Component)addInnerPanel, "North");
        addPanel.add((Component)this.tableAddPanel, "Center");
        return addPanel;
    }

    private JPanel createModifyPanel() {
        JPanel modifyPanel = new JPanel(new BorderLayout(5, 0));
        JPanel modifyInnerPanel = new JPanel(new BorderLayout(5, 0));
        JLabel label = new JLabel(JMeterUtils.getResString((String)"entry_dn"));
        label.setLabelFor(this.modify);
        modifyInnerPanel.add((Component)label, "West");
        modifyInnerPanel.add((Component)this.modify, "Center");
        modifyPanel.add((Component)modifyInnerPanel, "North");
        modifyPanel.add((Component)this.tableModifyPanel, "Center");
        return modifyPanel;
    }

    private JPanel testPanel() {
        this.cards = new JPanel(new CardLayout());
        this.cards.add((Component)new JPanel(), "");
        this.cards.add((Component)this.createAddPanel(), "Add");
        this.cards.add((Component)this.createModifyPanel(), "Modify");
        this.cards.add((Component)this.createDeletePanel(), "Delete");
        this.cards.add((Component)this.createSearchPanel(), "Search");
        return this.cards;
    }

    private JPanel createTestPanel() {
        JPanel testPanel = new JPanel(new BorderLayout());
        testPanel.setBorder(BorderFactory.createTitledBorder(JMeterUtils.getResString((String)"test_configuration")));
        testPanel.add(new JLabel(JMeterUtils.getResString((String)TEST)));
        JPanel rowPanel = new JPanel();
        rowPanel.add(this.addTest);
        this.bGroup.add(this.addTest);
        rowPanel.add(this.deleteTest);
        this.bGroup.add(this.deleteTest);
        rowPanel.add(this.searchTest);
        this.bGroup.add(this.searchTest);
        rowPanel.add(this.modifyTest);
        this.bGroup.add(this.modifyTest);
        testPanel.add((Component)rowPanel, "North");
        testPanel.add((Component)this.user_Defined, "Center");
        return testPanel;
    }

    private void init() {
        this.user_Defined.addItemListener(this);
        this.addTest.addItemListener(this);
        this.modifyTest.addItemListener(this);
        this.deleteTest.addItemListener(this);
        this.searchTest.addItemListener(this);
        this.setLayout(new BorderLayout(0, 5));
        if (this.displayName) {
            VerticalPanel mainPanel = new VerticalPanel();
            mainPanel.setBorder(this.makeBorder());
            this.add(this.makeTitlePanel(), "North");
            mainPanel.setBorder(this.makeBorder());
            mainPanel.add((Component)this.createServernamePanel());
            mainPanel.add((Component)this.createPortPanel());
            mainPanel.add((Component)this.createRootdnPanel());
            mainPanel.add((Component)this.createTestPanel());
            mainPanel.add((Component)this.testPanel());
            this.add((Component)mainPanel, "Center");
        } else {
            VerticalPanel mainPanel = new VerticalPanel();
            mainPanel.add((Component)this.createServernamePanel());
            mainPanel.add((Component)this.createPortPanel());
            mainPanel.add((Component)this.createRootdnPanel());
            mainPanel.add((Component)this.createTestPanel());
            mainPanel.add((Component)this.testPanel());
            this.add((Component)mainPanel, "Center");
        }
    }
}

