/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.protocol.ldap.sampler;

import javax.naming.NamingException;
import javax.naming.NoPermissionException;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.ModificationItem;
import org.apache.jmeter.config.Argument;
import org.apache.jmeter.config.Arguments;
import org.apache.jmeter.config.LoginConfig;
import org.apache.jmeter.protocol.ldap.config.LdapConfig;
import org.apache.jmeter.protocol.ldap.sampler.LdapClient;
import org.apache.jmeter.samplers.AbstractSampler;
import org.apache.jmeter.samplers.Entry;
import org.apache.jmeter.samplers.SampleResult;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.testelement.property.BooleanProperty;
import org.apache.jmeter.testelement.property.JMeterProperty;
import org.apache.jmeter.testelement.property.PropertyIterator;
import org.apache.jmeter.testelement.property.StringProperty;
import org.apache.jmeter.testelement.property.TestElementProperty;
import org.apache.log.Hierarchy;
import org.apache.log.Logger;

public class LDAPSampler
extends AbstractSampler {
    private static transient Logger log = Hierarchy.getDefaultHierarchy().getLoggerFor("jmeter.protocol.ldap");
    public static final String SERVERNAME = "servername";
    public static final String PORT = "port";
    public static final String ROOTDN = "rootdn";
    public static final String TEST = "test";
    public static final String ADD = "add";
    public static final String MODIFY = "modify";
    public static final String DELETE = "delete";
    public static final String SEARCHBASE = "search";
    public static final String SEARCHFILTER = "searchfilter";
    public static final String USER_DEFINED = "user_defined";
    public static final String ARGUMENTS = "arguments";
    public static final String BASE_ENTRY_DN = "base_entry_dn";
    public static int counter = 0;

    public void addCustomTestElement(TestElement element) {
        if (element instanceof LdapConfig || element instanceof LoginConfig) {
            this.mergeIn(element);
        }
    }

    public String getUsername() {
        return this.getPropertyAsString("ConfigTestElement.username");
    }

    public String getPassword() {
        return this.getPropertyAsString("ConfigTestElement.password");
    }

    public void setServername(String servername) {
        this.setProperty((JMeterProperty)new StringProperty(SERVERNAME, servername));
    }

    public void setPort(String port) {
        this.setProperty((JMeterProperty)new StringProperty(PORT, port));
    }

    public String getServername() {
        return this.getPropertyAsString(SERVERNAME);
    }

    public String getPort() {
        return this.getPropertyAsString(PORT);
    }

    public void setRootdn(String newRootdn) {
        this.setProperty(ROOTDN, newRootdn);
    }

    public String getRootdn() {
        return this.getPropertyAsString(ROOTDN);
    }

    public void setTest(String newTest) {
        this.setProperty(TEST, newTest);
    }

    public String getTest() {
        return this.getPropertyAsString(TEST);
    }

    public void setUserDefinedTest(boolean value) {
        this.setProperty((JMeterProperty)new BooleanProperty(USER_DEFINED, value));
    }

    public boolean getUserDefinedTest() {
        return this.getPropertyAsBoolean(USER_DEFINED);
    }

    public void setBaseEntryDN(String newbaseentry) {
        this.setProperty((JMeterProperty)new StringProperty(BASE_ENTRY_DN, newbaseentry));
    }

    public String getBaseEntryDN() {
        return this.getPropertyAsString(BASE_ENTRY_DN);
    }

    public void setArguments(Arguments value) {
        this.setProperty((JMeterProperty)new TestElementProperty(ARGUMENTS, (TestElement)value));
    }

    public Arguments getArguments() {
        return (Arguments)this.getProperty(ARGUMENTS).getObjectValue();
    }

    public BasicAttributes getUserAttributes() {
        boolean add = true;
        BasicAttribute basicattribute = new BasicAttribute("objectclass");
        basicattribute.add("top");
        basicattribute.add("person");
        basicattribute.add("organizationalPerson");
        basicattribute.add("inetOrgPerson");
        BasicAttributes attrs = new BasicAttributes(true);
        attrs.put(basicattribute);
        PropertyIterator iter = this.getArguments().iterator();
        while (iter.hasNext()) {
            Argument item = (Argument)iter.next().getObjectValue();
            BasicAttribute attr = this.getBasicAttribute(item.getName(), item.getValue());
            attrs.put(attr);
        }
        return attrs;
    }

    public ModificationItem[] getUserModAttributes() {
        ModificationItem[] mods = new ModificationItem[this.getArguments().getArguments().size()];
        boolean add = true;
        BasicAttributes attrs = new BasicAttributes(true);
        PropertyIterator iter = this.getArguments().iterator();
        int count = 0;
        while (iter.hasNext()) {
            Argument item = (Argument)iter.next().getObjectValue();
            BasicAttribute attr = this.getBasicAttribute(item.getName(), item.getValue());
            mods[count] = new ModificationItem(2, attr);
            count = 1;
        }
        return mods;
    }

    public ModificationItem[] getModificationItem() {
        ModificationItem[] mods = new ModificationItem[2];
        BasicAttribute mod0 = new BasicAttribute("userpassword", "secret");
        BasicAttribute mod1 = new BasicAttribute("mobile", "123-456-1234");
        mods[0] = new ModificationItem(2, mod0);
        mods[1] = new ModificationItem(1, mod1);
        return mods;
    }

    public BasicAttributes getBasicAttributes() {
        BasicAttributes basicattributes = new BasicAttributes();
        BasicAttribute basicattribute = new BasicAttribute("objectclass");
        basicattribute.add("top");
        basicattribute.add("person");
        basicattribute.add("organizationalPerson");
        basicattribute.add("inetOrgPerson");
        basicattributes.put(basicattribute);
        String s1 = "User";
        String s3 = "Test";
        String s5 = "user";
        String s6 = TEST;
        basicattributes.put(new BasicAttribute("givenname", s1));
        basicattributes.put(new BasicAttribute("sn", s3));
        basicattributes.put(new BasicAttribute("cn", "TestUser" + ++counter));
        basicattributes.put(new BasicAttribute("uid", s5));
        basicattributes.put(new BasicAttribute("userpassword", s6));
        this.setProperty((JMeterProperty)new StringProperty(ADD, "cn=TestUser" + counter));
        return basicattributes;
    }

    public BasicAttribute getBasicAttribute(String name, String value) {
        BasicAttribute attr = new BasicAttribute(name, value);
        return attr;
    }

    public String getLabel() {
        return "ldap://" + this.getServername() + ":" + this.getPort() + "/" + this.getRootdn();
    }

    public long addTest(LdapClient ldap) throws NoPermissionException, NamingException {
        long start = 0L;
        long end = 0L;
        if (this.getPropertyAsBoolean(USER_DEFINED)) {
            start = System.currentTimeMillis();
            ldap.createTest(this.getUserAttributes(), this.getPropertyAsString(BASE_ENTRY_DN));
            end = System.currentTimeMillis();
        } else {
            start = System.currentTimeMillis();
            ldap.createTest(this.getBasicAttributes(), this.getPropertyAsString(ADD));
            end = System.currentTimeMillis();
            ldap.deleteTest(this.getPropertyAsString(ADD));
        }
        return end - start;
    }

    public long deleteTest(LdapClient ldap) throws NoPermissionException, NamingException {
        long start = 0L;
        long end = 0L;
        if (!this.getPropertyAsBoolean(USER_DEFINED)) {
            ldap.createTest(this.getBasicAttributes(), this.getPropertyAsString(ADD));
            this.setProperty((JMeterProperty)new StringProperty(DELETE, this.getPropertyAsString(ADD)));
        }
        start = System.currentTimeMillis();
        ldap.deleteTest(this.getPropertyAsString(DELETE));
        end = System.currentTimeMillis();
        return end - start;
    }

    public long searchTest(LdapClient ldap) throws NoPermissionException, NamingException {
        long start = 0L;
        long end = 0L;
        if (!this.getPropertyAsBoolean(USER_DEFINED)) {
            ldap.createTest(this.getBasicAttributes(), this.getPropertyAsString(ADD));
            this.setProperty((JMeterProperty)new StringProperty(SEARCHBASE, this.getPropertyAsString(ADD)));
            this.setProperty((JMeterProperty)new StringProperty(SEARCHFILTER, this.getPropertyAsString(ADD)));
        }
        start = System.currentTimeMillis();
        ldap.searchTest(this.getPropertyAsString(SEARCHBASE), this.getPropertyAsString(SEARCHFILTER));
        end = System.currentTimeMillis();
        if (!this.getPropertyAsBoolean(USER_DEFINED)) {
            ldap.deleteTest(this.getPropertyAsString(ADD));
        }
        return end - start;
    }

    public long modifyTest(LdapClient ldap) throws NoPermissionException, NamingException {
        long start = 0L;
        long end = 0L;
        if (this.getPropertyAsBoolean(USER_DEFINED)) {
            start = System.currentTimeMillis();
            ldap.modifyTest(this.getUserModAttributes(), this.getPropertyAsString(BASE_ENTRY_DN));
            end = System.currentTimeMillis();
        } else {
            ldap.createTest(this.getBasicAttributes(), this.getPropertyAsString(ADD));
            this.setProperty((JMeterProperty)new StringProperty(MODIFY, this.getPropertyAsString(ADD)));
            start = System.currentTimeMillis();
            ldap.modifyTest(this.getModificationItem(), this.getPropertyAsString(MODIFY));
            end = System.currentTimeMillis();
            ldap.deleteTest(this.getPropertyAsString(ADD));
        }
        return end - start;
    }

    public SampleResult sample(Entry e) {
        SampleResult res = new SampleResult();
        boolean isSuccessful = false;
        res.setSampleLabel(this.getLabel() + ": " + this.getPropertyAsString(TEST));
        long time = 0L;
        LdapClient ldap = new LdapClient();
        try {
            ldap.connect(this.getServername(), this.getPort(), this.getRootdn(), this.getUsername(), this.getPassword());
            if (this.getPropertyAsString(TEST).equals(ADD)) {
                time = this.addTest(ldap);
            } else if (this.getPropertyAsString(TEST).equals(DELETE)) {
                time = this.deleteTest(ldap);
            } else if (this.getPropertyAsString(TEST).equals(MODIFY)) {
                time = this.modifyTest(ldap);
            } else if (this.getPropertyAsString(TEST).equals(SEARCHBASE)) {
                time = this.searchTest(ldap);
            }
            res.setResponseData("success full".getBytes());
            isSuccessful = true;
            ldap.disconnect();
        }
        catch (Exception ex) {
            res.setResponseData(ex.toString().getBytes());
            log.error("Ldap client - ", (Throwable)ex);
            ldap.disconnect();
            isSuccessful = false;
            time = 0L;
        }
        res.setTime(time);
        res.setSuccessful(isSuccessful);
        return res;
    }
}

