/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.protocol.ldap.sampler;

import java.util.Hashtable;
import javax.naming.NamingException;
import javax.naming.NoPermissionException;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.InitialDirContext;
import javax.naming.directory.ModificationItem;
import javax.naming.directory.SearchControls;
import org.apache.log.Hierarchy;
import org.apache.log.Logger;

public class LdapClient {
    private static transient Logger log = Hierarchy.getDefaultHierarchy().getLoggerFor("jmeter.protocol.ldap");
    DirContext dirContext;

    public void connect(String host, String port, String rootdn, String username, String password) throws Exception {
        Hashtable<String, String> env = new Hashtable<String, String>();
        env.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        env.put("java.naming.provider.url", "ldap://" + host + ":" + port + "/" + rootdn);
        env.put("java.naming.referral", "throw");
        env.put("java.naming.security.credentials", password);
        env.put("java.naming.security.principal", username);
        this.dirContext = new InitialDirContext(env);
    }

    public void disconnect() {
        try {
            this.dirContext = null;
        }
        catch (Exception e) {
            log.error("Ldap client - ", (Throwable)e);
        }
    }

    public void searchTest(String searchBase, String searchFilter) throws NoPermissionException, NamingException {
        SearchControls searchcontrols = new SearchControls(2, 1L, 0, null, false, false);
        this.dirContext.search(searchBase, searchFilter, searchcontrols);
    }

    public void modifyTest(ModificationItem[] mods, String string) throws NoPermissionException, NamingException {
        this.dirContext.modifyAttributes(string, mods);
    }

    public void createTest(BasicAttributes basicattributes, String string) throws NoPermissionException, NamingException {
        this.dirContext.createSubcontext(string, (Attributes)basicattributes);
    }

    public void deleteTest(String string) throws NoPermissionException, NamingException {
        this.dirContext.destroySubcontext(string);
    }
}

