/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xalan.lib;

import org.apache.xalan.extensions.ExpressionContext;
import org.apache.xpath.NodeSet;
import org.w3c.dom.Node;
import org.w3c.dom.traversal.NodeIterator;

public class ExsltMath {
    public static String max(ExpressionContext expCon, NodeIterator ni) {
        NodeSet ns = new NodeSet(ni);
        Node maxNode = null;
        double m = Double.MIN_VALUE;
        int i = 0;
        while (i < ns.getLength()) {
            Node n = ns.elementAt(i);
            double d = expCon.toNumber(n);
            if (Double.isNaN(d)) {
                return "NaN";
            }
            if (d > m) {
                m = d;
                maxNode = n;
            }
            ++i;
        }
        return expCon.toString(maxNode);
    }

    public static String min(ExpressionContext expCon, NodeIterator ni) {
        NodeSet ns = new NodeSet(ni);
        Node minNode = null;
        double m = Double.MAX_VALUE;
        int i = 0;
        while (i < ns.getLength()) {
            Node n = ns.elementAt(i);
            double d = expCon.toNumber(n);
            if (Double.isNaN(d)) {
                return "NaN";
            }
            if (d < m) {
                m = d;
                minNode = n;
            }
            ++i;
        }
        return expCon.toString(minNode);
    }

    public static NodeSet highest(ExpressionContext expCon, NodeIterator ni) throws CloneNotSupportedException {
        NodeSet ns = new NodeSet(ni);
        NodeIterator niClone = ns.cloneWithReset();
        double high = new Double(ExsltMath.max(expCon, niClone));
        NodeSet highNodes = new NodeSet();
        highNodes.setShouldCacheNodes(true);
        if (Double.isNaN(high)) {
            return highNodes;
        }
        int i = 0;
        while (i < ns.getLength()) {
            Node n = ns.elementAt(i);
            double d = expCon.toNumber(n);
            if (d == high) {
                highNodes.addElement(n);
            }
            ++i;
        }
        return highNodes;
    }

    public static NodeSet lowest(ExpressionContext expCon, NodeIterator ni) throws CloneNotSupportedException {
        NodeSet ns = new NodeSet(ni);
        NodeIterator niClone = ns.cloneWithReset();
        double low = new Double(ExsltMath.min(expCon, niClone));
        NodeSet lowNodes = new NodeSet();
        lowNodes.setShouldCacheNodes(true);
        if (Double.isNaN(low)) {
            return lowNodes;
        }
        int i = 0;
        while (i < ns.getLength()) {
            Node n = ns.elementAt(i);
            double d = expCon.toNumber(n);
            if (d == low) {
                lowNodes.addElement(n);
            }
            ++i;
        }
        return lowNodes;
    }
}

