/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xalan.transformer;

import java.util.Enumeration;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import org.apache.xalan.templates.ElemTemplate;
import org.apache.xalan.templates.ElemTemplateElement;
import org.apache.xalan.templates.StylesheetRoot;
import org.apache.xalan.trace.GenerateEvent;
import org.apache.xalan.trace.TraceManager;
import org.apache.xalan.transformer.ClonerToResultTree;
import org.apache.xalan.transformer.QueuedEvents;
import org.apache.xalan.transformer.SerializerSwitcher;
import org.apache.xalan.transformer.TransformState;
import org.apache.xalan.transformer.TransformerClient;
import org.apache.xalan.transformer.TransformerImpl;
import org.apache.xml.dtm.DTM;
import org.apache.xml.dtm.DTMIterator;
import org.apache.xml.dtm.ref.DTMNodeIterator;
import org.apache.xml.dtm.ref.dom2dtm.DOM2DTM;
import org.apache.xml.utils.MutableAttrListImpl;
import org.apache.xml.utils.NamespaceSupport2;
import org.apache.xml.utils.XMLCharacterRecognizer;
import org.apache.xpath.XPathContext;
import org.apache.xpath.objects.XObject;
import org.w3c.dom.Node;
import org.w3c.dom.traversal.NodeIterator;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.NamespaceSupport;

public class ResultTreeHandler
extends QueuedEvents
implements ContentHandler,
LexicalHandler,
TransformState,
DOM2DTM.CharacterNodeHandler,
ErrorHandler {
    private static final boolean DEBUG = false;
    boolean m_nsContextPushed = false;
    boolean m_isTransformClient = false;
    NamespaceSupport m_nsSupport = new NamespaceSupport2();
    private TransformerImpl m_transformer;
    private ContentHandler m_contentHandler;
    private LexicalHandler m_lexicalHandler;
    private StylesheetRoot m_stylesheetRoot = null;
    private int m_uniqueNSValue = 0;
    private static final String S_NAMESPACEPREFIX = "ns";
    public ClonerToResultTree m_cloner;
    private TraceManager m_tracer;
    private QueuedStateSnapshot m_snapshot = new QueuedStateSnapshot();

    public ResultTreeHandler() {
    }

    public ResultTreeHandler(TransformerImpl transformer, ContentHandler realHandler) {
        this.init(transformer, realHandler);
    }

    public void init(TransformerImpl transformer, ContentHandler realHandler) {
        this.m_transformer = transformer;
        TraceManager tracer = transformer.getTraceManager();
        this.m_tracer = null != tracer && tracer.hasTraceListeners() ? tracer : null;
        this.m_contentHandler = realHandler;
        this.m_lexicalHandler = this.m_contentHandler instanceof LexicalHandler ? (LexicalHandler)((Object)this.m_contentHandler) : null;
        this.m_isTransformClient = this.m_contentHandler instanceof TransformerClient;
        this.m_cloner = new ClonerToResultTree(transformer, this);
        if (null != this.m_transformer) {
            this.m_stylesheetRoot = this.m_transformer.getStylesheet();
        }
        this.pushDocumentEvent();
    }

    public void startDocument() throws SAXException {
    }

    public void endDocument() throws SAXException {
        this.flushPending(true);
        if (!this.m_docEnded) {
            this.m_contentHandler.endDocument();
            if (null != this.m_tracer) {
                GenerateEvent ge = new GenerateEvent(this.m_transformer, 2, null);
                this.m_tracer.fireGenerateEvent(ge);
            }
            this.m_docEnded = true;
            this.m_docPending = false;
        }
    }

    public void startElement(String ns, String localName, String name, Attributes atts) throws SAXException {
        if (this.m_docPending) {
            this.checkForSerializerSwitch(ns, localName);
        }
        this.flushPending(true);
        if (!this.m_nsContextPushed) {
            this.m_nsSupport.pushContext();
            this.m_nsContextPushed = true;
        }
        if (ns != null) {
            this.ensurePrefixIsDeclared(ns, name);
        }
        this.m_name = name;
        this.m_url = ns;
        this.m_localName = localName;
        if (null != atts) {
            this.m_attributes.addAttributes(atts);
        }
        this.m_elemIsPending = true;
        this.m_elemIsEnded = false;
        if (this.m_isTransformClient && null != this.m_transformer) {
            this.m_snapshot.m_currentElement = this.m_transformer.getCurrentElement();
            this.m_snapshot.m_currentTemplate = this.m_transformer.getCurrentTemplate();
            this.m_snapshot.m_matchedTemplate = this.m_transformer.getMatchedTemplate();
            int currentNodeHandle = this.m_transformer.getCurrentNode();
            DTM dtm = this.m_transformer.getXPathContext().getDTM(currentNodeHandle);
            this.m_snapshot.m_currentNode = dtm.getNode(currentNodeHandle);
            this.m_snapshot.m_matchedNode = this.m_transformer.getMatchedNode();
            this.m_snapshot.m_contextNodeList = this.m_transformer.getContextNodeList();
        }
        ++this.m_eventCount;
    }

    public void endElement(String ns, String localName, String name) throws SAXException {
        this.flushPending(true);
        this.m_contentHandler.endElement(ns, localName, name);
        if (null != this.m_tracer) {
            GenerateEvent ge = new GenerateEvent(this.m_transformer, 4, name, (Attributes)null);
            this.m_tracer.fireGenerateEvent(ge);
        }
        this.sendEndPrefixMappings();
        this.popEvent();
        this.m_nsSupport.popContext();
    }

    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        this.startPrefixMapping(prefix, uri, true);
    }

    public void startPrefixMapping(String prefix, String uri, boolean shouldFlush) throws SAXException {
        String existingURI;
        if (shouldFlush) {
            this.flushPending(false);
        }
        if (!this.m_nsContextPushed) {
            this.m_nsSupport.pushContext();
            this.m_nsContextPushed = true;
        }
        if (null == prefix) {
            prefix = "";
        }
        if (null == (existingURI = this.m_nsSupport.getURI(prefix))) {
            existingURI = "";
        }
        if (null == uri) {
            uri = "";
        }
        if (!existingURI.equals(uri)) {
            this.m_nsSupport.declarePrefix(prefix, uri);
        }
    }

    public void endPrefixMapping(String prefix) throws SAXException {
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        this.flushPending(true);
        this.m_contentHandler.characters(ch, start, length);
        if (null != this.m_tracer) {
            GenerateEvent ge = new GenerateEvent(this.m_transformer, 5, ch, start, length);
            this.m_tracer.fireGenerateEvent(ge);
        }
    }

    public void characters(Node node) throws SAXException {
        this.flushPending(true);
        if (this.m_isTransformClient) {
            this.m_snapshot.m_currentNode = node;
        }
        String data = node.getNodeValue();
        char[] ch = null;
        int length = 0;
        if (data != null) {
            ch = data.toCharArray();
            length = data.length();
            this.m_contentHandler.characters(ch, 0, length);
        }
        if (null != this.m_tracer) {
            GenerateEvent ge = new GenerateEvent(this.m_transformer, 5, ch, 0, length);
            this.m_tracer.fireGenerateEvent(ge);
        }
        if (this.m_isTransformClient) {
            this.m_snapshot.m_currentNode = null;
        }
    }

    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        if (this.m_docPending && XMLCharacterRecognizer.isWhiteSpace(ch, start, length)) {
            return;
        }
        this.flushPending(true);
        this.m_contentHandler.ignorableWhitespace(ch, start, length);
        if (null != this.m_tracer) {
            GenerateEvent ge = new GenerateEvent(this.m_transformer, 6, ch, start, length);
            this.m_tracer.fireGenerateEvent(ge);
        }
    }

    public void processingInstruction(String target, String data) throws SAXException {
        this.flushPending(true);
        this.m_contentHandler.processingInstruction(target, data);
        if (null != this.m_tracer) {
            GenerateEvent ge = new GenerateEvent(this.m_transformer, 7, target, data);
            this.m_tracer.fireGenerateEvent(ge);
        }
    }

    public void comment(String data) throws SAXException {
        this.flushPending(true);
        if (null != this.m_lexicalHandler) {
            this.m_lexicalHandler.comment(data.toCharArray(), 0, data.length());
        }
        if (null != this.m_tracer) {
            GenerateEvent ge = new GenerateEvent(this.m_transformer, 8, data);
            this.m_tracer.fireGenerateEvent(ge);
        }
    }

    public void comment(char[] ch, int start, int length) throws SAXException {
        this.flushPending(true);
        if (null != this.m_lexicalHandler) {
            this.m_lexicalHandler.comment(ch, start, length);
        }
        if (null != this.m_tracer) {
            GenerateEvent ge = new GenerateEvent(this.m_transformer, 8, new String(ch, start, length));
            this.m_tracer.fireGenerateEvent(ge);
        }
    }

    public void entityReference(String name) throws SAXException {
        this.flushPending(true);
        if (null != this.m_lexicalHandler) {
            this.m_lexicalHandler.startEntity(name);
            this.m_lexicalHandler.endEntity(name);
        }
        if (null != this.m_tracer) {
            GenerateEvent ge = new GenerateEvent(this.m_transformer, 9, name);
            this.m_tracer.fireGenerateEvent(ge);
        }
    }

    public void startEntity(String name) throws SAXException {
        this.flushPending(true);
        if (null != this.m_lexicalHandler) {
            this.m_lexicalHandler.startEntity(name);
        }
    }

    public void endEntity(String name) throws SAXException {
        this.flushPending(true);
        if (null != this.m_lexicalHandler) {
            this.m_lexicalHandler.endEntity(name);
        }
        if (null != this.m_tracer) {
            GenerateEvent ge = new GenerateEvent(this.m_transformer, 9, name);
            this.m_tracer.fireGenerateEvent(ge);
        }
    }

    public void startDTD(String s1, String s2, String s3) throws SAXException {
        this.flushPending(true);
        if (null != this.m_lexicalHandler) {
            this.m_lexicalHandler.startDTD(s1, s2, s3);
        }
    }

    public void endDTD() throws SAXException {
        this.flushPending(true);
        if (null != this.m_lexicalHandler) {
            this.m_lexicalHandler.endDTD();
        }
    }

    public void startCDATA() throws SAXException {
        this.flushPending(true);
        if (null != this.m_lexicalHandler) {
            this.m_lexicalHandler.startCDATA();
        }
    }

    public void endCDATA() throws SAXException {
        this.flushPending(true);
        if (null != this.m_lexicalHandler) {
            this.m_lexicalHandler.endCDATA();
        }
    }

    public void skippedEntity(String name) throws SAXException {
    }

    public void setNSDeclsHaveBeenAdded(boolean b) {
        this.m_nsDeclsHaveBeenAdded = b;
    }

    void flushDocEvent() throws SAXException {
        if (this.m_docPending) {
            this.m_contentHandler.startDocument();
            if (null != this.m_tracer) {
                GenerateEvent ge = new GenerateEvent(this.m_transformer, 1);
                this.m_tracer.fireGenerateEvent(ge);
            }
            if (this.m_contentHandler instanceof TransformerClient) {
                ((TransformerClient)((Object)this.m_contentHandler)).setTransformState(this);
            }
            this.m_docPending = false;
        }
    }

    void flushElem() throws SAXException {
        if (this.m_elemIsPending) {
            if (null != this.m_name) {
                try {
                    this.m_contentHandler.startElement(this.m_url, this.m_localName, this.m_name, this.m_attributes);
                }
                catch (Exception re) {
                    throw new SAXParseException(re.getMessage(), this.m_transformer.getCurrentElement().getPublicId(), this.m_transformer.getCurrentElement().getSystemId(), this.m_transformer.getCurrentElement().getLineNumber(), this.m_transformer.getCurrentElement().getColumnNumber(), re);
                }
                if (null != this.m_tracer) {
                    GenerateEvent ge = new GenerateEvent(this.m_transformer, 3, this.m_name, this.m_attributes);
                    this.m_tracer.fireGenerateEvent(ge);
                }
                if (this.m_isTransformClient) {
                    this.m_snapshot.m_currentNode = null;
                }
            }
            this.m_elemIsPending = false;
            this.m_attributes.clear();
            this.m_nsDeclsHaveBeenAdded = false;
            this.m_name = null;
            this.m_url = null;
            this.m_localName = null;
            this.m_namespaces = null;
        }
    }

    public final void flushPending() throws SAXException {
        this.flushPending(true);
    }

    public final void flushPending(boolean flushPrefixes) throws SAXException {
        if (flushPrefixes && this.m_docPending) {
            this.flushDocEvent();
        }
        if (this.m_elemIsPending) {
            if (!this.m_nsDeclsHaveBeenAdded) {
                this.startAndAddPrefixMappings();
            } else {
                this.sendStartPrefixMappings();
            }
            this.flushElem();
            this.m_nsContextPushed = false;
        }
    }

    public void outputResultTreeFragment(XObject obj, XPathContext support) throws SAXException {
        int doc = obj.rtf();
        DTM dtm = support.getDTM(doc);
        if (null != dtm) {
            int n = dtm.getFirstChild(doc);
            while (-1 != n) {
                this.flushPending(true);
                dtm.dispatchToEvents(n, this);
                n = dtm.getNextSibling(n);
            }
        }
    }

    public void setDocumentLocator(Locator locator) {
    }

    public void ensurePrefixIsDeclared(String ns, String rawName) throws SAXException {
        if (ns != null && ns.length() > 0) {
            String foundURI;
            String prefix;
            int index = rawName.indexOf(":");
            String string = prefix = index < 0 ? "" : rawName.substring(0, index);
            if (!(null == prefix || null != (foundURI = this.m_nsSupport.getURI(prefix)) && foundURI.equals(ns))) {
                this.startPrefixMapping(prefix, ns, false);
                this.m_attributes.addAttribute("http://www.w3.org/2000/xmlns/", prefix, "xmlns" + (prefix.length() == 0 ? "" : ":") + prefix, "CDATA", ns);
            }
        }
    }

    public void ensureNamespaceDeclDeclared(DTM dtm, int namespace) throws SAXException {
        String foundURI;
        String uri = dtm.getNodeValue(namespace);
        String prefix = dtm.getNodeNameX(namespace);
        if (!(uri == null || uri.length() <= 0 || null == prefix || null != (foundURI = this.m_nsSupport.getURI(prefix)) && foundURI.equals(uri))) {
            this.startPrefixMapping(prefix, uri, false);
        }
    }

    protected void sendStartPrefixMappings() throws SAXException {
        Enumeration prefixes = this.m_nsSupport.getDeclaredPrefixes();
        ContentHandler handler = this.m_contentHandler;
        while (prefixes.hasMoreElements()) {
            String prefix = (String)prefixes.nextElement();
            handler.startPrefixMapping(prefix, this.m_nsSupport.getURI(prefix));
        }
    }

    protected void startAndAddPrefixMappings() throws SAXException {
        Enumeration prefixes = this.m_nsSupport.getDeclaredPrefixes();
        ContentHandler handler = this.m_contentHandler;
        while (prefixes.hasMoreElements()) {
            String prefix = (String)prefixes.nextElement();
            String uri = this.m_nsSupport.getURI(prefix);
            handler.startPrefixMapping(prefix, uri);
            boolean isDefault = prefix.length() == 0;
            String name = isDefault ? "xmlns" : "xmlns:" + prefix;
            if (null == uri) {
                uri = "";
            }
            this.m_attributes.addAttribute("http://www.w3.org/2000/xmlns/", prefix, name, "CDATA", uri);
        }
        this.m_nsDeclsHaveBeenAdded = true;
    }

    protected void sendEndPrefixMappings() throws SAXException {
        Enumeration prefixes = this.m_nsSupport.getDeclaredPrefixes();
        ContentHandler handler = this.m_contentHandler;
        while (prefixes.hasMoreElements()) {
            String prefix = (String)prefixes.nextElement();
            handler.endPrefixMapping(prefix);
        }
    }

    private void checkForSerializerSwitch(String ns, String localName) throws SAXException {
        try {
            if (this.m_docPending) {
                SerializerSwitcher.switchSerializerIfHTML(this.m_transformer, ns, localName);
            }
        }
        catch (TransformerException te) {
            throw new SAXException(te);
        }
    }

    public void addNSDeclsToAttrs() {
        Enumeration prefixes = this.m_nsSupport.getDeclaredPrefixes();
        while (prefixes.hasMoreElements()) {
            String prefix = (String)prefixes.nextElement();
            boolean isDefault = prefix.length() == 0;
            String name = isDefault ? "xmlns" : "xmlns:" + prefix;
            String uri = this.m_nsSupport.getURI(prefix);
            if (null == uri) {
                uri = "";
            }
            this.m_attributes.addAttribute("http://www.w3.org/2000/xmlns/", prefix, name, "CDATA", uri);
        }
        this.m_nsDeclsHaveBeenAdded = true;
    }

    public void processNSDecls(int src, int type, DTM dtm) throws TransformerException {
        try {
            if (type == 1) {
                int namespace = dtm.getFirstNamespaceNode(src, true);
                while (-1 != namespace) {
                    String prefix = dtm.getNodeNameX(namespace);
                    String desturi = this.getURI(prefix);
                    String srcURI = dtm.getNodeValue(namespace);
                    if (!srcURI.equalsIgnoreCase(desturi)) {
                        this.startPrefixMapping(prefix, srcURI, false);
                    }
                    namespace = dtm.getNextNamespaceNode(src, namespace, true);
                }
            } else if (type == 13) {
                String prefix = dtm.getNodeNameX(src);
                String desturi = this.getURI(prefix);
                String srcURI = dtm.getNodeValue(src);
                if (!srcURI.equalsIgnoreCase(desturi)) {
                    this.startPrefixMapping(prefix, srcURI, false);
                }
            }
        }
        catch (SAXException se) {
            throw new TransformerException(se);
        }
    }

    public String getURI(String prefix) {
        return this.m_nsSupport.getURI(prefix);
    }

    public String getPrefix(String namespace) {
        Enumeration enumeration = this.m_nsSupport.getPrefixes();
        while (enumeration.hasMoreElements()) {
            String prefix = (String)enumeration.nextElement();
            if (!this.m_nsSupport.getURI(prefix).equals(namespace)) continue;
            return prefix;
        }
        return null;
    }

    public NamespaceSupport getNamespaceSupport() {
        return this.m_nsSupport;
    }

    public final ContentHandler getContentHandler() {
        return this.m_contentHandler;
    }

    public void setContentHandler(ContentHandler ch) {
        this.m_contentHandler = ch;
        this.m_isTransformClient = this.m_contentHandler instanceof TransformerClient;
        this.m_lexicalHandler = this.m_contentHandler instanceof LexicalHandler ? (LexicalHandler)((Object)this.m_contentHandler) : null;
        this.reInitEvents();
    }

    public int getUniqueNSValue() {
        return this.m_uniqueNSValue++;
    }

    public String getNewUniqueNSPrefix() {
        return S_NAMESPACEPREFIX + String.valueOf(this.getUniqueNSValue());
    }

    public MutableAttrListImpl getPendingAttributes() {
        return this.m_attributes;
    }

    public void addAttribute(String uri, String localName, String rawName, String type, String value) throws TransformerException {
        if (this.m_elemIsPending) {
            if (!this.m_nsDeclsHaveBeenAdded) {
                this.addNSDeclsToAttrs();
            }
            if (null == uri) {
                uri = "";
            }
            try {
                if (!rawName.equals("xmlns")) {
                    this.ensurePrefixIsDeclared(uri, rawName);
                }
            }
            catch (SAXException se) {
                throw new TransformerException(se);
            }
            if (!this.isDefinedNSDecl(rawName, value)) {
                this.m_attributes.addAttribute(uri, localName, rawName, type, value);
            }
        }
    }

    public boolean isDefinedNSDecl(String rawName, String value) {
        if (rawName.equals("xmlns") || rawName.startsWith("xmlns:")) {
            int index = rawName.indexOf(":");
            String prefix = index < 0 ? "" : rawName.substring(0, index);
            String definedURI = this.m_nsSupport.getURI(prefix);
            if (null != definedURI) {
                return definedURI.equals(value);
            }
            return false;
        }
        return false;
    }

    public boolean isDefinedNSDecl(int attr) {
        String prefix;
        String uri;
        DTM dtm = this.m_transformer.getXPathContext().getDTM(attr);
        return 13 == dtm.getNodeType(attr) && null != (uri = this.getURI(prefix = dtm.getNodeNameX(attr))) && uri.equals(dtm.getStringValue(attr));
    }

    public boolean isDefinedNSDecl(int attr, DTM dtm) {
        String prefix;
        String uri;
        return 13 == dtm.getNodeType(attr) && null != (uri = this.getURI(prefix = dtm.getNodeNameX(attr))) && uri.equals(dtm.getStringValue(attr));
    }

    public void addAttribute(int attr) throws TransformerException {
        DTM dtm = this.m_transformer.getXPathContext().getDTM(attr);
        if (this.isDefinedNSDecl(attr, dtm)) {
            return;
        }
        String ns = dtm.getNamespaceURI(attr);
        if (ns == null) {
            ns = "";
        }
        this.addAttribute(ns, dtm.getLocalName(attr), dtm.getNodeName(attr), "CDATA", dtm.getNodeValue(attr));
    }

    public void addAttributes(int src) throws TransformerException {
        DTM dtm = this.m_transformer.getXPathContext().getDTM(src);
        int node = dtm.getFirstAttribute(src);
        while (-1 != node) {
            this.addAttribute(node);
            node = dtm.getNextAttribute(node);
        }
    }

    public final boolean isElementPending() {
        return this.m_elemIsPending;
    }

    public ElemTemplateElement getCurrentElement() {
        if (this.m_elemIsPending) {
            return this.m_snapshot.m_currentElement;
        }
        return this.m_transformer.getCurrentElement();
    }

    public Node getCurrentNode() {
        if (this.m_snapshot.m_currentNode != null) {
            return this.m_snapshot.m_currentNode;
        }
        DTM dtm = this.m_transformer.getXPathContext().getDTM(this.m_transformer.getCurrentNode());
        return dtm.getNode(this.m_transformer.getCurrentNode());
    }

    public ElemTemplate getCurrentTemplate() {
        if (this.m_elemIsPending) {
            return this.m_snapshot.m_currentTemplate;
        }
        return this.m_transformer.getCurrentTemplate();
    }

    public ElemTemplate getMatchedTemplate() {
        if (this.m_elemIsPending) {
            return this.m_snapshot.m_matchedTemplate;
        }
        return this.m_transformer.getMatchedTemplate();
    }

    public Node getMatchedNode() {
        if (this.m_elemIsPending) {
            DTM dtm = this.m_transformer.getXPathContext().getDTM(this.m_snapshot.m_matchedNode);
            return dtm.getNode(this.m_snapshot.m_matchedNode);
        }
        DTM dtm = this.m_transformer.getXPathContext().getDTM(this.m_transformer.getMatchedNode());
        return dtm.getNode(this.m_transformer.getMatchedNode());
    }

    public NodeIterator getContextNodeList() {
        if (this.m_elemIsPending) {
            return new DTMNodeIterator(this.m_snapshot.m_contextNodeList);
        }
        return new DTMNodeIterator(this.m_transformer.getContextNodeList());
    }

    public Transformer getTransformer() {
        return this.m_transformer;
    }

    public void warning(SAXParseException exception) throws SAXException {
        if (this.m_contentHandler instanceof ErrorHandler) {
            ((ErrorHandler)((Object)this.m_contentHandler)).warning(exception);
        }
    }

    public void error(SAXParseException exception) throws SAXException {
        if (this.m_contentHandler instanceof ErrorHandler) {
            ((ErrorHandler)((Object)this.m_contentHandler)).error(exception);
        }
    }

    public void fatalError(SAXParseException exception) throws SAXException {
        this.m_elemIsPending = false;
        this.m_docEnded = true;
        this.m_docPending = false;
        if (this.m_contentHandler instanceof ErrorHandler) {
            ((ErrorHandler)((Object)this.m_contentHandler)).fatalError(exception);
        }
    }

    class QueuedStateSnapshot {
        ElemTemplateElement m_currentElement;
        Node m_currentNode;
        ElemTemplate m_currentTemplate;
        ElemTemplate m_matchedTemplate;
        int m_matchedNode;
        DTMIterator m_contextNodeList;

        QueuedStateSnapshot() {
        }
    }
}

