/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.protocol.ftp.config.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.apache.jmeter.config.ConfigTestElement;
import org.apache.jmeter.config.gui.AbstractConfigGui;
import org.apache.jmeter.gui.util.VerticalPanel;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.util.JMeterUtils;

public class FtpConfigGui
extends AbstractConfigGui {
    private static final String SERVER = "server";
    private static final String FILENAME = "filename";
    private JTextField server;
    private JTextField filename;
    private boolean displayName = true;

    public FtpConfigGui() {
        this(true);
    }

    public FtpConfigGui(boolean displayName) {
        this.displayName = displayName;
        this.init();
    }

    public String getStaticLabel() {
        return JMeterUtils.getResString((String)"ftp_sample_title");
    }

    public void configure(TestElement element) {
        super.configure(element);
        this.server.setText(element.getPropertyAsString("FTPSampler.server"));
        this.filename.setText(element.getPropertyAsString("FTPSampler.filename"));
    }

    public TestElement createTestElement() {
        ConfigTestElement element = new ConfigTestElement();
        this.modifyTestElement((TestElement)element);
        return element;
    }

    public void modifyTestElement(TestElement element) {
        this.configureTestElement(element);
        element.setProperty("FTPSampler.server", this.server.getText());
        element.setProperty("FTPSampler.filename", this.filename.getText());
    }

    private JPanel createServerPanel() {
        JLabel label = new JLabel(JMeterUtils.getResString((String)SERVER));
        this.server = new JTextField(10);
        this.server.setName(SERVER);
        label.setLabelFor(this.server);
        JPanel serverPanel = new JPanel(new BorderLayout(5, 0));
        serverPanel.add((Component)label, "West");
        serverPanel.add((Component)this.server, "Center");
        return serverPanel;
    }

    private JPanel createFilenamePanel() {
        JLabel label = new JLabel(JMeterUtils.getResString((String)"file_to_retrieve"));
        this.filename = new JTextField(10);
        this.filename.setName(FILENAME);
        label.setLabelFor(this.filename);
        JPanel filenamePanel = new JPanel(new BorderLayout(5, 0));
        filenamePanel.add((Component)label, "West");
        filenamePanel.add((Component)this.filename, "Center");
        return filenamePanel;
    }

    private void init() {
        this.setLayout(new BorderLayout(0, 5));
        if (this.displayName) {
            this.setBorder(this.makeBorder());
            this.add(this.makeTitlePanel(), "North");
        }
        VerticalPanel mainPanel = new VerticalPanel();
        mainPanel.add((Component)this.createServerPanel());
        mainPanel.add((Component)this.createFilenamePanel());
        this.add((Component)mainPanel, "Center");
    }
}

